import React, { PureComponent, createElement } from 'react';
import PropTypes from 'prop-types';
import { Button, Icon } from 'antd';
import styles from './index.less';

// TODO: 添加逻辑

class EditableLinkGroup extends PureComponent {
  static defaultProps = {
    links: [],
    onAdd: () => {},
    linkElement: 'a',
  };

  static propTypes = {
    links: PropTypes.array,
    onAdd: PropTypes.func,
    linkElement: PropTypes.oneOfType([PropTypes.func, PropTypes.string]),
  };

  render() {
    const { links, linkElement, onAdd } = this.props;
    return (
      <div className={styles.linkGroup}>
        {
          links.map(link => (
            createElement(linkElement, {
              key: `linkGroup-item-${link.id || link.title}`,
              to: link.href,
              href: link.href,
            }, link.title)
          ))
        }
        {
          <Button size="small" onClick={onAdd}>
            <Icon type="plus" />添加
          </Button>
        }
      </div>
    );
  }
}

export default EditableLinkGroup;
