package br.com.evologica.mvp.ui.splash;

import javax.inject.Inject;

import br.com.evologica.mvp.data.DataManager;
import br.com.evologica.mvp.ui.base.BasePresenter;

/**
 * Created by marcussales on 01/03/2017.
 */

public class SplashPresenter<V extends SplashMvpView> extends BasePresenter<V> implements SplashMvpPresenter<V> {

    @Inject
    public SplashPresenter(DataManager dataManager) {
        super(dataManager);
    }

    @Override
    public void onAttach(V mvpView) {
        super.onAttach(mvpView);

        if (!getDataManager().isLogged()){
            getMvpView().openLoginActivity();
        }else{
            getMvpView().openMainActivity();
        }
    }
}
