package br.com.evologica.mvp.ui.splash;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;

import javax.inject.Inject;

import br.com.evologica.mvp.R;
import br.com.evologica.mvp.ui.base.BaseActivity;
import br.com.evologica.mvp.ui.login.LoginActivity;
import br.com.evologica.mvp.ui.main.MainActivity;
import butterknife.ButterKnife;

/**
 * Created by marcussales on 01/03/2017.
 */

public class SplashActivity extends BaseActivity implements SplashMvpView {

    @Inject
    SplashMvpPresenter<SplashMvpView> mPresenter;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_splash);

        getActivityComponent().inject(this);

        ButterKnife.bind(this);

        mPresenter.onAttach(SplashActivity.this);
    }

    @Override
    public void openLoginActivity() {
        Intent intent = new Intent(this, LoginActivity.class);
        startActivity(intent);
        finish();
    }

    @Override
    public void openMainActivity() {
        Intent intent = new Intent(this, MainActivity.class);
        startActivity(intent);
        finish();
    }
}
