package br.com.evologica.mvp.ui.main;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.Button;

import javax.inject.Inject;

import br.com.evologica.mvp.R;
import br.com.evologica.mvp.ui.base.BaseActivity;
import br.com.evologica.mvp.ui.login.LoginActivity;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * Created by marcussales on 01/03/2017.
 */

public class MainActivity extends BaseActivity implements MainMvpView {

    @Inject
    MainMvpPresenter<MainMvpView> mPresenter;

    @BindView(R.id.logout_button)
    Button mLogoutButton;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        getActivityComponent().inject(this);

        ButterKnife.bind(this);

        mPresenter.onAttach(MainActivity.this);

    }

    @OnClick(R.id.logout_button)
    void onLogout(View v) {
        mPresenter.onLogout();
    }

    @Override
    public void openLoginActivity() {
        Intent intent = new Intent(this, LoginActivity.class);
        startActivity(intent);
        finish();
    }
}
