package br.com.evologica.mvp.ui.login;

import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.widget.EditText;

import javax.inject.Inject;

import br.com.evologica.mvp.R;
import br.com.evologica.mvp.ui.base.BaseActivity;
import br.com.evologica.mvp.ui.main.MainActivity;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;

/**
 * Created by marcussales on 01/03/2017.
 */

public class LoginActivity extends BaseActivity implements LoginMvpView {

    private static final String TAG = "LoginActivity";

    @Inject
    LoginMvpPresenter<LoginMvpView> mPresenter;

    @BindView(R.id.et_email)
    EditText mEmailEditText;

    @BindView(R.id.et_password)
    EditText mPasswordEditText;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login);

        getActivityComponent().inject(this);

        ButterKnife.bind(this);

        mPresenter.onAttach(LoginActivity.this);
    }

    @OnClick(R.id.btn_login)
    void onLogin(View v) {
        mPresenter.onLogin(mEmailEditText.getText().toString(),
                mPasswordEditText.getText().toString());
    }

    @Override
    public void openMainActivity() {
        Intent intent = new Intent(this, MainActivity.class);
        startActivity(intent);
        finish();
    }
}
