package br.com.evologica.mvp.ui.base;

import javax.inject.Inject;

import br.com.evologica.mvp.data.DataManager;

/**
 * Created by marcussales on 01/03/2017.
 */

public class BasePresenter<V extends MvpView> implements MvpPresenter<V> {

    private V mMvpView;

    private final DataManager mDataManager;

    @Inject
    public BasePresenter(DataManager mDataManager) {
        this.mDataManager = mDataManager;
    }

    public V getMvpView() {
        return mMvpView;
    }

    @Override
    public void onAttach(V mvpView) {
        mMvpView = mvpView;
    }

    @Override
    public void onDetach() {

    }

    public DataManager getDataManager() {
        return mDataManager;
    }
}
