package br.com.evologica.mvp.ui.base;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v7.app.AppCompatActivity;

import br.com.evologica.mvp.MvpApp;
import br.com.evologica.mvp.di.component.ActivityComponent;
import br.com.evologica.mvp.di.component.DaggerActivityComponent;
import br.com.evologica.mvp.di.module.ActivityModule;
import br.com.evologica.mvp.utils.CommonUtils;
import uk.co.chrisjenx.calligraphy.CalligraphyContextWrapper;

/**
 * Created by marcussales on 01/03/2017.
 */

public class BaseActivity extends AppCompatActivity implements MvpView, BaseFragment.Callback {

    private ActivityComponent mActivityComponent;

    private ProgressDialog mProgressDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mActivityComponent = DaggerActivityComponent.builder()
                            .activityModule(new ActivityModule(this))
                            .applicationComponent(((MvpApp) getApplication()).getComponent())
                            .build();
    }

    public ActivityComponent getActivityComponent() {
        return mActivityComponent;
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(CalligraphyContextWrapper.wrap(newBase));
    }

    @Override
    public void onFragmentAttached() {

    }

    @Override
    public void onFragmentDetached(String tag) {

    }

    @Override
    public void showLoading() {
        hideLoading();
        mProgressDialog = CommonUtils.showLoadingDialog(this);
    }

    @Override
    public void hideLoading() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.cancel();
        }
    }

    @Override
    public void onError(@StringRes int resId) {

    }

    @Override
    public void onError(String message) {

    }
}
