package br.com.evologica.mvp.di.module;

import android.app.Application;
import android.content.Context;

import javax.inject.Singleton;

import br.com.evologica.mvp.R;
import br.com.evologica.mvp.data.AppDataManager;
import br.com.evologica.mvp.data.DataManager;
import br.com.evologica.mvp.data.prefs.AppPreferencesHelper;
import br.com.evologica.mvp.data.prefs.PreferencesHelper;
import br.com.evologica.mvp.di.ApplicationContext;
import br.com.evologica.mvp.di.PreferenceInfo;
import br.com.evologica.mvp.utils.AppConstants;
import dagger.Module;
import dagger.Provides;
import uk.co.chrisjenx.calligraphy.CalligraphyConfig;

/**
 * Created by marcussales on 02/03/2017.
 */

@Module
public class ApplicationModule {

    private final Application mApplication;

    public ApplicationModule(Application application) {
        mApplication = application;
    }

    @Provides
    @ApplicationContext
    Context provideContext() {
        return mApplication;
    }

    @Provides
    Application provideApplication() {
        return mApplication;
    }

    @Provides
    @Singleton
    DataManager provideDataManager(AppDataManager appDataManager){
        return appDataManager;
    }

    @Provides
    @Singleton
    PreferencesHelper providePreferencesHelper(AppPreferencesHelper appPreferencesHelper){
        return appPreferencesHelper;
    }

    @Provides
    @PreferenceInfo
    String providePreferenceName(){
        return AppConstants.PREF_NAME;
    }

    @Provides
    @Singleton
    CalligraphyConfig provideCalligraphyDefaultConfig() {
        return new CalligraphyConfig.Builder()
                .setDefaultFontPath("fonts/source-sans-pro/SourceSansPro-Regular.ttf")
                .setFontAttrId(R.attr.fontPath)
                .build();
    }

}
