package br.com.evologica.mvp.di.module;

import android.app.Activity;
import android.content.Context;

import br.com.evologica.mvp.di.ActivityContext;
import br.com.evologica.mvp.di.PerActivity;
import br.com.evologica.mvp.ui.login.LoginMvpPresenter;
import br.com.evologica.mvp.ui.login.LoginMvpView;
import br.com.evologica.mvp.ui.login.LoginPresenter;
import br.com.evologica.mvp.ui.main.MainMvpPresenter;
import br.com.evologica.mvp.ui.main.MainMvpView;
import br.com.evologica.mvp.ui.main.MainPresenter;
import br.com.evologica.mvp.ui.splash.SplashMvpPresenter;
import br.com.evologica.mvp.ui.splash.SplashMvpView;
import br.com.evologica.mvp.ui.splash.SplashPresenter;
import dagger.Module;
import dagger.Provides;

/**
 * Created by marcussales on 02/03/2017.
 */

@Module
public class ActivityModule {

    private Activity mActivity;

    public ActivityModule(Activity activity) {
        this.mActivity = activity;
    }

    @Provides
    @ActivityContext
    Context provideContext(){
        return mActivity;
    }

    @Provides
    Activity provideActivity(){
        return mActivity;
    }

    @Provides
    @PerActivity
    SplashMvpPresenter<SplashMvpView> provideSplashPresenter(SplashPresenter<SplashMvpView> presenter){
        return presenter;
    }

    @Provides
    @PerActivity
    LoginMvpPresenter<LoginMvpView> provideLoginPresenter(LoginPresenter<LoginMvpView> presenter){
        return presenter;
    }

    @Provides
    @PerActivity
    MainMvpPresenter<MainMvpView> provideMainPresenter(MainPresenter<MainMvpView> presenter){
        return presenter;
    }
}
