package br.com.evologica.mvp.data.prefs;

import android.content.Context;
import android.content.SharedPreferences;

import javax.inject.Inject;
import javax.inject.Singleton;

import br.com.evologica.mvp.di.ApplicationContext;
import br.com.evologica.mvp.di.PreferenceInfo;

/**
 * Created by marcussales on 01/03/2017.
 */

@Singleton
public class AppPreferencesHelper implements PreferencesHelper {

    private static final String PREF_KEY_USER_LOGGED_IN = "PREF_KEY_USER_LOGGED_IN";

    private final SharedPreferences mPrefs;

    @Inject
    public AppPreferencesHelper(@ApplicationContext Context context,
                                @PreferenceInfo String prefFileName) {
        mPrefs = context.getSharedPreferences(prefFileName, Context.MODE_PRIVATE);
    }

    @Override
    public void setLoggedIn() {
        mPrefs.edit().putBoolean(PREF_KEY_USER_LOGGED_IN,true).apply();
    }

    @Override
    public void setLoggedOut() {
        mPrefs.edit().putBoolean(PREF_KEY_USER_LOGGED_IN,false).apply();
    }

    @Override
    public boolean isLogged() {
        return mPrefs.getBoolean(PREF_KEY_USER_LOGGED_IN,false);
    }
}
