package br.com.evologica.mvp.data;

import android.content.Context;

import javax.inject.Inject;
import javax.inject.Singleton;

import br.com.evologica.mvp.data.prefs.PreferencesHelper;
import br.com.evologica.mvp.di.ApplicationContext;

/**
 * Created by marcussales on 01/03/2017.
 */

@Singleton
public class AppDataManager implements DataManager {

    private static final String TAG = "AppDataManager";

    private final Context mContext;
    private final PreferencesHelper mPreferencesHelper;

    @Inject
    public AppDataManager(@ApplicationContext Context ctx,
                          PreferencesHelper preferencesHelper) {
        mContext = ctx;
        mPreferencesHelper = preferencesHelper;

    }

    @Override
    public void setLoggedIn() {
        mPreferencesHelper.setLoggedIn();
    }

    @Override
    public void setLoggedOut() {
        mPreferencesHelper.setLoggedOut();
    }

    @Override
    public boolean isLogged() {
        return mPreferencesHelper.isLogged();
    }
}
