unit ituExplorerV2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Clipbrd,
  Dialogs, acuObjectExplorer, ExtCtrls, StdCtrls, ComCtrls, ElXPThemedControl,
  ElTree, ActnCtrls, StdActns, ActnList, XPStyleActnCtrls, ActnMan, ToolWin,
  ActnMenus, ImgList, acuframework, DB, DBTables, ADODB, StarUML_TLB, IntegracaoDelphiSUML,
  Menus, JvExComCtrls, JvComCtrls, JvExExtCtrls, JvExtComponent, JvPanel,
  JvSplitter, JvExStdCtrls, JvMemo, JvStatusBar, JvListView, SynEdit, SynUniHighlighter,
  StdStyleActnCtrls;

type
  TExplorerV2 = class(TForm)
    pnlEditor: TJvPanel;
    pnlModel: TJvPanel;
    splVertical: TJvSplitter;
    pnlResult: TJvPanel;
    splHorizontal: TJvSplitter;
    tvModelExplorer: TElTree;
    con1: TADOConnection;
    il1: TImageList;
    actmgr1: TActionManager;
    actExecute: TAction;
    actCancel: TAction;
    actModelPanel: TAction;
    actResultsPanel: TAction;
    acttb1: TActionToolBar;
    pmCopiar: TPopupMenu;
    Copia: TMenuItem;
    pcEditor: TJvPageControl;
    XMLQuery: TAction;
    tsOQL: TTabSheet;
    tsSQL: TTabSheet;
    sbStatusBar: TJvStatusBar;
    pcResults: TJvPageControl;
    tsQueryResult: TTabSheet;
    tsError: TTabSheet;
    memErrorText: TJvMemo;
    pcResultType: TJvPageControl;
    tsOQLResult: TTabSheet;
    tsXMLResult: TTabSheet;
    pcXMLResults: TJvPageControl;
    tsList: TTabSheet;
    tsXML: TTabSheet;
    OQLObjects: TObjectExplorer;
    lvXMLListResult: TListView;
    memXMLTextResult: TJvMemo;
    pnlActionBar: TJvPanel;
    acttbReconnectDB: TActionToolBar;
    ReconnectDB: TAction;
    sbDB: TJvStatusBar;
    pnlStatusBar: TJvPanel;
    aOQLQuery: TAction;
    ilModelExplorer: TImageList;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure actModelPanelExecute(Sender: TObject);
    procedure actResultsPanelExecute(Sender: TObject);
    procedure tvModelExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
    procedure XMLQueryExecute(Sender: TObject);
    procedure actExecuteExecute(Sender: TObject);
    procedure memOQLQuery2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure memOQLQuery2DragOver(Sender, Source: TObject; X, Y: Integer;  State: TDragState; var Accept: Boolean);
    procedure CopiaDadosObjeto(Sender: TObject);
    procedure OQLObjectstvExplorerKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure memOQLQuery2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure memSQLQuery2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure memXMLTextResultKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ReconnectDBExecute(Sender: TObject);
    procedure pcEditorChange(Sender: TObject);
    procedure aOQLQueryExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    fExecuting: Boolean;
    fSession: acPersistenceSession;
    FStarUMLApp: IStarUMLApplication;
    fMetaModel: acMetaModel;
    fConnectionString: string;
    fUtil: TUtil;
    procedure SetStarUMLApp(const Value: IStarUMLApplication);
    procedure SetMetaModel(const Value: acMetaModel);
    function GetConnectionString: string;
    procedure ResizeColumns(piListView: TListView);
    function GetStringEntreParenteses(piString : string) : string;
    function GetNumeroDeStringOID (piString : string) : string;
    procedure CopiaTextoObjeto (piObjeto : TElTreeItem);

  protected
    procedure CreateParams(var Params : TCreateParams); override;    
  public
    { Public declarations }
    memOQLQuery: TSynEdit;
    memSQLQuery: TSynEdit;    
    function Connect : Boolean;
    property Session: acPersistenceSession read fSession;
    property ConnectionString: string read fConnectionString write fConnectionString;
    property StarUMLApp: IStarUMLApplication read FStarUMLApp write SetStarUMLApp;
    property MetaModel: acMetaModel read fMetaModel write SetMetaModel;
    property Util: TUtil read fUtil;

  end;

var
  ExplorerV2: TExplorerV2;

implementation

uses ituDataBaseLogin, DBLogDlg, DateUtils, acuRepositorySQL, acuObject, acuOQL,
     utuMessage, ituOQLParams;

{$R *.dfm}

procedure TExplorerV2.actExecuteExecute(Sender: TObject);
var lList: acPersistentObjectList;
    lStart: TDateTime;
    lOQLQuery: acAbstractOQLQuery;
    lOQLParams: TOQLParams;
    lResultField: utField;
    lEnum: acEnumerator;
    lField: utField;
    lColumn: TListColumn;
    lListItem: TListItem;
    lEnumAtt: acEnumerator;
    lFirstItemFlag: Boolean;
    lCount: integer;
begin
  lCount := 0;
  if (memOQLQuery.Text <> '') and (not fExecuting) then
  begin
    fExecuting := True;
    try
      if Assigned(fSession)
        then fSession.Free;

      fSession := PersistenceManager.OpenSession(fMetaModel, acRepositorySQL, gDefaultConnetionString);

      memSQLQuery.Text := '';
      OQLObjects.SetList(nil, '');
      lvXMLListResult.Clear;
      lvXMLListResult.Columns.Clear;
      pcResults.ActivePageIndex := 0;
      if not actResultsPanel.Checked then actResultsPanel.Execute;
      if not XMLQuery.Checked then
      begin
        pcResultType.ActivePageIndex := 0;

        lList := acPersistentObjectList.Create(acPersistentObject);
        try
          sbStatusBar.Panels[0].Text := 'Executing query...';
          sbStatusBar.Panels[1].Text := '';
          sbStatusBar.Panels[2].Text := '';
          Application.ProcessMessages;
          if memOQLQuery.SelText = ''
            then lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.Text)
            else lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.SelText);
          try
            if lOQLQuery.Parameters.Count > 0 then
            begin
              lOQLParams := TOQLParams.Create(nil, lOQLQuery);
              try
                lOQLParams.ShowModal;
              finally
                lOQLParams.free;
              end;
            end;

            lStart := Now;

            (lOQLQuery as acOQLQuery).LoadList(lList);
            memSQLQuery.Text := lOQLQuery.SQLText;
          finally
            lOQLQuery.Free;
          end;

          sbStatusBar.Panels[2].Text := TimeToStr(TimeOf(Now - lStart));
          sbStatusBar.Panels[0].Text := 'Query completed.';
          if lList.Count <= 1 then
            sbStatusBar.Panels[1].Text := inttostr(lList.Count) + ' object'
          else
            sbStatusBar.Panels[1].Text := inttostr(lList.Count) + ' objects';
          OQLObjects.SetList(lList, 'OQL Results');
        finally
          lList.Free;
        end;
      end
      else
      begin
        pcResultType.ActivePageIndex := 1;
        pcXMLResults.ActivePageIndex := 0;
        sbStatusBar.Panels[0].Text := 'Executing query...';
        sbStatusBar.Panels[1].Text := '';
        sbStatusBar.Panels[2].Text := ''; 
        Application.ProcessMessages;

        if memOQLQuery.SelText = ''
          then lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.Text)
          else lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.SelText);
        try
          if lOQLQuery.Parameters.Count > 0 then
          begin
            lOQLParams := TOQLParams.Create(nil, lOQLQuery);
            try
              lOQLParams.ShowModal;
            finally
              lOQLParams.free;
            end;
          end;

          lStart := Now;

          lResultField := utField.Create;
          try
            lResultField.Name := 'ROOT';
            (lOQLQuery as acDataSetOQLQuery).LoadDataSet(lResultField);
            memSQLQuery.Text := lOQLQuery.SQLText;
            memXMLTextResult.Text := lResultField.GetXMLString([xoLegible]);

            lvXMLListResult.Items.BeginUpdate;
            try
              //Adiciona as colunas no listview
              if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('METADATA')) then
              begin
                lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('METADATA').FieldByName('FIELDS').GetFieldsEnumerator;
                try
                  while not lEnum.EOL do
                  begin
                    lField := utField(lEnum.Current);
                    lColumn := lvXMLListResult.Columns.Add;
                    lColumn.Caption := lField.AttributeByName('Name').AsString;
                    lEnum.MoveNext;
                  end;
                finally
                  lEnum.Free;
                end;
              end;

              if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('ROWDATA')) then
              begin
                lCount := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').AttributeByName('Count').AsInteger;
                lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').GetFieldsEnumerator;
                try
                  while not lEnum.EOL do
                  begin
                    lField := utField(lEnum.Current);
                    lListItem := lvXMLListResult.Items.Add;
                    lEnumAtt := lField.GetAttibutesEnumerator;
                    try
                      lFirstItemFlag := true;
                      while not lEnumAtt.EOL do
                      begin
                        if lFirstItemFlag then
                        begin
                          lListItem.Caption := utAttribute(lEnumAtt.Current).AsString;
                          lFirstItemFlag := false;
                        end
                        else
                          lListItem.SubItems.Add(utAttribute(lEnumAtt.Current).AsString);
                        lEnumAtt.MoveNext;
                      end;
                    finally
                      lEnumAtt.Free;
                    end;
                    lEnum.MoveNext;
                  end;
                finally
                  lEnum.Free;
                end;
              end;
            finally
              lvXMLListResult.Items.EndUpdate;
            end;

          finally
            lResultField.free;
          end;
          ResizeColumns(lvXMLListResult);
        finally
          lOQLQuery.Free;
        end;
        sbStatusBar.Panels[2].Text := TimeToStr(TimeOf(Now - lStart));
        if lCount <= 1 then
          sbStatusBar.Panels[1].Text := inttostr(lCount) + ' row'
        else
          sbStatusBar.Panels[1].Text := inttostr(lCount) + ' rows';
        sbStatusBar.Panels[0].Text := 'Query completed.';
      end;
    except
      on e: Exception do
        begin
          memErrorText.Text := e.Message;
          pcResults.ActivePageIndex := 1;
          sbStatusBar.Panels[0].Text := 'Query completed with errors.';
        end;
    end;
  end;
  fExecuting := False;
end;

procedure TExplorerV2.actModelPanelExecute(Sender: TObject);
var
  lAction : TAction;
begin
  lAction := (Sender as TAction);
  lAction.Checked := not lAction.Checked;
  if lAction.Checked then
  begin
    pnlModel.Visible := True;
    if pnlModel.Width <= 10 then
      pnlModel.Width := 20;
  end
  else
  begin
    pnlModel.Visible := False;
  end;
end;

procedure TExplorerV2.actResultsPanelExecute(Sender: TObject);
var
  lAction : TAction;
begin
  lAction := (Sender as TAction);
  lAction.Checked := not lAction.Checked;
  if lAction.Checked then
  begin
    pnlResult.Visible := True;
    if pnlResult.Height <= 10 then
      pnlResult.Height := 20;
    splHorizontal.Align := alBottom;
    splHorizontal.Visible := True;
  end
  else
  begin
    splHorizontal.Visible := False;
    splHorizontal.Align := alNone;
    pnlResult.Visible := False;
  end;
end;


procedure TExplorerV2.aOQLQueryExecute(Sender: TObject);
begin
  aOQLQuery.Checked := True;
  XMLQuery.Checked := False;
end;

function TExplorerV2.Connect: Boolean;
begin
  result := false;
  try
    gDefaultConnetionString := GetConnectionString;
    fSession := PersistenceManager.OpenSession(fMetaModel, acRepositorySQL, gDefaultConnetionString);
    result := true;
  Except
    on e:Exception do
    begin
      ShowMessage(e.Message);
    end;
  end;
end;

procedure TExplorerV2.CopiaDadosObjeto(Sender: TObject);
begin
  if Assigned(OQLObjects.tvExplorer.Selected) then
    CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
end;

procedure TExplorerV2.CopiaTextoObjeto(piObjeto: TElTreeItem);
var
  lString : string;
begin
  lString := piObjeto.Text;
  lString := GetNumeroDeStringOID(GetStringEntreParenteses(lString));
  if lString <> '' then
    Clipbrd.Clipboard.AsText := lString;
end;

procedure TExplorerV2.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle   := Params.ExStyle or WS_EX_APPWINDOW;
end;

procedure TExplorerV2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if assigned(fSession) then fSession.Free;
  if assigned(futil) then fUtil.Free;
  FStarUMLApp := nil;
  Action := caFree;
  ExplorerV2 := nil;
end;

procedure TExplorerV2.FormCreate(Sender: TObject);
begin
  inherited;

	memSQLQuery := TSynEdit.Create(nil);

  with memSQLQuery do
  begin
  	Align := alClient;
  	Gutter.AutoSize := True;
  	Gutter.DigitCount := 3;
    Gutter.LeftOffset := 0;
    Gutter.Font.Name := 'Tahoma';
    Gutter.Font.Size := 8;
  	//ReadOnly := True;

    ExtraLineSpacing := 0;
    Gutter.ShowLineNumbers := True;

    RightEdge := 0;
    WordWrap := False;
    InsertCaret := TSynEditCaretType(0);
    InsertMode := True;
    MaxUndo := 1024;
    OverwriteCaret := TSynEditCaretType(0);

    Options := [];
  end;

  memSQLQuery.Highlighter := TSynUniSyn.Create(nil);

  TSynUniSyn(memSQLQuery.Highlighter).LoadHglFromFile(ExtractFileDir(Application.ExeName) + '\modules\staruml-conexo\syntax\SQL.xml');

  memSQLQuery.Parent := tsSQL;

	memOQLQuery := TSynEdit.Create(nil);
  with memOQLQuery do
  begin
  	Align := alClient;
  	Gutter.AutoSize := True;
  	Gutter.DigitCount := 3;
    Gutter.LeftOffset := 0;
    Gutter.Font.Name := 'Tahoma';
    Gutter.Font.Size := 8;
    Gutter.ShowLineNumbers := True;

  	WantTabs := True;

    OnDragDrop := memOQLQuery2DragDrop;
    OnDragOver := memOQLQuery2DragOver;
    OnKeyUp    := memOQLQuery2KeyUp;    

    ExtraLineSpacing := 0;
    Gutter.ShowLineNumbers := True;

    RightEdge := 0;
    WordWrap := False;
    InsertCaret := TSynEditCaretType(0);
    InsertMode := True;
    MaxUndo := 1024;
    OverwriteCaret := TSynEditCaretType(0);

    Options := [];
    Options := Options + [eoAutoIndent];
    Options := Options + [eoGroupUndo];
    Options := Options + [eoTrimTrailingSpaces];
    Options := Options + [eoTabIndent];
  end;

  memOQLQuery.Highlighter := TSynUniSyn.Create(nil);
  TSynUniSyn(memOQLQuery.Highlighter).LoadHglFromFile(ExtractFileDir(Application.ExeName) + '\modules\staruml-conexo\syntax\OQL.xml');
  memOQLQuery.Parent := tsOQL;
end;

procedure TExplorerV2.FormDestroy(Sender: TObject);
begin
  memOQLQuery.Highlighter.Free;
  memOQLQuery.Free;

  memSQLQuery.Highlighter.Free;
  memSQLQuery.Free;
end;

procedure TExplorerV2.FormShow(Sender: TObject);
var
    lDataBaseLogin: TDataBaseLogin;
    lConnected: boolean;
    lModalResult: Integer;
begin
  lModalResult := mrok;

  lConnected := false;
  lDataBaseLogin := TDataBaseLogin.Create(nil);
  try
    lDataBaseLogin.ProjectFileName := ExtractFileName(StarUMLApp.ProjectManager.FileName);
    while (lModalResult = mrOk) and (not lConnected) do
    begin
      lModalResult := lDataBaseLogin.ShowModal;
      if lModalResult = mrok then
      begin
        fConnectionString := lDataBaseLogin.ConnectionString;
        lConnected := Connect;
        sbDB.Panels[0].Text := 'Data Source: ' + lDataBaseLogin.vleConn.Values['Data Source'] +
                                         '  Initial Catalog: ' + lDataBaseLogin.vleConn.Values['Initial Catalog'];
      end;
    end;
  finally
    lDataBaseLogin.Free;
  end;

  aOQLQuery.Execute;
  OQLObjects.Align := alClient;
  splHorizontal.Visible := False;
  splHorizontal.Align := alNone;
  pnlResult.Visible := False;
  pcEditor.ActivePageIndex := 0;
  pcResults.ActivePageIndex := 1;
end;

function TExplorerV2.GetConnectionString: string;
begin
  Result := fConnectionString;
end;

function TExplorerV2.GetNumeroDeStringOID(piString: string): string;
var
  lString : string;
  lEnum : Integer;
begin
  lString := '';
  // Verifica se a string tem mais que 4 caracteres
  if  Length(piString) > 4  then
  begin
    // Extrai os 4 primeiros caracteres da string
    for lEnum := 1 to 4  do
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Se a string comear com OID: esses 4 primeiro caracteres sero excludos
    if lString = 'OID:' then
    begin
      lString := '';
      for lEnum := 5 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end
    // Caso contrrio copia-se a string toda
    else
    begin
      lString := '';
      for lEnum := 1 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end;
  end
  else
  begin
    lString := piString;
  end;
  Result := lString;  
end;

function TExplorerV2.GetStringEntreParenteses(piString: string): string;
var
  lString : string;
  lEnum : Integer;
  flagDadosDesejados : Boolean;
begin
  flagDadosDesejados := False;
  lString := '';
  for lEnum := 1 to Length(piString)  do
  begin
    // Fim dos dados entre parenteses
    if piString[lEnum] = ')' then
      flagDadosDesejados := False;
    if flagDadosDesejados then
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Inicio dos dados entre parenteses
    if piString[lEnum] = '(' then
      flagDadosDesejados := True;
  end;
  Result := lString;
end;

procedure TExplorerV2.memOQLQuery2DragDrop(Sender, Source: TObject; X,Y: Integer);
    function FromClause(piNode: TElTreeItem; var poPath: string): string;
    begin
      if piNode.Level = 1
      then begin
        poPath := acClassTicket(piNode.Data).PersistentObjectClassName;
        result := poPath;
      end
      else begin
        result := FromClause(piNode.Parent, poPath);
        poPath := poPath + '.' + copy(piNode.Text, 1, pred(pos(':', piNode.Text)));
        result := result + ', ' + #13#10 + '     ' + poPath;
      end;
    end;
var lCaption: string;
    lNode: TElTreeItem;
    lPath: string;
    lFrom: string;
    lSelect: string;
begin
  lNode := (TBaseDragControlObject(Source).Control as TElTree).Selected;
  if (TObject(lNode.Data) is acClassTicket)
    then begin
      lCaption := acClassTicket(lNode.Data).PersistentObjectClassName;
      if GetKeyState(VK_CONTROL) < 0
         then memOQLQuery.SelText := #13#10 +
                                  'SELECT ' + lCaption + #13#10 +
                                  'FROM ' + lCaption
         else memOQLQuery.SelText := lCaption;
    end
    else if (TObject(lNode.Data) is acAttributeTicket) then
    begin
      if GetKeyState(VK_CONTROL) < 0
        then begin
          lCaption := (TObject(lNode.Parent.data) as acClassTicket).PersistentObjectClassName;
          lFrom := FromClause(lNode.Parent, lPath);
          lSelect := copy(lPath, 1, pred(pos('.', lPath)));
          if lSelect = '' then lSelect := lPath;
          memOQLQuery.SelText := #13#10 +
                              'SELECT ' + lSelect + #13#10 +
                              'FROM ' + lFrom + #13#10 +
                              'WHERE ' + lPath + '.' + acAttributeTicket(lNode.Data).AttributeName + ' = ';
        end else memOQLQuery.SelText := acAttributeTicket(lNode.Data).AttributeName;
    end;
end;

procedure TExplorerV2.memOQLQuery2DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
var
  lNode: TElTreeItem;
begin
  Accept := (TBaseDragControlObject(Source).Control is TElTree);
  if Accept then
  begin
    lNode := (TBaseDragControlObject(Source).Control as TElTree).Selected;
    Accept := Accept and ((TObject(lNode.Data) is acClassTicket) or (TObject(lNode.Data) is acAttributeTicket));
    if State = dsDragEnter then TWinControl(Sender).SetFocus;
  end
end;

procedure TExplorerV2.memOQLQuery2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Select All Crtl + A
  if (Key = 65) and (Shift = [ssCtrl]) then
  begin
    memOQLQuery.SelectAll;
  end;
  // Execute Crtl + E
  if (Key = 69) and (Shift = [ssCtrl]) then
  begin
    if (not fExecuting) then actExecute.Execute;
  end;
end;

procedure TExplorerV2.memSQLQuery2KeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Select All Crtl + A
  if (Key = 65) and (Shift = [ssCtrl]) then
  begin
    memSQLQuery.SelectAll;
  end;
end;

procedure TExplorerV2.memXMLTextResultKeyUp(Sender: TObject; var Key: Word;  Shift: TShiftState);
begin
  // Select All Crtl + A
  if (Key = 65) and (Shift = [ssCtrl]) then
  begin
    memXMLTextResult.SelectAll;
  end;
end;

procedure TExplorerV2.OQLObjectstvExplorerKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Copia dados do objeto ao apertar Ctrl + C
  if (Key = 67) and (Shift = [ssCtrl]) then
  begin
    if Assigned(OQLObjects.tvExplorer.Selected) then
      CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
  end;
end;

procedure TExplorerV2.OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  lPoint : TPoint;
begin
  GetCursorPos(lPoint);
  if (Button = mbRight) then
  begin
    pmCopiar.Popup(lPoint.X ,lPoint.Y );
  end;
end;

procedure TExplorerV2.pcEditorChange(Sender: TObject);
var
  lOQLQuery: acAbstractOQLQuery;
begin
  if pcEditor.ActivePageIndex = 1 then
  begin
    pcEditor.ActivePageIndex := 1;
    try
      if memOQLQuery.Text <> '' then
        begin

          memSQLQuery.Text := '';
          if not XMLQuery.Checked then
          begin
              if memOQLQuery.SelText = ''
                then lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.Text)
                else lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.SelText);
            try
              memSQLQuery.Text := lOQLQuery.SQLText;
            finally
              lOQLQuery.Free;
            end;
          end
          else
          begin
              if memOQLQuery.SelText = ''
                then lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.Text)
                else lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.SelText);
            try
              memSQLQuery.Text := lOQLQuery.SQLText;
            finally
              lOQLQuery.Free;
            end;
          end;

        end;
      except
        on e: Exception do
          begin
            if not actResultsPanel.Checked then actResultsPanel.Execute;
            memErrorText.Text := e.Message;
            pcResults.ActivePageIndex := 1;
            pcEditor.ActivePageIndex := 0;
            sbStatusBar.Panels[0].Text := 'OQL translation to SQL failed.';
            sbStatusBar.Panels[1].Text := '';
            sbStatusBar.Panels[2].Text := '';
          end;
    end;
  end;
  
end;

procedure TExplorerV2.ReconnectDBExecute(Sender: TObject);
var
    lDataBaseLogin: TDataBaseLogin;
    lConnected: boolean;
    lModalResult: Integer;
begin
  lModalResult := mrok;

  lConnected := false;
  lDataBaseLogin := TDataBaseLogin.Create(nil);
  try
    lDataBaseLogin.ProjectFileName := ExtractFileName(StarUMLApp.ProjectManager.FileName);
    while (lModalResult = mrOk) and (not lConnected) do
    begin
      lModalResult := lDataBaseLogin.ShowModal;
      if lModalResult = mrok then
      begin
        fConnectionString := lDataBaseLogin.ConnectionString;
        lConnected := Connect;
        if actResultsPanel.Checked then actResultsPanel.Execute;
        sbStatusBar.Panels[0].Text := '';  
        sbStatusBar.Panels[1].Text := '';
        sbStatusBar.Panels[2].Text := '';
        sbDB.Panels[0].Text := 'Data Source: ' + lDataBaseLogin.vleConn.Values['Data Source'] +
                                         '  Initial Catalog: ' + lDataBaseLogin.vleConn.Values['Initial Catalog'];
        OQLObjects.SetList(nil, '');
        lvXMLListResult.Clear;
        lvXMLListResult.Columns.Clear;
        memXMLTextResult.Clear;
        pcResults.ActivePageIndex := 0;
      end;
    end;
  finally
    lDataBaseLogin.Free;
  end;
end;

procedure TExplorerV2.ResizeColumns(piListView: TListView);
var li: integer;
begin
  if piListView.Columns.Count > 0 then
  begin
    piListView.Items.BeginUpdate;
    try
      for li := pred(piListView.Columns.Count) downto 0 do
      begin
        piListView.Columns.Items[li].Width := -2;
      end;
    finally
      piListView.Columns[0].Width := piListView.Columns[0].Width + 20;
      piListView.Items.EndUpdate;
    end;
  end;
end;

procedure TExplorerV2.SetMetaModel(const Value: acMetaModel);
begin
  fMetaModel := Value;
  tvModelExplorer.Items.AddChildObject(nil, 'Persistence Model', fMetaModel).Expand(False);
end;

procedure TExplorerV2.SetStarUMLApp(const Value: IStarUMLApplication);
var   lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  FStarUMLApp := Value;
  fUtil := TUtil.Create(FStarUMLApp);
  fUtil.AlimentarMetamodel(FStarUMLApp, lMetaModelGenOpt, nil);
  MetaModel := fUtil.MetaModel;
end;

procedure TExplorerV2.tvModelExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
var lClassTicket: acClassTicket;
    lAttributeTicket: acAttributeTicket;
    lRelationTicket: acRelationTicket;
    lCardinality: string;
    lEnumerator: acEnumerator;
    li: integer;
    targetNode :  TElTreeItem;
begin
  if (Node.Tag <> 100) then
  begin
    Node.Owner.Items.BeginUpdate;
    try
      if (TObject(Node.Data) is acMetaModel) then
      begin
        lEnumerator := acMetaModel(Node.Data).ClassTickets.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lClassTicket := acClassTicket(lEnumerator.Current);
          targetNode := Node.Owner.Items.AddChildObject(Node, lClassTicket.PersistentObjectClassName, lClassTicket);
          targetNode.ImageIndex := 6;
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acClassTicket) then
      begin
        lClassTicket := acClassTicket(Node.Data);
        repeat
          for li := 0 to pred(lClassTicket.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
            if lAttributeTicket.Stereotype = pvPersistent then
            begin
              targetNode := Node.Owner.Items.AddChildObject(Node, lAttributeTicket.AttributeName + ': ' + lAttributeTicket.AttributeType, lAttributeTicket);
              if lAttributeTicket.Mandatory then
                targetNode.ImageIndex := 5
              else
                targetNode.ImageIndex := 0;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsIn.Objects[li]);
            if lRelationTicket.DestinationMaxMultiplicity = N
              then lCardinality := '*'
              else lCardinality := inttostr(lRelationTicket.DestinationMaxMultiplicity);
            if lRelationTicket.DestinationPropertyName <> '' then
            begin
              targetNode := Node.Owner.Items.AddChildObject(Node, lRelationTicket.DestinationPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.OriginTicket.PersistentObjectClassName, lRelationTicket.OriginTicket);
              if lRelationTicket.DestinationMaxMultiplicity = N then
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 4
                else
                  targetNode.ImageIndex := 2;
              end
              else
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 3
                else
                  targetNode.ImageIndex := 1;
              end;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsOut.Objects[li]);
            if lRelationTicket.OriginPropertyName <> '' then
            begin
              if lRelationTicket.OriginMaxMultiplicity = N
                then lCardinality := '*'
                else lCardinality := inttostr(lRelationTicket.OriginMaxMultiplicity);
              targetNode := Node.Owner.Items.AddChildObject(Node, lRelationTicket.OriginPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.DestinationTicket.PersistentObjectClassName, lRelationTicket.DestinationTicket);
              if lRelationTicket.OriginMaxMultiplicity = N then
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 4
                else
                  targetNode.ImageIndex := 2;
              end
              else
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 3
                else
                  targetNode.ImageIndex := 1;
              end;
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        until lClassTicket = nil;
      end;
      Node.Tag := 100;
    finally
      Node.Owner.Items.EndUpdate;
    end;
  end;
end;

procedure TExplorerV2.XMLQueryExecute(Sender: TObject);
begin
  aOQLQuery.Checked := False;
  XMLQuery.Checked := True;
end;

end.
