unit ituDataBaseLogin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, ValEdit, Registry, StarUML_TLB,
  Buttons, IntegracaoDelphiSUML;

const cPROJECT_SAVE_OPTIONS_PATH = 'Software\StarUML\Options\' + cOPTIONSCHEMAID + '\Projects\';

type
  TDataBaseLogin = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    vleConn: TValueListEditor;
    BitBtn1: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    FProjectFileName: string;
    procedure SetConnectionString(const Value: string);
    { Private declarations }
    procedure ConnectionStringToInterface(piConnectionString: string);
    function GetConnectionString: string;
    procedure SetProjectFileName(const Value: string);
  public
    property ConnectionString: string read GetConnectionString write SetConnectionString;
    property ProjectFileName: string read FProjectFileName write SetProjectFileName;
  end;

implementation

uses strUtils, uConnStringTemplates;

{$R *.dfm}

procedure TDataBaseLogin.Button2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDataBaseLogin.ConnectionStringToInterface(
  piConnectionString: string);
  var lAux: TStringList;
      I: Integer;
      lKey, lValue: string;
      lPos: integer;
      lParam: string;
begin
  lAux := TStringList.Create;
  try
    if piConnectionString[Length(piConnectionString)] = ';' then
      Delete(piConnectionString, length(piConnectionString), 1);
    piConnectionString := '"'+ StringReplace(piConnectionString, ';', '";"', [rfReplaceAll,rfIgnoreCase]) + '"';
    lAux.Delimiter := ';';
    lAux.DelimitedText := piConnectionString;
    for I := 0 to lAux.Count - 1 do
    begin
      lParam := StringReplace(lAux[i],'"','',[rfReplaceAll]);
      lPos := Pos('=',lParam);
      lKey := Copy(lParam,1,lPos - 1);
      lValue := Copy(lParam,lPos + 1, Length(lParam) - lPos);
      vleConn.InsertRow(lKey, lValue, true);
    end;
  finally
    lAux.free;
  end;
end;

procedure TDataBaseLogin.BitBtn1Click(Sender: TObject);
var lConnStrings: TConnStringsTemplates;
begin
  lConnStrings := TConnStringsTemplates.Create(nil);
  try
    if lConnStrings.ShowModal = mrok then
      ConnectionString := lConnStrings.ConnectionString;
  finally
    lConnStrings.Free;
  end;
end;

procedure TDataBaseLogin.Button1Click(Sender: TObject);
var lReg: TRegistry;
begin
  ModalResult := mrnone;
  lReg := TRegistry.Create;
  try
    lReg.RootKey := HKEY_CURRENT_USER;
    lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ProjectFileName + '\Explorer', true);
    lReg.WriteString('DEFAULT_CONNECTION_STRING', ConnectionString);
  finally
    lReg.free;
  end;
  ModalResult := mrOk;
end;

procedure TDataBaseLogin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;
end;


procedure TDataBaseLogin.FormShow(Sender: TObject);
var lReg: TRegistry;
    lConnString: string;
begin
  ModalResult := mrnone;
  lReg := TRegistry.Create;
  try
    lReg.RootKey := HKEY_CURRENT_USER;
    lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ProjectFileName + '\Explorer', true);
    lConnString := lReg.ReadString('DEFAULT_CONNECTION_STRING');
    if lConnString <> '' then
      ConnectionString := lConnString
    else
      ConnectionString := 'Provider=SQLNCLI.1;Data Source=;Initial Catalog=;User ID=;Password=';

  finally
    lReg.free;
  end;
end;

function TDataBaseLogin.GetConnectionString: string;
var
  I: Integer;
begin
  Result := '';
  for I := 1 to vleConn.RowCount - 1 do
    Result := result + vleConn.Keys[i] + '=' + vleConn.Values[vleConn.Keys[i]] + ';'
end;

procedure TDataBaseLogin.SetConnectionString(const Value: string);
begin
  vleConn.Strings.Clear;
  ConnectionStringToInterface(Value);
end;

procedure TDataBaseLogin.SetProjectFileName(const Value: string);
begin
  FProjectFileName := Value;
end;


end.
