unit fModelMappingsGenerationOptions;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, JvExStdCtrls, JvCombobox, JvDriveCtrls, JvListBox, StarUML_TLB,
  Buttons, Registry, IntegracaoDelphiSUML;

const cPROJECT_SAVE_OPTIONS_PATH = 'Software\StarUML\Options\' + cOPTIONSCHEMAID + '\Projects\';

type
  TModelMappingsGenerationOptions = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    dlbDirectory: TJvDirectoryListBox;
    dcbDrive: TJvDriveCombo;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    edtFileName: TEdit;
    GroupBox2: TGroupBox;
    ckbIgnoreXSD: TCheckBox;
    lblFileExists: TLabel;
    BitBtn3: TBitBtn;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    ckbDefault: TCheckBox;
    GroupBox3: TGroupBox;
    rdObjectPascal: TRadioButton;
    rdCSharp: TRadioButton;
    rdJava: TRadioButton;
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure edtFileNameChange(Sender: TObject);
    procedure dlbDirectoryClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FStarUMLApp: IStarUMLApplication;
    procedure SetStarUMLApp(const Value: IStarUMLApplication);
    procedure CheckFile;
    procedure GetParameters;
    { Private declarations }
  public
    { Public declarations }
    property StarUMLApp: IStarUMLApplication read FStarUMLApp write SetStarUMLApp;
  end;

var
  ModelMappingsGenerationOptions: TModelMappingsGenerationOptions;

implementation

{$R *.dfm}

{ TModelMappingsGenerationOptions }

procedure TModelMappingsGenerationOptions.BitBtn1Click(Sender: TObject);
var lReg: TRegistry;
begin
  ModalResult := mrnone;
  if edtFileName.Text = '' then
    Application.MessageBox('Model mappings file name must be specified.', 'Attention', MB_ICONINFORMATION)
  else
  begin
    if ckbDefault.Checked then
    begin
      lReg := TRegistry.Create;
      try
        lReg.RootKey := HKEY_CURRENT_USER;
        lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(StarUMLApp.ProjectManager.FileName), true);
        lReg.WriteString('MODELMAPPINGS_IGNORE_XSD_SCHEMA', BoolToStr(ckbIgnoreXSD.Checked, true));
        lReg.WriteString('MODELMAPPINGS_OUTPUT_DIRECTORY', dlbDirectory.Directory);
        lReg.WriteString('MODELMAPPINGS_FILENAME', edtFileName.Text);
        
        if rdObjectPascal.Checked then
        begin            
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'O');
        end
        else if rdCSharp.Checked then
        begin
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'C');
        end
        else
        begin
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'J');
        end;
      finally
        lReg.free;
      end;
    end;          
         
    ModalResult := mrOk;
  end;
end;

procedure TModelMappingsGenerationOptions.BitBtn3Click(Sender: TObject);
begin
  GetParameters;
end;

procedure TModelMappingsGenerationOptions.CheckFile;
begin
  lblFileExists.Visible := FileExists(IncludeTrailingPathDelimiter(dlbDirectory.Directory) + edtFileName.Text);
end;

procedure TModelMappingsGenerationOptions.dlbDirectoryClick(Sender: TObject);
begin
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.edtFileNameChange(Sender: TObject);
begin
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.FormDestroy(Sender: TObject);
begin
  FStarUMLApp := nil;
end;

procedure TModelMappingsGenerationOptions.FormShow(Sender: TObject);
begin
  GetParameters;
end;

procedure TModelMappingsGenerationOptions.GetParameters;
var lReg: TRegistry;
begin
  lReg := TRegistry.Create;
  try
    lReg.RootKey := HKEY_CURRENT_USER;
    lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(StarUMLApp.ProjectManager.FileName), true);

    ckbIgnoreXSD.Checked := StrToBoolDef(lReg.ReadString('MODELMAPPINGS_IGNORE_XSD_SCHEMA'), false);

    if lReg.ReadString('MODELMAPPINGS_OUTPUT_DIRECTORY') <> '' then
      dlbDirectory.Directory := lReg.ReadString('MODELMAPPINGS_OUTPUT_DIRECTORY')
    else
      dlbDirectory.Directory := ExtractFilePath(StarUMLApp.ProjectManager.FileName);

    if lReg.ReadString('MODELMAPPINGS_FILENAME') <> '' then
      edtFileName.Text := lReg.ReadString('MODELMAPPINGS_FILENAME')
    else
      edtFileName.Text := 'acuRegisterModelMappings.pas';

    if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') <> '' then
    begin
      if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') = 'O' then
        rdObjectPascal.Checked := True
      else if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') = 'C' then
        rdCSharp.Checked := True
      else
        rdJava.Checked := True;
           
    end
    else
      rdObjectPascal.Checked := True;
  finally
    lReg.free;
  end;
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.SetStarUMLApp(
  const Value: IStarUMLApplication);
begin
  FStarUMLApp := Value;
end;

procedure TModelMappingsGenerationOptions.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.InitialDir := dlbDirectory.Directory;
  if OpenDialog1.Execute then
  begin
    dlbDirectory.Directory := ExtractFilePath(OpenDialog1.FileName);
    edtFileName.Text := ExtractFileName(OpenDialog1.FileName);
    CheckFile;
  end;
end;


end.
