unit cxuCadastroClasse;

interface

uses cxuUseCase, utuMessage;

type

  cxCadastroClasse = class(cxUseCase)
  protected
    function GetUseCaseCode: String; override;
  public
    procedure rmObtemContexto(piField: utField; const piResponseField: utField = nil);
    procedure rmIncluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmExcluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmEditaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmSalvaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmConsultaObjeto(piField: utField; const piResponseField: utField = nil);
  end;

implementation

{ cxCadastroClasse }

procedure cxCadastroClasse.rmObtemContexto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_OBTEM_CONTEXTO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroClasse.rmSalvaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_SALVA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroClasse.rmExcluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EXCLUI_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroClasse.rmIncluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_INCLUI_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroClasse.rmConsultaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_CONSULTA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroClasse.rmEditaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EDITA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

function cxCadastroClasse.GetUseCaseCode: String;
begin
  result := '1080';
end;

end.
