unit fXSDEditor;

interface

uses
  LCLType, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, ComCtrls, Buttons, StdCtrls, StarUMLintf;

type
  TXSDEdit = class(TForm)
    pnlTransition: TPanel;
    Panel2: TPanel;
    pgcPrincipal: TPageControl;
    tbsXSDIn: TTabSheet;
    tbsXSDOut: TTabSheet;
    btnSalvar: TSpeedButton;
    btnSendExternalEditor: TSpeedButton;
    memXSDIn: TMemo;
    memXSDOut: TMemo;
    btnGetExternalEditor: TSpeedButton;
    btnCancel: TSpeedButton;
    procedure FormShow(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnSendExternalEditorClick(Sender: TObject);
    procedure pgcPrincipalDrawTab(Control: TCustomTabControl; TabIndex: Integer; const Rect: TRect; Active: Boolean);
    procedure btnGetExternalEditorClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure pgcPrincipalChanging(Sender: TObject; var AllowChange: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
    fBeforeXSD, fAfterXSD: string;
    fXSDDoc: TMemo;
    fEditing: boolean;

    fUMLTransition: IUMLTransition;
    fCurrentFileName: string;
    function GetXSDIn: String;
    procedure SetXSDIn(const Value: String);
    function GetXSDOut: String;
    procedure SetXSDOut(const Value: String);
    function GetTempPath: String;
    function GetCurrentFileName: string;
    procedure SetCurrentFileName(const Value: string);
    function GetExternalXSDEditor: string;
    procedure SetEditing(const Value: boolean);
  public
    { Public declarations }
    property Transition: IUMLTransition read fUMLTransition write fUMLTransition;
    property XSDIn: String read GetXSDIn write SetXSDIn;
    property XSDOut: String read GetXSDOut write SetXSDOut;
    property TempPath: String read GetTempPath;
    property CurrentFileName: string read GetCurrentFileName write SetCurrentFileName;
    property ExternalXSDEditor: string read GetExternalXSDEditor;
    property Editing: boolean  read fEditing write SetEditing;
  end;

var
  XSDEdit: TXSDEdit;

implementation

uses IntegracaoDelphiSUML;

{$R *.dfm}

{ TXSDEditor }

//function CreateProcessSimple(cmd: string): boolean;
//var
//  SUInfo: TStartupInfo;
//  ProcInfo: TProcessInformation;
//begin
//  FillChar(SUInfo, SizeOf(SUInfo), #0);
//  SUInfo.cb      := SizeOf(SUInfo);
//  SUInfo.dwFlags := STARTF_USESHOWWINDOW;
//  SUInfo.wShowWindow := SW_HIDE;
//
//  Result := CreateProcess(nil,
//                          PChar(cmd),
//                          nil,
//                          nil,
//                          false,
//                          CREATE_NEW_CONSOLE or
//                          NORMAL_PRIORITY_CLASS,
//                          nil,
//                          nil,
//                          SUInfo,
//                          ProcInfo);
//
//  if (Result) then
//  begin
//    WaitForSingleObject(ProcInfo.hProcess, INFINITE);
//
//    CloseHandle(ProcInfo.hProcess);
//    CloseHandle(ProcInfo.hThread);
//  end;
//end;

procedure TXSDEdit.FormClose(Sender: TObject; var Action: TCloseAction);
begin
end;

procedure TXSDEdit.FormCreate(Sender: TObject);
begin
  fEditing := false;
end;

procedure TXSDEdit.FormShow(Sender: TObject);
begin
  memXSDIn.Lines.Text := Self.XSDIn;
  memXSDOut.Lines.Text := Self.XSDOut;
end;

function TXSDEdit.GetCurrentFileName: string;
begin
  result := fCurrentFileName;
end;

function TXSDEdit.GetExternalXSDEditor: string;
begin
  result := gStarUMLAPP.GetOptionValue(cOPTIONSCHEMAID, 'EXTERNAL_XSD_EDITOR');
  if (result = '') or (not FileExists(result)) then
  begin
    result := '';
    if FileExists('C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe') then
      result := 'C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe'
    else   
      if FileExists('C:\Program Files\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe') then   
        result := 'C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe';
  end;
end;

function TXSDEdit.GetTempPath: String;
begin
  Result := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP'));
end;

function TXSDEdit.GetXSDIn: String;
begin
  result := fUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In');
end;

function TXSDEdit.GetXSDOut: String;
begin
  result := fUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out');
end;

procedure TXSDEdit.pgcPrincipalChanging(Sender: TObject; var AllowChange: Boolean);
begin
  if fEditing then
  begin
    Application.MessageBox('Cannot change tab. Must finish current edition.', 'StarUML', MB_ICONINFORMATION);
    AllowChange := false;
  end;

end;

procedure TXSDEdit.pgcPrincipalDrawTab(Control: TCustomTabControl; TabIndex: Integer; const Rect: TRect; Active: Boolean);
begin
end;

procedure TXSDEdit.SetCurrentFileName(const Value: string);
begin
  fCurrentFileName := value;
end;

procedure TXSDEdit.SetEditing(const Value: boolean);
begin
  fEditing := Value;
  btnSendExternalEditor.Visible := not value;
  btnGetExternalEditor.Visible := value;
  btnCancel.Visible := value;
end;

procedure TXSDEdit.SetXSDIn(const Value: String);
begin
  fUMLTransition.SetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In', Value);
end;

procedure TXSDEdit.SetXSDOut(const Value: String);
begin
  fUMLTransition.SetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out', Value);
end;

procedure TXSDEdit.btnCancelClick(Sender: TObject);
begin
  self.Editing := false;
end;

procedure TXSDEdit.btnGetExternalEditorClick(Sender: TObject);
var laux: TStringList;
begin
  lAux := TStringList.Create;
  try
    lAux.LoadFromFile(self.TempPath + Self.CurrentFileName);
    fAfterXSD := lAux.Text;
  finally
    lAux.free;
  end;

  if fBeforeXSD <> fAfterXSD then
  begin
    fXSDDoc.Lines.Text := fAfterXSD;
    if pgcPrincipal.ActivePage = tbsXSDIn then
      Self.XSDIn := fAfterXSD
    else if pgcPrincipal.ActivePage = tbsXSDOut then
      Self.XSDOut := fAfterXSD;
  end;

  self.Editing := false;
end;

procedure TXSDEdit.btnSalvarClick(Sender: TObject);
begin
  if pgcPrincipal.ActivePage = tbsXSDIn then
  begin
    XSDIn := memXSDIn.Lines.Text;
  end else if pgcPrincipal.ActivePage = tbsXSDOut then
  begin
    XSDOut := memXSDOut.Lines.Text;
  end;
end;

procedure TXSDEdit.btnSendExternalEditorClick(Sender: TObject);
var
//  SUInfo: TStartupInfo;
//  ProcInfo: TProcessInformation;
  lOk: boolean;
  lAux: TStringList;
begin
(*  if Self.ExternalXSDEditor = '' then
  begin
    Application.MessageBox('Need to define an external XSD editor.','StarUML', MB_ICONINFORMATION);
    exit;
  end;

  Self.CurrentFileName := 'StarUmlXSDTmpFile.xsd';
  if pgcPrincipal.ActivePage = tbsXSDIn then
    fXSDDoc := memXSDIn
  else if pgcPrincipal.ActivePage = tbsXSDOut then
    fXSDDoc := memXSDOut;

  lAux := TStringList.Create;
  try
    if trim(fXSDDoc.Lines.Text) = '' then
      lAux.Text := '<?xml version="1.0" encoding="utf-8" ?>' + #13#10 +
                    '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" />'
    else
      lAux.Text := fXSDDoc.Lines.Text;

    fBeforeXSD := lAux.Text;

    try
      if FileExists(self.TempPath + Self.CurrentFileName) then DeleteFile(self.TempPath + Self.CurrentFileName);
      lAux.SaveToFile(self.TempPath + Self.CurrentFileName);
    except
      Randomize;
      Self.CurrentFileName := 'StarUmlXSDTmpFile' + inttostr(Random(999999)) + '.xsd';
      lAux.SaveToFile(self.TempPath + Self.CurrentFileName);
    end;
  finally
    lAux.free;
  end;

  FillChar(SUInfo, SizeOf(SUInfo), #0);
  SUInfo.cb      := SizeOf(SUInfo);
  SUInfo.dwFlags := STARTF_USESHOWWINDOW;
  SUInfo.wShowWindow := SW_SHOWNORMAL;

  lOk := CreateProcess(nil,
                       PChar(ExternalXSDEditor + ' ' + self.TempPath + Self.CurrentFileName),
                       nil,
                       nil,
                       false,
                       CREATE_NEW_CONSOLE or
                       NORMAL_PRIORITY_CLASS,
                       nil,
                       nil,
                       SUInfo,
                       ProcInfo);

  self.Editing := lOK;                     

  if (lOk) then
  begin
    CloseHandle(ProcInfo.hProcess);
    CloseHandle(ProcInfo.hThread);
  end;*)
end;

end.
