unit IntegracaoDelphiSUML;

interface

uses
  LCLType, InstantCode, StarUMLintf, acuObject, SysUtils, acuModel, acuRepositorySQL,
  Classes, Mostra_Processamento, acuContainers, utuStateMachine, variants, Utility;

const cOPTIONSCHEMAID = 'StarUML.Conexo';
const N = MaxInt;

const MODELO = '::AppModel';
const MODELO_SGIES = MODELO + '::SGIESModel';
const MODELO_SISCON = MODELO + '::SISCONModel';
const MODELO_NAME = 'AppModel';
const MODELO_SGIES_NAME = 'SGIESModel';
const MODELO_SISCON_NAME = 'SISCONModel';

const cBASE_STATE_MACHINE = 'smServer';
const cBASE_PERSISTENT_OBJECT_CLASS = 'acPersistentObject';
const cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH = MODELO + '::FrameworkModel::acuFrameworkPackage::' + cBASE_PERSISTENT_OBJECT_CLASS;
const cBASE_USECASE_CLASS = 'ucUseCase';
const cBASE_USECASE_CLASS_FULL_PATH = MODELO + '::FrameworkModel::acuFrameworkPackage::UCU::' + cBASE_USECASE_CLASS;


//const ACTION_SUFIX = '_ANSWER';
//const ACTION_PREFIX = 'RM_';
//const TRIGGER_SUFIX = '';
//const TRIGGER_PREFIX = 'RM_';


type
  TDataBaseVendor = (dbvSQLServer, dbvOracle, dbvDB2);

  //////////////////////////////////////////////////////////////////////////////
  TCodeGenParams = class(TObject);

  TProcCodeGen = function (piParams: TCodeGenParams): string of object;

  TCodeGenParamsUseCase = class(TCodeGenParams)
  private
    FUseCaseCode: string;
  public
    property UseCaseCode: string read FUseCaseCode write FUseCaseCode;
  end;

  TCodeGenParamsUseCaseJava = class(TCodeGenParamsUseCase)
  private
    FJavaClientPackageName: string;
  public
    property JavaClientPackageName: string read FJavaClientPackageName write FJavaClientPackageName;
  end;

  //////////////////////////////////////////////////////////////////////////////

  TModelMappingsOptions = record
    FileName: string;
    IgnoreXSDSchema: boolean;
    TargetLanguage: string;
  end;

  TMetaModelGenerationOptions = record
    SilentMode: boolean;
    CheckDBAttributeNameLength: boolean;
    CheckDBTableNameLength: boolean;
  end;

  TUtil = class(TObject)
  private
    { Private declarations }
    fStarUMLApp: IStarUMLApplication;
    fMetaModel: acMetaModel;
    fMetaModelPersistenceMap: acMetaModelPersistenceMapSQL;
    function FindLostClasses(out poLostClasses: TStringList): integer;
    procedure PutMessage(piMessage: string; piElement: IElement; piMessageType: integer = 0);
  public
    constructor Create;
    destructor Destroy; override;

    function AlimentarMetamodel(piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;
    function AlimentarMetamodelRegisterMapping(poClasseRaiz: IUMLClass; poMetaModel: acMetaModel; piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;
    function AlimentarMetamodelRelationsAll(poPackage: IUMLPackage; poMetaModel: acMetaModel; piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;

    procedure GerarUseCaseTickets(const poRootUseCase: IUMLUseCase; poMetaModel: acMetaModel; piProgress: TFShowProgress);
    function AlimentarMetamodelUseCase(poRootUseCase: IUMLUseCase; piBaseStateMachine: IUMLStateMachine;
                                       piBaseSubmachineState: IUMLSubmachineState; poMetaModel: acMetaModel; piProgress: TFShowProgress): string;
    procedure AlimentaMetaModelStateMachine(piRootUseCase: IUMLUseCase; piStarUMLStateMachine: IUMLStateMachine; piStarUMLChildStateMachine: IUMLStateMachine; poStateMachine: utStateMachine; piLevel: integer);

    function GerarUseCaseServerPreview_Pascal(piParams: TCodeGenParams): string;
    function GerarUseCaseClientPreview_Pascal(piParams: TCodeGenParams): string;
    function GerarUseCaseClientPreview_Java(piParams: TCodeGenParams): string;
    function GerarUseCaseClientPreview_DotNet(piParams: TCodeGenParams): string;

    function GerarClassPreview_Pascal(piClass : IUMLClass) : string;
    function GerarClassPreview_CSharp(piClass : IUMLClass) : string;
    function GerarClassPreview_Java(piClass : IUMLClass) : string;

    procedure GerarUnitRegisterModelMappings(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);
    procedure GerarUnitRegisterModelMappings_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);
    procedure GerarUnitRegisterModelMappings_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);
    function  GerarBodyRegisterMappings(piModelMappingsOptions: TModelMappingsOptions; const piInstantCodeConsts: TInstantCodeConsts; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer): string;
    procedure GerarBodyRegisterMappings_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter);
    procedure GerarBodyRegisterMappings_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter);
    function  GerarBodyRelationsAll(piProgress: TFShowProgress): string;
    procedure GerarBodyRelationsAll_CSharp(piProgress: TFShowProgress; piUnitRegisterMappings: PStringWriter);
    procedure GerarBodyRelationsAll_Java(piProgress: TFShowProgress; piUnitRegisterMappings: PStringWriter);
    procedure GerarUnitRelationsAll(piModelMappingsOptions: TModelMappingsOptions; psFileName: string; piProgress: TFShowProgress);
    function  GerarRelationsPartnerShips(piClassTicket: acClassTicket; piInstantCodeClass: TInstantCodeClass): string;

    function  GerarBodyUseCases(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
    function  GerarBodyUseCases_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter): string;
    function  GerarBodyUseCases_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter): string;

    function  GerarBodyStateMachines(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
    function  GerarBodyStateMachines_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter): string;
    function  GerarBodyStateMachines_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piUnitRegisterMappings: PStringWriter): string;
    function  GerarBodyStateMachine(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
    function  GerarBodyStateMachine_CSharp(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string; piUnitRegisterMappings: PStringWriter): string;
    function  GerarBodyStateMachine_Java(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string; piUnitRegisterMappings: PStringWriter): string;

    procedure SaveUseCaseDiagramJPG(piUseCaseName, piTargetDirectory: string);

    procedure SaveAllDiagrams(const piTargetDirectory: string);

    function DescendsFrom(piElement: IUMLGeneralizableElement; piName: string): boolean;

//    procedure GerarUnitRegisterMappings(psFileName: string; piProgress: TFShowProgress);
    procedure Reversa(psNomePacote, psPrjPath, psSTARUMLprj: string);
    function CriarUMLClass(pIStarUMLApp: IStarUMLApplication; pClassTicket: acClassTicket; pUMLPackage: IUMLPackage; var piUMLClass: IUMLClass): boolean;

//    procedure CriarUMLAttributes(piClassTicket: acClassTicket; piUMLClass: IUMLClass; piFactory: IUMLFactory);
    procedure CriarArvore(piIStarUMLApp: IStarUMLApplication; piUMLClass: IUMLClass; piUMLPackage: IUMLPackage; piClassTicket: acClassTicket);
    procedure CriarUMLAssociations(piIStarUMLApp: IStarUMLApplication; piRelationHash: acObjectHash; piModel: IUMLModel; piPackage: IUMLPackage);
    function ExisteAssociacao(piRelationTicket: acRelationTicket; piUMLClassOrigem, piUMLClassDestino: IUMLClass): boolean;
    function BuscaClasseModelo(poPackage: IUMLPackage; piClassName: string; var pbAchou: boolean) : IUMLClass;
    function CarregaMetodo(pStarUMLApp: IStarUMLApplication): string;
    procedure CarregarMetodosNGU(pUMLClass: IUMLClass; pInstantCodeClass: TInstantCodeClass);

    function GerarSQLPreview(piModelElement: IModel; piDBVendor: TDataBaseVendor = dbvSQLServer): string;
    function GerarFullSQLPreview(piDBVendor: TDataBaseVendor = dbvSQLServer): string;

    function SQLColumnTypeByVendor(piAttributeTicket: acAttributeTicket; piDBVendor: TDataBaseVendor): string;

    function SQLScriptCreateDirectTable(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptCreateIndirectTable(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptDBColumn(piDBColumnMap: acDBColumnMapTicket; piAlwaysNulls: boolean; piDBVendor: TDataBaseVendor): string;
    function SQLScriptDirectTableForeignKeys(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptIndirectTableForeignKeys(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;

    function SQLScriptDropDirectTable(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptDropIndirectTable(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptDropDirectTableForeignKeys(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;
    function SQLScriptDropIndirectTableForeignKeys(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;

    function ValidateAttribute(const piAttribute: IUMLAttribute; piCheckLength: boolean): string;
    function ValidateDBAttribute(piAttributeDBName: string; piType: string; piFSize, piVSize: integer; piCheckLength: boolean): string;
    function ValidateDBAttributeType(piType: string; piFSize, piVSize: integer): string;
    function ValidateClass(piUMLClass: IUMLClass; poErrors: TStringList): integer;

    function EncodeMultiplicity(piMultiplicity: Integer): string;

    procedure ConvertXSDsToUseCaseXSD(piProgress: TFShowProgress);

    property MetaModel: acMetaModel read fMetaModel write fMetaModel;
    property MetaModelPersistenceMap: acMetaModelPersistenceMapSQL read fMetaModelPersistenceMap write fMetaModelPersistenceMap;
    property StarUMLApp: IStarUMLApplication read fStarUMLApp;
  end;

  function InitializeAddIn(AApplicationHandle: THandle; AStarUMLApplication: TObject): Integer; {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}
  function FinalizeAddIn: Integer;  {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}
  function DoMenuAction(ActionID: Integer): Integer;  {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}

var gStarUMLApp: IStarUMLApplication;

implementation

uses dialogs, uDBAttributeParameters, acuUseCaseStateMachine, acuFramework, Forms, DelphiAddInObj,
     Controls, strutils, utuMessage, utuXSD, acuModelMapping;

function InitializeAddIn(AApplicationHandle: THandle; AStarUMLApplication: TObject): Integer;  {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}
begin
//  Application.Handle := AApplicationHandle;
  if AStarUMLApplication.GetInterface(IID_IStarUMLApplication, gStarUMLApp)
    then Result := 0
    else Result := -1;
end;

function FinalizeAddIn: Integer;  {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}
begin
  gStarUMLApp := Nil;
  Result := 0;
end;

function DoMenuAction(ActionID: Integer): Integer;  {$IFDEF MSWINDOWS} stdcall; {$ELSE} cdecl; {$ENDIF}
begin
  try
    Result := TDelphiAddInObj.DoMenuAction(ActionID);
  except
    on E: Exception do
    begin
      Application.MessageBox(PAnsiChar(e.Message), 'Error...', MB_ICONERROR);
    end;
  end;
end;


function TUtil.FindLostClasses(out poLostClasses: TStringList): integer;

  procedure ReadEtireModel(piUMLClassifier: IUMLClassifier);
  var I: integer;
      lAuxElement: IElement;
      lUMLClass: IUMLClass;
  begin
    //Varre todo o modelo procurando por classes
    for I := 0 to piUMLClassifier.GetOwnedElementCount - 1 do
    begin
      if (piUMLClassifier.GetOwnedElementAt(i).QueryInterface(IUMLClass, lAuxElement) = S_OK) then
      begin
        lUMLClass := piUMLClassifier.GetOwnedElementAt(i) as IUMLClass;
        if not DescendsFrom(lUMLClass, cBASE_PERSISTENT_OBJECT_CLASS) then
          poLostClasses.Add(lUMLClass.Pathname);
      end;

      if (piUMLClassifier.GetOwnedElementAt(i).QueryInterface(IUMLModel, lAuxElement) = S_OK) then
      begin
        if not sametext(piUMLClassifier.GetOwnedElementAt(i).Name, 'FrameworkModel') then
          ReadEtireModel(piUMLClassifier.GetOwnedElementAt(i) as IUMLClassifier)
      end
      else if (piUMLClassifier.GetOwnedElementAt(i).QueryInterface(IUMLPackage, lAuxElement) = S_OK) then
        ReadEtireModel(piUMLClassifier.GetOwnedElementAt(i) as IUMLClassifier);
    end;
  end;
begin
  poLostClasses.Clear;
  ReadEtireModel(gStarUMLApp.GetProject);
  result := poLostClasses.Count;
end;

function TUtil.SQLColumnTypeByVendor(piAttributeTicket: acAttributeTicket;
  piDBVendor: TDataBaseVendor): string;
begin

end;

function TUtil.SQLScriptDBColumn(piDBColumnMap: acDBColumnMapTicket; piAlwaysNulls: boolean; piDBVendor: TDataBaseVendor): string;
var lSQLColumnDBType: string;
begin
  result := '';

  if SameText(piDBColumnMap.AttributeTicket.DBType,'varchar') then
    lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.VarSize), ')')
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'char') then
    lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.FixSize), ')')
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'int') then
    case piDBVendor of
      dbvOracle: lSQLColumnDBType := 'number(10)';
    else
      lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;
    end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'integer') then
    case piDBVendor of
      dbvOracle: lSQLColumnDBType := 'number(10)';
    else
      lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;
    end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'numeric') then
  begin
    if (piDBColumnMap.AttributeTicket.VarSize > 0) then
      lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.FixSize), ',', inttostr(piDBColumnMap.AttributeTicket.VarSize), ')')
    else
      lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.FixSize), ')');
  end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'decimal') then
  begin
    if (piDBColumnMap.AttributeTicket.VarSize > 0) then
      lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.FixSize), ',', inttostr(piDBColumnMap.AttributeTicket.VarSize), ')')
    else
      lSQLColumnDBType := concat(piDBColumnMap.AttributeTicket.DBType, '(', inttostr(piDBColumnMap.AttributeTicket.FixSize), ')');
  end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'text') then
    case piDBVendor of
      dbvSQLServer: lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;
    else
      lSQLColumnDBType := 'clob';
    end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'datetime') then
    case piDBVendor of
      dbvSQLServer: lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;
      dbvOracle: lSQLColumnDBType := 'date';
      dbvDB2: lSQLColumnDBType := 'timestamp';
    end
  else if SameText(piDBColumnMap.AttributeTicket.DBType, 'image') then
    case piDBVendor of
      dbvSQLServer: lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;
    else
      lSQLColumnDBType := 'blob';
    end
  else
    lSQLColumnDBType := piDBColumnMap.AttributeTicket.DBType;

  result := concat(result, piDBColumnMap.ColumnName, StringOfChar(' ', 50 - Length(piDBColumnMap.ColumnName)), uppercase(lSQLColumnDBType));

  if (piAlwaysNulls) or (not piDBColumnMap.AttributeTicket.Mandatory) then
    case piDBVendor of
      dbvDB2: result := concat(result, '');
    else
      result := concat(result, ' NULL')
    end
  else
    result := concat(result, ' NOT NULL');
end;

procedure TUtil.SaveAllDiagrams(const piTargetDirectory: string);

  procedure SearchDiagrams(piModel: IModel; piUseCaseName: string);
  var
    I: Integer;
    lUMLClassifier: IUMLClassifier;
    lDir: string;
  begin
    for I := 0 to piModel.GetOwnedDiagramCount - 1 do
    begin
      lDir := IncludeTrailingPathDelimiter(piTargetDirectory) + piUseCaseName;
//      if not DirectoryExists(lDir) then
//        CreateDirectory(PAnsiChar(lDir),nil);

      piModel.GetOwnedDiagramAt(I).DiagramView.ExportDiagramAsJPEG(IncludeTrailingPathDelimiter(lDir) +
                                                                   piModel.GetOwnedDiagramAt(I).GetMetaClass.Name + '_' +
                                                                   piModel.GetOwnedDiagramAt(I).Name + '.jpg');
    end;
    if piModel.GetMetaClass.IsKindOf('UMLClassifier') and (piModel.Pathname <> MODELO + '::FrameworkModel') then
    begin
      lUMLClassifier := piModel as IUMLClassifier;
      for I := 0 to lUMLClassifier.GetOwnedElementCount - 1 do
      begin
        if lUMLClassifier.GetOwnedElementAt(I).GetMetaClass.IsKindOf('UMLUseCase') then
          SearchDiagrams(lUMLClassifier.GetOwnedElementAt(I), lUMLClassifier.GetOwnedElementAt(I).Name)
        else
          SearchDiagrams(lUMLClassifier.GetOwnedElementAt(I), piUseCaseName)
      end;
      for I := 0 to lUMLClassifier.GetBehaviorCount - 1 do
        SearchDiagrams(lUMLClassifier.GetBehaviorAt(I), piUseCaseName);
    end;
  end;

  var lModel: IModel;
begin
  lModel := gStarUMLApp.FindByPathname(MODELO) as IModel;
  SearchDiagrams(lModel, '');
end;

procedure TUtil.SaveUseCaseDiagramJPG(piUseCaseName, piTargetDirectory: string);

  procedure FindAndSave(piRootUseCase: IUMLUseCase);
    var lChildUseCaseCount, I: integer;
        lUMLStateMachine: IUMLStateMachine;
        lUMLChildUseCase: IUMLUseCase;
  begin
    for lChildUseCaseCount := 0 to piRootUseCase.GetSpecializationCount - 1 do
    begin
      lUMLChildUseCase := piRootUseCase.GetSpecializationAt(lChildUseCaseCount).Child as IUMLUseCase;
      if SameText(lUMLChildUseCase.Name, piUseCaseName) then
      begin
        for I := 0 to lUMLChildUseCase.GetOwnedDiagramCount - 1 do
          lUMLChildUseCase.GetOwnedDiagramAt(I).DiagramView.ExportDiagramAsJPEG(piTargetDirectory + piUseCaseName + lUMLChildUseCase.GetOwnedDiagramAt(I).Name + '.jpg');

        if lUMLChildUseCase.GetBehaviorCount > 0 then
        begin
          lUMLStateMachine := lUMLChildUseCase.GetBehaviorAt(0);
          for I := 0 to lUMLStateMachine.GetOwnedDiagramCount - 1 do
            lUMLStateMachine.GetOwnedDiagramAt(I).DiagramView.ExportDiagramAsJPEG(piTargetDirectory + piUseCaseName + lUMLStateMachine.GetOwnedDiagramAt(I).Name + '.jpg');
        end;
      end
      else
        FindAndSave(lUMLChildUseCase);
    end;
  end;

  var lElement: IElement;
      lUMLRootUseCase: IUMLUseCase;

begin
  lElement := gStarUMLApp.FindByPathname(MODELO + '::FrameworkModel::acuFrameworkPackage::UCU::ucUseCase');
  lUMLRootUseCase := lElement as IUMLUseCase;
  FindAndSave(lUMLRootUseCase);
end;

function TUtil.SQLScriptCreateDirectTable(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;

  procedure GetDBColumns(piClassDBTicket: acClassToDBMapTicket; var poScript: string);
    var I: integer;
        lChildClassToDBMapTicket: acClassToDBMapTicket;
        lChildClassTicket: acClassTicket;
        lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
        lRelationTicket: acRelationTicket;
        lRelationPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
        lParentClassToDBMapTicket: acClassToDBMapTicket;
        lColumnTicket: acDBColumnMapTicket;
        lEnum: acEnumerator;
  begin
    lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

    lEnum := piClassDBTicket.Columns.GetEnumerator;
    while not lEnum.EOL do
    begin
      lColumnTicket := acDBColumnMapTicket(lEnum.Current);
      if lColumnTicket.AttributeTicket.Stereotype = acAttributeStereotype.pvPersistent then
      begin
        poScript := concat(poScript, ',', #13#10);
        lParentClassToDBMapTicket := nil;
        if assigned(piClassDBTicket.ClassTicket.ParentClassTicket) then
          lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassDBTicket.ClassTicket.ParentClassTicket);
        if (not assigned(lParentClassToDBMapTicket)) or
           (not SameText(piClassDBTicket.TableName, lParentClassToDBMapTicket.TableName)) then
          poScript := concat(poScript, SQLScriptDBColumn(lColumnTicket, false, piDBVendor))
        else
          poScript := concat(poScript, SQLScriptDBColumn(lColumnTicket, true, piDBVendor))
      end;
      lEnum.MoveNext;
    end;

    for i := piClassDBTicket.ClassTicket.RelationTicketsIn.Count - 1 downto 0 do
    begin
      lRelationTicket := acRelationTicket(piClassDBTicket.ClassTicket.RelationTicketsIn.Objects[i]);
      lRelationPersistenceMapTicket := lMetaModelPersistenceMapSQL.RelationsSQLPersistenceMapTicket[lRelationTicket];
      if (lRelationTicket.DestinationMaxMultiplicity <= 1) then
        if (lRelationPersistenceMapTicket is acDirectDBRelationMapTicket)then
        begin
          poScript := concat(poScript, ',', #13#10);

          case piDBVendor of
            dbvOracle: poScript := concat(poScript, acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName, StringOfChar(' ', 50 - Length(acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName)), uppercase('number(10)'));
          else
            poScript := concat(poScript, acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName, StringOfChar(' ', 50 - Length(acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName)), uppercase('INT'));
          end;

          lParentClassToDBMapTicket := nil;
          if assigned(piClassDBTicket.ClassTicket.ParentClassTicket) then
            lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassDBTicket.ClassTicket.ParentClassTicket);
          if (not assigned(lParentClassToDBMapTicket)) or
             (not SameText(piClassDBTicket.TableName, lParentClassToDBMapTicket.TableName)) then
          begin
            if lRelationTicket.DestinationMinMultiplicity > 0 then
              poScript := concat(poScript, ' NOT NULL')
            else
              case piDBVendor of
                dbvDB2   : poScript := concat(poScript,'');//faz nada
              else
                poScript := concat(poScript, ' NULL');
              end;
          end
          else
          begin
            case piDBVendor of
              dbvDB2   : poScript := concat(poScript,'');//faz nada
            else
              poScript := concat(poScript, ' NULL');
            end;
          end;
        end;
    end;

    for I := 0 to piClassDBTicket.ClassTicket.DirectDescendants.Count - 1 do
    begin
      lChildClassTicket := acClassTicket(piClassDBTicket.ClassTicket.DirectDescendants.Items[i]);
      lChildClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lChildClassTicket);
      if lChildClassToDBMapTicket.TableName = piClassDBTicket.TableName then
        GetDBColumns(lChildClassToDBMapTicket, poScript);
    end;
  end;

var
  lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
  lParentClassToDBMapTicket: acClassToDBMapTicket;
begin
  Result := '';
  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  lParentClassToDBMapTicket := nil;
  if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
    lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassToDBMapTicket.ClassTicket.ParentClassTicket);

  if (not assigned(lParentClassToDBMapTicket)) or
     (not SameText(piClassToDBMapTicket.TableName, lParentClassToDBMapTicket.TableName)) then
  begin
    if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
      Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                           piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
    else
      Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);

    case piDBVendor of
      dbvOracle:
      begin
        Result := concat(Result, 'begin execute immediate ', #13#10);
        Result := concat(Result, '''CREATE TABLE ', piClassToDBMapTicket.TableName, ' (', #13#10);
        Result := concat(Result, piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns)), uppercase('number(10) PRIMARY KEY'));
        GetDBColumns(piClassToDBMapTicket, result);
        if piClassToDBMapTicket.TypeColumnName <> '' then //if (piClassToDBMapTicket.ClassTicket.isPatriarc) and (piClassToDBMapTicket.ClassTicket.HasDescendants) then
        begin
          result := concat(result, ',', #13#10);
          result := concat(result, piClassToDBMapTicket.TypeColumnName, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.TypeColumnName)), 'number(10) NOT NULL');
        end;
        Result := concat(Result, #13#10, ')'';', #13#10);
        Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');
      end;
      dbvDB2:
      begin
        Result := concat(Result, 'CREATE TABLE ', piClassToDBMapTicket.TableName, ' (', #13#10);
        Result := concat(Result, piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns)), uppercase('INT NOT NULL PRIMARY KEY'));
        GetDBColumns(piClassToDBMapTicket, result);
        if piClassToDBMapTicket.TypeColumnName <> '' then //if (piClassToDBMapTicket.ClassTicket.isPatriarc) and (piClassToDBMapTicket.ClassTicket.HasDescendants) then
        begin
          result := concat(result, ',', #13#10);
          result := concat(result, piClassToDBMapTicket.TypeColumnName, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.TypeColumnName)), 'INT NOT NULL');
        end;
        Result := concat(Result, #13#10, ');');
      end;
      else
      begin
        Result := concat(Result, 'CREATE TABLE ', piClassToDBMapTicket.TableName, ' (', #13#10);
        Result := concat(Result, piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns)), uppercase('INT PRIMARY KEY'));
        GetDBColumns(piClassToDBMapTicket, result);
        if piClassToDBMapTicket.TypeColumnName <> '' then //if (piClassToDBMapTicket.ClassTicket.isPatriarc) and (piClassToDBMapTicket.ClassTicket.HasDescendants) then
        begin
          result := concat(result, ',', #13#10);
          result := concat(result, piClassToDBMapTicket.TypeColumnName, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.TypeColumnName)), 'INT NOT NULL');
        end;
        Result := concat(Result, #13#10, ');');
      end;

    end;
  end;
end;

function TUtil.SQLScriptCreateIndirectTable(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;
begin
  Result := concat(format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.Name,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);

  case piDBVendor of
    dbvOracle:
      begin
        Result := concat(Result, 'begin execute immediate ', #13#10);
        Result := concat(Result, '''CREATE TABLE ', piIndirectDBRelationMapTicket.TableName, ' (', #13#10);
        Result := concat(Result, piIndirectDBRelationMapTicket.FKOrigemName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKOrigemName)), uppercase('number(10) NOT NULL,'),#13#10);
        Result := concat(Result, piIndirectDBRelationMapTicket.FKDestinoName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKDestinoName)), uppercase('number(10) NOT NULL'));
        Result := concat(Result, #13#10, ')'';', #13#10);
        Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');
      end;
    else
      begin
        Result := concat(Result, 'CREATE TABLE ', piIndirectDBRelationMapTicket.TableName, ' (', #13#10);
        Result := concat(Result, piIndirectDBRelationMapTicket.FKOrigemName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKOrigemName)), uppercase('INT NOT NULL,'),#13#10);
        Result := concat(Result, piIndirectDBRelationMapTicket.FKDestinoName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKDestinoName)), uppercase('INT NOT NULL'));
        Result := concat(Result, #13#10, ');');
      end;
  end;
end;

function TUtil.SQLScriptIndirectTableForeignKeys(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket; piDBVendor: TDataBaseVendor): string;
  var lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
      lOriginClassToDBMapTicket,
      lDestinationClassToDBMapTicket: acClassToDBMapTicket;
      lNomeConstraint: string;
begin
  result := '';
  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  lOriginClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket);
  lDestinationClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket);

  Result := concat(Result, format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.Name,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);

  if piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName <> ''
    then lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName
    else lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName;

  if piDBVendor = dbvDB2 then lNomeConstraint := Copy(lNomeConstraint,1,18);

  case piDBVendor of
    dbvOracle:
    begin
      Result := concat(Result, 'begin execute immediate ', #13#10);
      result := concat(result, Format('''ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)'';',
                                       [piIndirectDBRelationMapTicket.TableName,
                                       lNomeConstraint,
                                       piIndirectDBRelationMapTicket.FKOrigemName,
                                       lOriginClassToDBMapTicket.TableName,
                                       lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10);
      Result := concat(Result, 'exception when others then raise;', #13#10, 'end;', #13#10#13#10);

      if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> ''
        then lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName
        else lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName;

      Result := concat(Result, 'begin execute immediate ', #13#10);
      result := concat(result, Format('''ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)'';',
                                       [piIndirectDBRelationMapTicket.TableName,
                                       lNomeConstraint,
                                       piIndirectDBRelationMapTicket.FKDestinoName,
                                       lDestinationClassToDBMapTicket.TableName,
                                       lDestinationClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10);
      Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');

      if piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName <> '' then
      begin
        Result := concat(Result, #13#10#13#10);
        Result := concat(Result, 'begin execute immediate ', #13#10);
        result := concat(result, Format('''CREATE UNIQUE INDEX %s ON %s (%s, %s)'';',
                                       ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName,
                                        piIndirectDBRelationMapTicket.TableName,
                                        piIndirectDBRelationMapTicket.FKOrigemName,
                                        piIndirectDBRelationMapTicket.FKDestinoName]),#13#10);
        Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');
      end;
      if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> '' then
      begin
        Result := concat(Result, #13#10#13#10);
        Result := concat(Result, 'begin execute immediate ', #13#10);
        result := concat(result, Format('''CREATE UNIQUE INDEX %s ON %s (%s, %s)'';',
                                       ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName,
                                        piIndirectDBRelationMapTicket.TableName,
                                        piIndirectDBRelationMapTicket.FKDestinoName,
                                        piIndirectDBRelationMapTicket.FKOrigemName]),#13#10);
        Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');
      end;
    end;
    else
    begin
      result := concat(result, Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
                                       [piIndirectDBRelationMapTicket.TableName,
                                       lNomeConstraint,
                                       piIndirectDBRelationMapTicket.FKOrigemName,
                                       lOriginClassToDBMapTicket.TableName,
                                       lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10#13#10);

      if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> ''
        then lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName
        else lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName;

      result := concat(result, Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
                                       [piIndirectDBRelationMapTicket.TableName,
                                       lNomeConstraint,
                                       piIndirectDBRelationMapTicket.FKDestinoName,
                                       lDestinationClassToDBMapTicket.TableName,
                                       lDestinationClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]));

      if piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName <> '' then
      begin
        Result := concat(Result, #13#10#13#10);
        result := concat(result, Format('CREATE UNIQUE INDEX %s ON %s (%s, %s);',
                                       ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName,
                                        piIndirectDBRelationMapTicket.TableName,
                                        piIndirectDBRelationMapTicket.FKOrigemName,
                                        piIndirectDBRelationMapTicket.FKDestinoName]));
      end;
      if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> '' then
      begin
        Result := concat(Result, #13#10#13#10);
        result := concat(result, Format('CREATE UNIQUE INDEX %s ON %s (%s, %s);',
                                       ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName,
                                        piIndirectDBRelationMapTicket.TableName,
                                        piIndirectDBRelationMapTicket.FKDestinoName,
                                        piIndirectDBRelationMapTicket.FKOrigemName]));
      end;
    end;
  end;
end;

function TUtil.SQLScriptDirectTableForeignKeys(piClassToDBMapTicket: acClassToDBMapTicket; piDBVendor: TDataBaseVendor): string;
  var I: integer;
      lRelationTicket: acRelationTicket;
      lRelationPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
      lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
      lOriginClassToDBMapTicket,
      lDestinationClassToDBMapTicket: acClassToDBMapTicket;
      lParentClassToDBMapTicket: acClassToDBMapTicket;
      lComment: boolean;
      lAux: string;
      lNomeConstraint: string;
begin
  result := '';
  lComment := false;
  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  if (not piClassToDBMapTicket.ClassTicket.isPatriarc) then
  begin
    lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassToDBMapTicket.ClassTicket.ParentClassTicket);
    if not SameText(piClassToDBMapTicket.TableName, lParentClassToDBMapTicket.TableName) then
    begin
      lComment := true;
      if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
        Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                             piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
      else
        Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);

      lNomeConstraint := 'F' + StringReplace(piClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns;

      if piDBVendor = dbvDB2 then lNomeConstraint := Copy(lNomeConstraint,1,18);

      case piDBVendor of
        dbvOracle:
        begin
          Result := concat(Result, 'begin execute immediate ', #13#10);
          result := concat(result,
                             Format('''ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)'';',
                                    [piClassToDBMapTicket.TableName,
                                    lNomeConstraint,
                                    piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns,
                                    lParentClassToDBMapTicket.TableName,
                                    lParentClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10);
          Result := concat(Result, 'exception when others then raise;', #13#10, 'end;');
        end;
        else
        begin
          result := concat(result,
                             Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
                                    [piClassToDBMapTicket.TableName,
                                    lNomeConstraint,
                                    piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns,
                                    lParentClassToDBMapTicket.TableName,
                                    lParentClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]));
        end;
      end;
    end;
  end;

  for i := piClassToDBMapTicket.ClassTicket.RelationTicketsIn.Count - 1 downto 0 do
  begin
    lRelationTicket := acRelationTicket(piClassToDBMapTicket.ClassTicket.RelationTicketsIn.Objects[i]);
    lRelationPersistenceMapTicket := lMetaModelPersistenceMapSQL.RelationsSQLPersistenceMapTicket[lRelationTicket];
    if (lRelationTicket.DestinationMaxMultiplicity <= 1) then
    begin
      if (lRelationPersistenceMapTicket is acDirectDBRelationMapTicket)then
      begin

        if not lComment then
        begin
          lComment := true;
          if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
            Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                                 piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
          else
            Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);
        end
        else
          Result := concat(Result, #13#10#13#10);

        lOriginClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lRelationTicket.OriginClassTicket);
        lDestinationClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lRelationTicket.DestinationClassTicket);

        Result := concat(Result, format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[lRelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                                     EncodeMultiplicity(lRelationTicket.OriginMinMultiplicity),
                                                                     EncodeMultiplicity(lRelationTicket.OriginMaxMultiplicity),
                                                                     lRelationTicket.Name,
                                                                     EncodeMultiplicity(lRelationTicket.DestinationMinMultiplicity),
                                                                     EncodeMultiplicity(lRelationTicket.DestinationMaxMultiplicity),
                                                                     lRelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);

        lNomeConstraint := 'F' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName;

        if piDBVendor = dbvDB2 then lNomeConstraint := Copy(lNomeConstraint,1,18);

        case piDBVendor of
          dbvOracle:
          begin
            Result := concat(Result, 'begin execute immediate ', #13#10);
            result := concat(result,
                               Format('''ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s)'';',
                                      [lDestinationClassToDBMapTicket.TableName,
                                      lNomeConstraint,
                                      acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
                                      lOriginClassToDBMapTicket.TableName,
                                      lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10);
            Result := concat(Result, 'exception when others then raise;', #13#10, 'end;',#13#10#13#10);

            Result := concat(Result, 'begin execute immediate ', #13#10);
            result := concat(result, Format('''CREATE INDEX %s ON %s (%s)'';',
                                      ['I' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
                                      lDestinationClassToDBMapTicket.TableName,
                                      acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName]),#13#10);
            Result := concat(Result, 'exception when others then raise;', #13#10, 'end;',#13#10#13#10);
          end;
          else
          begin
            result := concat(result,
                               Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
                                      [lDestinationClassToDBMapTicket.TableName,
                                      lNomeConstraint,
                                      acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
                                      lOriginClassToDBMapTicket.TableName,
                                      lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10#13#10);

            result := concat(result, Format('CREATE INDEX %s ON %s (%s);',
                                      ['I' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
                                      lDestinationClassToDBMapTicket.TableName,
                                      acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName]));
          end;

        end;
      end;
    end;
  end;

  if piClassToDBMapTicket.ClassTicket.DBIndexes <> '' then
  begin
    result := concat(result, #13#10#13#10);
    result := concat(result, '-- Indexes created by user (IDX tag)', #13#10);
    case piDBVendor of
      dbvOracle:
      begin
        lAux := piClassToDBMapTicket.ClassTicket.DBIndexes;

        lAux := StringReplace(lAux, #13#10,'',[rfReplaceAll]);
        lAux := StringReplace(lAux, ';','',[rfReplaceAll]);
        lAux := StringReplace(lAux, 'create ', concat(''';##begin execute immediate ', #13#10, '''create '), [rfReplaceAll, rfIgnoreCase]);
        lAux := StringReplace(lAux, '##','',[]);
        lAux := StringReplace(lAux, '##',concat(#13#10,'exception when others then raise;', #13#10, 'end;', #13#10#13#10),[rfReplaceAll]);
        lAux := concat(lAux, ''';', #13#10, 'exception when others then raise;', #13#10, 'end;');
        lAux := StringReplace(lAux, ''';','',[]);

        Result := concat(Result, lAux, #13#10);
      end;
      else
      begin
        result := concat(result, piClassToDBMapTicket.ClassTicket.DBIndexes);
      end;
    end;
  end;
end;

function TUtil.SQLScriptDropDirectTable(piClassToDBMapTicket: acClassToDBMapTicket;
  piDBVendor: TDataBaseVendor): string;
var
  lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
  lParentClassToDBMapTicket: acClassToDBMapTicket;
begin
  Result := '';
  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  lParentClassToDBMapTicket := nil;
  if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
    lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassToDBMapTicket.ClassTicket.ParentClassTicket);

  if (not assigned(lParentClassToDBMapTicket)) or
     (not SameText(piClassToDBMapTicket.TableName, lParentClassToDBMapTicket.TableName)) then
  begin
    if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
      Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                           piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
    else
      Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);

    case piDBVendor of
      dbvOracle:
      begin
        result := concat(Result, 'begin', #13#10);
        result := concat(result, format('  execute immediate ''drop table %s'';', [piClassToDBMapTicket.TableName]), #13#10);
        result := concat(Result, '  exception when others then null;', #13#10);
        result := concat(result, 'end;');
      end;
      dbvDB2:
      begin
        result := concat(result, format('IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(''%s'') AND type in (''U''))',
                                        [piClassToDBMapTicket.TableName]));
        result := concat(Result, #13#10);
        result := concat(result, format('DROP TABLE %s', [piClassToDBMapTicket.TableName]));
      end;
      else
      begin
        result := concat(result, format('IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(''%s'') AND type in (''U''))',
                                        [piClassToDBMapTicket.TableName]));
        result := concat(Result, #13#10);
        result := concat(result, format('DROP TABLE %s', [piClassToDBMapTicket.TableName]));
      end;
    end;
//    Result := concat(Result, 'CREATE TABLE ', piClassToDBMapTicket.TableName, ' (', #13#10);

//    case piDBVendor of
//      dbvSQLServer: Result := concat(Result, piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns)), uppercase('INT PRIMARY KEY'));
//      dbvOracle: Result := concat(Result, piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns)), uppercase('number(10) PRIMARY KEY'));
//    end;

//    GetDBColumns(piClassToDBMapTicket, result);

//    if piClassToDBMapTicket.TypeColumnName <> '' then
////      if (piClassToDBMapTicket.ClassTicket.isPatriarc) and (piClassToDBMapTicket.ClassTicket.HasDescendants) then
//      begin
//        result := concat(result, ',', #13#10);
//        case piDBVendor of
//          dbvSQLServer: result := concat(result, piClassToDBMapTicket.TypeColumnName, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.TypeColumnName)), 'INT NOT NULL');
//          dbvOracle: result := concat(result, piClassToDBMapTicket.TypeColumnName, StringOfChar(' ', 50 - Length(piClassToDBMapTicket.TypeColumnName)), 'number(10) NOT NULL');
//        end;
//      end;
//
//    Result := concat(Result, #13#10, ');');
  end;
end;

function TUtil.SQLScriptDropDirectTableForeignKeys(piClassToDBMapTicket: acClassToDBMapTicket;
  piDBVendor: TDataBaseVendor): string;
  var I: integer;
      lRelationTicket: acRelationTicket;
      lRelationPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
      lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
//      lOriginClassToDBMapTicket,
      lDestinationClassToDBMapTicket: acClassToDBMapTicket;
      lParentClassToDBMapTicket: acClassToDBMapTicket;
      lComment: boolean;
begin
  result := '';
  lComment := false;
  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  if (not piClassToDBMapTicket.ClassTicket.isPatriarc) then
  begin
    lParentClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piClassToDBMapTicket.ClassTicket.ParentClassTicket);
    if not SameText(piClassToDBMapTicket.TableName, lParentClassToDBMapTicket.TableName) then
    begin
      lComment := true;
      if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
        Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                             piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
      else
        Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);

      case piDBVendor of
        dbvSQLServer:
        begin
          result := concat(result, format('IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(''%s'') AND parent_object_id = OBJECT_ID(''%s''))',
                                          ['F' + StringReplace(piClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns,
                                           piClassToDBMapTicket.TableName]));
          result := concat(Result, #13#10);
          result := concat(result, format('ALTER TABLE %s DROP CONSTRAINT %s',
                                          [piClassToDBMapTicket.TableName,
                                          'F' + StringReplace(piClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]));
        end;
        dbvOracle:
        begin
          result := concat(Result, 'begin', #13#10);
          result := concat(result, format('  execute immediate ''alter table %s drop constraint %s'';', [piClassToDBMapTicket.TableName,
                                                                                                        'F' + StringReplace(piClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns ]), #13#10);
          result := concat(Result, '  exception when others then null;', #13#10);
          result := concat(result, 'end;');
        end;
      end;
//      result := concat(result,
//                         Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
//                                [piClassToDBMapTicket.TableName,
//                                'F' + StringReplace(piClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns,
//                                piClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns,
//                                lParentClassToDBMapTicket.TableName,
//                                lParentClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]));
    end;
  end;

  for i := piClassToDBMapTicket.ClassTicket.RelationTicketsIn.Count - 1 downto 0 do
  begin
    lRelationTicket := acRelationTicket(piClassToDBMapTicket.ClassTicket.RelationTicketsIn.Objects[i]);
    lRelationPersistenceMapTicket := lMetaModelPersistenceMapSQL.RelationsSQLPersistenceMapTicket[lRelationTicket];
    if (lRelationTicket.DestinationMaxMultiplicity <= 1) then
    begin
      if (lRelationPersistenceMapTicket is acDirectDBRelationMapTicket)then
      begin

        if not lComment then
        begin
          lComment := true;
          if assigned(piClassToDBMapTicket.ClassTicket.ParentClassTicket) then
            Result := concat(Result, format('-- CLASS %s(%s)' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName,
                                                                 piClassToDBMapTicket.ClassTicket.ParentClassTicket.PersistentObjectClassName]),#13#10)
          else
            Result := concat(Result, format('-- CLASS %s' ,[piClassToDBMapTicket.ClassTicket.PersistentObjectClassName]),#13#10);
        end
        else
          Result := concat(Result, #13#10#13#10);

//        lOriginClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lRelationTicket.OriginTicket);
        lDestinationClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lRelationTicket.DestinationClassTicket);

        Result := concat(Result, format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[lRelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                                     EncodeMultiplicity(lRelationTicket.OriginMinMultiplicity),
                                                                     EncodeMultiplicity(lRelationTicket.OriginMaxMultiplicity),
                                                                     lRelationTicket.Name,
                                                                     EncodeMultiplicity(lRelationTicket.DestinationMinMultiplicity),
                                                                     EncodeMultiplicity(lRelationTicket.DestinationMaxMultiplicity),
                                                                     lRelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);


        case piDBVendor of
          dbvSQLServer:
          begin
            result := concat(result, format('IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(''%s'') AND parent_object_id = OBJECT_ID(''%s''))',
                                            ['F' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
                                             lDestinationClassToDBMapTicket.TableName]));
            result := concat(Result, #13#10);
            result := concat(result, format('ALTER TABLE %s DROP CONSTRAINT %s',
                                            [lDestinationClassToDBMapTicket.TableName,
                                            'F' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName]));
          end;
          dbvOracle:
          begin
            result := concat(Result, 'begin', #13#10);
            result := concat(result, format('  execute immediate ''alter table %s drop constraint %s'';', [lDestinationClassToDBMapTicket.TableName,
                                                                                                          'F' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName]), #13#10);
            result := concat(Result, '  exception when others then null;', #13#10);
            result := concat(result, 'end;');
          end;
        end;

//        result := concat(result,
//                           Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
//                                  [lDestinationClassToDBMapTicket.TableName,
//                                  'F' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
//                                  acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
//                                  lOriginClassToDBMapTicket.TableName,
//                                  lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10#13#10);
//
//        result := concat(result, Format('CREATE INDEX %s ON %s (%s);',
//                                  ['I' + StringReplace(lDestinationClassToDBMapTicket.ClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName,
//                                  lDestinationClassToDBMapTicket.TableName,
//                                  acDirectDBRelationMapTicket(lRelationPersistenceMapTicket).FKColumnName]));
      end;
    end;
  end;

//  if piClassToDBMapTicket.ClassTicket.DBIndexes <> '' then
//  begin
//    result := concat(result, #13#10#13#10);
//    result := concat(result, '-- Indexes created by user (IDX tag)', #13#10);
//    result := concat(result, piClassToDBMapTicket.ClassTicket.DBIndexes);
//  end;
end;

function TUtil.SQLScriptDropIndirectTable(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket;
  piDBVendor: TDataBaseVendor): string;
begin
  Result := concat(format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.Name,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);

  case piDBVendor of
    dbvSQLServer:
    begin
      result := concat(result, format('IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(''%s'') AND type in (''U''))',
                                      [piIndirectDBRelationMapTicket.TableName]));
      result := concat(Result, #13#10);
      result := concat(result, format('DROP TABLE %s', [piIndirectDBRelationMapTicket.TableName]));
    end;
    dbvOracle:
    begin
      result := concat(Result, 'begin', #13#10);
      result := concat(result, format('  execute immediate ''drop table %s'';', [piIndirectDBRelationMapTicket.TableName]), #13#10);
      result := concat(Result, '  exception when others then null;', #13#10);
      result := concat(result, 'end;');
    end;
  end;

//  Result := concat(Result, 'CREATE TABLE ', piIndirectDBRelationMapTicket.TableName, ' (', #13#10);
//  case piDBVendor of
//    dbvSQLServer:
//      begin
//        Result := concat(Result, piIndirectDBRelationMapTicket.FKOrigemName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKOrigemName)), uppercase('INT NOT NULL,'),#13#10);
//        Result := concat(Result, piIndirectDBRelationMapTicket.FKDestinoName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKDestinoName)), uppercase('INT NOT NULL'));
//      end;
//    dbvOracle:
//      begin
//        Result := concat(Result, piIndirectDBRelationMapTicket.FKOrigemName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKOrigemName)), uppercase('number(10) NOT NULL,'),#13#10);
//        Result := concat(Result, piIndirectDBRelationMapTicket.FKDestinoName, StringOfChar(' ', 50 - Length(piIndirectDBRelationMapTicket.FKDestinoName)), uppercase('number(10) NOT NULL'));
//      end;
//  end;
//  Result := concat(Result, #13#10, ');');
end;

function TUtil.SQLScriptDropIndirectTableForeignKeys(piIndirectDBRelationMapTicket: acIndirectDBRelationMapTicket;
  piDBVendor: TDataBaseVendor): string;
var
//    lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
//    lOriginClassToDBMapTicket,
//    lDestinationClassToDBMapTicket: acClassToDBMapTicket;
  lNomeConstraint: string;

begin
  result := '';
//  lMetaModelPersistenceMapSQL := MetaModel.DefaultMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

//  lOriginClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piIndirectDBRelationMapTicket.RelationTicket.OriginTicket);
//  lDestinationClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(piIndirectDBRelationMapTicket.RelationTicket.DestinationTicket);

  Result := concat(Result, format('-- RELATION %s(%s..%s) <--%s--> (%s..%s)%s' ,[piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassName,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.OriginMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.Name,
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMinMultiplicity),
                                                               EncodeMultiplicity(piIndirectDBRelationMapTicket.RelationTicket.DestinationMaxMultiplicity),
                                                               piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassName]),#13#10);

  if piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName <> ''
    then lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName
    else lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName;

  case piDBVendor of
    dbvSQLServer:
    begin
      result := concat(result, format('IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(''%s'') AND parent_object_id = OBJECT_ID(''%s''))',
                                      [lNomeConstraint,
                                       piIndirectDBRelationMapTicket.TableName]));
      result := concat(Result, #13#10);
      result := concat(result, format('ALTER TABLE %s DROP CONSTRAINT %s',
                                      [piIndirectDBRelationMapTicket.TableName,
                                      lNomeConstraint]));
    end;
    dbvOracle:
    begin
      result := concat(Result, 'begin', #13#10);
      result := concat(result, format('  execute immediate ''alter table %s drop constraint %s'';', [piIndirectDBRelationMapTicket.TableName,
                                                                                                     lNomeConstraint]), #13#10);
      result := concat(Result, '  exception when others then null;', #13#10);
      result := concat(result, 'end;');
    end;
  end;

//  result := concat(result, Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
//                                   [piIndirectDBRelationMapTicket.TableName,
//                                   lNomeConstraint,
//                                   piIndirectDBRelationMapTicket.FKOrigemName,
//                                   lOriginClassToDBMapTicket.TableName,
//                                   lOriginClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]),#13#10#13#10);

  result := concat(Result, #13#10#13#10);

  if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> ''
    then lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName
    else lNomeConstraint := 'F' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationClassTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName;


  case piDBVendor of
    dbvSQLServer:
    begin
      result := concat(result, format('IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(''%s'') AND parent_object_id = OBJECT_ID(''%s''))',
                                      [lNomeConstraint,
                                       piIndirectDBRelationMapTicket.TableName]));
      result := concat(Result, #13#10);
      result := concat(result, format('ALTER TABLE %s DROP CONSTRAINT %s',
                                      [piIndirectDBRelationMapTicket.TableName,
                                      lNomeConstraint]));
    end;
    dbvOracle:
    begin
      result := concat(Result, 'begin', #13#10);
      result := concat(result, format('  execute immediate ''alter table %s drop constraint %s'';', [piIndirectDBRelationMapTicket.TableName,
                                                                                                     lNomeConstraint]), #13#10);
      result := concat(Result, '  exception when others then null;', #13#10);
      result := concat(result, 'end;');
    end;
  end;

//  result := concat(result, Format('ALTER TABLE %s ADD CONSTRAINT %s FOREIGN KEY (%s) REFERENCES %s(%s);',
//                                   [piIndirectDBRelationMapTicket.TableName,
//                                   lNomeConstraint,
//                                   piIndirectDBRelationMapTicket.FKDestinoName,
//                                   lDestinationClassToDBMapTicket.TableName,
//                                   lDestinationClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns]));

//  if piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName <> '' then
//  begin
//    Result := concat(Result, #13#10#13#10);
//    result := concat(result, Format('CREATE UNIQUE INDEX %s ON %s (%s, %s);',
//                                   ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.OriginTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.OriginPropertyName,
//                                    piIndirectDBRelationMapTicket.TableName,
//                                    piIndirectDBRelationMapTicket.FKOrigemName,
//                                    piIndirectDBRelationMapTicket.FKDestinoName]));
//  end;
//  if piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName <> '' then
//  begin
//    Result := concat(Result, #13#10#13#10);
//    result := concat(result, Format('CREATE UNIQUE INDEX %s ON %s (%s, %s);',
//                                   ['I' + StringReplace(piIndirectDBRelationMapTicket.RelationTicket.DestinationTicket.PersistentObjectClassCode, '-', 'S', [rfReplaceAll]) + piIndirectDBRelationMapTicket.RelationTicket.DestinationPropertyName,
//                                    piIndirectDBRelationMapTicket.TableName,
//                                    piIndirectDBRelationMapTicket.FKDestinoName,
//                                    piIndirectDBRelationMapTicket.FKOrigemName]));
//  end;
end;

procedure TUtil.AlimentaMetaModelStateMachine(piRootUseCase: IUMLUseCase; piStarUMLStateMachine: IUMLStateMachine; piStarUMLChildStateMachine: IUMLStateMachine; poStateMachine: utStateMachine; piLevel: integer);


  function CreateState(piUMLState: IUMLStateVertex): utState;
  var
        lUCStateMachine: IUMLStateMachine;
        lUMLStateAux: IUMLStateVertex;
        lUseCaseTicket: acUseCaseTicket;
        lUseCaseCode: string;
  begin
    result := nil;
    if (piUMLState.QueryInterface(IUMLSubmachineState, lUMLStateAux) = S_OK) then
    begin

      if not assigned ((piUMLState as IUMLSubmachineState).Submachine) then
      begin
        if piLevel = 0 then lUCStateMachine := piStarUMLChildStateMachine
        else
        begin
          gStarUMLApp.SelectInModelExplorer(piUMLState);
          raise Exception.Create(format('SubMachine state property not definied for state "%s".',[piUMLState.Pathname]));
        end;
      end
      else lUCStateMachine := (piUmlState as IUMLSubmachineState).Submachine;
      
      Result := utSubMachineState.create(poStateMachine, piUMLState.Name);

      lUseCaseCode := (lUCStateMachine.Context as IUMLUseCase).GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');
      if (trim(lUseCaseCode) = '') or (trim(lUseCaseCode) = '0') then
      begin
        raise Exception.Create(Format('Need to define tagged value "Code" for UseCase "%s" in DBUseCaseMap Tag Definition.',[(lUCStateMachine.Context as IUMLUseCase).Pathname]));
      end;

      lUseCaseTicket := MetaModel.UseCaseTicketByCode[lUseCaseCode];
      if not Assigned(lUseCaseTicket) then
      begin
        raise Exception.Create(Format('UseCaseTicket not found for UseCase "%s" in DBUseCaseMap Tag Definition.',[(lUCStateMachine.Context as IUMLUseCase).Pathname + ' ('+lUseCaseCode+')']));
      end;

      //ShowMessage((piUmlState as IUMLSubmachineState).Submachine.Context.Pathname);
      (Result as utSubMachineState).StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket , Result as utSubMachineState);
      utSubMachineState(Result).StateMachine.Name := lUCStateMachine.Name;
      AlimentaMetaModelStateMachine(piRootUseCase, lUCStateMachine, piStarUMLChildStateMachine, utSubMachineState(Result).StateMachine, piLevel + 1);
    end
    else if piUMLState.QueryInterface(IUMLFinalState, lUMLStateAux) = S_OK then
      Result := utFinalState.create(poStateMachine, piUMLState.Name)
    else if piUMLState.QueryInterface(IUMLState, lUMLStateAux) = S_OK then
      Result := utState.create(poStateMachine, piUMLState.Name);
  end;


  procedure ParseOperationsCodes(piSl: TStringList; piValue: string; piDelimiter: string);
  var dx : integer;
      ns : string;
      txt : string;
      delta : integer;
  begin
    delta := Length(piDelimiter) ;
    txt := piValue + piDelimiter;
    piSl.BeginUpdate;
    piSl.Clear;
    try
      while Length(txt) > 0 do
      begin
        dx := Pos(piDelimiter, txt) ;
        ns := Copy(txt,0,dx-1) ;
        piSl.Add(Trim(ns)) ;
        txt := Copy(txt,dx+delta,MaxInt) ;
      end;
    finally
      piSl.EndUpdate;
    end;
  end;


var
  lStateCount,lTransitionCount, I: integer;
  lUMLTopState: IUMLCompositeState;
  lUMLState, lUMLStateAux: IUMLStateVertex;
  lUMLTransition: IUMLTransition;

  lState: utState;
  lStateAux: utState;
  lTransition: utTransition;
  lHasInitialState: boolean;
//  lHasFinalState: boolean;

  lTriggerCode, lXsdIn, lXsdOut, lStrOperationsCodes, lUseCaseXSD, lXSDInName, lXSDOutName: string;
  lxsdFile: utXSDFile;
begin
  lTriggerCode := '';
  lXsdIn := '';
  lXsdOut := '';
  lxsdFile := nil;
  lStrOperationsCodes := '';

  lHasInitialState := false;
//  lHasFinalState := false;

  //Verifica se o caso de uso possui uma colecao de xsds. Se houver,
  //as tagged values das transicoes xsdin e xsdout dever conter o nome da xsd
  //que esta na colecao. Seno, dever conter o prprio xsd

  lUseCaseXSD := (piStarUMLStateMachine.Context as IUMLUsecase).GetTaggedValueAsString('DBMappings', 'UseCaseMap', 'XSDs');
  if lUseCaseXSD <> '' then lxsdFile := utXSDFile.create(lUseCaseXSD);
  try
    //Varre todos os estados do StateMachine
    lUMLTopState := piStarUMLStateMachine.Top as IUMLCompositeState;
    for lStateCount := 0 to lUMLTopState.GetSubvertexCount - 1 do
    begin
      lUMLState := lUMLTopState.GetSubvertexAt(lStateCount) ;

      lState := poStateMachine.FindState(lUMLState.Name);

      if not Assigned(lState) then
        lState := CreateState(lUMLState);

      if lUMLState.QueryInterface(IUMLState, lUMLStateAux) = S_OK then
      begin
        if (lUMLState.QueryInterface(IUMLFinalState, lUMLStateAux) = S_OK) then
//          lHasFinalState := true;

        //Adiciona EntryActions
        for I := 0 to (lUMLState as IUMLState).GetEntryActionCount - 1 do
          lState.AddEntryAction((lUMLState as IUMLState).GetEntryActionAt(i).Name);

        //Adiciona os DoActions
        for I := 0 to (lUMLState as IUMLState).GetDoActivityCount - 1 do
          lState.AddDoAction((lUMLState as IUMLState).GetDoActivityAt(I).Name);

        //Adiciona ExitActions
        for I := 0 to (lUMLState as IUMLState).GetExitActionCount - 1 do
          lState.AddExitAction((lUMLState as IUMLState).GetExitActionAt(i).Name);

        //Varre todas as transicoes de saida do estado atual
        if lUMLState.GetOutgoingCount = 0 then
        begin
          if not (lUMLState.QueryInterface(IUMLFinalState, lUMLStateAux) = S_OK) then
          begin
            gStarUMLApp.SelectInModelExplorer(lUMLState);
            raise Exception.Create(format('State "%s" must have at least one outgoing transition.', [lUMLState.Pathname]));
          end;
        end
        else
        begin
          for lTransitionCount := 0 to lUMLState.GetOutgoingCount - 1 do
          begin
            lUMLTransition := lUMLState.GetOutgoingAt(lTransitionCount);
            lTransition := lState.NewOutgoingTransition(lUMLTransition.Name);

            if trim(lUMLTransition.GuardCondition) <> '' then
              lTransition.GuardCondition := lUMLTransition.GuardCondition;

            if lUMLTransition.GetTriggerCount > 0 then
            begin
              for I := 0 to lUMLTransition.GetTriggerCount - 1 do
              begin
                lTriggerCode := lUMLTransition.GetTriggerAt(i).GetTaggedValueAsString ( 'DBMappings', 'DBSignalEventMap', 'Code');

                if lTriggerCode = '0' then lTriggerCode := '';
                if lTriggerCode <> '' then
                begin
                  if lState.TransitionTriggerExists(lTriggerCode) then
                  begin
                    gStarUMLApp.SelectInModelExplorer(lUMLTransition.GetTriggerAt(i));
                    raise Exception.Create(format('Trigger code "%s"("%s") already exists. It must be unique in the same state machine.', [lTriggerCode,lUMLTransition.GetTriggerAt(i).Pathname]));
                  end;
                end
                else
                  if lState.TransitionTriggerExists(lUMLTransition.GetTriggerAt(i).Name) then
                  begin
                    gStarUMLApp.SelectInModelExplorer(lUMLTransition.GetTriggerAt(i));
                    raise Exception.Create(format('Trigger name "%s" already exists. It must be unique in the same state machine.', [lUMLTransition.GetTriggerAt(i).Pathname]));
                  end;

                lTransition.AddTrigger(lUMLTransition.GetTriggerAt(i).Name, lTriggerCode);
              end;

              for I := 0 to lUMLTransition.GetEffectCount - 1 do
                lTransition.AddEffect(lUMLTransition.GetEffectAt(I).Name);
            end
            else
            begin
              if not (lUMLState.QueryInterface(IUMLPseudostate, lUMLStateAux) = S_OK) then
              begin
                gStarUMLApp.SelectInModelExplorer(lUMLTransition);
                raise Exception.Create(format('Transition "%s" must have a trigger.',[lUMLTransition.Pathname]));
              end;
            end;

            if assigned(lUMLTransition.Target) then
            begin
              lStateAux := poStateMachine.FindState(lUMLTransition.Target.Name);
              if not Assigned(lStateAux) then
                lStateAux := CreateState(lUMLTransition.Target);
              lTransition.TargetState := lStateAux;
            end;
            lTransition.SourceState := lState;


            //Verifica se o caso de uso possui uma colecao de xsds. Se houver,
            //as tagged values das transicoes xsdin e xsdout dever conter o nome da xsd
            //que esta na colecao. Seno, dever conter o prprio xsd
            if assigned(lxsdFile) then
            begin
              lXsdInName := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD In');
              lXsdOutName := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD Out');
              lXSDIn := '';
              lXSDOut:= '';

              if lXsdInName <> '' then
              begin
                if not lxsdFile.XSDExists(lXsdInName) then
                begin
                  gStarUMLApp.SelectInModelExplorer(lUMLTransition);
                  raise Exception.Create(format('Invalid XSDIn name "%s". Transition %s',[lXsdInName, lUMLTransition.Pathname]));
                end;
                lXSDIn := lxsdFile.XSDByName(lXsdInName).Text;
              end;

              if lXsdOutName <> '' then
              begin
                if not lxsdFile.XSDExists(lXsdOutName) then
                begin
                  gStarUMLApp.SelectInModelExplorer(lUMLTransition);
                  raise Exception.Create(format('Invalid XSDOut name "%s". Transition %s',[lXsdOutName, lUMLTransition.Pathname]));
                end;
                lXSDOut := lxsdFile.XSDByName(lXsdOutName).Text;
              end;
            end
            else
            begin
              lXsdIn := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD In');
              lXsdOut := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD Out');
            end;

            lStrOperationsCodes := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'Operations Codes');

            if not SameText(lStrOperationsCodes,'') then
            begin
              ParseOperationsCodes(lTransition.OperationsCodes, lStrOperationsCodes, ',');
            end;

            try
              if lXsdIn <> '' then
                lTransition.XsdIn.XML := lXsdIn;
            except
              on e: exception do
              begin
                gStarUMLApp.SelectInModelExplorer(lUMLTransition);
                raise Exception.Create(format('Tagged value "XSD In" has an invalid XML schema.' + #13#10#13#10 +
                                              'Statemachine: %s' + #13#10 +
                                              'State: %s' + #13#10 +
                                              'Transition: %s' + #13#10 +
                                              'Error: %s',
                                              [lUMLTransition.StateMachine.Pathname,
                                               lUMLState.Name,
                                               lUMLTransition.Name,
                                               e.Message]));
              end;
            end;

            try
              if lXsdOut <> '' then
                lTransition.XsdOut.XML := lXsdOut;
            except
              on e: exception do
              begin
                gStarUMLApp.SelectInModelExplorer(lUMLTransition);
                raise Exception.Create(format('Tagged value "XSD Out" has an invalid XML schema.' + #13#10#13#10 +
                                              'Statemachine: %s' + #13#10 +
                                              'State: %s' + #13#10 +
                                              'Transition: %s' + #13#10 +
                                              'Error: %s',
                                              [lUMLTransition.StateMachine.Pathname,
                                               lUMLState.Name,
                                               lUMLTransition.Name,
                                               e.Message]));
              end;
            end;
          end;
        end;
      end
      else
       //Define o Initial State
        if lUMLState.QueryInterface(IUMLPseudostate, lUMLStateAux) = S_OK then
        begin
          lHasInitialState := true;
          if lUMLState.GetOutgoingCount <> 1 then
          begin
            gStarUMLApp.SelectInModelExplorer(lUMLState);
            raise Exception.Create(format('The initial state "%s" must have one transition.',[lUMLState.Pathname]));
          end;

          lStateAux := poStateMachine.FindState(lUMLState.GetOutgoingAt(0).Target.Name);
          if not Assigned(lStateAux) then
            lStateAux := CreateState(lUMLState.GetOutgoingAt(0).Target);
          poStateMachine.InitialState := lStateAux;
        end;
    end;
  finally
    if assigned(lxsdFile) then lxsdfile.free;
  end;


  if not lHasInitialState then
  begin
    gStarUMLApp.SelectInModelExplorer(piStarUMLStateMachine);
    raise Exception.Create(format('State machine "%s" must have a Initial State (PseudoState).',[piStarUMLStateMachine.Pathname]));
  end;

//  if not lHasFinalState then
//    raise Exception.Create(format('State machine "%s" must have a Final State.',[piStarUMLStateMachine.Pathname]));

end;


function TUtil.AlimentarMetamodel(piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;
var lPrjManager: IProjectManager;
    lPrj: IUMLProject;
    lIMetaModel: IMetaModel;
//    lMetaClass: IMetaClass;
    lModel: IUMLModel;
    lPackage: IUMLPackage;
    lClassePersistentObject: IUMLClass;
    lElement: IElement;

    lRootUseCase: IUMLUseCase;

    lUMLBaseStateMachine: IUMLStateMachine;
    lUMLTopState: IUMLCompositeState;
    lUMLBaseSubmachineState: IUMLSubmachineState;

    I: integer;
    lLostClasses: TStringList;
//    lsResult: string;
begin
   if not piMetaModelOptions.SilentMode then PutMessage(FormatDateTime('hh:nn:ss', Time) +  ' - Generating model mappings...', gStarUMLApp.GetProject, 2);

   if piMetaModelOptions.SilentMode then
   begin
     piMetaModelOptions.CheckDBAttributeNameLength := false;
     piMetaModelOptions.CheckDBTableNameLength := false;
   end;

   try
     // Obtm Gerenciador de Projeto do STARUML
     lPrjManager := gStarUMLApp.Get_ProjectManager;

     // Obtm projeto do STARUML de onde sero extrados os elementos UML
     lPrj := lPrjManager.Get_Project;

     if assigned(lPrj) then
     begin
       // Meta Modelo do Star UML
       lIMetaModel := gStarUMLApp.MetaModel;

       //Obtem a classe acPersistentObject do modelo do StarUML
       lElement := gStarUMLApp.FindByPathname(MODELO + '::FrameworkModel::acuFrameworkPackage::' + cBASE_PERSISTENT_OBJECT_CLASS);

       if assigned(lElement) then
       begin
         lClassePersistentObject := lElement as IUMLClass;

         lLostClasses := TStringList.Create;
         try
           if FindLostClasses(lLostClasses) > 0 then
             for I := 0 to lLostClasses.Count - 1 do
               PutMessage(format('[Warning] Class "%s" does not descends from %s',[lLostClasses[i], cBASE_PERSISTENT_OBJECT_CLASS]),
                          gStarUMLApp.GetProject, 0);
         finally
           lLostClasses.Free;
         end;

         result := AlimentarMetamodelRegisterMapping(lClassePersistentObject, MetaModel, piMetaModelOptions, piProgress);

         lElement := gStarUMLApp.FindByPathname(MODELO);
         lModel := lElement as IUMLModel;

         lPackage := lModel as IUMLPackage;
         result := AlimentarMetamodelRelationsAll(lPackage, MetaModel, piMetaModelOptions, piProgress);

         lElement := gStarUMLApp.FindByPathname(MODELO + '::FrameworkModel::acuFrameworkPackage::UCU::ucUseCase');

         if not assigned(lElement) then raise Exception.Create('Use case "ucUseCase" not found.');

         lRootUseCase := lElement as IUMLUseCase;

         //Verifica a existencia da StateMachine smServer no caso de uso ucUseCase
         if (lRootUseCase.GetBehaviorCount = 0) or (lRootUseCase.GetBehaviorAt(0).Name <> cBASE_STATE_MACHINE) then
           raise Exception.Create('Statemachine "'+ cBASE_STATE_MACHINE + '" not found.');

         lUMLBaseStateMachine :=  lRootUseCase.GetBehaviorAt(0);
         lUMLTopState := lUMLBaseStateMachine.Top as IUMLCompositeState;

         for I := 0 to lUMLTopState.GetSubvertexCount - 1 do
           if lUMLTopState.GetSubvertexAt(i).Name = 'UseCaseSubmachine' then
           begin
             lUMLBaseSubmachineState := lUMLTopState.GetSubvertexAt(i) as IUMLSubmachineState;
             break;
           end;

         GerarUseCaseTickets((lElement as IUMLUseCase), MetaModel, piProgress);
         AlimentarMetamodelUseCase((lElement as IUMLUseCase), lUMLBaseStateMachine, lUMLBaseSubmachineState, MetaModel, piProgress);
         lUMLBaseSubmachineState.Submachine := nil;
         lElement := nil;
         if not piMetaModelOptions.SilentMode then PutMessage(FormatDateTime('hh:nn:ss', Time) +  ' - Model mappings generated.', gStarUMLApp.GetProject, 2);
       end;
     end;
     MetaModel.SetOrder;
   finally

   end;
end;

function TUtil.AlimentarMetamodelRegisterMapping(poClasseRaiz: IUMLClass; poMetaModel: acMetaModel; piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;
var index, index2, lFixSize, lVarSize: integer;
    lbMandatory: boolean;
    lClassChild: IUMLClass;
    lUMLAttribute: IUMLAttribute;
    lsNomeClasse, lsAtributo, lsAtributoType, lsIDO, lsClassCode, lsTabela, lsTypeColumnName, lsColumnName, lsResult, lsColumnDBType: String;
    lDBIntIdoMapTicket: acDBIdoMapTicket;
    lClassMapTicket: acClassTicket;
    lClassToDBMapTicket: acClassToDBMapTicket;
    lMetaModelPersistenceMap: acMetaModelPersistenceMap;
    prop: acAttributeTicket;
    lFormDBAttributeParams: TfDBAttributeParameters;
    lAttributeIsAuditable: boolean;
    lAuditDescription: string;
    lIndexes: string;

    lDbAttributeError: string;
    lClassDisplayName, lAttributeDisplayName: string;
    lClassErrors: TStringList;
begin

  if (poClasseRaiz.GetSpecializationCount > 0) then
  begin
    if assigned(piProgress) then piProgress.ChangeMessage('Creating Meta Model...', 0, poClasseRaiz.GetSpecializationCount);

    for index := 0 to (poClasseRaiz.GetSpecializationCount) - 1 do
    begin
      if assigned(piProgress) then piProgress.Inc;

      lClassChild := poClasseRaiz.GetSpecializationAt(index).Child as IUMLClass;

      // Busca atributos da classe
      lsNomeClasse := lClassChild.Name;

      lClassDisplayName := '';
      if assigned(gStarUMLApp.ExtensionManager.FindIncludedProfile('UserDisplayNames')) then
        lClassDisplayName := lClassChild.GetTaggedValueAsString('UserDisplayNames', 'ClassDisplayNames', 'DN');

      lsIDO := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO');
      lsTabela := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table');
      lsClassCode := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod');
      lsTypeColumnName := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Type');
      lAuditDescription := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'AuditDescription');
      lIndexes := lClassChild.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'IDX');

      if Trim(lsIDO) = '' then
      begin
        gStarUMLApp.SelectInModelExplorer(lClassChild);
        raise Exception.Create(Format('Need to define tagged value "DBIDO" for class "%s" in DBClassMap Tag Definition Set (DBMappings Profiler).',[lClassChild.Pathname]));
      end
      else
        if length(lsIDO) > 25 then
        begin
//          StarUMLApp.SelectInModelExplorer(lClassChild);
//          StarUMLApp.Log(Format('[Warning] Class "%s". Tagged value "DBIDO" is larger than 25 characters. May be a problem for database foreign key''s name.',[lClassChild.Pathname]));
          PutMessage(Format('[Warning] Class "%s". Tagged value "DBIDO" is larger than 25 characters. May be a problem for database foreign key''s name.',[lClassChild.Pathname]),
                     lClassChild, 0);
        end;

      if Trim(lsTabela) = '' then
      begin
        gStarUMLApp.SelectInModelExplorer(lClassChild);
        raise Exception.Create(Format('Need to define tagged value "Table" for class "%s" in DBClassMap Tag Definition Set (DBMappings Profiler).',[lClassChild.Pathname]));
      end;

      if piMetaModelOptions.CheckDBTableNameLength then
        if Length(lsTabela) > 30 then
          if MessageDlg(Format('Tagged value "Table" for class "%s" is larger than 30 characters. Ignore all and continue?',
                               [lClassChild.Pathname]), mtConfirmation, mbYesNo, 0) = idyes then
            piMetaModelOptions.CheckDBTableNameLength := false
          else
          begin
            gStarUMLApp.SelectInModelExplorer(lClassChild);
            raise Exception.Create('Operation stopped by user.')
          end;

      if Length(lsTabela) > 30 then
//        StarUMLApp.Log(format('[Warning] Class "%s". Tagged value "Table" is larger than 30 characters.', [lClassChild.Pathname]));
          PutMessage(format('[Warning] Class "%s". Tagged value "Table" is larger than 30 characters.', [lClassChild.Pathname]),
                     lClassChild, 0);


      if Trim(lsClassCode) = '' then
      begin
        gStarUMLApp.SelectInModelExplorer(lClassChild);
        raise Exception.Create(Format('Need to define tagged value "Cod" for class "%s" in DBClassMap Tag Definition Set (DBMappings Profiler).',[lClassChild.Pathname]));
      end;

      lClassMapTicket  := poMetaModel.NewClassRegisterTicket(lsClassCode, lsNomeClasse, poClasseRaiz.Name, 0);
      lClassMapTicket.AuditDescription := lAuditDescription;
      lClassMapTicket.DisplayName := lClassDisplayName;
      lClassMapTicket.DBIndexes := lIndexes;

      lMetaModelPersistenceMap := fMetaModelPersistenceMap;

      lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create(lsIDO);
      lClassToDBMapTicket := (lMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewClassToDBMapRegisterTicket(lsClassCode, lClassMapTicket, lDBIntIdoMapTicket);

      lClassToDBMapTicket.TableName := lsTabela;
      lClassToDBMapTicket.TypeColumnName := lsTypeColumnName;

      //Realiza as validaes dos atributos /////////////////////////////////////////////////////////////////////////////////
      for index2 := 0 to lClassChild.GetAttributeCount - 1 do
      begin
        lUMLAttribute := lClassChild.GetAttributeAt(index2);

        //Persistent  o stereotype default
        if (sametext(lUMLAttribute.StereotypeName,'')) then lUMLAttribute.SetStereotype('Persistent');

        if (sametext(lUMLAttribute.StereotypeName,'Persistent')) then
        begin
          lDbAttributeError := ValidateAttribute(lUMLAttribute, piMetaModelOptions.CheckDBAttributeNameLength);
          if lDbAttributeError <> '' then
          begin
            lFormDBAttributeParams := TfDBAttributeParameters.Create(nil, gStarUMLApp, lUMLAttribute);
            try
              lFormDBAttributeParams.Error := lDbAttributeError;
              lFormDBAttributeParams.ckbCheckLength.Checked := piMetaModelOptions.CheckDBAttributeNameLength;

              if lFormDBAttributeParams.ShowModal = mrok then
              begin
                piMetaModelOptions.CheckDBAttributeNameLength := lFormDBAttributeParams.ckbCheckLength.Checked;
              end
              else
              begin
                gStarUMLApp.SelectInModelExplorer(lUMLAttribute);
                raise Exception.Create(format('Invalid attribute database parameter for "%s"%s%s',[lUMLAttribute.Pathname, #13#10#13#10, lDbAttributeError]));
              end;
            finally
              lFormDBAttributeParams.Free;
            end;
          end;

          if length(lsColumnName) > 30 then
            PutMessage(format('[Warning] Class "%s". Attribute "%s". Tagged value "Name" is larger than 30 characters.', [lClassChild.Name, lUMLAttribute.Name]),
                       lUMLAttribute, 0);
        end; //if sametext(lUMLAttribute.StereotypeName,'Persistent') then
      end;

      lClassErrors := TStringList.Create;
      try
        if ValidateClass(lClassChild, lClassErrors) > 0 then
        begin
          gStarUMLApp.SelectInModelExplorer(lClassChild);
          raise Exception.Create(format('The following errors were found in class "%s":%s%s', [lClassChild.Pathname, #13#13, lClassErrors.Text]));
        end;
      finally
        lClassErrors.free;
      end;
      ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


      // Percorre atributos da classe
      for index2 := 0 to lClassChild.GetAttributeCount - 1 do
      begin
        lUMLAttribute := lClassChild.GetAttributeAt(index2);

        lAttributeDisplayName := '';
        if assigned(gStarUMLApp.ExtensionManager.FindIncludedProfile('UserDisplayNames')) then
          lAttributeDisplayName := lUMLAttribute.GetTaggedValueAsString('UserDisplayNames', 'AttributeDisplayNames', 'DN');

        lsAtributo := lUMLAttribute.Name;

        lAttributeIsAuditable := sametext(lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'IsAuditable'), 'True');
        lsColumnName := lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name');
        lsColumnDBType := lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Type');
        lFixSize := strtointdef(lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'FSize'),0);
        lVarSize := strtointdef(lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'VSize'),0);
        lbMandatory := sametext(lUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Mand'), 'True');

        if assigned(lUMLAttribute.Type_)
          then lsAtributoType := (lUMLAttribute.Type_ as IUMLClass).Name
          else lsAtributoType := lUMLAttribute.TypeExpression;

        if sametext(lUMLAttribute.StereotypeName, 'Persistent') then
        begin
          prop := lClassMapTicket.NewAttributeTicket(lsAtributo, lsAtributoType, acAttributeStereotype.pvPersistent, lAttributeIsAuditable, -1);
          prop.FixSize := lFixSize;
          prop.VarSize := lVarSize;
          prop.Mandatory := lbMandatory;
          prop.DBType := lsColumnDBType;
        end
        else if sametext(lUMLAttribute.StereotypeName, 'Transient') then
          prop := lClassMapTicket.NewAttributeTicket(lsAtributo, lsAtributoType, acAttributeStereotype.pvTransient, lAttributeIsAuditable, -1)
        else if sametext(lUMLAttribute.StereotypeName, 'Derived') then
          prop := lClassMapTicket.NewAttributeTicket(lsAtributo, lsAtributoType, acAttributeStereotype.pvDerived, lAttributeIsAuditable, -1)
        else
        begin
          gStarUMLApp.SelectInModelExplorer(lUMLAttribute);
          raise Exception.Create(Format('Need to define Stereotype (Persistent, Transient or Derived) property for attribute "%s".',[lUMLAttribute.Pathname]));
        end;

        prop.DisplayName := lAttributeDisplayName;

        case lUMLAttribute.Visibility of
          vkPublic: prop.Visibility := acAttributeVisibility.pvPublic;
          vkProtected: prop.Visibility := acAttributeVisibility.pvProtected;
          vkPrivate: prop.Visibility := acAttributeVisibility.pvPrivate;
          else prop.Visibility := acAttributeVisibility.pvPrivate;
        end;
        lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := lsColumnName;
      end;
//        PersistenceManager.RegisterClass(lsNomeClasse, AlimentarMetamodelRegisterMapping);
      lsResult := lsResult + self.AlimentarMetamodelRegisterMapping(lClassChild, poMetaModel, piMetaModelOptions, piProgress);
    end;
  end;

 result := lsResult;
 end;


function TUtil.AlimentarMetamodelRelationsAll(poPackage: IUMLPackage; poMetaModel: acMetaModel; piMetaModelOptions: TMetaModelGenerationOptions; piProgress: TFShowProgress): string;
var lRelationTicket: acRelationTicket;
    liOriginMinCardinalidade, liOriginMaxCardinalidade, liDestinationMinCardinalidade, liDestinationMaxCardinalidade: integer;
    index, lPos: integer;
    lAssociacao: IUMLAssociation;
    lPackage: IUMLPackage;
    sOriginCardinalidade, sDestinationCardinalidade, lsresult: String;
    sDBAssociationTableName, FKAColumnName, FKBColumnName, lsMin, lsMax: String;
    bIndireta: Boolean;
    sOriginClassName, sOriginPropertyName, sRelationName, sDestinationClassName, sDestinationPropertyName: String;
    piMetaModelPersistenceMap: acMetaModelPersistenceMap;
    lModelElement: IUMLModelElement;
    lacOrAggregation, lacDsAggregation: Integer;
    lIsAuditable: boolean;
    lBidirectional: boolean;
    lDisplayName, lDestinationDisplayName, lOriginDisplayName: string;
begin
  lacOrAggregation := acPropertyAggregation.pvNone;
  lacDsAggregation := acPropertyAggregation.pvNone;

    // Percorre todos os elementos do modelo
  if assigned(piProgress) then piProgress.ChangeMessage('Creating Meta Model relations...', 0, poPackage.GetSpecializationCount);
  for index := 0 to poPackage.GetOwnedElementCount - 1 do
  begin
    if assigned(piProgress) then piProgress.Inc;

    lModelElement := poPackage.GetOwnedElementAt(index);

    // Busca as associaes dentro dos pacotes ou modelo
    if (lModelElement.GetClassName = 'UMLAssociation') then
    begin
      lAssociacao := lModelElement as IUMLAssociation;

      //Unico tipo de associao(UMLAssociation) utilizado atualmente so associaes entre classes;
      //Qualquer outro tipo de associao  ignorado na gerao do MetaModel
      if(lAssociacao.GetConnectionAt(0).Get_Participant.IsKindOf('UMLClass')) and
        (lAssociacao.GetConnectionAt(1).Get_Participant.IsKindOf('UMLClass')) then
      begin
        sRelationName             := lAssociacao.Name;

        try
          sOriginClassName          := (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Name;
        except
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('Association "%s" is orphan.', [sRelationName]));
        end;

        lIsAuditable := sametext(lAssociacao.GetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'IsAuditable'), 'True');

        if (trim(sRelationName) = '') and (lIsAuditable) then
        begin
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('Auditable association must have a name (%s).', [sRelationName]));
        end;

        sDestinationClassName     := (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Name;

        sOriginPropertyName       := lAssociacao.GetConnectionAt(1).Name;
        sDestinationPropertyName  := lAssociacao.GetConnectionAt(0).Name;

        sOriginCardinalidade      := lAssociacao.GetConnectionAt(1).Get_Multiplicity;
        sDestinationCardinalidade := lAssociacao.GetConnectionAt(0).Get_Multiplicity;

        case lAssociacao.GetConnectionAt(0).Aggregation of
          akNone: lacOrAggregation := acPropertyAggregation.pvNone;
          akAggregate: lacOrAggregation := acPropertyAggregation.pvAggregate;
          akComposite: lacOrAggregation := acPropertyAggregation.pvComposite;
        end;

        case lAssociacao.GetConnectionAt(1).Aggregation of
          akNone: lacDsAggregation := acPropertyAggregation.pvNone;
          akAggregate: lacDsAggregation := acPropertyAggregation.pvAggregate;
          akComposite: lacDsAggregation := acPropertyAggregation.pvComposite;
        end;

        lDisplayName := '';
        lOriginDisplayName := '';
        lDestinationDisplayName := '';

        if assigned(gStarUMLApp.ExtensionManager.FindIncludedProfile('UserDisplayNames')) then
        begin
          lDisplayName := lAssociacao.GetTaggedValueAsString('UserDisplayNames', 'AssociationDisplayNames', 'DN');
          lOriginDisplayName := lAssociacao.GetTaggedValueAsString('UserDisplayNames', 'AssociationDisplayNames', 'DNA');
          lDestinationDisplayName := lAssociacao.GetTaggedValueAsString('UserDisplayNames', 'AssociationDisplayNames', 'DNB');
        end;

        if not DescendsFrom((lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass), cBASE_PERSISTENT_OBJECT_CLASS) then
        begin
          gStarUMLApp.SelectInModelExplorer((lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass));
          raise Exception.Create(Format('Class "%s" must descends from %s.',
                                 [(lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Name, cBASE_PERSISTENT_OBJECT_CLASS]));
        end;

        if not DescendsFrom((lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass), cBASE_PERSISTENT_OBJECT_CLASS) then
        begin
          gStarUMLApp.SelectInModelExplorer((lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass));
          raise Exception.Create(Format('Class "%s" must descends from %s.',
                                 [(lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Name, cBASE_PERSISTENT_OBJECT_CLASS]));
        end;

        // Busca atributos da associao
        if Trim(sOriginCardinalidade) = '' then
        begin
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('Need to define multiplicity for assosiation "%s" between "%s" and "%s".',
                                 [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                                 (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]))
        end
        else
          if Trim(sOriginCardinalidade) = '0' then
          begin
            gStarUMLApp.SelectInModelExplorer(lAssociacao);
            raise Exception.Create(Format('Invalid multiplicity value for assosiation "%s" between "%s" and "%s".',
                                   [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                                   (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
          end;

        if Trim(sDestinationCardinalidade) = '' then
        begin
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('Need to define multiplicity for assosiation "%s" between "%s" and "%s".',[lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                                                                                                                    (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]))
        end
        else
          if Trim(sDestinationCardinalidade) = '0' then
          begin
            gStarUMLApp.SelectInModelExplorer(lAssociacao);
            raise Exception.Create(Format('Invalid multiplicity value for assosiation "%s" between "%s" and "%s".',
                                   [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                                   (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
          end;

        if (sOriginCardinalidade = '1') then
        begin
          liOriginMinCardinalidade := 1;
          liOriginMaxCardinalidade := 1;
        end
        else
          if (sOriginCardinalidade = '*') then
          begin
            liOriginMinCardinalidade := 0;
            liOriginMaxCardinalidade := N;
          end
          else
          begin
            lPos := Pos('..', sOriginCardinalidade);
            lsMin := copy(sOriginCardinalidade, 1, lPos-1);
            lsMax := copy(sOriginCardinalidade, lPos + 2, length(sOriginCardinalidade) - (lPos + 1));
            liOriginMinCardinalidade := strtoint(lsMin);
            if (uppercase(lsMax) = 'N') or (lsMax = '*') then
              liOriginMaxCardinalidade := N
            else
              liOriginMaxCardinalidade := strtoint(lsMax);
          end;

        if (sDestinationCardinalidade = '1') then
        begin
          liDestinationMinCardinalidade := 1;
          liDestinationMaxCardinalidade := 1;
        end
        else
          if (sDestinationCardinalidade = '*') then
          begin
            liDestinationMinCardinalidade := 0;
            liDestinationMaxCardinalidade := N;
          end
          else
          begin
            lPos := Pos('..', sDestinationCardinalidade);
            lsMin := copy(sDestinationCardinalidade, 1, lPos-1);
            lsMax := copy(sDestinationCardinalidade, lPos + 2, length(sDestinationCardinalidade) - (lPos + 1));
            liDestinationMinCardinalidade := strtoint(lsMin);
            if (uppercase(lsMax) = 'N') or (lsMax = '*') then
              liDestinationMaxCardinalidade := N
            else
              liDestinationMaxCardinalidade := strtoint(lsMax);
          end;

        lBidirectional := (sOriginPropertyName <> '') and (sDestinationPropertyName <> '');

        if ((liOriginMaxCardinalidade = 1) and (liDestinationMaxCardinalidade = N)) then
        begin
          lRelationTicket := poMetaModel.NewRelationRegisterTicket(sDestinationClassName, sDestinationPropertyName, -1, liDestinationMinCardinalidade, liDestinationMaxCardinalidade, lacDsAggregation, sRelationName, sOriginClassName, sOriginPropertyName, -1, liOriginMinCardinalidade, liOriginMaxCardinalidade, lacOrAggregation, lBidirectional, lIsAuditable);
          lRelationTicket.OriginDisplayName := lDestinationDisplayName;
          lRelationTicket.DestinationDisplayName := lOriginDisplayName;
        end
        else
        begin
          lRelationTicket := poMetaModel.NewRelationRegisterTicket(sOriginClassName, sOriginPropertyName, -1, liOriginMinCardinalidade, liOriginMaxCardinalidade, lacOrAggregation, sRelationName, sDestinationClassName, sDestinationPropertyName, -1, liDestinationMinCardinalidade, liDestinationMaxCardinalidade, lacDsAggregation, lBidirectional, lIsAuditable);
          lRelationTicket.OriginDisplayName := lOriginDisplayName;
          lRelationTicket.DestinationDisplayName := lDestinationDisplayName;
        end;
        lRelationTicket.DisplayName := lDisplayName;

        lsresult := lsresult +' Apos NewRelationRegisterTicket -'+ inttostr(poMetaModel.RelationTickets.Count);
        piMetaModelPersistenceMap := fMetaModelPersistenceMap;

        // Busca Atributos estendidos da associaao
        bIndireta := sametext(lAssociacao.GetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'Ind'), 'True');
        FKAColumnName := lAssociacao.GetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'FKA');

        //Se no for relacionamento indireto e a cardinalidade for N para N, ERRO
        if (not bIndireta) and (lRelationTicket.OriginMaxMultiplicity > 1) and (lRelationTicket.DestinationMaxMultiplicity > 1) then
        begin
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('"Ind" tagged value must me checked for associations with Multiplicity "N" <-> "N" ("%s" and "%s").',
                                       [(lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname, (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
        end;


        if Trim(FKAColumnName) = '' then
        begin
          gStarUMLApp.SelectInModelExplorer(lAssociacao);
          raise Exception.Create(Format('Need to define tagged value "FKA" for the association between "%s" and "%s".',
                                       [(lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname, (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
        end;

        if piMetaModelOptions.CheckDBAttributeNameLength then
          if Length(FKAColumnName) > 25 then
            if MessageDlg(Format('Tagged value "FKA" for the association "%s" between "%s" and "%s" is larger than 25 characters. Ignore all and continue?',
                   [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                    (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]), mtConfirmation, mbYesNo, 0) = idyes then
              piMetaModelOptions.CheckDBAttributeNameLength := false
            else
            begin
              gStarUMLApp.SelectInModelExplorer(lAssociacao);
              raise Exception.Create('Operation stopped by user.')
            end;

        if Length(FKAColumnName) > 25 then
  //        StarUMLApp.Log(format('[Warning] Assosiation "%s". Tagged value "FKA" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]));
            PutMessage(format('[Warning] Assosiation "%s". Tagged value "FKA" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]),
                       lAssociacao, 0);


        if bIndireta then
        begin
          //Checa se o property name de origem e destino so superiores a 25 caracteres. Essa checagem  realizada
          //porque essa property name  utilizada para compor o nome da foreign key
          if piMetaModelOptions.CheckDBAttributeNameLength then
            if Length(sOriginPropertyName) > 25 then
              if MessageDlg(Format('End2.Name property for the association "%s" between "%s" and "%s" is larger than 25 characters. Ignore all and continue?',
                     [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                      (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]), mtConfirmation, mbYesNo, 0) = idyes then
                piMetaModelOptions.CheckDBAttributeNameLength := false
              else
              begin
                gStarUMLApp.SelectInModelExplorer(lAssociacao);
                raise Exception.Create('Operation stopped by user.')
              end;

          if Length(sOriginPropertyName) > 25 then
    //        StarUMLApp.Log(format('[Warning] Assosiation "%s". Tagged value "FKA" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]));
              PutMessage(format('[Warning] Assosiation "%s". End2.Name property is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]),
                         lAssociacao, 0);

          if piMetaModelOptions.CheckDBAttributeNameLength then
            if Length(sDestinationPropertyName) > 25 then
              if MessageDlg(Format('End1.Name property for the association "%s" between "%s" and "%s" is larger than 25 characters. Ignore all and continue?',
                     [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                      (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]), mtConfirmation, mbYesNo, 0) = idyes then
                piMetaModelOptions.CheckDBAttributeNameLength := false
              else
              begin
                gStarUMLApp.SelectInModelExplorer(lAssociacao);
                raise Exception.Create('Operation stopped by user.')
              end;

          if Length(sDestinationPropertyName) > 25 then
    //        StarUMLApp.Log(format('[Warning] Assosiation "%s". Tagged value "FKA" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]));
              PutMessage(format('[Warning] Assosiation "%s". End1.Name property is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]),
                         lAssociacao, 0);




          sDBAssociationTableName := lAssociacao.GetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'ATbName');
          if Trim(sDBAssociationTableName) = '' then
          begin
            gStarUMLApp.SelectInModelExplorer(lAssociacao);
            raise Exception.Create(Format('Need to define tagged value "ATbName" when "Ind" tagged value is checked for the association between "%s" and "%s".',
                                          [(lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname, (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
          end;

          FKBColumnName := lAssociacao.GetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'FKB');
          if Trim(FKBColumnName) = '' then
          begin
            gStarUMLApp.SelectInModelExplorer(lAssociacao);
            raise Exception.Create(Format('Need to define tagged value "FKB" when "Ind" tagged value is checked for the association between "%s" and "%s".',
                                          [(lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname, (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]));
          end;

          if piMetaModelOptions.CheckDBAttributeNameLength then
            if Length(FKBColumnName) > 25 then
              if MessageDlg(Format('Tagged value "FKB" for the association "%s" between "%s" and "%s" is larger than 25 characters. Ignore all and continue?',
                     [lAssociacao.Name, (lAssociacao.GetConnectionAt(0).Get_Participant as IUMLClass).Pathname,
                      (lAssociacao.GetConnectionAt(1).Get_Participant as IUMLClass).Pathname]), mtConfirmation, mbYesNo, 0) = idyes then
                piMetaModelOptions.CheckDBAttributeNameLength := false
              else
              begin
                gStarUMLApp.SelectInModelExplorer(lAssociacao);
                raise Exception.Create('Operation stopped by user.')
              end;

          if Length(FKBColumnName) > 25 then
  //          StarUMLApp.Log(format('[Warning] Assosiation "%s". Tagged value "FKB" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]));
            PutMessage(format('[Warning] Assosiation "%s". Tagged value "FKB" is larger than 25 characters. May be a problem for database foreign key''s name.', [lAssociacao.Pathname]),
                       lAssociacao, 0);

        end;

        // Lgica responsvel por selecionar o mtodo de relacionamento de acordo com a cardinalidade
        if lRelationTicket.OriginMaxMultiplicity <= 1 then
        begin
          if lRelationTicket.DestinationMaxMultiplicity <= 1 then
          begin
              if bIndireta then
                (piMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewIndirectOneToOneDbRelationMapRegisterTicket(lRelationTicket, FKAColumnName, FKBColumnName, sDBAssociationTableName)
              else (piMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewOneToOneDbRelationMapRegisterTicket(lRelationTicket, FKAColumnName);
          end
          else
        end
        else //sOriginCardinalidade = N
        begin
          if lRelationTicket.DestinationMaxMultiplicity <= 1 then
          begin
            if bIndireta then
              (piMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewIndirectOneToManyDbRelationMapRegisterTicket(lRelationTicket, FKAColumnName, FKBColumnName, sDBAssociationTableName)
            else
              (piMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewOneToManyDbRelationMapRegisterTicket(lRelationTicket, FKAColumnName);
          end
          else
            (piMetaModelPersistenceMap as acMetaModelPersistenceMapSql).NewManyToManyDbRelationMapRegisterTicket(lRelationTicket, FKAColumnName, FKBColumnName, sDBAssociationTableName);
        end; //end else
      end;
    end // end primeiro if
    else
      if (lModelElement.GetClassName = 'UMLPackage') or (lModelElement.GetClassName = 'UMLModel') then
      begin
        lPackage := lModelElement as IUMLPackage;
        lsresult := lsresult + self.AlimentarMetamodelRelationsAll(lPackage, poMetaModel, piMetaModelOptions, piProgress);
      end;
   end; // end for
//      PersistenceManager.RegisterRelation( AlimentarMetamodelRelationsAll );

  result := lsresult;
end;


procedure TUtil.GerarUseCaseTickets(const poRootUseCase: IUMLUseCase; poMetaModel: acMetaModel; piProgress: TFShowProgress);
var lChildUseCaseCount: integer;
    lUMLChildUseCase: IUMLUseCase;
    lUseCaseTicket: acUseCaseTicket;
    lUseCaseCode: String;

    I,J: integer;
    lUMLClassDiagram: IUMLClassDiagram;
    lUMLClass: IUMLClass;
    lAvaliableClasses: TStringList;
    lUseCaseIsAuditable: boolean;
begin
  //Varre todos os usecases filho de ucUseCase
  for lChildUseCaseCount := 0 to poRootUseCase.GetSpecializationCount - 1 do
  begin
    lUMLChildUseCase := poRootUseCase.GetSpecializationAt(lChildUseCaseCount).Child as IUMLUseCase;

    if not lUMLChildUseCase.IsAbstract then
    begin
      //Cria um UseCaseTicket
      lUseCaseCode := lUMLChildUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');
      lUseCaseIsAuditable := lUMLChildUseCase.GetTaggedValueAsBoolean('DBMappings', 'DBUseCaseMap', 'IsAuditable');
      if (trim(lUseCaseCode) = '') or (trim(lUseCaseCode) = '0') then
      begin
        gStarUMLApp.SelectInModelExplorer(lUMLChildUseCase);
        raise Exception.Create(Format('Need to define tagged value "Code" for UseCase "%s" in DBUseCaseMap Tag Definition.',[lUMLChildUseCase.Pathname]));
      end;

      lUseCaseTicket := poMetaModel.UseCaseTicketByCode[lUseCaseCode];
      if Assigned(lUseCaseTicket) then
      begin
        gStarUMLApp.SelectInModelExplorer(lUMLChildUseCase);
        raise Exception.Create(Format('Use case ticket already defined for UseCase "%s" in DBUseCaseMap Tag Definition.',[lUMLChildUseCase.Pathname]));
      end;

      lAvaliableClasses := TStringList.Create;
      try
        //Varre todos os diagramas de classes que esto abaixo do UseCase e adiciona
        //todas as classes encontradas nos diagramas como classes disponveis para o caso de uso da framework
        for I := 0 to lUMLChildUseCase.GetOwnedDiagramCount - 1 do //Varre todos os diagramas do caso de uso
        begin
          if lUMLChildUseCase.GetOwnedDiagramAt(I).GetMetaClass.IsKindOf('UMLClassDiagram') then
          begin
            lUMLClassDiagram := lUMLChildUseCase.GetOwnedDiagramAt(I) as IUMLClassDiagram;
            for J := 0 to lUMLClassDiagram.DiagramView.GetOwnedViewCount - 1 do //Varre todos os objetos visuais do diagrama
            begin
              if lUMLClassDiagram.DiagramView.GetOwnedViewAt(j).GetMetaClass.IsKindOf('UMLClassView') then
              begin
                lUMLClass := lUMLClassDiagram.DiagramView.GetOwnedViewAt(j).Model as IUMLClass;
                if lAvaliableClasses.Indexof(lUMLClass.Name) = -1 then
                  if DescendsFrom(lUMLClass, cBASE_PERSISTENT_OBJECT_CLASS) then
                    lAvaliableClasses.Add(lUMLClass.Name);
              end;
            end;
          end;
        end;

        if lAvaliableClasses.Count = 0
          then lUseCaseTicket := poMetaModel.NewUseCaseTicket(lUseCaseCode, nil, lUseCaseIsAuditable)
          else lUseCaseTicket := poMetaModel.NewUseCaseTicket(lUseCaseCode, lAvaliableClasses, lUseCaseIsAuditable);

        lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);

      finally
        lAvaliableClasses.Free;
      end;

      lUseCaseTicket.Name := lUMLChildUseCase.Name;
      lUseCaseTicket.InheritsFromClass := lUMLChildUseCase.GetGeneralizationAt(0).Parent.Name;
    end;

    if lUMLChildUseCase.GetSpecializationCount > 0 then
      GerarUseCaseTickets(lUMLChildUseCase, poMetaModel, piProgress);
  end;
end;


function TUtil.AlimentarMetamodelUseCase(poRootUseCase: IUMLUseCase; piBaseStateMachine: IUMLStateMachine;
  piBaseSubmachineState: IUMLSubmachineState; poMetaModel: acMetaModel; piProgress: TFShowProgress): string;
var
  lChildUseCaseCount: integer;
  lUMLChildUseCase: IUMLUseCase;
  lUMLStateMachine: IUMLStateMachine;
  lStateMachine: utStateMachine;
  lUseCaseTicket: acUseCaseTicket;
  lUseCaseCode: String;

begin

  //Varre todos os usecases filho de ucUseCase
  for lChildUseCaseCount := 0 to poRootUseCase.GetSpecializationCount - 1 do
  begin
    lUMLChildUseCase := poRootUseCase.GetSpecializationAt(lChildUseCaseCount).Child as IUMLUseCase;

    if not lUMLChildUseCase.IsAbstract then
    begin
      //Retorna a primeira StateMachine
      lUMLStateMachine := lUMLChildUseCase.GetBehaviorAt(0);

      if assigned(lUMLStateMachine) then
      begin
        //Cria um UseCaseTicket
        lUseCaseCode := lUMLChildUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');


        if (trim(lUseCaseCode) = '') or (trim(lUseCaseCode) = '0') then
        begin
          gStarUMLApp.SelectInModelExplorer(lUMLChildUseCase);
          raise Exception.Create(Format('Need to define tagged value "Code" for UseCase "%s" in DBUseCaseMap Tag Definition.',[lUMLChildUseCase.Pathname]));
        end;

        lUseCaseTicket := poMetaModel.UseCaseTicketByCode[lUseCaseCode];
//        lUseCaseTicket := poMetaModel.NewUseCaseTicket(lUseCaseCode, nil, lUseCaseIsAuditable);
//        lUseCaseTicket.Name := lUMLChildUseCase.Name;
//        lUseCaseTicket.InheritsFrom := lUMLChildUseCase.GetGeneralizationAt(0).Parent.Name;

        lStateMachine := lUseCaseTicket.StateMachine;
        lStateMachine.Name := piBaseStateMachine.Name;
        //piBaseSubmachineState.Submachine := lUMLStateMachine;
        AlimentaMetaModelStateMachine(lUMLChildUseCase, piBaseStateMachine, lUMLStateMachine, lStateMachine, 0);
      end
      else
      begin
        gStarUMLApp.SelectInModelExplorer(lUMLChildUseCase);
        raise Exception.Create(format('Usecase "%s" must have a statemachine or must be abstract.',[lUMLChildUseCase.Pathname]));
      end;
    end
    else
//      StarUMLApp.Log(format('[Warning] Usecase "%s" is abstract.',[lUMLChildUseCase.Pathname]));
      PutMessage(format('[Warning] Usecase "%s" is abstract.',[lUMLChildUseCase.Pathname]),
                 lUMLChildUseCase, 0);

    if lUMLChildUseCase.GetSpecializationCount > 0 then
      AlimentarMetamodelUseCase(lUMLChildUseCase, piBaseStateMachine, piBaseSubmachineState, poMetaModel, piProgress);
  end;
end;



function TUtil.GerarBodyRegisterMappings(piModelMappingsOptions: TModelMappingsOptions; const piInstantCodeConsts: TInstantCodeConsts; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer): string;
var lEnum, lEnumAttributes: acEnumerator;
    lClassTicket: acClassTicket;
    lAttributeTicket: acAttributeTicket;
    lsNomeClasse, lsTabela, lsIDOCode, lsTypeColumnName, sRegisterMapping, lsAtributo, lsIDO, lsColumnName, lsNomeClasseParent, lsAtrStereotype, lsAtrType: String;
    lClassToDBMapTicket: acClassToDBMapTicket;
    lDBColumnMapTicket: acDBColumnMapTicket;
    lRelationTicket: acRelationTicket;
    lInstantCodeConst: TInstantCodeConst;
    index: integer;
    lAtrStereotype: Integer;
    li: Integer;
begin
  li := 1;
  // Obtm todos os ClassTickets da UNIT
  lEnum := MetaModel.ClassTickets.GetEnumerator;
  try
    // Visita todos os ClassTickets da UNIT
    if assigned(piProgress) then piProgress.ChangeMessage(format('Generating model mappings class tickets... (%d de %d classes)', [piStartAt + piEndAt - 1, MetaModel.ClassTickets.Count]), 0, MetaModel.ClassTickets.Count);
    while (not lEnum.EOL) and (li <= piEndAt) do
    begin
      if assigned(piProgress) then piProgress.Inc;
      if li >= piStartAt then
      begin
        lClassTicket := acClassTicket(lEnum.Current);
        lClassToDBMapTicket := fMetaModelPersistenceMap.GetClassToDBMapTicket(lClassTicket);

        //Busca atributos da classe
        lsNomeClasse := lClassTicket.PersistentObjectClassName;
        if (lClassTicket.ParentClassTicket = nil) then
          lsNomeClasseParent := cBASE_PERSISTENT_OBJECT_CLASS
        else lsNomeClasseParent := lClassTicket.ParentClassTicket.PersistentObjectClassName;
        lsTabela := lClassToDBMapTicket.TableName;
        lsIDO := lClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns;
        lsIDOCode := lClassTicket.PersistentObjectClassCode;
        lsTypeColumnName := lClassToDBMapTicket.TypeColumnName;

                      //sInitialization := sInitialization + '   PersistenceManager.RegisterClass('+lsNomeClasse+', RegisterMappings);' +#13#10;
  //        sRegisterMapping := sRegisterMapping + #13#10 + 'if assigned(PersistenceManager.GetRegisteredClass('''+lsNomeClasse+''')) then' + #13#10;
  //        sRegisterMapping := sRegisterMapping + 'begin' + #13#10;

        if sRegisterMapping <> '' then sRegisterMapping := sRegisterMapping + #13#10;
        sRegisterMapping := sRegisterMapping + 'lClassMapTicket    := piMetaModel.NewClassRegisterTicket('''+ lsIDOCode + ''',''' + lsNomeClasse + ''','''+lsNomeClasseParent+''', '+IntToStr(lClassTicket.FieldsCount)+');' + #13#10;
        sRegisterMapping := sRegisterMapping + 'lClassMapTicket.AuditDescription := ' + QuotedStr(lClassTicket.AuditDescription) + ';' + #13#10;
        if lClassTicket.DisplayName <> lClassTicket.PersistentObjectClassName then
          sRegisterMapping := sRegisterMapping + 'lClassMapTicket.DisplayName := ' + QuotedStr(lClassTicket.DisplayName) + ';' + #13#10;
        sRegisterMapping := sRegisterMapping + #13#10 + 'lDBIntIdoMapTicket := acDBIntIdoMapTicket.Create(''' + lsIDO + ''');' + #13#10;
        sRegisterMapping := sRegisterMapping + 'lClassToDBMapTicket := piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket('''+ lsIDOCode +''', lClassMapTicket, lDBIntIdoMapTicket) ;' + #13#10;
        sRegisterMapping := sRegisterMapping + 'lClassToDBMapTicket.TableName := ''' + lsTabela + ''';' + #13#10;
        if lsTypeColumnName <> '' then
          sRegisterMapping := sRegisterMapping + 'lClassToDBMapTicket.TypeColumnName := '''+ lsTypeColumnName +''';' + #13#10;

        if lClassTicket.Attributes.Count > 0 then
          sRegisterMapping := sRegisterMapping + '// registrando os atributos da classe' + #13#10;

         //Percorre atributos da classe
        for index := 0 to lClassTicket.Attributes.Count - 1 do
        begin
          lsAtributo := lClassTicket.Attributes.Strings[index];
          lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[index]);
          lDBColumnMapTicket := acDBColumnMapTicket(lClassToDBMapTicket.Columns.ValueOf(UpperCase(lsAtributo)));
          lAtrStereotype := lAttributeTicket.Stereotype;
          lsAtrType := lAttributeTicket.AttributeType;
          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
            lsAtrStereotype := 'acAttributeStereotype.pvPersistent'
          else if (lAtrStereotype = acAttributeStereotype.pvTransient) then
              lsAtrStereotype := 'acAttributeStereotype.pvTransient'
              else lsAtrStereotype := 'acAttributeStereotype.pvDerived';

          sRegisterMapping := sRegisterMapping + 'prop := lClassMapTicket.NewAttributeTicket('''+ lsAtributo +''', '''+ lsAtrType +''', '+lsAtrStereotype+ ', ' + BoolToStr(lDBColumnMapTicket.AttributeTicket.IsAuditable, true) +', '+IntToStr(lAttributeTicket.AttributeIndex)+');' + #13#10;
          if lAttributeTicket.DisplayName <> lAttributeTicket.AttributeName then
            sRegisterMapping := sRegisterMapping + '  prop.DisplayName := ' + QuotedStr(lAttributeTicket.DisplayName) + ';' + #13#10;

          sRegisterMapping := sRegisterMapping + 'prop.FixSize := ' + inttostr(lAttributeTicket.FixSize) + ';' + #13#10;
          sRegisterMapping := sRegisterMapping + 'prop.VarSize := ' + inttostr(lAttributeTicket.VarSize) + ';' + #13#10;
          sRegisterMapping := sRegisterMapping + 'prop.Mandatory := ' + BoolToStr(lAttributeTicket.Mandatory, true) + ';' + #13#10;
          sRegisterMapping := sRegisterMapping + 'prop.DBType := ''' + lAttributeTicket.DBType + ''';' + #13#10;

          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
          begin
  //          lsTipoAttribute := lClassTicket.ObjectClass.GetPropType(lsAtributo).ClassName;
            lsColumnName := lDBColumnMapTicket.ColumnName;

            sRegisterMapping := sRegisterMapping + 'lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName := '''+ lsColumnName +''';' + #13#10;
          end;

          lInstantCodeConst := TInstantCodeConst.Create(piInstantCodeConsts);
//          lInstantCodeConst.TypeValue := TInstantCodeType(lInstantCodeConst);
          lInstantCodeConst.Name := lClassTicket.PersistentObjectClassName + '_' + lsAtributo;
          lInstantCodeConst.TypeName := 'Integer';
          lInstantCodeConst.Value := IntToStr(lAttributeTicket.AttributeIndex);
        end;

        for index := 0 to lClassTicket.RelationTicketsOut.Count - 1 do
        begin
          lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsOut.Objects[index]);
          if lRelationTicket.OriginPropertyName <> '' then
          begin
            lInstantCodeConst := TInstantCodeConst.Create(piInstantCodeConsts);
            lInstantCodeConst.Name := lClassTicket.PersistentObjectClassName + '_' + lRelationTicket.OriginPropertyName;
            lInstantCodeConst.TypeName := 'Integer';
            lInstantCodeConst.Value := IntToStr(lRelationTicket.OriginPropertyindex);
          end;
        end;

        for index := 0 to lClassTicket.RelationTicketsIn.Count - 1 do
        begin
          lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsIn.Objects[index]);
          if lRelationTicket.DestinationPropertyName <> '' then
          begin
            lInstantCodeConst := TInstantCodeConst.Create(piInstantCodeConsts);
            lInstantCodeConst.Name := lClassTicket.PersistentObjectClassName + '_' + lRelationTicket.DestinationPropertyName;
            lInstantCodeConst.TypeName := 'Integer';
            lInstantCodeConst.Value := IntToStr(lRelationTicket.DestinationPropertyIndex);
          end;
        end;


  //        sRegisterMapping := sRegisterMapping + 'end;' + #13#10;
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;

  result := sRegisterMapping;
end;

procedure TUtil.GerarBodyRegisterMappings_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer; piUnitRegisterMappings: PStringWriter);
var
  lEnum: acEnumerator;
  lClassTicket: acClassTicket;
  lAttributeTicket: acAttributeTicket;
  lsNomeClasse, lsTabela, lsIDOCode, lsTypeColumnName, lsAtributo, lsIDO, lsColumnName, lsNomeClasseParent, lsAtrStereotype, lsAtrType, lsNomeArgProp: String;
  lClassToDBMapTicket: acClassToDBMapTicket;
  lDBColumnMapTicket: acDBColumnMapTicket;
  index: integer;
  lAtrStereotype: Integer;
  li: Integer;
  lNomeArgAttributeNameTicket: string;
  lNumArgAttributeNameTicket : integer;
begin
  li := 1;
  lNumArgAttributeNameTicket := 1;
  piUnitRegisterMappings.Indent();
  // Obtm todos os ClassTickets da UNIT
  lEnum := MetaModel.ClassTickets.GetEnumerator;
  try
    // Visita todos os ClassTickets da UNIT
    if assigned(piProgress) then piProgress.ChangeMessage(format('Generating model mappings class tickets... (%d de %d classes)', [piStartAt + piEndAt - 1, MetaModel.ClassTickets.Count]), 0, MetaModel.ClassTickets.Count);
    piUnitRegisterMappings.WriteLine('acClassTicket lClassMapTicket;');
    piUnitRegisterMappings.WriteLine('acDBIdoMapTicket lDBIntIdoMapTicket;');
    piUnitRegisterMappings.WriteLine('acClassToDBMapTicket lClassToDBMapTicket;');
    piUnitRegisterMappings.WriteLine('acAttributeTicket prop;');
    while (not lEnum.EOL) and (li <= piEndAt) do
    begin
      if assigned(piProgress) then piProgress.Inc;
      if li >= piStartAt then
      begin
        lClassTicket := acClassTicket(lEnum.Current);
        lClassToDBMapTicket := fMetaModelPersistenceMap.GetClassToDBMapTicket(lClassTicket);

        //Busca atributos da classe
        lsNomeClasse := lClassTicket.PersistentObjectClassName;
        if (lClassTicket.ParentClassTicket = nil)
          then lsNomeClasseParent := cBASE_PERSISTENT_OBJECT_CLASS
          else lsNomeClasseParent := lClassTicket.ParentClassTicket.PersistentObjectClassName;
        lsTabela  := lClassToDBMapTicket.TableName;
        lsIDO     := lClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns;
        lsIDOCode := lClassTicket.PersistentObjectClassCode;
        lsTypeColumnName := lClassToDBMapTicket.TypeColumnName;

        piUnitRegisterMappings.WriteLine();
        piUnitRegisterMappings.WriteLine('lClassMapTicket = piMetaModel.NewClassRegisterTicket("'+ lsIDOCode + '","' + lsNomeClasse + '","'+lsNomeClasseParent + '", ' + IntToStr(lClassTicket.FieldsCount) + ');'); //+'", typeof(acOIDInt));');
        piUnitRegisterMappings.WriteLine('lClassMapTicket.AuditDescription = "' + lClassTicket.AuditDescription + '";');
        if lClassTicket.DisplayName <> lClassTicket.PersistentObjectClassName then
          piUnitRegisterMappings.WriteLine('lClassMapTicket.DisplayName = "' + lClassTicket.DisplayName + '";');
        piUnitRegisterMappings.WriteLine('lDBIntIdoMapTicket = new acDBIntIdoMapTicket("' + lsIDO + '");');
        piUnitRegisterMappings.WriteLine('lClassToDBMapTicket = piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket("'+ lsIDOCode +'", lClassMapTicket, lDBIntIdoMapTicket);');


        piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.TableName = "' + lsTabela + '";');
        if lsTypeColumnName <> '' then
          piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.TypeColumnName = "'+ lsTypeColumnName +'";');

        if lClassTicket.Attributes.Count > 0 then
          piUnitRegisterMappings.WriteLine('// registrando os atributos da classe');

         //Percorre atributos da classe
        for index := 0 to lClassTicket.Attributes.Count - 1 do
        begin
          lsAtributo := lClassTicket.Attributes.Strings[index];
          lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[index]);
          lDBColumnMapTicket := acDBColumnMapTicket(lClassToDBMapTicket.Columns.ValueOf(UpperCase(lsAtributo)));
          lAtrStereotype := lDBColumnMapTicket.AttributeTicket.Stereotype;
          lsAtrType := lDBColumnMapTicket.AttributeTicket.AttributeType;
          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
            lsAtrStereotype := 'acAttributeStereotype.pvPersistent'
          else if (lAtrStereotype = acAttributeStereotype.pvTransient) then
              lsAtrStereotype := 'acAttributeStereotype.pvTransient'
              else lsAtrStereotype := 'acAttributeStereotype.pvDerived';

          if StrToInt(lsIDOCode) > 0
            then lsNomeArgProp := 'arg_'+lsIDOCode+'_'+IntToStr(index)
            else lsNomeArgProp := 'arg_A'+strutils.RightStr(lsIDOCode, Length(lsIDOCode)-1)+'_'+IntToStr(index);
          piUnitRegisterMappings.WriteLine('acClassTicket '+lsNomeArgProp+' = lClassMapTicket;');
          lNomeArgAttributeNameTicket := 'piAttributeName' + IntToStr(lNumArgAttributeNameTicket);
          Inc(lNumArgAttributeNameTicket);

          piUnitRegisterMappings.WriteLine('String ' + lNomeArgAttributeNameTicket + ';');
          piUnitRegisterMappings.WriteLine(lNomeArgAttributeNameTicket + ' = "'+lsAtributo+'";');

          piUnitRegisterMappings.WriteLine('prop = '+lsNomeArgProp+'.NewAttributeTicket('+ lNomeArgAttributeNameTicket +', "'+ lsAtrType +'", '+lsAtrStereotype+ ', ' + AnsiLowerCase(BoolToStr(lDBColumnMapTicket.AttributeTicket.IsAuditable, true)) +', '+IntToStr(lAttributeTicket.AttributeIndex)+');');
          if lAttributeTicket.DisplayName <> lAttributeTicket.AttributeName then
            piUnitRegisterMappings.WriteLine('prop.DisplayName = "' + lAttributeTicket.DisplayName + '";');

          piUnitRegisterMappings.WriteLine('prop.FixSize = ' + inttostr(lAttributeTicket.FixSize) + ';');
          piUnitRegisterMappings.WriteLine('prop.VarSize = ' + inttostr(lAttributeTicket.VarSize) + ';');
          piUnitRegisterMappings.WriteLine('prop.Mandatory = ' + AnsiLowerCase(BoolToStr(lAttributeTicket.Mandatory, true)) + ';');
          piUnitRegisterMappings.WriteLine('prop.DBType = "' + lAttributeTicket.DBType + '";');

          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
          begin
            lsColumnName := lDBColumnMapTicket.ColumnName;

            piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).ColumnName = "'+ lsColumnName +'";')
          end;
        end;
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;

  piUnitRegisterMappings.Outdent();
end;

procedure TUtil.GerarBodyRegisterMappings_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer;
  piUnitRegisterMappings: PStringWriter);
var
  lEnum: acEnumerator;
  lClassTicket: acClassTicket;
  lAttributeTicket: acAttributeTicket;
  lsNomeClasse, lsTabela, lsIDOCode, lsTypeColumnName, lsAtributo, lsIDO, lsColumnName, lsNomeClasseParent, lsAtrStereotype, lsAtrType, lsNomeArgProp: String;
  lClassToDBMapTicket: acClassToDBMapTicket;
  lDBColumnMapTicket: acDBColumnMapTicket;
  index: integer;
  lAtrStereotype: Integer;
  li: Integer;
  lNomeArgAttributeNameTicket: string;
  lNumArgAttributeNameTicket : integer;
begin
  li := 1;
  lNumArgAttributeNameTicket := 1;
  piUnitRegisterMappings.Indent();
  // Obtm todos os ClassTickets da UNIT
  lEnum := MetaModel.ClassTickets.GetEnumerator;
  try
    // Visita todos os ClassTickets da UNIT
    if assigned(piProgress) then piProgress.ChangeMessage(format('Generating model mappings class tickets... (%d de %d classes)', [piStartAt + piEndAt - 1, MetaModel.ClassTickets.Count]), 0, MetaModel.ClassTickets.Count);
    piUnitRegisterMappings.WriteLine('acClassTicket lClassMapTicket;');
    piUnitRegisterMappings.WriteLine('acDBIdoMapTicket lDBIntIdoMapTicket;');
    piUnitRegisterMappings.WriteLine('acClassToDBMapTicket lClassToDBMapTicket;');
    piUnitRegisterMappings.WriteLine('acAttributeTicket prop;');
    while (not lEnum.EOL) and (li <= piEndAt) do
    begin
      if assigned(piProgress) then piProgress.Inc;
      if li >= piStartAt then
      begin
        lClassTicket := acClassTicket(lEnum.Current);
        lClassToDBMapTicket := fMetaModelPersistenceMap.GetClassToDBMapTicket(lClassTicket);

        //Busca atributos da classe
        lsNomeClasse := lClassTicket.PersistentObjectClassName;
        if (lClassTicket.ParentClassTicket = nil)
          then lsNomeClasseParent := cBASE_PERSISTENT_OBJECT_CLASS
          else lsNomeClasseParent := lClassTicket.ParentClassTicket.PersistentObjectClassName;
        lsTabela  := lClassToDBMapTicket.TableName;
        lsIDO     := lClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns;
        lsIDOCode := lClassTicket.PersistentObjectClassCode;
        lsTypeColumnName := lClassToDBMapTicket.TypeColumnName;

        piUnitRegisterMappings.WriteLine();

        piUnitRegisterMappings.WriteLine('lClassMapTicket = piMetaModel.NewClassRegisterTicket("'+ lsIDOCode + '","' + lsNomeClasse + '","'+lsNomeClasseParent+'", ' + IntToStr(lClassTicket.FieldsCount) + ');');
        piUnitRegisterMappings.WriteLine('lClassMapTicket.setAuditDescription("' + lClassTicket.AuditDescription + '");');
        if lClassTicket.DisplayName <> lClassTicket.PersistentObjectClassName then
          piUnitRegisterMappings.WriteLine('lClassMapTicket.setDisplayName("' + lClassTicket.DisplayName + '");');
        piUnitRegisterMappings.WriteLine('lDBIntIdoMapTicket = new acDBIntIdoMapTicket("' + lsIDO + '");');
        piUnitRegisterMappings.WriteLine('lClassToDBMapTicket = piMetaModelPersistenceMap.NewClassToDBMapRegisterTicket("'+ lsIDOCode +'", lClassMapTicket, lDBIntIdoMapTicket);');


        piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.setTableName("' + lsTabela + '");');
        if lsTypeColumnName <> '' then
          piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.setTypeColumnName("'+ lsTypeColumnName +'");');

        if lClassTicket.Attributes.Count > 0 then
          piUnitRegisterMappings.WriteLine('// registrando os atributos da classe');

         //Percorre atributos da classe
        for index := 0 to lClassTicket.Attributes.Count - 1 do
        begin
          lsAtributo := lClassTicket.Attributes.Strings[index];
          lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[index]);
          lDBColumnMapTicket := acDBColumnMapTicket(lClassToDBMapTicket.Columns.ValueOf(UpperCase(lsAtributo)));
          lAtrStereotype := lDBColumnMapTicket.AttributeTicket.Stereotype;
          lsAtrType := lDBColumnMapTicket.AttributeTicket.AttributeType;
          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
            lsAtrStereotype := 'acAttributeStereotype.pvPersistent'
          else if (lAtrStereotype = acAttributeStereotype.pvTransient) then
              lsAtrStereotype := 'acAttributeStereotype.pvTransient'
              else lsAtrStereotype := 'acAttributeStereotype.pvDerived';

          if StrToInt(lsIDOCode) > 0
            then lsNomeArgProp := 'arg_'+lsIDOCode+'_'+IntToStr(index)
            else lsNomeArgProp := 'arg_A'+strutils.RightStr(lsIDOCode, Length(lsIDOCode)-1)+'_'+IntToStr(index);
          piUnitRegisterMappings.WriteLine('acClassTicket '+lsNomeArgProp+' = lClassMapTicket;');
          lNomeArgAttributeNameTicket := 'piAttributeName' + IntToStr(lNumArgAttributeNameTicket);
          Inc(lNumArgAttributeNameTicket);

          piUnitRegisterMappings.WriteLine('String ' + lNomeArgAttributeNameTicket + ';');
          piUnitRegisterMappings.WriteLine(lNomeArgAttributeNameTicket + ' = "'+lsAtributo+'";');

          piUnitRegisterMappings.WriteLine('prop = '+lsNomeArgProp+'.NewAttributeTicket('+ lNomeArgAttributeNameTicket +', "'+ lsAtrType +'", '+lsAtrStereotype+ ', ' + AnsiLowerCase(BoolToStr(lDBColumnMapTicket.AttributeTicket.IsAuditable, true)) +', '+IntToStr(lAttributeTicket.AttributeIndex)+');');
          if lAttributeTicket.DisplayName <> lAttributeTicket.AttributeName then
            piUnitRegisterMappings.WriteLine('prop.DisplayName = "' + lAttributeTicket.DisplayName + '";');

          piUnitRegisterMappings.WriteLine('prop.setFixSize(' + inttostr(lAttributeTicket.FixSize) + ');');
          piUnitRegisterMappings.WriteLine('prop.setVarSize(' + inttostr(lAttributeTicket.VarSize) + ');');
          piUnitRegisterMappings.WriteLine('prop.setMandatory(' + AnsiLowerCase(BoolToStr(lAttributeTicket.Mandatory, true)) + ');');
          piUnitRegisterMappings.WriteLine('prop.setDBType("' + lAttributeTicket.DBType + '");');

          if (lAtrStereotype = acAttributeStereotype.pvPersistent) then
          begin
            lsColumnName := lDBColumnMapTicket.ColumnName;

            piUnitRegisterMappings.WriteLine('lClassToDBMapTicket.NewDbColumnMapRegisterTicket(prop).setColumnName("'+ lsColumnName +'");')
          end;
        end;
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;

  piUnitRegisterMappings.Outdent();
end;

procedure TUtil.GerarUnitRegisterModelMappings(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);
const
  MAX_UC = 100;
  MAX_CLASS = 200;
var
    lInstantCodeModule: TInstantCodeModule;
    lInstantCodeProc: TInstantCodeProc;
    lInstantCodeVar: TInstantCodeVar;
    lInstantCodeBody: TInstantCodeBody;
    lProcBody: String;
    lI,
    lTotalGroups: Integer;
    lRegisterUseCasesCall,
    lRegisterClassCall: string;
    lInstantCodeConsts: TInstantCodeConsts;
//    lInstantCodeWriter: TInstantCodeWriter;
//    s: string;
begin
    // Cria UNIT
    lInstantCodeModule := TInstantCodeModule.Create(nil);

    lInstantCodeModule.Name := 'acuRegisterModelMappings';

    lInstantCodeModule.InterfaceSection.AddUses.Name := 'acuModel, acuRepositorySQL';
    lInstantCodeConsts := TInstantCodeConsts.Create(lInstantCodeModule.InterfaceSection);

    lInstantCodeModule.ImplementationSection.AddUses.Name := 'utuStateMachine, acuUseCaseStateMachine';

    lTotalGroups := (MetaModel.ClassTickets.Count div MAX_CLASS);
    if (MetaModel.ClassTickets.Count mod MAX_CLASS) <> 0 then Inc(lTotalGroups);

    for lI := 0 to lTotalGroups - 1 do
    begin

      //PROCEDURE RegisterClassTickets //////////////////////////////////////////
      lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
      lInstantCodeProc.Name := 'RegisterClassTickets' + IntToStr(lI + 1);
      lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
      lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMapSQL', []);
      lInstantCodeBody := lInstantCodeProc.Body;
      //class
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lClassMapTicket';
      lInstantCodeVar.TypeName := 'acClassTicket';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lClassToDBMapTicket';
      lInstantCodeVar.TypeName := 'acClassToDBMapTicket';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lDBIntIdoMapTicket';
      lInstantCodeVar.TypeName := 'acDBIdoMapTicket';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'prop';
      lInstantCodeVar.TypeName := 'acAttributeTicket';
      lInstantCodeBody.Text := GerarBodyRegisterMappings(piModelMappingsOptions, lInstantCodeConsts, piProgress, lI*(MAX_CLASS) + 1, (lI + 1)*MAX_CLASS);

      if (lRegisterClassCall <> '') then lRegisterClassCall := concat(lRegisterClassCall, #13#10);
      lRegisterClassCall := concat(lRegisterClassCall, 'RegisterClassTickets',  IntToStr(lI + 1), '(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap)', '{', IntToStr(lI*(MAX_CLASS) + 1) , ' - ', IntToStr( (lI + 1)*MAX_CLASS ), '};' );

    end;

    //PROCEDURE RegisterClassRelationTickets //////////////////////////////////////////
    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
    lInstantCodeProc.Name := 'RegisterClassRelationTickets';
    lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
    lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMapSQL', []);
    lInstantCodeBody := lInstantCodeProc.Body;
    //class
    lInstantCodeVar := lInstantCodeBody.Vars.Add;
    lInstantCodeVar.Name := 'lRelationTicket';
    lInstantCodeVar.TypeName := 'acRelationTicket';
    lInstantCodeBody.Text := GerarBodyRelationsAll(piProgress);

    lTotalGroups := (MetaModel.UseCaseTickets.Count div MAX_UC);
    if (MetaModel.UseCaseTickets.Count mod MAX_UC) <> 0 then Inc(lTotalGroups);

    for lI := 0 to lTotalGroups - 1 do
    begin

      //PROCEDURE RegisterUseCases //////////////////////////////////////////
      lProcBody := GerarBodyUseCases(piModelMappingsOptions, piProgress, lI*(MAX_UC) + 1, (lI + 1)*MAX_UC, lInstantCodeModule.ImplementationSection);
      lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
      lInstantCodeProc.Name := 'RegisterUseCases' + IntToStr(lI + 1);
      lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
      lInstantCodeBody := lInstantCodeProc.Body;
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lUseCaseTicket';
      lInstantCodeVar.TypeName := 'acUseCaseTicket';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lSubMachineUseCaseTicket';
      lInstantCodeVar.TypeName := 'acUseCaseTicket';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lStateMachine';
      lInstantCodeVar.TypeName := 'utStateMachine';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lSubMachineState';
      lInstantCodeVar.TypeName := 'utSubMachineState';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lState';
      lInstantCodeVar.TypeName := 'utState';
      lInstantCodeVar := lInstantCodeBody.Vars.Add;
      lInstantCodeVar.Name := 'lTransition';
      lInstantCodeVar.TypeName := 'utTransition';

      lInstantCodeBody.Text := lProcBody;
      lInstantCodeModule.ImplementationSection.InsertProc(lInstantCodeProc);

      if (lRegisterUseCasesCall <> '') then lRegisterUseCasesCall := concat(lRegisterUseCasesCall,  #13#10);
      lRegisterUseCasesCall := concat(lRegisterUseCasesCall, 'RegisterUseCases',  IntToStr(lI + 1), '(piMetaModelPersistenceMap.MetaModel)', '{', IntToStr(lI*(MAX_UC) + 1) , ' - ', IntToStr( (lI + 1)*MAX_UC ), '};' );

    end;

    //PROCEDURE RegisterModelMappings //////////////////////////////////////////
    lInstantCodeProc := lInstantCodeModule.InterfaceSection.AddProc;
    lInstantCodeProc.Name := 'RegisterModelMappings';
    lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMapSQL', []);

    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
    lInstantCodeProc.Name := 'RegisterModelMappings';
    lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMapSQL', []);
    lInstantCodeBody := lInstantCodeProc.Body;

    lInstantCodeBody.Text := concat(' ', lRegisterClassCall, #13#10,
                                    ' ', 'RegisterClassRelationTickets(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap);',#13#10,
                                    ' ', lRegisterUseCasesCall);

    // Gerao de arquivo
    if assigned(piProgress) then piProgress.ChangeMessage('Saving file "'+ piModelMappingsOptions.FileName +'"...');
    lInstantCodeModule.SaveToFile(piModelMappingsOptions.FileName);
end;


procedure TUtil.GerarUnitRegisterModelMappings_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);

const
  MAX_UC = 100;
  MAX_CLASS = 200;
var
  lProcBody: String;
  lI,
  lTotalGroups: Integer;
  lRegisterUseCasesCall,
  lRegisterClassCall: PStringWriter;

  lArquivoRegisterModelMappings: PStringWriter;
begin
  // Cria UNIT
  lArquivoRegisterModelMappings := PStringWriter.Create();
  lRegisterUseCasesCall := PStringWriter.Create();
  lRegisterClassCall    := PStringWriter.Create();
  try                                            
    lArquivoRegisterModelMappings.WriteLine('using acuFramework;');
    lArquivoRegisterModelMappings.WriteLine('using acuRepositorySQL;');
    lArquivoRegisterModelMappings.WriteLine('using System;');
    lArquivoRegisterModelMappings.WriteLine('using acuModel;');
    lArquivoRegisterModelMappings.WriteLine('using utuStateMachine;');
    lArquivoRegisterModelMappings.WriteLine('using acuUseCaseStateMachine;');
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('namespace acuRegisterModelMappings {');    
    lArquivoRegisterModelMappings.WriteLine();        
    lArquivoRegisterModelMappings.Indent();

    lArquivoRegisterModelMappings.WriteLine('public sealed class acuRegisterModelMappings {');
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.Indent();

    lArquivoRegisterModelMappings.WriteLine('static acuRegisterModelMappings() {');
    lArquivoRegisterModelMappings.WriteLine('}');

    //PROCEDURE RegisterClassTickets //////////////////////////////////////////
    lTotalGroups := (MetaModel.ClassTickets.Count div MAX_CLASS);
    if (MetaModel.ClassTickets.Count mod MAX_CLASS) <> 0 then Inc(lTotalGroups);
    lArquivoRegisterModelMappings.WriteLine();
    for lI := 0 to lTotalGroups - 1 do
    begin
      lArquivoRegisterModelMappings.WriteLine('internal static void RegisterClassTickets' + IntToStr(lI + 1) + '(acMetaModel piMetaModel, acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
      GerarBodyRegisterMappings_CSharp(piModelMappingsOptions, piProgress, lI*(MAX_CLASS) + 1, (lI + 1)*MAX_CLASS, lArquivoRegisterModelMappings);
      lArquivoRegisterModelMappings.WriteLine('}');

      lRegisterClassCall.WriteLine('RegisterClassTickets' + IntToStr(lI + 1) + '(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap);' );
    end;

    //PROCEDURE RegisterClassRelationTickets //////////////////////////////////////////
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('internal static void RegisterClassRelationTickets(acMetaModel piMetaModel, acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
    GerarBodyRelationsAll_CSharp(piProgress, lArquivoRegisterModelMappings);
    lArquivoRegisterModelMappings.WriteLine('}');

    lTotalGroups := (MetaModel.UseCaseTickets.Count div MAX_UC);
    if (MetaModel.UseCaseTickets.Count mod MAX_UC) <> 0 then Inc(lTotalGroups);
    for lI := 0 to lTotalGroups - 1 do
    begin
      //PROCEDURE RegisterUseCases //////////////////////////////////////////

      lProcBody := GerarBodyUseCases_CSharp(piModelMappingsOptions, piProgress, lI*(MAX_UC) + 1, (lI + 1)*MAX_UC, lArquivoRegisterModelMappings);

      lArquivoRegisterModelMappings.WriteLine();
      lArquivoRegisterModelMappings.WriteLine('internal static void RegisterUseCases'+ IntToStr(lI + 1)+'(acMetaModel piMetaModel, acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
      lArquivoRegisterModelMappings.WriteLine(lProcBody);
      lArquivoRegisterModelMappings.WriteLine('}');

      lRegisterUseCasesCall.WriteLine('RegisterUseCases' + IntToStr(lI + 1) + '(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap);' );
    end;

    //PROCEDURE RegisterModelMappings //////////////////////////////////////////
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('internal static void RegisterModelMappings(acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
    lArquivoRegisterModelMappings.Indent();
    lArquivoRegisterModelMappings.Append(lRegisterClassCall);
    lArquivoRegisterModelMappings.WriteLine('RegisterClassRelationTickets(piMetaModelPersistenceMap.MetaModel, piMetaModelPersistenceMap);');
    lArquivoRegisterModelMappings.Append(lRegisterUseCasesCall);
    lArquivoRegisterModelMappings.Outdent();
    lArquivoRegisterModelMappings.WriteLine('}');

    //Finalizao
    lArquivoRegisterModelMappings.Outdent();
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('}');
    lArquivoRegisterModelMappings.Outdent();
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('}');

    // Gerao de arquivo
    if assigned(piProgress) then piProgress.ChangeMessage('Saving file "'+ piModelMappingsOptions.FileName +'"...');
    lArquivoRegisterModelMappings.SaveToFile(piModelMappingsOptions.FileName);

  finally
    lArquivoRegisterModelMappings.Free;
  end;
end;

procedure TUtil.GerarUnitRegisterModelMappings_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress);
const
  MAX_UC = 100;
  MAX_CLASS = 200;
var
  lProcBody: String;
  lI,
  lTotalGroups: Integer;
  lRegisterUseCasesCall,
  lRegisterClassCall: PStringWriter;

  lArquivoRegisterModelMappings: PStringWriter;
begin
  // Cria UNIT
  lArquivoRegisterModelMappings := PStringWriter.Create();
  lRegisterUseCasesCall := PStringWriter.Create();
  lRegisterClassCall    := PStringWriter.Create();
  try
    lArquivoRegisterModelMappings.WriteLine('import acurepositorysql.*;');
    lArquivoRegisterModelMappings.WriteLine('import acumodel.*;');
    lArquivoRegisterModelMappings.WriteLine('import utustatemachine.*;');
    lArquivoRegisterModelMappings.WriteLine('import acuusecasestatemachine.*;');
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.Indent();

    lArquivoRegisterModelMappings.WriteLine('public class acRegisterModelMappings {');
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.Indent();

    //PROCEDURE RegisterClassTickets //////////////////////////////////////////
    lTotalGroups := (MetaModel.ClassTickets.Count div MAX_CLASS);
    if (MetaModel.ClassTickets.Count mod MAX_CLASS) <> 0 then Inc(lTotalGroups);
    lArquivoRegisterModelMappings.WriteLine();
    for lI := 0 to lTotalGroups - 1 do
    begin
      lArquivoRegisterModelMappings.WriteLine('static void RegisterClassTickets' + IntToStr(lI + 1) + '(acMetaModel piMetaModel, acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
      GerarBodyRegisterMappings_Java(piModelMappingsOptions, piProgress, lI*(MAX_CLASS) + 1, (lI + 1)*MAX_CLASS, lArquivoRegisterModelMappings);
      lArquivoRegisterModelMappings.WriteLine('}');

      lRegisterClassCall.WriteLine('RegisterClassTickets' + IntToStr(lI + 1) + '(piMetaModelPersistenceMap.getMetaModel(), piMetaModelPersistenceMap);' );
    end;

    //PROCEDURE RegisterClassRelationTickets //////////////////////////////////////////
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('static void RegisterClassRelationTickets(acMetaModel piMetaModel, acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
    GerarBodyRelationsAll_Java(piProgress, lArquivoRegisterModelMappings);
    lArquivoRegisterModelMappings.WriteLine('}');

    lTotalGroups := (MetaModel.UseCaseTickets.Count div MAX_UC);
    if (MetaModel.UseCaseTickets.Count mod MAX_UC) <> 0 then Inc(lTotalGroups);
    for lI := 0 to lTotalGroups - 1 do
    begin
      //PROCEDURE RegisterUseCases //////////////////////////////////////////

      lProcBody := GerarBodyUseCases_Java(piModelMappingsOptions, piProgress, lI*(MAX_UC) + 1, (lI + 1)*MAX_UC, lArquivoRegisterModelMappings);

      lArquivoRegisterModelMappings.WriteLine();
      lArquivoRegisterModelMappings.WriteLine('static void RegisterUseCases'+ IntToStr(lI + 1)+'(acMetaModel piMetaModel) {');
      lArquivoRegisterModelMappings.WriteLine(lProcBody);
      lArquivoRegisterModelMappings.WriteLine('}');

      lRegisterUseCasesCall.WriteLine('RegisterUseCases' + IntToStr(lI + 1) + '(piMetaModelPersistenceMap.getMetaModel());' );
    end;

    //PROCEDURE RegisterModelMappings //////////////////////////////////////////
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('static void RegisterModelMappings(acMetaModelPersistenceMapSQL piMetaModelPersistenceMap) {');
    lArquivoRegisterModelMappings.Indent();
    lArquivoRegisterModelMappings.Append(lRegisterClassCall);
    lArquivoRegisterModelMappings.WriteLine('RegisterClassRelationTickets(piMetaModelPersistenceMap.getMetaModel(), piMetaModelPersistenceMap);');
    lArquivoRegisterModelMappings.Append(lRegisterUseCasesCall);
    lArquivoRegisterModelMappings.Outdent();
    lArquivoRegisterModelMappings.WriteLine('}');

    //Finalizao
    lArquivoRegisterModelMappings.Outdent();
    lArquivoRegisterModelMappings.WriteLine();
    lArquivoRegisterModelMappings.WriteLine('}');

    // Gerao de arquivo
    if assigned(piProgress) then piProgress.ChangeMessage('Saving file "'+ piModelMappingsOptions.FileName +'"...');
    lArquivoRegisterModelMappings.SaveToFile(piModelMappingsOptions.FileName);

  finally
    lArquivoRegisterModelMappings.Free;
  end;
end;

function TUtil.GerarBodyRelationsAll(piProgress: TFShowProgress): string;
var lEnumRelation: acEnumerator;
    lRelationTicket: acRelationTicket;
    lClassTicketOrigem, lClassTicketDestino: acClassTicket;
    sRelationsAll, lsNomeTabelaAssociativa, lsNomeFKA, lsNomeFKB: String;
    sMetodo, lsOrAggregation, lsDsAggregation: string;
    lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
    bIndireta: boolean;
    lMultiplicityOrMax, lMultiplicityDsMax, lMultiplicityOrMin, lMultiplicityDsMin: integer;
begin
  if assigned(piProgress) then piProgress.ChangeMessage('Generating model mappings relation tickets...', 0, MetaModel.RelationTickets.Count);
  lEnumRelation := MetaModel.RelationTickets.GetEnumerator;
  try
    while not lEnumRelation.EOL do
    begin
         if assigned(piProgress) then piProgress.Inc;
         lRelationTicket := acRelationTicket(lEnumRelation.Current);
         // Obtm classes origem e destino. No est sendo considerada associaao ternria.
         lClassTicketOrigem := lRelationTicket.OriginClassTicket;
         lClassTicketDestino := lRelationTicket.DestinationClassTicket;

         lMultiplicityOrMax := lRelationTicket.OriginMaxMultiplicity;
         lMultiplicityDsMax := lRelationTicket.DestinationMaxMultiplicity;

         lMultiplicityOrMin := lRelationTicket.OriginMinMultiplicity;
         lMultiplicityDsMin := lRelationTicket.DestinationMinMultiplicity;

          case lRelationTicket.OriginAggregation of
            acPropertyAggregation.pvNone: lsOrAggregation := 'acPropertyAggregation.pvNone';
            acPropertyAggregation.pvAggregate: lsOrAggregation := 'acPropertyAggregation.pvAggregate';
            acPropertyAggregation.pvComposite: lsOrAggregation := 'acPropertyAggregation.pvComposite';
          end;

          case lRelationTicket.DestinationAggregation of
            acPropertyAggregation.pvNone: lsDsAggregation := 'acPropertyAggregation.pvNone';
            acPropertyAggregation.pvAggregate: lsDsAggregation := 'acPropertyAggregation.pvAggregate';
            acPropertyAggregation.pvComposite: lsDsAggregation := 'acPropertyAggregation.pvComposite';
          end;

         sRelationsAll := sRelationsAll + 'lRelationTicket := piMetaModel.NewRelationRegisterTicket(';
         sRelationsAll := sRelationsAll + '''' + lClassTicketOrigem.PersistentObjectClassName + '''' + ', ' + '''' + lRelationTicket.OriginPropertyName + '''' + ', '+IntToStr(lRelationTicket.OriginPropertyindex)+', ' + inttostr(lMultiplicityOrMin) + ', ' + inttostr(lMultiplicityOrMax) + ', ' + lsOrAggregation;
         sRelationsAll := sRelationsAll + ', ' + '''' + lRelationTicket.Name + '''' + ', ';
         sRelationsAll := sRelationsAll + '''' + lClassTicketDestino.PersistentObjectClassName + '''' + ', ' + '''' + lRelationTicket.DestinationPropertyName + '''' + ', '+IntToStr(lRelationTicket.DestinationPropertyIndex)+', ' + inttostr(lMultiplicityDsMin) + ', ' + inttostr(lMultiplicityDsMax) + ', ' + lsDsAggregation;
         sRelationsAll := sRelationsAll + ', ' + BoolToStr(lRelationTicket.Bidirectional, true);
         sRelationsAll := sRelationsAll + ', ' + BoolToStr(lRelationTicket.IsAuditable, true);
         sRelationsAll := sRelationsAll + ');' + #13#10;
         if lRelationTicket.DisplayName <> lRelationTicket.Name then
           sRelationsAll := sRelationsAll + 'lRelationTicket.DisplayName := ' + QuotedStr(lRelationTicket.DisplayName) + ';' + #13#10;
         if lRelationTicket.OriginDisplayName <> '' then
           sRelationsAll := sRelationsAll + 'lRelationTicket.OriginDisplayName := ' + QuotedStr(lRelationTicket.OriginDisplayName) + ';' + #13#10;
         if lRelationTicket.DestinationDisplayName <> '' then
           sRelationsAll := sRelationsAll + 'lRelationTicket.DestinationDisplayName := ' + QuotedStr(lRelationTicket.DestinationDisplayName) + ';' + #13#10;


         // ATRIBUTOS ESTENDIDOS
         // Obtm classe responsvel por mapeamento OO-DB para Relacionamento
         lRelationSQLPersistenceMapTicket := fMetaModelPersistenceMap.GetRelationsSQLPersistenceMapTicket(lRelationTicket);

         if (lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket) then
         begin
             bIndireta := true;
             lsNomeTabelaAssociativa := ', ''' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).TableName + '''';
             lsNomeFKA := ', ''' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKOrigemName + '''';
             lsNomeFKB := ', ''' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKDestinoName + '''';

         end
         else
           begin
               bIndireta := false;
               lsNomeFKA := ', ''' + (lRelationSQLPersistenceMapTicket as acDirectDBRelationMapTicket).FKColumnName + '''';
           end;

           // Lgica responsvel por selecionar o mtodo de relacionamento de acordo com a cardinalidade
           if lMultiplicityOrMax <= 1 then
           begin
             if lMultiplicityDsMax <= 1 then
             begin
                 if bIndireta then
                   sMetodo := 'NewIndirectOneToOneDbRelationMapRegisterTicket'
                 else
                   sMetodo := 'NewOneToOneDbRelationMapRegisterTicket';
             end
             else
             begin
               if bIndireta then
                 sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
               else
                 sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
             end;
           end
           else //lsMultiplicityOr = N
           begin
             if lMultiplicityDsMax <= 1 then
             begin
               if bIndireta then
                 sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
               else
                 sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
             end
             else
               sMetodo := 'NewManyToManyDbRelationMapRegisterTicket';
           end;

           sRelationsAll := sRelationsAll + 'if lRelationTicket <> nil then piMetaModelPersistenceMap.';
           sRelationsAll := sRelationsAll + sMetodo + '(lRelationTicket' + lsNomeFKA + lsNomeFKB + lsNomeTabelaAssociativa + ');' + #13#10 + #13#10;
           lsNomeFKA := '';
           lsNomeFKB := '';
           lsNomeTabelaAssociativa := '';

         lEnumRelation.MoveNext;
    end;
  finally
    lEnumRelation.Free;
  end;
    result := sRelationsAll;
end;


procedure TUtil.GerarBodyRelationsAll_CSharp(piProgress: TFShowProgress; piUnitRegisterMappings: PStringWriter);
var lEnumRelation: acEnumerator;
    lRelationTicket: acRelationTicket;
    lClassTicketOrigem, lClassTicketDestino: acClassTicket;
    lsNomeTabelaAssociativa, lsNomeFKA, lsNomeFKB: String;
    sMetodo, lsOrAggregation, lsDsAggregation: string;
    lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
    bIndireta: boolean;
    lMultiplicityOrMax, lMultiplicityDsMax, lMultiplicityOrMin, lMultiplicityDsMin: integer;
    lOriginPropertyName, lDetinationPropertyName: string;
//    I,
    lNumPropertyName: integer;
begin
  lNumPropertyName:= 0;
  if assigned(piProgress) then piProgress.ChangeMessage('Generating model mappings relation tickets...', 0, MetaModel.RelationTickets.Count);
  piUnitRegisterMappings.Indent();
  piUnitRegisterMappings.WriteLine('acRelationTicket lRelationTicket;');

  lEnumRelation := MetaModel.RelationTickets.GetEnumerator;
  try
    while not lEnumRelation.EOL do
    begin
      if assigned(piProgress) then piProgress.Inc;
      lRelationTicket := acRelationTicket(lEnumRelation.Current);
      // Obtm classes origem e destino. No est sendo considerada associaao ternria.
      lClassTicketOrigem := lRelationTicket.OriginClassTicket;
      lClassTicketDestino := lRelationTicket.DestinationClassTicket;

      lMultiplicityOrMax := lRelationTicket.OriginMaxMultiplicity;
      lMultiplicityDsMax := lRelationTicket.DestinationMaxMultiplicity;

      lMultiplicityOrMin := lRelationTicket.OriginMinMultiplicity;
      lMultiplicityDsMin := lRelationTicket.DestinationMinMultiplicity;

      case lRelationTicket.OriginAggregation of
        acPropertyAggregation.pvNone: lsOrAggregation := 'acPropertyAggregation.pvNone';
        acPropertyAggregation.pvAggregate: lsOrAggregation := 'acPropertyAggregation.pvAggregate';
        acPropertyAggregation.pvComposite: lsOrAggregation := 'acPropertyAggregation.pvComposite';
      end;

      case lRelationTicket.DestinationAggregation of
        acPropertyAggregation.pvNone: lsDsAggregation := 'acPropertyAggregation.pvNone';
        acPropertyAggregation.pvAggregate: lsDsAggregation := 'acPropertyAggregation.pvAggregate';
        acPropertyAggregation.pvComposite: lsDsAggregation := 'acPropertyAggregation.pvComposite';
      end;

      Inc(lNumPropertyName);
      lOriginPropertyName := 'piOriginPropertyName' + IntToStr(lNumPropertyName);
      lDetinationPropertyName := 'piDestinationPropertyName' + IntToStr(lNumPropertyName);

//      piUnitRegisterMappings.WriteLine('ShortString ' + lOriginPropertyName + ';');
//      piUnitRegisterMappings.WriteLine('ShortString ' + lDetinationPropertyName + ';');
//      piUnitRegisterMappings.WriteLine(lOriginPropertyName + '.Data = new Byte[] {');
//      piUnitRegisterMappings.WriteLine(IntToStr(Length(lRelationTicket.OriginPropertyName))+ ', ');
//      for I := 1 to Length(lRelationTicket.OriginPropertyName) do
//      begin
//        piUnitRegisterMappings.WriteLine(IntToStr(Ord(lRelationTicket.OriginPropertyName[I]))+ ', ');
//      end;
//      piUnitRegisterMappings.WriteLine('};');
//      piUnitRegisterMappings.WriteLine(lDetinationPropertyName + '.Data = new Byte[] {');
//        piUnitRegisterMappings.WriteLine(IntToStr(Length(lRelationTicket.DestinationPropertyName))+ ', ');
//      for I := 1 to Length(lRelationTicket.DestinationPropertyName) do
//      begin
//        piUnitRegisterMappings.WriteLine(IntToStr(Ord(lRelationTicket.DestinationPropertyName[I]))+ ', ');
//      end;
//      piUnitRegisterMappings.WriteLine('};');
      piUnitRegisterMappings.WriteLine('String ' + lOriginPropertyName + ';');
      piUnitRegisterMappings.WriteLine('String ' + lDetinationPropertyName + ';');
      piUnitRegisterMappings.WriteLine(lOriginPropertyName     + ' = "'+ lRelationTicket.OriginPropertyName + '";');
      piUnitRegisterMappings.WriteLine(lDetinationPropertyName + ' = "'+ lRelationTicket.DestinationPropertyName + '";');

      piUnitRegisterMappings.Write('lRelationTicket = piMetaModel.NewRelationRegisterTicket(');
      piUnitRegisterMappings.Write('"' + lClassTicketOrigem.PersistentObjectClassName + '"' + ', ' + lOriginPropertyName + ', ' + IntToStr(lRelationTicket.OriginPropertyindex) + ', ' + inttostr(lMultiplicityOrMin) + ', ' + inttostr(lMultiplicityOrMax) + ', ' + lsOrAggregation);
      piUnitRegisterMappings.Write(', ' + '"' + lRelationTicket.Name + '"' + ', ');
      piUnitRegisterMappings.Write('"' + lClassTicketDestino.PersistentObjectClassName + '"' + ', ' + lDetinationPropertyName + ', ' + IntToStr(lRelationTicket.DestinationPropertyIndex) + ', ' + inttostr(lMultiplicityDsMin) + ', ' + inttostr(lMultiplicityDsMax) + ', ' + lsDsAggregation);
      piUnitRegisterMappings.Write(', ' + AnsiLowerCase(BoolToStr(lRelationTicket.Bidirectional, true)));
      piUnitRegisterMappings.Write(', ' + AnsiLowerCase(BoolToStr(lRelationTicket.IsAuditable, true)));
      piUnitRegisterMappings.WriteLine(');');
      if lRelationTicket.DisplayName <> lRelationTicket.Name then
       piUnitRegisterMappings.WriteLine('lRelationTicket.DisplayName = "' + lRelationTicket.DisplayName + '";');
      if lRelationTicket.OriginDisplayName <> '' then
       piUnitRegisterMappings.WriteLine('lRelationTicket.OriginDisplayName = "' + lRelationTicket.OriginDisplayName + '";');
      if lRelationTicket.DestinationDisplayName <> '' then
       piUnitRegisterMappings.WriteLine('lRelationTicket.DestinationDisplayName = "' + lRelationTicket.DestinationDisplayName + '";');


      // ATRIBUTOS ESTENDIDOS
      // Obtm classe responsvel por mapeamento OO-DB para Relacionamento
      lRelationSQLPersistenceMapTicket := fMetaModelPersistenceMap.GetRelationsSQLPersistenceMapTicket(lRelationTicket);

      if (lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket) then
      begin
        bIndireta := true;
        lsNomeTabelaAssociativa := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).TableName + '"';
        lsNomeFKA := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKOrigemName + '"';
        lsNomeFKB := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKDestinoName + '"';
      end
      else
       begin
         bIndireta := false;
         lsNomeFKA := ', "' + (lRelationSQLPersistenceMapTicket as acDirectDBRelationMapTicket).FKColumnName + '"';
       end;

      // Lgica responsvel por selecionar o mtodo de relacionamento de acordo com a cardinalidade
      if lMultiplicityOrMax <= 1 then
      begin
       if lMultiplicityDsMax <= 1 then
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToOneDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToOneDbRelationMapRegisterTicket';
       end
       else
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
       end;
      end
      else //lsMultiplicityOr = N
      begin
       if lMultiplicityDsMax <= 1 then
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
       end
       else sMetodo := 'NewManyToManyDbRelationMapRegisterTicket';
      end;

     piUnitRegisterMappings.WriteLine('if (lRelationTicket != null){');
     piUnitRegisterMappings.WriteLine(#9+'piMetaModelPersistenceMap.'+sMetodo + '(lRelationTicket' + lsNomeFKA + lsNomeFKB + lsNomeTabelaAssociativa + ');');
     piUnitRegisterMappings.WriteLine('}');
     piUnitRegisterMappings.WriteLine();
     lsNomeFKA := '';
     lsNomeFKB := '';
     lsNomeTabelaAssociativa := '';

     lEnumRelation.MoveNext;
    end;
  finally
    lEnumRelation.Free;
  end;

  piUnitRegisterMappings.Outdent();
end;

procedure TUtil.GerarBodyRelationsAll_Java(piProgress: TFShowProgress; piUnitRegisterMappings: PStringWriter);
var lEnumRelation: acEnumerator;
    lRelationTicket: acRelationTicket;
    lClassTicketOrigem, lClassTicketDestino: acClassTicket;
    lsNomeTabelaAssociativa, lsNomeFKA, lsNomeFKB: String;
    sMetodo, lsOrAggregation, lsDsAggregation: string;
    lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
    bIndireta: boolean;
    lMultiplicityOrMax, lMultiplicityDsMax, lMultiplicityOrMin, lMultiplicityDsMin: integer;
    lOriginPropertyName, lDetinationPropertyName: string;
    lNumPropertyName: integer;
begin
  lNumPropertyName:= 0;
  if assigned(piProgress) then piProgress.ChangeMessage('Generating model mappings relation tickets...', 0, MetaModel.RelationTickets.Count);
  piUnitRegisterMappings.Indent();
  piUnitRegisterMappings.WriteLine('acRelationTicket lRelationTicket;');

  lEnumRelation := MetaModel.RelationTickets.GetEnumerator;
  try
    while not lEnumRelation.EOL do
    begin
      if assigned(piProgress) then piProgress.Inc;
      lRelationTicket := acRelationTicket(lEnumRelation.Current);
      // Obtm classes origem e destino. No est sendo considerada associaao ternria.
      lClassTicketOrigem := lRelationTicket.OriginClassTicket;
      lClassTicketDestino := lRelationTicket.DestinationClassTicket;

      lMultiplicityOrMax := lRelationTicket.OriginMaxMultiplicity;
      lMultiplicityDsMax := lRelationTicket.DestinationMaxMultiplicity;

      lMultiplicityOrMin := lRelationTicket.OriginMinMultiplicity;
      lMultiplicityDsMin := lRelationTicket.DestinationMinMultiplicity;

      case lRelationTicket.OriginAggregation of
        acPropertyAggregation.pvNone: lsOrAggregation := 'acPropertyAggregation.pvNone';
        acPropertyAggregation.pvAggregate: lsOrAggregation := 'acPropertyAggregation.pvAggregate';
        acPropertyAggregation.pvComposite: lsOrAggregation := 'acPropertyAggregation.pvComposite';
      end;

      case lRelationTicket.DestinationAggregation of
        acPropertyAggregation.pvNone: lsDsAggregation := 'acPropertyAggregation.pvNone';
        acPropertyAggregation.pvAggregate: lsDsAggregation := 'acPropertyAggregation.pvAggregate';
        acPropertyAggregation.pvComposite: lsDsAggregation := 'acPropertyAggregation.pvComposite';
      end;

      Inc(lNumPropertyName);
      lOriginPropertyName := 'piOriginPropertyName' + IntToStr(lNumPropertyName);
      lDetinationPropertyName := 'piDestinationPropertyName' + IntToStr(lNumPropertyName);

      piUnitRegisterMappings.WriteLine('String ' + lOriginPropertyName + ';');
      piUnitRegisterMappings.WriteLine('String ' + lDetinationPropertyName + ';');
      piUnitRegisterMappings.WriteLine(lOriginPropertyName     + ' = "'+ lRelationTicket.OriginPropertyName + '";');
      piUnitRegisterMappings.WriteLine(lDetinationPropertyName + ' = "'+ lRelationTicket.DestinationPropertyName + '";');

      piUnitRegisterMappings.Write('lRelationTicket = piMetaModel.NewRelationRegisterTicket(');
      piUnitRegisterMappings.Write('"' + lClassTicketOrigem.PersistentObjectClassName + '"' + ', ' + lOriginPropertyName + ', ' + IntToStr(lRelationTicket.OriginPropertyindex) + ', ' + inttostr(lMultiplicityOrMin) + ', ' + inttostr(lMultiplicityOrMax) + ', ' + lsOrAggregation);
      piUnitRegisterMappings.Write(', ' + '"' + lRelationTicket.Name + '"' + ', ');
      piUnitRegisterMappings.Write('"' + lClassTicketDestino.PersistentObjectClassName + '"' + ', ' + lDetinationPropertyName + ', ' + IntToStr(lRelationTicket.DestinationPropertyIndex) + ', ' + inttostr(lMultiplicityDsMin) + ', ' + inttostr(lMultiplicityDsMax) + ', ' + lsDsAggregation);
      piUnitRegisterMappings.Write(', ' + AnsiLowerCase(BoolToStr(lRelationTicket.Bidirectional, true)));
      piUnitRegisterMappings.Write(', ' + AnsiLowerCase(BoolToStr(lRelationTicket.IsAuditable, true)));
      piUnitRegisterMappings.WriteLine(');');
      if lRelationTicket.DisplayName <> lRelationTicket.Name then
       piUnitRegisterMappings.WriteLine('lRelationTicket.DisplayName = "' + lRelationTicket.DisplayName + '";');
      if lRelationTicket.OriginDisplayName <> '' then
       piUnitRegisterMappings.WriteLine('lRelationTicket.OriginDisplayName = "' + lRelationTicket.OriginDisplayName + '";');
      if lRelationTicket.DestinationDisplayName <> '' then
       piUnitRegisterMappings.WriteLine('lRelationTicket.DestinationDisplayName = "' + lRelationTicket.DestinationDisplayName + '";');


      // ATRIBUTOS ESTENDIDOS
      // Obtm classe responsvel por mapeamento OO-DB para Relacionamento
      lRelationSQLPersistenceMapTicket := fMetaModelPersistenceMap.GetRelationsSQLPersistenceMapTicket(lRelationTicket);

      if (lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket) then
      begin
        bIndireta := true;
        lsNomeTabelaAssociativa := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).TableName + '"';
        lsNomeFKA := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKOrigemName + '"';
        lsNomeFKB := ', "' + (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKDestinoName + '"';
      end
      else
       begin
         bIndireta := false;
         lsNomeFKA := ', "' + (lRelationSQLPersistenceMapTicket as acDirectDBRelationMapTicket).FKColumnName + '"';
       end;

      // Lgica responsvel por selecionar o mtodo de relacionamento de acordo com a cardinalidade
      if lMultiplicityOrMax <= 1 then
      begin
       if lMultiplicityDsMax <= 1 then
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToOneDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToOneDbRelationMapRegisterTicket';
       end
       else
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
       end;
      end
      else //lsMultiplicityOr = N
      begin
       if lMultiplicityDsMax <= 1 then
       begin
         if bIndireta
          then sMetodo := 'NewIndirectOneToManyDbRelationMapRegisterTicket'
          else sMetodo := 'NewOneToManyDbRelationMapRegisterTicket';
       end
       else sMetodo := 'NewManyToManyDbRelationMapRegisterTicket';
      end;
                                   
     piUnitRegisterMappings.WriteLine('if (lRelationTicket != null){');
     piUnitRegisterMappings.WriteLine(#9+'piMetaModelPersistenceMap.'+sMetodo + '(lRelationTicket' + lsNomeFKA + lsNomeFKB + lsNomeTabelaAssociativa + ');');
     piUnitRegisterMappings.WriteLine('}');
     piUnitRegisterMappings.WriteLine();
     lsNomeFKA := '';
     lsNomeFKB := '';
     lsNomeTabelaAssociativa := '';

     lEnumRelation.MoveNext;
    end;
  finally
    lEnumRelation.Free;
  end;

  piUnitRegisterMappings.Outdent();
end;

function TUtil.GerarBodyStateMachine(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
var lState: utState;
    lTransition: utTransition;
    lStatesEnum, lTransitionsEnum, lTriggersEnum: acEnumerator;
    lTrigger: utTrigger;
    I:integer;
    lAux: string;

    lInstantCodeProc: TInstantCodeProc;
    lInstantCodeBody: TInstantCodeBody;
    lUseCaseStateMachine: acUseCaseStateMachine;
begin
  result := '';
  lStatesEnum := piStateMachine.GetStatesEnumerator;
  try
    //Adiciona todos os States
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        lUseCaseStateMachine := (lState as utSubMachineState).StateMachine as acUseCaseStateMachine;
        result := Concat(result, format('lSubMachineState := utSubMachineState.Create(lStateMachine, ''%s'');', [lState.Name]), #13#10);
        result := Concat(result, format('lSubMachineUseCaseTicket := piMetaModel.UseCaseTicketByCode[''%s''];', [lUseCaseStateMachine.UseCaseTicket.Code]), #13#10);
        result := Concat(result, format('lSubMachineState.StateMachine := acUseCaseStateMachine.Create(lSubMachineUseCaseTicket, lSubMachineState);', []), #13#10);
      end
      else if lState is utFinalState then
        result := Concat(result, format('utFinalState.Create(lStateMachine, ''%s'');', [lState.Name]), #13#10)
      else
        result := Concat(result, format('utState.Create(lStateMachine, ''%s'');', [lState.Name]), #13#10);
      lStatesEnum.MoveNext;
    end;

    result := Concat(result, #13#10, '//Define o InitialState do StateMachine', #13#10);
    result := Concat(result, format('lStateMachine.InitialState := lStateMachine.FindState(''%s'');', [piStateMachine.InitialState.Name]), #13#10);

    result := Concat(result, #13#10, '//Adiciona as transicoes dos estados', #13#10);
    //Adiciona as transicoes de cada estado
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);

      if (lState.EntryActions.Count > 0) or (lState.DoActions.Count > 0) or
         (lState.ExitActions.Count > 0) or (lState.OutgoingTransitionCount > 0) then
      begin
        result := Concat(result, format('lState := lStateMachine.FindState(''%s'');', [lState.Name]), #13#10);

         //Adiciona os EntryACtions do estado corrente
        for I := 0 to lState.EntryActions.Count - 1 do
          result := Concat(result, format('lState.AddEntryAction(''%s'');', [lState.EntryActions[i]]), #13#10);
        //Adiciona os DoACtions do estado corrente
        for I := 0 to lState.DoActions.Count - 1 do
          result := Concat(result, format('lState.AddDoAction(''%s'');', [lState.DoActions[i]]), #13#10);
         //Adiciona os ExitACtions do estado corrente
        for I := 0 to lState.ExitActions.Count - 1 do
          result := Concat(result, format('lState.AddExitAction(''%s'');', [lState.ExitActions[i]]), #13#10);

        lTransitionsEnum := lState.GetOutgoingTransitionsEnumerator;
        try
          while not lTransitionsEnum.EOL do
          begin
            lTransition := utTransition(lTransitionsEnum.Current);

            if lTransition.Name = '' then
              result := Concat(result,'lTransition := lState.NewOutgoingTransition;', #13#10)
            else
              result := Concat(result, format('lTransition := lState.NewOutgoingTransition(''%s'');', [lTransition.Name]), #13#10);

            if lTransition.GuardCondition <> '' then
              result := Concat(result, format('lTransition.GuardCondition := ''%s'';', [lTransition.GuardCondition]), #13#10);

            if assigned(lTransition.SourceState) then
              result := Concat(result, 'lTransition.SourceState := lState;', #13#10);
            if assigned(lTransition.TargetState) then
              if lTransition.IsSelfTransition then
                result := Concat(result, 'lTransition.TargetState := lState;', #13#10)
              else
                result := Concat(result, format('lTransition.TargetState := lStateMachine.FindState(''%s'');', [lTransition.GetRealTargetState.Name]), #13#10);

            for I := 0 to lTransition.OperationsCodes.Count - 1 do
            begin
              result := Concat(result, format('lTransition.OperationsCodes.Add(''%s'');', [lTransition.OperationsCodes.Strings[I]]), #13#10);
            end;

            lTriggersEnum := lTransition.GetTriggersEnumerator;
            try
              while not lTriggersEnum.EOL do
              begin
                lTrigger := utTrigger(lTriggersEnum.Current);

                if lTrigger.Code <> '' then
                  result := Concat(result, format('lTransition.AddTrigger(''%s'',''%s'');', [lTrigger.Name, lTrigger.Code]), #13#10)
                else
                  result := Concat(result, format('lTransition.AddTrigger(''%s'');', [lTrigger.Name]), #13#10);

                lTriggersEnum.MoveNext;
              end;
            finally
              lTriggersEnum.Free;
            end;

            for I := 0 to lTransition.EffectsCount - 1 do
              result := Concat(result, format('lTransition.AddEffect(''%s'');', [lTransition.Effects[i]]), #13#10);

            if Not piModelMappingsOptions.IgnoreXSDSchema then
            begin
              if lTransition.XsdIn.XML <> '' then
              begin
                lAux := lTransition.XsdIn.XML;
                lAux := StringReplace(lAux, '''', '''''', [rfReplaceAll]);
                lAux := StringReplace(lAux, #13#10, ''' + #13#10 +' + #13#10 + '''', [rfReplaceAll]);
                result := Concat(result, format('lTransition.XsdIn.XML := %s;', ['GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + lTransition.SourceState.Name + '_' + lTransition.Name]), #13#10);

                lInstantCodeProc := piInstantCodeImplementationSection.AddProc;
                lInstantCodeProc.ResultTypeName := 'String';
                lInstantCodeProc.Name := 'GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + lTransition.SourceState.Name + '_' + lTransition.Name;
                lInstantCodeBody := lInstantCodeProc.Body;
                lInstantCodeBody.Text := 'Result := ''' + lAux + ''';';
              end;

              if lTransition.XsdOut.XML <> '' then
              begin
                lAux := lTransition.XsdOut.XML;
                lAux := StringReplace(lAux, '''', '''''', [rfReplaceAll]);
                lAux := StringReplace(lAux, #13#10, ''' + #13#10 +' + #13#10 + '''', [rfReplaceAll]);
                result := Concat(result, format('lTransition.XsdOut.XML := %s;', ['GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + lTransition.SourceState.Name + '_' + lTransition.Name]), #13#10);

                lInstantCodeProc := piInstantCodeImplementationSection.AddProc;
                lInstantCodeProc.ResultTypeName := 'String';
                lInstantCodeProc.Name := 'GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + lTransition.SourceState.Name + '_' + lTransition.Name;
                lInstantCodeBody := lInstantCodeProc.Body;
                lInstantCodeBody.Text := 'Result := ''' + lAux + ''';';;
              end;
            end;

            lTransitionsEnum.MoveNext;
          end;
        finally
          lTransitionsEnum.Free;
        end;
        result := Concat(result, #13#10);
      end;
      lStatesEnum.MoveNext;
    end;
    result := Concat(result, #13#10);

    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        result := Concat(result, format('// SUBSTATEMACHINE %s ///////////////////////', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, format('lStateMachine := lUseCaseTicket.FindStateMachine(''%s'');', [piStateMachine.Name]), #13#10);
        result := Concat(result, format('lStateMachine := utSubMachineState(lStateMachine.FindState(''%s'')).StateMachine as acUseCaseStateMachine;', [lState.Name]), #13#10);
        result := Concat(result, format('lStateMachine.Name := ''%s'';', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, GerarBodyStateMachine(piModelMappingsOptions, utSubMachineState(lState).StateMachine, piUseCaseTicketCode, piInstantCodeImplementationSection));
      end;
      lStatesEnum.MoveNext;
    end;
  finally
    lStatesEnum.Free;
  end;
end;

function TUtil.GerarBodyUseCases(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt: Integer; piEndAt: Integer; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
var lEnum: acEnumerator;
    lUseCaseTicket: acUseCaseTicket;
    lEnumClasses: acEnumerator;
    lClassTicket: acClassTicket;
    lInstantCodeProc: TInstantCodeProc;
    lInstantCodeBody: TInstantCodeBody;
    lInstantCodeVar: TInstantCodeVar;
    lBody: string;
    li: integer;
begin
  result := '';
  lBody := '';
  li := 1;
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets. GetEnumerator;
  try
    while not lEnum.EOL and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lBody := '';
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);

        lInstantCodeProc := piInstantCodeImplementationSection.AddProc;
        lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
        lInstantCodeBody := lInstantCodeProc.Body;
        lInstantCodeVar := lInstantCodeBody.Vars.Add;
        lInstantCodeVar.Name := 'lUseCaseTicket';
        lInstantCodeVar.TypeName := 'acUseCaseTicket';

        lInstantCodeProc.Name := 'NewUseCaseTicket_' + lUseCaseTicket.Name + '_' + lUseCaseTicket.Code;

        lEnumClasses := lUseCaseTicket.GetAvaliableClassesEnumerator;
        if not lEnumClasses.eol then
        begin
          lInstantCodeVar := lInstantCodeBody.Vars.Add;
          lInstantCodeVar.Name := 'lAvaliableClasses';
          lInstantCodeVar.TypeName := 'TStringList';

          lBody := Concat(lBody, 'try',#13#10);
          try
            while not lEnumClasses.EOL do
            begin
              lClassTicket := acClassTicket(lEnumClasses.Current);
              lBody := Concat(lBody, '  lAvaliableClasses.add(', QuotedStr(lClassTicket.PersistentObjectClassName), ');',#13#10);
              lEnumClasses.MoveNext;
            end;
          finally
            lEnumClasses.free;
          end;

          lBody := Concat(lBody, format('  lUseCaseTicket := piMetaModel.NewUseCaseTicket(''%s'', lAvaliableClasses, %s);', [lUseCaseTicket.Code, BoolToStr(lUseCaseTicket.IsAuditable, true)]), #13#10);
          lBody := Concat(lBody, 'finally',#13#10);
          lBody := Concat(lBody, '  lAvaliableClasses.free;',#13#10);
          lBody := Concat(lBody, 'end;',#13#10);
        end
        else
        begin
          lBody := Concat(lBody, format('lUseCaseTicket := piMetaModel.NewUseCaseTicket(''%s'', nil, %s);', [lUseCaseTicket.Code, BoolToStr(lUseCaseTicket.IsAuditable, true)]), #13#10);
        end;
        lBody := Concat(lBody, format('lUseCaseTicket.Name := ''%s'';', [lUseCaseTicket.Name]), #13#10);
        lBody := Concat(lBody, format('lUseCaseTicket.InheritsFromClass := ''%s'';', [lUseCaseTicket.InheritsFromClass]), #13#10);

        lInstantCodeBody.Text := lBody;

        result := concat(result, lInstantCodeProc.Name,'(piMetaModel);',#13#10);
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
  result := result + GerarBodyStateMachines(piModelMappingsOptions, piProgress, piStartAt, piEndAt, piInstantCodeImplementationSection);
end;


function TUtil.GerarBodyUseCases_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer;
  piUnitRegisterMappings: PStringWriter): string;
var
  lEnum: acEnumerator;
  lUseCaseTicket: acUseCaseTicket;
  lEnumClasses: acEnumerator;
  lClassTicket: acClassTicket;
  lProcName   : string; 
  li: integer;
begin
  result := '';
  li := 1;
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets. GetEnumerator;
  try
    while not lEnum.EOL and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);

        lProcName := 'NewUseCaseTicket_'+ lUseCaseTicket.Name + '_' + lUseCaseTicket.Code;
        piUnitRegisterMappings.WriteLine();
        piUnitRegisterMappings.WriteLine('internal static void '+lProcName+'(acMetaModel piMetaModel) {');
        piUnitRegisterMappings.Indent();

        lEnumClasses := lUseCaseTicket.GetAvaliableClassesEnumerator;
        if not lEnumClasses.eol then
        begin
//          piUnitRegisterMappings.WriteLine('try');
//          piUnitRegisterMappings.Indent();
          piUnitRegisterMappings.WriteLine('TStringList lAvaliableClasses;');
          try
            while not lEnumClasses.EOL do
            begin
              lClassTicket := acClassTicket(lEnumClasses.Current);
              piUnitRegisterMappings.WriteLine('lAvaliableClasses.add("'+ lClassTicket.PersistentObjectClassName+ '");');
              lEnumClasses.MoveNext;
            end;
          finally
            lEnumClasses.free;
          end;

          piUnitRegisterMappings.WriteLine(format('acUseCaseTicket lUseCaseTicket = piMetaModel.NewUseCaseTicket("%s", lAvaliableClasses, %s);', [lUseCaseTicket.Code, AnsiLowerCase(BoolToStr(lUseCaseTicket.IsAuditable, true))]));
//          piUnitRegisterMappings.WriteLine('finally');
//          piUnitRegisterMappings.WriteLine(#9 + 'lAvaliableClasses.free;');                                                                                                                                                        
//          piUnitRegisterMappings.WriteLine('end;');
//          piUnitRegisterMappings.Outdent();
        end
        else
        begin
          piUnitRegisterMappings.WriteLine(format('acUseCaseTicket lUseCaseTicket = piMetaModel.NewUseCaseTicket("%s", null, %s);', [lUseCaseTicket.Code, AnsiLowerCase(BoolToStr(lUseCaseTicket.IsAuditable, true))]));
        end;
        piUnitRegisterMappings.WriteLine(format('lUseCaseTicket.Name = "%s";', [lUseCaseTicket.Name]));
        piUnitRegisterMappings.WriteLine(format('lUseCaseTicket.InheritsFromClass = "%s";', [lUseCaseTicket.InheritsFromClass]));
                                        
        piUnitRegisterMappings.Outdent();
        piUnitRegisterMappings.WriteLine('}');
        result := concat(result, #9#9#9, lProcName,'(piMetaModel);',#13#10);
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
  result := result + GerarBodyStateMachines_CSharp(piModelMappingsOptions, piProgress, piStartAt, piEndAt, piUnitRegisterMappings);
end;

function TUtil.GerarBodyUseCases_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer;
  piUnitRegisterMappings: PStringWriter): string;
var
  lEnum: acEnumerator;
  lUseCaseTicket: acUseCaseTicket;
  lEnumClasses: acEnumerator;
  lClassTicket: acClassTicket;
  lProcName   : string; 
  li: integer;
begin
  result := '';
  li := 1;
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets. GetEnumerator;
  try
    while not lEnum.EOL and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);

        lProcName := 'NewUseCaseTicket_'+ lUseCaseTicket.Name + '_' + lUseCaseTicket.Code;
        piUnitRegisterMappings.WriteLine();
        piUnitRegisterMappings.WriteLine('static void '+lProcName+'(acMetaModel piMetaModel) {');
        piUnitRegisterMappings.Indent();

        lEnumClasses := lUseCaseTicket.GetAvaliableClassesEnumerator;
        if not lEnumClasses.eol then
        begin
          piUnitRegisterMappings.WriteLine('TStringList lAvaliableClasses;');
          try
            while not lEnumClasses.EOL do
            begin
              lClassTicket := acClassTicket(lEnumClasses.Current);
              piUnitRegisterMappings.WriteLine('lAvaliableClasses.add("'+ lClassTicket.PersistentObjectClassName+ '");');
              lEnumClasses.MoveNext;
            end;
          finally
            lEnumClasses.free;
          end;

          piUnitRegisterMappings.WriteLine(format('acUseCaseTicket lUseCaseTicket = piMetaModel.NewUseCaseTicket("%s", lAvaliableClasses, %s);', [lUseCaseTicket.Code, AnsiLowerCase(BoolToStr(lUseCaseTicket.IsAuditable, true))]));
        end
        else
        begin
          piUnitRegisterMappings.WriteLine(format('acUseCaseTicket lUseCaseTicket = piMetaModel.NewUseCaseTicket("%s", null, %s);', [lUseCaseTicket.Code, AnsiLowerCase(BoolToStr(lUseCaseTicket.IsAuditable, true))]));
        end;
        piUnitRegisterMappings.WriteLine(format('lUseCaseTicket.setName("%s");', [lUseCaseTicket.Name]));
        piUnitRegisterMappings.WriteLine(format('lUseCaseTicket.setInheritsFromClass("%s");', [lUseCaseTicket.InheritsFromClass]));
                                        
        piUnitRegisterMappings.Outdent();
        piUnitRegisterMappings.WriteLine('}');
        result := concat(result, #9#9#9, lProcName,'(piMetaModel);',#13#10);
      end;
      inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
  result := result + GerarBodyStateMachines_Java(piModelMappingsOptions, piProgress, piStartAt, piEndAt, piUnitRegisterMappings);
end;

function TUtil.GerarBodyStateMachines(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress;  piStartAt: Integer; piEndAt: Integer; piInstantCodeImplementationSection: TInstantCodeImplementationSection): string;
var lEnum: acEnumerator;
    lUseCaseTicket: acUseCaseTicket;
    li: integer;
begin
  result := '';
  li := 1;
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets.GetEnumerator;
  try
    while not lEnum.EOL  and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);
        result := Concat(result, #13#10);
        result := Concat(result, format('//Gerando StateMachine para o caso de uso ''%s''', [lUseCaseTicket.Name]), #13#10);
        result := Concat(result, format('lUseCaseTicket := piMetaModel.UseCaseTicketByCode[''%s''];', [lUseCaseTicket.Code]), #13#10);
        result := Concat(result, 'lUseCaseTicket.StateMachine := acUseCaseStateMachine.Create(lUseCaseTicket);', #13#10, #13#10);
        result := Concat(result, 'lStateMachine := lUseCaseTicket.StateMachine;', #13#10, #13#10);
        result := Concat(result, format('lStateMachine.Name := ''%s'';', [lUseCaseTicket.StateMachine.Name]), #13#10);
        result := result + GerarBodyStateMachine(piModelMappingsOptions, lUseCaseTicket.StateMachine, lUseCaseTicket.Code, piInstantCodeImplementationSection);
      end;
      Inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

function TUtil.GerarBodyStateMachines_CSharp(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer; piUnitRegisterMappings: PStringWriter): string;
var
  lEnum: acEnumerator;
  lUseCaseTicket: acUseCaseTicket;
  li: integer;
begin
  result := '';
  li := 1;
  result := Concat(result, #13#10#9#9#9, 'acUseCaseTicket lUseCaseTicket;', #13#10);
  result := Concat(result, #9#9#9, 'utStateMachine lStateMachine;', #13#10);
  result := Concat(result, #9#9#9, 'utState lState;', #13#10);
  result := Concat(result, #9#9#9, 'acUseCaseTicket lSubMachineUseCaseTicket;', #13#10);    
  result := Concat(result, #9#9#9, 'utSubMachineState lSubMachineState;', #13#10);
  result := Concat(result, #9#9#9, 'utTransition lTransition;', #13#10);
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets.GetEnumerator;
  try
    while not lEnum.EOL  and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);
        result := Concat(result, #13#10);
        result := Concat(result, #9#9#9, format('//Gerando StateMachine para o caso de uso "%s"', [lUseCaseTicket.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lUseCaseTicket = piMetaModel.get_UseCaseTicketByCode("%s");', [lUseCaseTicket.Code]), #13#10);
        result := Concat(result, #9#9#9, 'lUseCaseTicket.StateMachine = new acUseCaseStateMachine(lUseCaseTicket);', #13#10, #13#10);
        result := Concat(result, #9#9#9, 'lStateMachine = lUseCaseTicket.StateMachine;', #13#10, #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine.Name = "%s";', [lUseCaseTicket.StateMachine.Name]), #13#10);
        result := result + GerarBodyStateMachine_CSharp(piModelMappingsOptions, lUseCaseTicket.StateMachine, lUseCaseTicket.Code, piUnitRegisterMappings);
      end;
      Inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

function TUtil.GerarBodyStateMachines_Java(piModelMappingsOptions: TModelMappingsOptions; piProgress: TFShowProgress; piStartAt, piEndAt: Integer;
  piUnitRegisterMappings: PStringWriter): string;
var
  lEnum: acEnumerator;
  lUseCaseTicket: acUseCaseTicket;
  li: integer;
begin
  result := '';
  li := 1;
  result := Concat(result, #13#10#9#9#9, 'acUseCaseTicket lUseCaseTicket;', #13#10);
  result := Concat(result, #9#9#9, 'utStateMachine lStateMachine;', #13#10);
  result := Concat(result, #9#9#9, 'utState lState;', #13#10);
  result := Concat(result, #9#9#9, 'acUseCaseTicket lSubMachineUseCaseTicket;', #13#10);
  result := Concat(result, #9#9#9, 'utSubMachineState lSubMachineState;', #13#10);
  result := Concat(result, #9#9#9, 'utTransition lTransition;', #13#10);
  //UseCase Tickets
  lEnum := MetaModel.UseCaseTickets.GetEnumerator;
  try
    while not lEnum.EOL  and (li <= piEndAt) do
    begin
      if li >= piStartAt then
      begin
        lUseCaseTicket := acUseCaseTicket(lEnum.Current);
        result := Concat(result, #13#10);
        result := Concat(result, #9#9#9, format('//Gerando StateMachine para o caso de uso "%s"', [lUseCaseTicket.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lUseCaseTicket = piMetaModel.getUseCaseTicketByCode("%s");', [lUseCaseTicket.Code]), #13#10);
        result := Concat(result, #9#9#9, 'lUseCaseTicket.setStateMachine(new acUseCaseStateMachine(lUseCaseTicket, null));', #13#10, #13#10);
        result := Concat(result, #9#9#9, 'lStateMachine = lUseCaseTicket.getStateMachine();', #13#10, #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine.setName("%s");', [lUseCaseTicket.StateMachine.Name]), #13#10);
        result := result + GerarBodyStateMachine_Java(piModelMappingsOptions, lUseCaseTicket.StateMachine, lUseCaseTicket.Code, piUnitRegisterMappings);
      end;
      Inc(li);
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

function TUtil.GerarBodyStateMachine_CSharp(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string; piUnitRegisterMappings: PStringWriter): string;
var
  lState: utState;
  lTransition: utTransition;
  lStatesEnum, lTransitionsEnum, lTriggersEnum: acEnumerator;
  lTrigger: utTrigger;
  I:integer;
  lAux: string;

  lUseCaseStateMachine: acUseCaseStateMachine;
begin
  result := '';
  lStatesEnum := piStateMachine.GetStatesEnumerator;
  try
    //Adiciona todos os States
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        lUseCaseStateMachine := (lState as utSubMachineState).StateMachine as acUseCaseStateMachine;
        result := Concat(result, #9#9#9, format('lSubMachineState = new utSubMachineState(lStateMachine, "%s");', [lState.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lSubMachineUseCaseTicket = piMetaModel.get_UseCaseTicketByCode("%s");', [lUseCaseStateMachine.UseCaseTicket.Code]), #13#10);
        result := Concat(result, #9#9#9, format('lSubMachineState.StateMachine = new acUseCaseStateMachine(lSubMachineUseCaseTicket, lSubMachineState);', []), #13#10);
      end
      else if lState is utFinalState then
        result := Concat(result, #9#9#9, format('new utFinalState(lStateMachine, "%s");', [lState.Name]), #13#10)
      else
        result := Concat(result, #9#9#9, format('new utState(lStateMachine, "%s");', [lState.Name]), #13#10);
      lStatesEnum.MoveNext;
    end;

    result := Concat(result, #13#10#9#9#9, '//Define o InitialState do StateMachine', #13#10);
    result := Concat(result, #9#9#9, format('lStateMachine.InitialState = lStateMachine.FindState("%s");', [piStateMachine.InitialState.Name]), #13#10);

    result := Concat(result, #13#10#9#9#9, '//Adiciona as transicoes dos estados', #13#10);
    //Adiciona as transicoes de cada estado
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);

      if (lState.EntryActions.Count > 0) or (lState.DoActions.Count > 0) or
         (lState.ExitActions.Count > 0) or (lState.OutgoingTransitionCount > 0) then
      begin
        result := Concat(result, #9#9#9, format('lState = lStateMachine.FindState("%s");', [lState.Name]), #13#10);

         //Adiciona os EntryACtions do estado corrente
        for I := 0 to lState.EntryActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddEntryAction("%s");', [lState.EntryActions[i]]), #13#10);
        //Adiciona os DoACtions do estado corrente
        for I := 0 to lState.DoActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddDoAction(''%s'');', [lState.DoActions[i]]), #13#10);
         //Adiciona os ExitACtions do estado corrente
        for I := 0 to lState.ExitActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddExitAction("%s");', [lState.ExitActions[i]]), #13#10);

        lTransitionsEnum := lState.GetOutgoingTransitionsEnumerator;
        try
          while not lTransitionsEnum.EOL do
          begin
            lTransition := utTransition(lTransitionsEnum.Current);

            if lTransition.Name = '' then
              result := Concat(result, #9#9#9, 'lTransition = lState.NewOutgoingTransition;', #13#10)
            else
              result := Concat(result, #9#9#9, format('lTransition = lState.NewOutgoingTransition("%s");', [lTransition.Name]), #13#10);

            if lTransition.GuardCondition <> '' then
              result := Concat(result, #9#9#9, format('lTransition.GuardCondition = "%s";', [lTransition.GuardCondition]), #13#10);

            if assigned(lTransition.SourceState) then
              result := Concat(result, #9#9#9, 'lTransition.SourceState = lState;', #13#10);
            if assigned(lTransition.TargetState) then
              if lTransition.IsSelfTransition then
                result := Concat(result, #9#9#9, 'lTransition.TargetState = lState;', #13#10)
              else
                result := Concat(result, #9#9#9, format('lTransition.TargetState = lStateMachine.FindState("%s");', [lTransition.GetRealTargetState.Name]), #13#10);

            for I := 0 to lTransition.OperationsCodes.Count - 1 do
            begin
              result := Concat(result, #9#9#9, format('lTransition.OperationsCodes.Add("%s");', [lTransition.OperationsCodes.Strings[I]]), #13#10);
            end;

            lTriggersEnum := lTransition.GetTriggersEnumerator;
            try
              while not lTriggersEnum.EOL do
              begin
                lTrigger := utTrigger(lTriggersEnum.Current);

                if lTrigger.Code <> '' then
                  result := Concat(result, #9#9#9, format('lTransition.AddTrigger("%s","%s");', [lTrigger.Name, lTrigger.Code]), #13#10)
                else
                  result := Concat(result, #9#9#9, format('lTransition.AddTrigger("%s", "");', [lTrigger.Name]), #13#10);

                lTriggersEnum.MoveNext;
              end;
            finally
              lTriggersEnum.Free;
            end;

            for I := 0 to lTransition.EffectsCount - 1 do
              result := Concat(result, #9#9#9, format('lTransition.AddEffect("%s");', [lTransition.Effects[i]]), #13#10);

            if Not piModelMappingsOptions.IgnoreXSDSchema then
            begin
              if lTransition.XsdIn.XML <> '' then
              begin
                lAux := lTransition.XsdIn.XML;
                lAux := StringReplace(lAux, '"', '\"', [rfReplaceAll]);   
                lAux := StringReplace(lAux, #13#10, '', [rfReplaceAll]);
                result := Concat(result, #9#9#9, format('lTransition.XsdIn.XML = %s();', ['GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name]), #13#10);
                                            
                piUnitRegisterMappings.WriteLine();
                piUnitRegisterMappings.WriteLine('internal static string GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name+'() {');
                piUnitRegisterMappings.WriteLine(#9+'return "' + lAux + '";');
                piUnitRegisterMappings.WriteLine('}');
              end;

              if lTransition.XsdOut.XML <> '' then
              begin
                lAux := lTransition.XsdOut.XML;
                lAux := StringReplace(lAux, '"', '\"', [rfReplaceAll]);
                lAux := StringReplace(lAux, #13#10, '', [rfReplaceAll]);
                result := Concat(result, #9#9#9, format('lTransition.XsdOut.XML = %s();', ['GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name]), #13#10);

                piUnitRegisterMappings.WriteLine();
                piUnitRegisterMappings.WriteLine('internal static string GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name+'() {');
                piUnitRegisterMappings.WriteLine(#9+'return "' + lAux + '";');
                piUnitRegisterMappings.WriteLine('}');
              end;
            end;

            lTransitionsEnum.MoveNext;
          end;
        finally
          lTransitionsEnum.Free;
        end;
        result := Concat(result, #13#10);
      end;
      lStatesEnum.MoveNext;
    end;
    result := Concat(result, #13#10);

    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        result := Concat(result, #9#9#9, format('// SUBSTATEMACHINE %s ///////////////////////', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine = lUseCaseTicket.FindStateMachine("%s");', [piStateMachine.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine = (acUseCaseStateMachine)(lStateMachine.FindState("%s") as utSubMachineState).StateMachine;', [lState.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine.Name = "%s";', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, GerarBodyStateMachine_CSharp(piModelMappingsOptions, utSubMachineState(lState).StateMachine, piUseCaseTicketCode, piUnitRegisterMappings));
      end;
      lStatesEnum.MoveNext;
    end;
  finally
    lStatesEnum.Free;
  end;
end;

function TUtil.GerarBodyStateMachine_Java(piModelMappingsOptions: TModelMappingsOptions; piStateMachine: utStateMachine; piUseCaseTicketCode: string;
  piUnitRegisterMappings: PStringWriter): string;
var
  lState: utState;
  lTransition: utTransition;
  lStatesEnum, lTransitionsEnum, lTriggersEnum: acEnumerator;
  lTrigger: utTrigger;
  I:integer;
  lAux: string;

  lUseCaseStateMachine: acUseCaseStateMachine;
begin
  result := '';
  lStatesEnum := piStateMachine.GetStatesEnumerator;
  try
    //Adiciona todos os States
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        lUseCaseStateMachine := (lState as utSubMachineState).StateMachine as acUseCaseStateMachine;
        result := Concat(result, #9#9#9, format('lSubMachineState = new utSubMachineState(lStateMachine, "%s");', [lState.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lSubMachineUseCaseTicket = piMetaModel.getUseCaseTicketByCode("%s");', [lUseCaseStateMachine.UseCaseTicket.Code]), #13#10);
        result := Concat(result, #9#9#9, format('lSubMachineState.setStateMachine( new acUseCaseStateMachine(lSubMachineUseCaseTicket, lSubMachineState) );', []), #13#10);
      end
      else if lState is utFinalState then
        result := Concat(result, #9#9#9, format('new utFinalState(lStateMachine, "%s");', [lState.Name]), #13#10)
      else
        result := Concat(result, #9#9#9, format('new utState(lStateMachine, "%s");', [lState.Name]), #13#10);
      lStatesEnum.MoveNext;
    end;

    result := Concat(result, #13#10#9#9#9, '//Define o InitialState do StateMachine', #13#10);
    result := Concat(result, #9#9#9, format('lStateMachine.setInitialState( lStateMachine.FindState("%s") );', [piStateMachine.InitialState.Name]), #13#10);

    result := Concat(result, #13#10#9#9#9, '//Adiciona as transicoes dos estados', #13#10);
    //Adiciona as transicoes de cada estado
    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);

      if (lState.EntryActions.Count > 0) or (lState.DoActions.Count > 0) or
         (lState.ExitActions.Count > 0) or (lState.OutgoingTransitionCount > 0) then
      begin
        result := Concat(result, #9#9#9, format('lState = lStateMachine.FindState("%s");', [lState.Name]), #13#10);

         //Adiciona os EntryACtions do estado corrente
        for I := 0 to lState.EntryActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddEntryAction("%s");', [lState.EntryActions[i]]), #13#10);
        //Adiciona os DoACtions do estado corrente
        for I := 0 to lState.DoActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddDoAction(''%s'');', [lState.DoActions[i]]), #13#10);
         //Adiciona os ExitACtions do estado corrente
        for I := 0 to lState.ExitActions.Count - 1 do
          result := Concat(result, #9#9#9, format('lState.AddExitAction("%s");', [lState.ExitActions[i]]), #13#10);

        lTransitionsEnum := lState.GetOutgoingTransitionsEnumerator;
        try
          while not lTransitionsEnum.EOL do
          begin
            lTransition := utTransition(lTransitionsEnum.Current);

            if lTransition.Name = '' then
              result := Concat(result, #9#9#9, 'lTransition = lState.NewOutgoingTransition;', #13#10)
            else
              result := Concat(result, #9#9#9, format('lTransition = lState.NewOutgoingTransition("%s");', [lTransition.Name]), #13#10);

            if lTransition.GuardCondition <> '' then
              result := Concat(result, #9#9#9, format('lTransition.setGuardCondition("%s");', [lTransition.GuardCondition]), #13#10);

            if assigned(lTransition.SourceState) then
              result := Concat(result, #9#9#9, 'lTransition.setSourceState(lState);', #13#10);
            if assigned(lTransition.TargetState) then
              if lTransition.IsSelfTransition then
                result := Concat(result, #9#9#9, 'lTransition.setTargetState(lState);', #13#10)
              else
                result := Concat(result, #9#9#9, format('lTransition.setTargetState( lStateMachine.FindState("%s") );', [lTransition.GetRealTargetState.Name]), #13#10);

            for I := 0 to lTransition.OperationsCodes.Count - 1 do
            begin
              result := Concat(result, #9#9#9, format('lTransition.OperationsCodes.Add("%s");', [lTransition.OperationsCodes.Strings[I]]), #13#10);
            end;

            lTriggersEnum := lTransition.GetTriggersEnumerator;
            try
              while not lTriggersEnum.EOL do
              begin
                lTrigger := utTrigger(lTriggersEnum.Current);

                if lTrigger.Code <> '' then
                  result := Concat(result, #9#9#9, format('lTransition.AddTrigger("%s","%s");', [lTrigger.Name, lTrigger.Code]), #13#10)
                else
                  result := Concat(result, #9#9#9, format('lTransition.AddTrigger("%s", "");', [lTrigger.Name]), #13#10);

                lTriggersEnum.MoveNext;
              end;
            finally
              lTriggersEnum.Free;
            end;

            for I := 0 to lTransition.EffectsCount - 1 do
              result := Concat(result, #9#9#9, format('lTransition.AddEffect("%s");', [lTransition.Effects[i]]), #13#10);

            if Not piModelMappingsOptions.IgnoreXSDSchema then
            begin
              if lTransition.XsdIn.XML <> '' then
              begin
                lAux := lTransition.XsdIn.XML;
                lAux := StringReplace(lAux, '"', '\"', [rfReplaceAll]);   
                lAux := StringReplace(lAux, #13#10, '', [rfReplaceAll]);
                result := Concat(result, #9#9#9, format('lTransition.getXsdIn().setXML( %s );', ['GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name + '()']), #13#10);

                piUnitRegisterMappings.WriteLine();
                piUnitRegisterMappings.WriteLine('static String GetXSDIn_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name+'() {');
                piUnitRegisterMappings.WriteLine(#9+'return "' + lAux + '";');
                piUnitRegisterMappings.WriteLine('}');
              end;

              if lTransition.XsdOut.XML <> '' then
              begin
                lAux := lTransition.XsdOut.XML;
                lAux := StringReplace(lAux, '"', '\"', [rfReplaceAll]);
                lAux := StringReplace(lAux, #13#10, '', [rfReplaceAll]);
                result := Concat(result, #9#9#9, format('lTransition.getXsdOut().setXML( %s );', ['GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name + '()']), #13#10);

                piUnitRegisterMappings.WriteLine();
                piUnitRegisterMappings.WriteLine('static String GetXSDOut_' + piUseCaseTicketCode + '_' + piStateMachine.Name + '_' + AnsiString(lTransition.SourceState.Name) + '_' + lTransition.Name+'() {');
                piUnitRegisterMappings.WriteLine(#9+'return "' + lAux + '";');
                piUnitRegisterMappings.WriteLine('}');
              end;
            end;

            lTransitionsEnum.MoveNext;
          end;
        finally
          lTransitionsEnum.Free;
        end;
        result := Concat(result, #13#10);
      end;
      lStatesEnum.MoveNext;
    end;
    result := Concat(result, #13#10);

    lStatesEnum.MoveFirst;
    while not lStatesEnum.EOL do
    begin
      lState := utState(lStatesEnum.Current);
      if lState is utSubMachineState then
      begin
        result := Concat(result, #9#9#9, format('// SUBSTATEMACHINE %s ///////////////////////', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine = lUseCaseTicket.FindStateMachine("%s");', [piStateMachine.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine = (acUseCaseStateMachine)( (utSubMachineState) lStateMachine.FindState("%s") ).getStateMachine();', [lState.Name]), #13#10);
        result := Concat(result, #9#9#9, format('lStateMachine.setName( "%s" );', [utSubMachineState(lState).StateMachine.Name]), #13#10);
        result := Concat(result, GerarBodyStateMachine_Java(piModelMappingsOptions, utSubMachineState(lState).StateMachine, piUseCaseTicketCode, piUnitRegisterMappings));
      end;
      lStatesEnum.MoveNext;
    end;
  finally
    lStatesEnum.Free;
  end;
end;

function TUtil.GerarUseCaseClientPreview_DotNet(piParams: TCodeGenParams): string;
var
  lJavaCode: TStringStream;
  lUseCase: acUseCaseTicket;

  procedure AddText(piIndent: integer = 0; piText: string = '');
  begin
    piText := StringOfChar(' ', piIndent * 4) + piText;
    lJavaCode.WriteString(concat(piText,#13#10));
  end;


  procedure ReadStateMachine(piStateMachine: utStateMachine);
  var lTransitionEnum, lStateEnum, lTriggersEnum: acEnumerator;
      lState: utState;
      lTransition: utTransition;
      lTrigger: utTrigger;
      lObjectHash: acObjectHash;
      lTriggerName: string;
  begin
    lStateEnum := piStateMachine.GetStatesEnumerator;
    lObjectHash := acObjectHash.Create(127, False);
    try
      while not lStateEnum.EOL do
      begin
        lState := utState(lStateEnum.Current);

        if piStateMachine.Name <> cBASE_STATE_MACHINE then
        begin
          lTransitionEnum := lState.GetOutgoingTransitionsEnumerator;
          try
            while not lTransitionEnum.EOL do
            begin
              lTransition := utTransition(lTransitionEnum.Current);

              lTriggersEnum := lTransition.GetTriggersEnumerator;
              try
                while not lTriggersEnum.EOL do
                begin
                  lTrigger := utTrigger(lTriggersEnum.Current);
                    if lTrigger.Code <> ''
                      then lTriggerName := lTrigger.Code
                      else lTriggerName := lTrigger.Name;
                  if not assigned(lObjectHash.ValueOf(lTriggerName)) then
                  begin
                    AddText(1, format('public Field %s(Field piField)',[LowerCase(lTrigger.Name)]));
                    AddText(1, '{');
                    AddText(2, format('RequestMessage piMessage = new RequestMessage("%s", piField);',[lTriggerName]));
                    AddText(2, 'return Session.SendRequest(piMessage).RootField;');
                    AddText(1, '}');
                    AddText;
                    lObjectHash.Add(lTriggerName, lTrigger);
                  end;
                  lTriggersEnum.MoveNext;
                end;
              finally
                lTriggersEnum.Free;
              end;

              lTransitionEnum.MoveNext;
            end;
          finally
            lTransitionEnum.Free;
          end;
        end;

        if lState is utSubMachineState then
          ReadStateMachine(utSubMachineState(lState).StateMachine);

        lStateEnum.MoveNext;
      end;
    finally
      lStateEnum.Free;
      lObjectHash.Free;
    end;
  end;

begin
//  lDescendFromUCcSecuredUseCase := false;
//  for I := 0 to piUseCase.GetGeneralizationCount - 1 do
//    if SameText(piUseCase.GetGeneralizationAt(i).Parent.Name, 'ucUseCase') then
//    begin
//      lDescendFromUCcSecuredUseCase := true;
//      break;
//    end;
//
//  if not lDescendFromUCcSecuredUseCase then
//    raise Exception.Create('Usecase must descend "ucUseCase".');

//  if not DescendsFrom(piUseCase, 'ucUseCase') then
//    raise Exception.Create('Usecase must descend "ucUseCase".');


//  lUseCaseCode := piUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');
  lUseCase := MetaModel.UseCaseTickets.ValueOf(TCodeGenParamsUseCase(piParams).UseCaseCode) as acUseCaseTicket;

  lJavaCode := TStringStream.Create('');
  try
// WARNING
// -------
// The class declared in this file were generated from a design model.
// If this file is re-imported, the contents of this file will be
// regenerated and all manual modifications will be lost.

    AddText(0, '/*********************************************************************');
    AddText(0, '*');
    AddText(0, '* Automatic Code Generation');
    AddText(0, '*');
    AddText(0, '* WARNING');
    AddText(0, '*');
    AddText(0, '* The class declared in this file were generated from a design model.');
    AddText(0, '* If this file is re-imported, the contents of this file will be');
    AddText(0, '* regenerated and all manual modifications will be lost.');
    AddText(0, '*');
    AddText(0, format('* Date: %s',[FormatDateTime('dd/mm/yyyy hh:nn', now)]));
    AddText(0, '*********************************************************************/');
    AddText;

    AddText(0, 'using System;');
    AddText;

    AddText(0, format('public class %s : %s {',[lUseCase.Name, 'UseCase'{piUseCase.GetGeneralizationAt(0).parent.name}]));
    AddText;
    AddText(1, format('public %s(int piSessionID) : base(piSessionID)',[lUseCase.Name]));
    AddText(1, '{');
    AddText(1, '}');
    AddText;
    AddText(1, format('public %s(Session piSession) : base(piSession)',[lUseCase.Name]));
    AddText(1, '{');
    AddText(1, '}');
    AddText;
    AddText(1, format('public %s(int piSessionID, String piObjectID) : base(piSessionID, piObjectID)',[lUseCase.Name]));
    AddText(1, '{');
    AddText(1, '}');
    AddText;
    AddText(1, format('public %s(Session piSession, String piObjectID) : base(piSession, piObjectID)',[lUseCase.Name]));
    AddText(1, '{');
    AddText(1, '}');
    AddText;

    ReadStateMachine(lUseCase.StateMachine);

    AddText(1, 'public override String Codigo');
    AddText(1, '{');
    AddText(2, format('get { return "%s"; }',[lUseCase.Code]));
    AddText(1, '}');

    AddText(0, '}');

    result := lJavaCode.DataString;
  finally
    lJavaCode.Free;
  end;
end;

function TUtil.GerarUseCaseClientPreview_Java(piParams: TCodeGenParams): string;
var
  lJavaCode: TStringStream;
  lUseCase: acUseCaseTicket;
  lUseCaseName: string;

  function FormatJavaMethodName(piName: string): string;
  var lName: String;
      lPos: integer;
  begin
    lName := LowerCase(piName);
    lPos := Pos('_', lName);
    while lpos > 0 do
    begin
      if lpos < Length(lName) then lName[lPos+1] := UpCase(lName[lPos+1]);
      delete(lName,lPos, 1);
      lPos := Pos('_', lName);
    end;
    result := lName;
  end;


  procedure AddText(piIndent: integer = 0; piText: string = '');
  begin
    piText := StringOfChar(' ', piIndent * 4) + piText;
    lJavaCode.WriteString(concat(piText,#13#10));
  end;


  procedure ReadStateMachine(piStateMachine: utStateMachine);
  var lTransitionEnum, lStateEnum, lTriggersEnum: acEnumerator;
      lState: utState;
      lTransition: utTransition;
      lTrigger: utTrigger;
      lObjectHash: acObjectHash;
      lTriggerName: string;
  begin
    lStateEnum := piStateMachine.GetStatesEnumerator;
    lObjectHash := acObjectHash.Create(127, False);
    try
      while not lStateEnum.EOL do
      begin
        lState := utState(lStateEnum.Current);

        if piStateMachine.Name <> cBASE_STATE_MACHINE then
        begin
          lTransitionEnum := lState.GetOutgoingTransitionsEnumerator;
          try
            while not lTransitionEnum.EOL do
            begin
              lTransition := utTransition(lTransitionEnum.Current);

              lTriggersEnum := lTransition.GetTriggersEnumerator;
              try
                while not lTriggersEnum.EOL do
                begin
                  lTrigger := utTrigger(lTriggersEnum.Current);
                    if lTrigger.Code <> ''
                      then lTriggerName := lTrigger.Code
                      else lTriggerName := lTrigger.Name;
                  if not assigned(lObjectHash.ValueOf(lTriggerName)) then
                  begin
                    AddText(1, format('public Field %s(Field piField) throws UnknownHostException, UCException, IOException {',[FormatJavaMethodName(lTrigger.Name)]));
                    AddText(2, format('RequestMessage piMessage = new RequestMessage("%s", piField);',[lTriggerName]));
                    AddText(2, 'return getSession().sendRequest(piMessage).getRootField();');
                    AddText(1, '}');
                    AddText;
                    lObjectHash.Add(lTriggerName, lTrigger);
                  end;
                  lTriggersEnum.MoveNext;
                end;
              finally
                lTriggersEnum.Free;
              end;

              lTransitionEnum.MoveNext;
            end;
          finally
            lTransitionEnum.Free;
          end;
        end;

        if lState is utSubMachineState then
          ReadStateMachine(utSubMachineState(lState).StateMachine);

        lStateEnum.MoveNext;
      end;
    finally
      lStateEnum.Free;
      lObjectHash.Free;
    end;
  end;

begin
//  lDescendFromUCcSecuredUseCase := false;
//  for I := 0 to piUseCase.GetGeneralizationCount - 1 do
//    if SameText(piUseCase.GetGeneralizationAt(i).Parent.Name, 'ucUseCase') then
//    begin
//      lDescendFromUCcSecuredUseCase := true;
//      break;
//    end;
//
//  if not lDescendFromUCcSecuredUseCase then
//    raise Exception.Create('Usecase must descend "ucUseCase".');

//  if not DescendsFrom(piUseCase, 'ucUseCase') then
//    raise Exception.Create('Usecase must descend "ucUseCase".');


//  lUseCaseCode := piUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');
  lUseCase := MetaModel.UseCaseTickets.ValueOf(TCodeGenParamsUseCase(piParams).UseCaseCode) as acUseCaseTicket;

  lJavaCode := TStringStream.Create('');
  try
// WARNING
// -------
// The class declared in this file were generated from a design model.
// If this file is re-imported, the contents of this file will be
// regenerated and all manual modifications will be lost.

    AddText(0, '/*********************************************************************');
    AddText(0, '*');
    AddText(0, '* Automatic Code Generation');
    AddText(0, '*');
    AddText(0, '* WARNING');
    AddText(0, '*');
    AddText(0, '* The class declared in this file were generated from a design model.');
    AddText(0, '* If this file is re-imported, the contents of this file will be');
    AddText(0, '* regenerated and all manual modifications will be lost.');
    AddText(0, '*');
    AddText(0, format('* Date: %s',[FormatDateTime('dd/mm/yyyy hh:nn', now)]));
    AddText(0, '*********************************************************************/');
    AddText;

    AddText(0, 'package ' + TCodeGenParamsUseCaseJava(piParams).JavaClientPackageName);
    AddText;

    AddText(0, 'import java.io.IOException;');
    AddText(0, 'import java.net.UnknownHostException;');
    AddText(0, 'import br.com.conexops.uclbp.*;');
    AddText;

    if SameText(copy(lUseCase.Name,1,2), 'uc') then
      lUseCaseName := 'UC' + RightStr(lUseCase.Name, Length(lUseCase.Name) - 2)
    else
      lUseCaseName := UpperCase(lUseCase.Name[1]) + RightStr(lUseCase.Name, Length(lUseCase.Name) - 1);

    AddText(0, format('public class %s extends %s {',[lUseCaseName, 'UseCase'{piUseCase.GetGeneralizationAt(0).parent.name}]));
    AddText;
    AddText(1, format('public %s(int piSessionID) throws UCException, NumberFormatException, IOException {',[lUseCaseName]));
    AddText(2, 'super(piSessionID);');
    AddText(1, '}');
    AddText;
    AddText(1, format('public %s(Session piSession) throws UCException, NumberFormatException, IOException {',[lUseCaseName]));
    AddText(2, 'super(piSession);');
    AddText(1, '}');
    AddText;

    ReadStateMachine(lUseCase.StateMachine);

    AddText(1, 'public String getCodigo() {');
    AddText(2, format('return "%s";',[lUseCase.Code]));
    AddText(1, '}');

    AddText(0, '}');

    result := lJavaCode.DataString;
  finally
    lJavaCode.Free;
  end;
end;

function TUtil.GerarUseCaseClientPreview_Pascal(piParams: TCodeGenParams): string;
begin

end;

procedure TUtil.GerarUnitRelationsAll(piModelMappingsOptions: TModelMappingsOptions; psFileName: string; piProgress: TFShowProgress);
var
    lInstantCodeModule: TInstantCodeModule;
    lInstantCodeProc: TInstantCodeProc;
    lInstantCodeVar: TInstantCodeVar;
    lInstantCodeBody: TInstantCodeBody;
//    lInstantCodeWriter: TInstantCodeWriter;
//    s: string;
begin
    // Cria UNIT
    lInstantCodeModule := TInstantCodeModule.Create(nil);

    lInstantCodeModule.Name := 'RelationsAll';

    // Section interface
    lInstantCodeModule.InterfaceSection.AddUses.Name := 'acuframework';

    lInstantCodeProc := lInstantCodeModule.InterfaceSection.AddProc;

    lInstantCodeProc.Name := 'GenerateRelations';
    lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
    lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMap', []);

    // Section implementation
    lInstantCodeModule.ImplementationSection.AddUses.Name := 'acuRepositorySQL';

    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;

    lInstantCodeProc.Name := 'GenerateRelations';
    lInstantCodeProc.Parameters.AddParameter('piMetaModel', 'acMetaModel', []);
    lInstantCodeProc.Parameters.AddParameter('piMetaModelPersistenceMap', 'acMetaModelPersistenceMap', []);

    lInstantCodeBody := lInstantCodeProc.Body;

    lInstantCodeVar := lInstantCodeBody.Vars.Add;
    lInstantCodeVar.Name := 'lRelationTicket';
    lInstantCodeVar.TypeName := 'acRelationTicket';

    lInstantCodeBody.Text := GerarBodyRelationsAll(piProgress);

//    lInstantCodeModule.InitializationSection.CodeText := 'RegisterRelation()';

    // Gerao de arquivo
    lInstantCodeModule.SaveToFile(psFileName);
end;


function TUtil.GerarRelationsPartnerShips(piClassTicket: acClassTicket; piInstantCodeClass: TInstantCodeClass): string;
var li: Integer;
    lRelation: acRelationTicket;
//    lPropertyClass: acObjectClass;
//    lPartner: acObject;
//    lRelationPartnerList: acRelationPartnerList;
//    lRelationPartnerShip: acRelationPartnerShip;
    lInstantCodeField: TInstantCodeField;
    lInstantCodeProperty: TInstantCodeProperty;
    lsresult: String;
begin
//  while piClassTicket <> nil do
//  begin
    for li := 0 to piClassTicket.RelationTicketsIn.Count - 1 do
    begin
      lRelation := (piClassTicket.RelationTicketsIn.Objects[li] as acRelationTicket);
      if (lRelation.DestinationPropertyName <> '') then
      begin
        if lRelation.DestinationMaxMultiplicity > 1 then
        begin
//            lInstantCodeField := piInstantCodeClass.AddField(viPrivate);
//            lInstantCodeField.TypeName := 'acRelationPartnerList';
//            lInstantCodeField.Name := 'f'+lRelation.DestinationPropertyName;

            lInstantCodeProperty := piInstantCodeClass.AddProperty(viPublished);
            lInstantCodeProperty.GetterName := 'getPartnerList';
            lInstantCodeProperty.Name := lRelation.DestinationPropertyName;
            lInstantCodeProperty.TypeName := 'acRelationPartnerList';
        end
        else
        begin
//            lInstantCodeField := piInstantCodeClass.AddField(viPrivate);
//            lInstantCodeField.TypeName := 'acRelationPartnerShip';
//            lInstantCodeField.Name := 'f'+lRelation.DestinationPropertyName;

            lInstantCodeProperty := piInstantCodeClass.AddProperty(viPublished);
            lInstantCodeProperty.GetterName := 'getPartnerShip';
            lInstantCodeProperty.Name := lRelation.DestinationPropertyName;
            lInstantCodeProperty.TypeName := 'acRelationPartnerShip';
        end;
        lInstantCodeProperty.Index := IntToStr(lRelation.DestinationPropertyIndex);
      end;
    end;
    for li := 0 to piClassTicket.RelationTicketsOut.Count - 1 do
    begin
      lRelation := (piClassTicket.RelationTicketsOut.Objects[li] as acRelationTicket);
      if (lRelation.OriginPropertyName <> '') then
      begin
        if lRelation.OriginMaxMultiplicity > 1 then
        begin
//            lInstantCodeField := piInstantCodeClass.AddField(viPrivate);
//            lInstantCodeField.TypeName := 'acRelationPartnerList';
//            lInstantCodeField.Name := 'f'+lRelation.OriginPropertyName;

            lInstantCodeProperty := piInstantCodeClass.AddProperty(viPublished);
            lInstantCodeProperty.GetterName := 'getPartnerList';
            lInstantCodeProperty.Name := lRelation.OriginPropertyName;
            lInstantCodeProperty.TypeName := 'acRelationPartnerList';
        end
        else
        begin
            lInstantCodeField := piInstantCodeClass.AddField(viPrivate);
            lInstantCodeField.TypeName := 'acRelationPartnerShip';
            lInstantCodeField.Name := 'f'+lRelation.OriginPropertyName;

            lInstantCodeProperty := piInstantCodeClass.AddProperty(viPublished);
            lInstantCodeProperty.GetterName := 'getPartnerShip';
            lInstantCodeProperty.Name := lRelation.OriginPropertyName;
            lInstantCodeProperty.TypeName := 'acRelationPartnerShip';
        end;
        lInstantCodeProperty.Index := IntToStr(lRelation.OriginPropertyindex);
      end;
    end;
//    piClassTicket := piClassTicket.ParentClassTicket;
//    lsresult := lsresult + piClassTicket.PersitentObjectClassName;
//  end;

  result := lsresult;
end;


function TUtil.GerarClassPreview_CSharp(piClass: IUMLClass): string;

  procedure EscreveAtributoClasse(const piCodigoClasse: PStringWriter; piNomeAtributo, piTipoAtributo: String; piVisibility: Integer);
  begin
      //Escreve atributo       
      case piVisibility of
         acAttributeVisibility.pvPublic    : piCodigoClasse.WriteLine('public ');
         acAttributeVisibility.pvProtected : piCodigoClasse.Write('protected ');
         acAttributeVisibility.pvPrivate   : piCodigoClasse.Write('private ');
         else piCodigoClasse.Write('private ');
      end;
      piCodigoClasse.WriteLine(piTipoAtributo+' f'+piNomeAtributo+';');
      
      //Escreve getter and setter

      piCodigoClasse.WriteLine('public ' + piTipoAtributo+' '+piNomeAtributo);
      piCodigoClasse.WriteLine('{');
      piCodigoClasse.Indent();
      piCodigoClasse.WriteLine('get { return '+' f'+piNomeAtributo+'; }');
      piCodigoClasse.WriteLine('set { f'+piNomeAtributo+' = value; }');
      piCodigoClasse.Outdent();
      piCodigoClasse.WriteLine('}');   
  end;

var
  lsNomeClasse, lsAtributo, lsTipoAttribute, lsNomeUnit: string;
  index: integer;
  lClassTicket: acClassTicket;
  lAttributeTicket: acAttributeTicket;

  lCodigoClasse: PStringWriter;
  lParamsConstrutor: String;
  lRelation: acRelationTicket;
begin
  if not DescendsFrom(piClass, cBASE_PERSISTENT_OBJECT_CLASS) then
    raise Exception.Create(format('Class must descend "%s".',[cBASE_PERSISTENT_OBJECT_CLASS]));

  Result := '';
  lParamsConstrutor := '';
  lsNomeClasse  := piClass.Name;
  lsNomeUnit    := Copy(lsNomeClasse, 1, 2) + 'u' + Copy(lsNomeClasse, 3, Length(lsNomeClasse)-2);
  lClassTicket  := MetaModel.ClassRegisterTicketByName[lsNomeClasse];

  lCodigoClasse := PStringWriter.Create;
  try
    lCodigoClasse.WriteLine('using System;');
    lCodigoClasse.WriteLine('using System.Collections.Generic;');
    lCodigoClasse.WriteLine('using System.Linq;');
    lCodigoClasse.WriteLine('using System.Text;');
    lCodigoClasse.WriteLine('using System.Threading.Tasks;');
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('using acuFramework;');             
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('namespace '+lsNomeUnit);
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();   
    lCodigoClasse.WriteLine('class '+lsNomeClasse+': '+piClass.GetGeneralizationAt(0).Parent.Name+'');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();

    // Percorre atributos da classe
    for index := 0 to lClassTicket.Attributes.Count - 1 do
    begin
        lAttributeTicket := lClassTicket.Attributes.Objects[index] as acAttributeTicket;
        lsAtributo       := lClassTicket.Attributes.Strings[index];
        lsTipoAttribute  := lAttributeTicket.AttributeType;
        lParamsConstrutor:= lParamsConstrutor + lsTipoAttribute + ' pi'+ lsAtributo + ', ';

        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, lAttributeTicket.Visibility);
    end;

    //Escrever RelationsPartnerShips
    for index := 0 to lClassTicket.RelationTicketsIn.Count - 1 do
    begin
      lRelation := (lClassTicket.RelationTicketsIn.Objects[index] as acRelationTicket);
      if (lRelation.DestinationPropertyName <> '') then
      begin                
        //Escreve atributo               
        lsAtributo := lRelation.DestinationPropertyName;
        if lRelation.DestinationMaxMultiplicity > 1
          then lsTipoAttribute := 'acRelationPartnerList'
          else begin
            lsTipoAttribute := 'acRelationPartnerShip';
//            lParamsConstrutor:= lParamsConstrutor + lsTipoAttribute + ' pi'+ lsAtributo + ', ';
          end;
        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, acAttributeVisibility.pvProtected);
      end;
    end;
    for index := 0 to lClassTicket.RelationTicketsOut.Count - 1 do
    begin
      lRelation := (lClassTicket.RelationTicketsOut.Objects[index] as acRelationTicket);
      if (lRelation.OriginPropertyName <> '') then
      begin                                   
        //Escreve atributo
        lsAtributo := lRelation.OriginPropertyName;
        if lRelation.OriginMaxMultiplicity > 1
          then lsTipoAttribute := 'acRelationPartnerList'
          else begin
            lsTipoAttribute := 'acRelationPartnerShip';
//            lParamsConstrutor:= lParamsConstrutor + lsTipoAttribute + ' pi'+ lsAtributo + ', ';
          end;
        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, acAttributeVisibility.pvProtected);
      end;
    end;

    //Escrever mtodos
//    CarregarMetodosNGU(piClass, lInstantCodeClass);
        
    //Escreve construtor
    lCodigoClasse.WriteLine('');
//    lCodigoClasse.WriteLine('public '+lsNomeClasse+'('+ strutils.LeftStr(lParamsConstrutor, Length(lParamsConstrutor)-2) + ')');
    lCodigoClasse.WriteLine('public '+lsNomeClasse+'(acPersistenceSession piSession) : base(piSession)');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();
    //Inicializa atributos no construtor
    {
    for index := 0 to lClassTicket.Attributes.Count - 1 do
    begin
      lsAtributo := lClassTicket.Attributes.Strings[index];
      lCodigoClasse.WriteLine('this.'+lsAtributo + '.Value = null;');
//      lCodigoClasse.WriteLine('this.'+lsAtributo + ' = pi' + lsAtributo + ';');
    end;
    }                             
    //Inicializa relations no construtor
//    for index := 0 to lClassTicket.RelationTicketsIn.Count - 1 do
//    begin
//      lRelation := (lClassTicket.RelationTicketsIn.Objects[index] as acRelationTicket);
//      if (lRelation.DestinationPropertyName <> '') then
//      begin
//        lsAtributo := lRelation.DestinationPropertyName;                  
//        if lRelation.DestinationMaxMultiplicity > 1
//          then lCodigoClasse.WriteLine('this.'+lsAtributo + ' = new List<' + lRelation.DestinationClass.ClassName + '>();')
//          else lCodigoClasse.WriteLine('this.'+lsAtributo + ' = null;');//lCodigoClasse.WriteLine('this.'+lsAtributo + ' = pi' + lsAtributo + ';');
//      end;
//    end;
//    for index := 0 to lClassTicket.RelationTicketsOut.Count - 1 do
//    begin
//      lRelation := (lClassTicket.RelationTicketsOut.Objects[index] as acRelationTicket);
//      if (lRelation.OriginPropertyName <> '') then
//      begin
//        lsAtributo := lRelation.OriginPropertyName;
//        if lRelation.OriginMaxMultiplicity > 1
//          then lCodigoClasse.WriteLine('this.'+lsAtributo + ' = new List<' + lRelation.OriginClass.ClassName + '>();')
//          else lCodigoClasse.WriteLine('this.'+lsAtributo + ' = null;');//lCodigoClasse.WriteLine('this.'+lsAtributo + ' = pi' + lsAtributo + ';');
//      end;
//    end;
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');
    
    lCodigoClasse.WriteLine('');
//    lCodigoClasse.WriteLine('public '+lsNomeClasse+'('+ strutils.LeftStr(lParamsConstrutor, Length(lParamsConstrutor)-2) + ')');
    lCodigoClasse.WriteLine('public '+lsNomeClasse+'(acClassTicket piClassTicket, acPersistenceSession piSession, acOID piOID, acPersistentObjectState piState) ');
    lCodigoClasse.WriteLine('    : base(piClassTicket, piSession, piOID, piState) {  }');


    //Escrever registro da classe
//    lCodigoClasse.WriteLine('');
//    lCodigoClasse.WriteLine('public void RegistraClasse()');
//    lCodigoClasse.WriteLine('{');
//    lCodigoClasse.WriteLine('  acuFramework.__Global.PersistenceManager().RegisterClass( typeof('+lsNomeClasse+') );');
//    lCodigoClasse.WriteLine('}');
//    lCodigoClasse.WriteLine('');

    //Escrever mtodo ToString         
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('public override String ToString()');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();
    lCodigoClasse.WriteLine('return "'+lsNomeClasse+': " + this.IDO.AsString;');
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');
    lCodigoClasse.WriteLine('');
    
    //Fim
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}'); 
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');

    Result := lCodigoClasse.AsString;
  finally
    lCodigoClasse.Free;
  end;
end;

function TUtil.GerarClassPreview_Java(piClass: IUMLClass): string;

  procedure EscreveAtributoClasse(const piCodigoClasse: PStringWriter; piNomeAtributo, piTipoAtributo: String; piVisibility: Integer);
  begin
      //Escreve atributo
      case piVisibility of
         acAttributeVisibility.pvPublic    : piCodigoClasse.WriteLine('public ');
         acAttributeVisibility.pvProtected : piCodigoClasse.Write('protected ');
         acAttributeVisibility.pvPrivate   : piCodigoClasse.Write('private ');
         else piCodigoClasse.Write('private ');
      end;
      piCodigoClasse.WriteLine(piTipoAtributo+' f'+piNomeAtributo+';');
      
      //Escreve getter and setter

      piCodigoClasse.WriteLine('public ' + piTipoAtributo+' get'+piNomeAtributo+'() {');
      piCodigoClasse.Indent();
      piCodigoClasse.WriteLine('return '+' f'+piNomeAtributo+';');
      piCodigoClasse.Outdent();
      piCodigoClasse.WriteLine('}');   
      piCodigoClasse.WriteLine('public void set'+piNomeAtributo+'('+piTipoAtributo+' pi'+piNomeAtributo+') {');
      piCodigoClasse.Indent();
      piCodigoClasse.WriteLine('f'+piNomeAtributo+' = pi'+piNomeAtributo+'; ');
      piCodigoClasse.Outdent();
      piCodigoClasse.WriteLine('}');
  end;

var
  lsNomeClasse, lsAtributo, lsTipoAttribute, lsNomeUnit: string;
  index: integer;
  lClassTicket: acClassTicket;
  lAttributeTicket: acAttributeTicket;

  lCodigoClasse: PStringWriter;
  lParamsConstrutor: String;
  lRelation: acRelationTicket;
begin
  if not DescendsFrom(piClass, cBASE_PERSISTENT_OBJECT_CLASS) then
    raise Exception.Create(format('Class must descend "%s".',[cBASE_PERSISTENT_OBJECT_CLASS]));

  Result := '';
  lParamsConstrutor := '';
  lsNomeClasse  := piClass.Name;
  lsNomeUnit    := Copy(lsNomeClasse, 1, 2) + 'u' + Copy(lsNomeClasse, 3, Length(lsNomeClasse)-2);
  lClassTicket  := MetaModel.ClassRegisterTicketByName[lsNomeClasse];

  lCodigoClasse := PStringWriter.Create;
  try
    lCodigoClasse.WriteLine('import acuframework.*;');
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('');
//    lCodigoClasse.WriteLine('namespace '+lsNomeUnit);
//    lCodigoClasse.WriteLine('{');
//    lCodigoClasse.Indent();
    lCodigoClasse.WriteLine('public class '+lsNomeClasse+' extends '+piClass.GetGeneralizationAt(0).Parent.Name+'');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();

    // Percorre atributos da classe
    for index := 0 to lClassTicket.Attributes.Count - 1 do
    begin
        lAttributeTicket := lClassTicket.Attributes.Objects[index] as acAttributeTicket;
        lsAtributo       := lClassTicket.Attributes.Strings[index];
        lsTipoAttribute  := lAttributeTicket.AttributeType;
        lParamsConstrutor:= lParamsConstrutor + lsTipoAttribute + ' pi'+ lsAtributo + ', ';

        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, lAttributeTicket.Visibility);
    end;

    //Escrever RelationsPartnerShips
    for index := 0 to lClassTicket.RelationTicketsIn.Count - 1 do
    begin
      lRelation := (lClassTicket.RelationTicketsIn.Objects[index] as acRelationTicket);
      if (lRelation.DestinationPropertyName <> '') then
      begin                
        //Escreve atributo               
        lsAtributo := lRelation.DestinationPropertyName;
        if lRelation.DestinationMaxMultiplicity > 1
          then lsTipoAttribute := 'acRelationPartnerList'
          else begin
            lsTipoAttribute := 'acRelationPartnerShip';
          end;
        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, acAttributeVisibility.pvProtected);
      end;
    end;
    for index := 0 to lClassTicket.RelationTicketsOut.Count - 1 do
    begin
      lRelation := (lClassTicket.RelationTicketsOut.Objects[index] as acRelationTicket);
      if (lRelation.OriginPropertyName <> '') then
      begin                                   
        //Escreve atributo
        lsAtributo := lRelation.OriginPropertyName;
        if lRelation.OriginMaxMultiplicity > 1
          then lsTipoAttribute := 'acRelationPartnerList'
          else begin
            lsTipoAttribute := 'acRelationPartnerShip';
          end;
        EscreveAtributoClasse(lCodigoClasse, lsAtributo, lsTipoAttribute, acAttributeVisibility.pvProtected);
      end;
    end;

    //Escrever mtodos
    //Escreve construtor
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('public '+lsNomeClasse+'(acPersistenceSession piSession) {');
    lCodigoClasse.Indent();
    lCodigoClasse.WriteLine('super(piSession);');
    //Inicializa atributos no construtor
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');
    
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('public '+lsNomeClasse+'(acClassTicket piClassTicket, acPersistenceSession piSession, acOID piOID, acPersistentObjectState piState) {');
    lCodigoClasse.WriteLine('  super(piClassTicket, piSession, piOID, piState);');
    lCodigoClasse.WriteLine('}');


    //Escrever registro da classe
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('static public void registraClasse()');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.WriteLine('  acuframework.__Global.PersistenceManager().RegisterClass( '+lsNomeClasse+'.class );');
    lCodigoClasse.WriteLine('}');
    lCodigoClasse.WriteLine('');

    //Escrever mtodo ToString         
    lCodigoClasse.WriteLine('');
    lCodigoClasse.WriteLine('public String toString()');
    lCodigoClasse.WriteLine('{');
    lCodigoClasse.Indent();
    lCodigoClasse.WriteLine('return "'+lsNomeClasse+': " + this.getIDO().getAsString();');
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');
    lCodigoClasse.WriteLine('');
    
    //Fim
    lCodigoClasse.Outdent();
    lCodigoClasse.WriteLine('}');

    Result := lCodigoClasse.AsString;
  finally
    lCodigoClasse.Free;
  end;
end;

function TUtil.GerarClassPreview_Pascal(piClass : IUMLClass): string;
var
  lsNomeClasse, lsAtributo, lsTipoAttribute, lsNomeUnit: string;
  index: integer;
  lClassTicket: acClassTicket;
  lInstantCodeModule: TInstantCodeModule;
  lInstantCodeProject: TInstantCodeProject;
  lInstantCodeClass: TInstantCodeClass;
  lInstantCodeField: TInstantCodeField;
  lAttributeTicket: acAttributeTicket;
  lInstantCodeProperty: TInstantCodeProperty;

begin
  lInstantCodeClass := nil;

  if not DescendsFrom(piClass, cBASE_PERSISTENT_OBJECT_CLASS) then
    raise Exception.Create(format('Class must descend "%s".',[cBASE_PERSISTENT_OBJECT_CLASS]));

  lsNomeClasse := piClass.Name;
  lsNomeUnit := Copy(lsNomeClasse, 1, 2) + 'u' + Copy(lsNomeClasse, 3, Length(lsNomeClasse)-2);

  lClassTicket := MetaModel.ClassRegisterTicketByName[lsNomeClasse];

  lInstantCodeProject := TInstantCodeProject.Create;
  // Cria UNIT
  lInstantCodeModule := TInstantCodeModule.Create(lInstantCodeProject);

  lInstantCodeModule.Name := lsNomeUnit;

  if (trim(piClass.GetGeneralizationAt(0).Parent.Name) = '') then
      raise Exception.Create('Esta classe deve possuir generalizao')
  else
  begin
    if not SameText(piClass.GetGeneralizationAt(0).Parent.Name, cBASE_PERSISTENT_OBJECT_CLASS) then
      lInstantCodeModule.InterfaceSection.AddUses.Name := 'acuframework, ' +
                                                           Copy(piClass.GetGeneralizationAt(0).Parent.Name, 1, 2) + 'u' +
                                                           Copy(piClass.GetGeneralizationAt(0).Parent.Name, 3,
                                                                Length(piClass.GetGeneralizationAt(0).Parent.Name)-2)
    else
      lInstantCodeModule.InterfaceSection.AddUses.Name := 'acuframework';    

    lInstantCodeClass := lInstantCodeModule.InterfaceSection.AddClass(lInstantCodeClass);
    lInstantCodeClass.Name := lsNomeClasse;
  //          lInstantCodeClass.BaseClassName := cBASE_PERSISTENT_OBJECT_CLASS;

    lInstantCodeClass.BaseClassName := piClass.GetGeneralizationAt(0).Parent.Name;

    // Section interface




    // Percorre atributos da classe
    for index := 0 to lClassTicket.Attributes.Count - 1 do
    begin
        lAttributeTicket := lClassTicket.Attributes.Objects[index] as acAttributeTicket;
        lsAtributo := lClassTicket.Attributes.Strings[index];
        lsTipoAttribute := lAttributeTicket.AttributeType;

//        case lAttributeTicket.Visibility of
//           acAttributeVisibility.pvPublic : lInstantCodeField := lInstantCodeClass.AddField(viPublic);
//           acAttributeVisibility.pvProtected : lInstantCodeField := lInstantCodeClass.AddField(viProtected);
//           acAttributeVisibility.pvPrivate : lInstantCodeField := lInstantCodeClass.AddField(viPrivate);
//        else lInstantCodeField := lInstantCodeClass.AddField(viPrivate);
//        end;

        lInstantCodeProperty := lInstantCodeClass.AddProperty(viPublished);
        lInstantCodeProperty.Index := IntToStr(lAttributeTicket.AttributeIndex);
        lInstantCodeProperty.GetterName := 'get'+copy(lAttributeTicket.AttributeType,3,Length(lAttributeTicket.AttributeType) - 2);
        lInstantCodeProperty.Name := lsAtributo;
        lInstantCodeProperty.TypeName := lsTipoAttribute;
    end;

    // Mtodos
//            lsPrjFileName := pStarUMLApp.ProjectManager.FileName;
//            lPos := Pos('\mdl\', lsPrjFileName);
//            lsPrjPathName := copy(lsPrjFileName, 1, lPos-1);
//
//
//            lPos := Pos(lsNomeClasse, piClass.Pathname);
//            lsNomePacote := copy(piClass.Pathname, 1, lPos-3);
//
//            lElement := pStarUMLApp.FindByPathname(lsNomePacote);
//            if (lElement <> nil) and (lElement.GetClassName = 'UMLPackage') then
//            begin
//              lPackage := lElement as IUMLPackage;
//              lsNomePacote := lPackage.Name;
//
//              lsPasPath := lsPrjPathName + '\' + lowercase(lsNomePacote) + '\src\ngu\' + lsNomeUnit + '.pas';
//
      CarregarMetodosNGU(piClass, lInstantCodeClass);

      GerarRelationsPartnerShips(lClassTicket, lInstantCodeClass);

      lInstantCodeModule.ImplementationSection.Clear;
      lInstantCodeModule.InitializationSection.CodeText := '// PersistenceManager.RegisterClass(TypeOf('+lsNomeClasse+'));';

      result := lInstantCodeModule.AsString;
//            end
//            else result := 'A classe deve estar dentro de um pacote.';
  end;
end;

function TUtil.GerarFullSQLPreview(piDBVendor: TDataBaseVendor): string;
var
     ///////////
     lEnumClass, lEnumRelation: acEnumerator;
     lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;
     lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
     lClassTicket: acClassTicket;
     lAux: string;
begin
   Result := format('-- SCRIPT CREATION DATE/TIME %s', [FormatDateTime('dd/mm/yyyy @ hhnn',now)]) + #13#10#13#10;

   lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

   if piDBVendor in [dbvSQLServer, dbvOracle] then
   begin
     if piDBVendor = dbvOracle then Result := Concat(Result, #13#10#13#10, 'begin');

     // 1. DROP CONTRAINTS (DBASSOCIATIONMAP)/////////////////////////////////////////////////////
     Result := Concat(Result, #13#10#13#10, '--DROP CONSTRAINTS AND INDEXES FROM DBASSOCIATIONMAP (RELATIONS)');
     lEnumRelation := lMetaModelPersistenceMapSQL.RelationsToDBMapTicketsEnumerator;
     try
       while not lEnumRelation.EOL do
       begin
         lRelationSQLPersistenceMapTicket := acRelationSQLPersistenceMapTicket(lEnumRelation.Current);
         if lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket then
         begin
           Result := Concat(Result, #13#10#13#10);
           Result := concat(Result, SQLScriptDropIndirectTableForeignKeys(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
         end;
         lEnumRelation.MoveNext;
       end;
     finally
       lEnumRelation.Free;
     end;

     // 2. DROP CONTRAINTS (DBACLASSMAP)//////////////////////////////////////////////////////////
     Result := Concat(Result, #13#10#13#10, '--DROP CONSTRAINTS AND INDEXES FROM DBACLASSMAP');
     lEnumClass := MetaModel.ClassTickets.GetEnumerator;
     try
       while not lEnumClass.EOL do
       begin
         lClassTicket := acClassTicket(lEnumClass.Current);
         lAux := SQLScriptDropDirectTableForeignKeys(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassTicket), piDBVendor);
         if lAux <> '' then
         begin
           Result := Concat(Result, #13#10#13#10);
           Result := concat(Result, lAux);
         end;
         lEnumClass.MoveNext;
       end;

     finally
       lEnumClass.Free;
     end;

     // 3. DROP TABLE (DBASSOCIATIONMAP)//////////////////////////////////////////////////////////
     Result := Concat(Result, #13#10#13#10, '--CREATE TABLES FROM DBASSOCIATIONMAP (RELATIONS)');
     lEnumRelation := lMetaModelPersistenceMapSQL.RelationsToDBMapTicketsEnumerator;
     try
       while not lEnumRelation.EOL do
       begin
         lRelationSQLPersistenceMapTicket := acRelationSQLPersistenceMapTicket(lEnumRelation.Current);
         if lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket then
         begin
           Result := Concat(Result, #13#10#13#10);
           Result := concat(Result, SQLScriptDropIndirectTable(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
         end;
         lEnumRelation.MoveNext;
       end;
     finally
       lEnumRelation.Free;
     end;

     // 4. DROP TABLE (DBCLASSMAP)////////////////////////////////////////////////////////////////
     Result := Concat(Result, '--CREATE TABLES FROM DBCLASSMAP');
     lEnumClass := MetaModel.ClassTickets.GetEnumerator;
     try
       while not lEnumClass.EOL do
       begin
         lClassTicket := acClassTicket(lEnumClass.Current);
         lAux := SQLScriptDropDirectTable(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassTicket), piDBVendor);
         if lAux <> '' then
         begin
           Result := Concat(Result, #13#10#13#10);
           Result := concat(Result, lAux);
         end;
         lEnumClass.MoveNext;
       end;

     finally
       lEnumClass.Free;
     end;
   end;
   
   // 5. CREATE TABLE (DBCLASSMAP)//////////////////////////////////////////////////////////////
   Result := Concat(Result, '--CREATE TABLES FROM DBCLASSMAP');
   lEnumClass := MetaModel.ClassTickets.GetEnumerator;
   try
     while not lEnumClass.EOL do
     begin
       lClassTicket := acClassTicket(lEnumClass.Current);
       lAux := SQLScriptCreateDirectTable(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassTicket), piDBVendor);
       if lAux <> '' then
       begin
         Result := Concat(Result, #13#10#13#10);
         Result := concat(Result, lAux);
       end;
       lEnumClass.MoveNext;
     end;

   finally
     lEnumClass.Free;
   end;

   // 6. CREATE TABLE (DBASSOCIATIONMAP)////////////////////////////////////////////////////////
   Result := Concat(Result, #13#10#13#10, '--CREATE TABLES FROM DBASSOCIATIONMAP (RELATIONS)');
   lEnumRelation := lMetaModelPersistenceMapSQL.RelationsToDBMapTicketsEnumerator;
   try
     while not lEnumRelation.EOL do
     begin
       lRelationSQLPersistenceMapTicket := acRelationSQLPersistenceMapTicket(lEnumRelation.Current);
       if lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket then
       begin
         Result := Concat(Result, #13#10#13#10);
         Result := concat(Result, SQLScriptCreateIndirectTable(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
       end;
       lEnumRelation.MoveNext;
     end;
   finally
     lEnumRelation.Free;
   end;

   // 7. ADD CONSTRAINTS (DBCLASSMAP)///////////////////////////////////////////////////////////
   Result := Concat(Result, #13#10#13#10, '--ADD CONSTRAINTS AND INDEXES FROM DBACLASSMAP');
   lEnumClass := MetaModel.ClassTickets.GetEnumerator;
   try
     while not lEnumClass.EOL do
     begin
       lClassTicket := acClassTicket(lEnumClass.Current);
       lAux := SQLScriptDirectTableForeignKeys(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassTicket), piDBVendor);
       if lAux <> '' then
       begin
         Result := Concat(Result, #13#10#13#10);
         Result := concat(Result, lAux);
       end;
       lEnumClass.MoveNext;
     end;

   finally
     lEnumClass.Free;
   end;

   // 8. ADD CONSTRAINTS (DBASSOCIATIONMAP)/////////////////////////////////////////////////////
   Result := Concat(Result, #13#10#13#10, '--ADD CONSTRAINTS AND INDEXES FROM DBASSOCIATIONMAP (RELATIONS)');
   lEnumRelation := lMetaModelPersistenceMapSQL.RelationsToDBMapTicketsEnumerator;
   try
     while not lEnumRelation.EOL do
     begin
       lRelationSQLPersistenceMapTicket := acRelationSQLPersistenceMapTicket(lEnumRelation.Current);
       if lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket then
       begin
         Result := Concat(Result, #13#10#13#10);
         Result := concat(Result, SQLScriptIndirectTableForeignKeys(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
       end;
       lEnumRelation.MoveNext;
     end;
   finally
     lEnumRelation.Free;
   end;

   if piDBVendor = dbvOracle then Result := Concat(Result, #13#10#13#10, 'end;', #13#10#13#10);   

   Result := Concat(Result, #13#10#13#10, '-- END OF SCRIPT --');
end;

function TUtil.GerarUseCaseServerPreview_Pascal(piParams: TCodeGenParams): string;
var
  lUseCase: acUseCaseTicket;
  lEntryObjectHash: acObjectHash;
  lExitObjectHash: acObjectHash;
  lDoObjectHash: acObjectHash;
  lGuardObjectHash: acObjectHash;
  lEffectObjectHash: acObjectHash;

  lInstantCodeModule: TInstantCodeModule;
  lInstantCodeProject: TInstantCodeProject;
  lInstantCodeClass: TInstantCodeClass;

  procedure AddOverrideMethods;
  var lInstantCodeMethod: TInstantCodeMethod;
      lInstantCodeProc: TInstantCodeProc;
  begin
    lInstantCodeMethod := lInstantCodeClass.AddMethod(viPublic);
    lInstantCodeMethod.Prototype.Name := 'Initialize';
    lInstantCodeMethod.Prototype.Flags := [pfOverride];
    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
    lInstantCodeProc.Name := lInstantCodeClass.Name + '.' + 'Initialize';
    lInstantCodeProc.Body.Text := 'inherited;' + #13#10;
    lInstantCodeMethod.Proc := lInstantCodeProc;

    lInstantCodeMethod := lInstantCodeClass.AddMethod(viPublic);
    lInstantCodeMethod.Prototype.Name := 'Finalize';
    lInstantCodeMethod.Prototype.Flags := [pfOverride];
    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
    lInstantCodeProc.Name := lInstantCodeClass.Name + '.' + 'Finalize';
    lInstantCodeProc.Body.Text := #13#10 + 'inherited;';
    lInstantCodeMethod.Proc := lInstantCodeProc;
  end;

  procedure AddMethod(piMethodName: string);
  var lInstantCodeMethod: TInstantCodeMethod;
      lInstantCodeProc: TInstantCodeProc;
  begin
    lInstantCodeMethod := lInstantCodeClass.AddMethod(viPublished);
    lInstantCodeMethod.Prototype.Name := piMethodName;
    lInstantCodeMethod.Prototype.Parameters.AddParameter('piRequest', 'utRequest', []);
    lInstantCodeMethod.Prototype.Parameters.AddParameter('piTransition', 'utTransition', []);
//    lInstantCodeMethod.Prototype.Parameters.AddParameter('poProcessed', 'boolean', [poVar]);
    lInstantCodeProc := lInstantCodeModule.ImplementationSection.AddProc;
    lInstantCodeProc.Header.Parameters.AddParameter('piRequest', 'utRequest', []);
    lInstantCodeProc.Header.Parameters.AddParameter('piTransition', 'utTransition', []);
//    lInstantCodeProc.Header.Parameters.AddParameter('poProcessed', 'boolean', [poVar]);
    lInstantCodeProc.Name := lInstantCodeClass.Name + '.' + piMethodName;
    lInstantCodeProc.Body.Text := #13#10 + #13#10 + 'piRequest.Processed := True;';
    lInstantCodeMethod.Proc := lInstantCodeProc;
  end;

  procedure ReadStateMachine(piStateMachine: utStateMachine);
  var I: integer;
      lTransitionEnum, lStateEnum: acEnumerator;
      lState: utState;
      lTransition: utTransition;
  begin
    lStateEnum := piStateMachine.GetStatesEnumerator;
    try
      while not lStateEnum.EOL do
      begin
        lState := utState(lStateEnum.Current);

        //No gerar cdigo para o StateMachine bsico
        if piStateMachine.Name <> cBASE_STATE_MACHINE then
        begin
          for i := 0 to lState.EntryActions.Count - 1 do
            if not assigned(lEntryObjectHash.ValueOf(lState.EntryActions[i])) then
            begin
              AddMethod(lState.EntryActions[i]);
              lEntryObjectHash.Add(lState.EntryActions[i], lState);
            end;

          for i := 0 to lState.ExitActions.Count - 1 do
            if not assigned(lExitObjectHash.ValueOf(lState.ExitActions[i])) then
            begin
              AddMethod(lState.ExitActions[i]);
              lExitObjectHash.Add(lState.ExitActions[i], lState);
            end;

          for i := 0 to lState.DoActions.Count - 1 do
            if not assigned(lDoObjectHash.ValueOf(lState.DoActions[i])) then
            begin
              AddMethod(lState.DoActions[i]);
              lDoObjectHash.Add(lState.DoActions[i], lState);
            end;

          lTransitionEnum := lState.GetOutgoingTransitionsEnumerator;
          try
            while not lTransitionEnum.EOL do
            begin
              lTransition := utTransition(lTransitionEnum.Current);

              if lTransition.GuardCondition <> '' then
                if not assigned(lGuardObjectHash.ValueOf(lTransition.GuardCondition)) then
                begin
                  AddMethod(lTransition.GuardCondition);
                  lGuardObjectHash.Add(lTransition.GuardCondition, lTransition);
                end;

              for i := 0 to lTransition.EffectsCount - 1 do
                if not assigned(lEffectObjectHash.ValueOf(lTransition.Effects[i])) then
                begin
                  AddMethod(lTransition.Effects[i]);
                  lEffectObjectHash.Add(lTransition.Effects[i], lTransition);
                end;

              lTransitionEnum.MoveNext;
            end;
          finally
            lTransitionEnum.Free;
          end;
        end;

        if lState is utSubMachineState then
          ReadStateMachine(utSubMachineState(lState).StateMachine);

        lStateEnum.MoveNext;
      end;
    finally
      lStateEnum.Free;
    end;
  end;

begin
//  lDescendFromUCcSecuredUseCase := false;
//  for I := 0 to piUseCase.GetGeneralizationCount - 1 do
//    if SameText(piUseCase.GetGeneralizationAt(i).Parent.Name, 'ucUseCase') then
//    begin
//      lDescendFromUCcSecuredUseCase := true;
//      break;
//    end;
//
//  if not lDescendFromUCcSecuredUseCase then
//    raise Exception.Create('Usecase must descend "ucUseCase".');
//  if not DescendsFrom(piUseCase, 'ucUseCase') then
//    raise Exception.Create('Usecase must descend "ucUseCase".');
//
//  lUseCaseCode := piUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');

  lEntryObjectHash := acObjectHash.Create(127, False);
  lExitObjectHash := acObjectHash.Create(127, False);
  lDoObjectHash := acObjectHash.Create(127, False);
  lGuardObjectHash := acObjectHash.Create(127, False);
  lEffectObjectHash := acObjectHash.Create(127, False);
  try
    lUseCase := MetaModel.UseCaseTickets.ValueOf(TCodeGenParamsUseCase(piParams).UseCaseCode) as acUseCaseTicket;

    lInstantCodeProject := TInstantCodeProject.Create;
    lInstantCodeModule := TInstantCodeModule.Create(lInstantCodeProject);
    lInstantCodeModule.Name := 'ucu' + copy(lUseCase.Name, 3, length(lUseCase.Name) - 2);
    // Section interface
    lInstantCodeModule.InterfaceSection.AddUses.Name := 'utuStateMachine, utuRequest, ucuUseCase';

    lInstantCodeClass := lInstantCodeModule.InterfaceSection.AddClass();
    lInstantCodeClass.Name := lUseCase.Name;

    lInstantCodeClass.BaseClassName := lUseCase.InheritsFromClass;

    lInstantCodeModule.ImplementationSection.AddUses.Name := 'ucuManager';

    AddOverrideMethods;

    ReadStateMachine(lUseCase.StateMachine);

    lInstantCodeModule.InitializationSection.CodeText :=  format('  gucManager.RegisterClass(%s,%s);',[TCodeGenParamsUseCase(piParams).UseCaseCode, lUseCase.Name]);

    result := lInstantCodeModule.AsString;
  finally
    lEntryObjectHash.Free;
    lExitObjectHash.Free;
    lDoObjectHash.Free;
    lGuardObjectHash.Free;
    lEffectObjectHash.Free;
  end;
end;


procedure TUtil.CarregarMetodosNGU(pUMLClass: IUMLClass; pInstantCodeClass: TInstantCodeClass);
var lMetCont, liCont, liCont2, liParCount, liParIndex: integer;
    lsMetName: string;
    lMetodo: TInstantCodeMethod;
    lVisibility: TInstantCodeVisibility;
    lParameter: TInstantCodeParameter;
    lUMLOperation: IUMLOperation;
    lUMLParameter: IUMLParameter;
begin

    lMetCont := pUMLClass.GetOperationCount;

    for liCont := 0 to lMetCont - 1 do
    begin
        lUMLOperation := pUMLClass.GetOperationAt(liCont);
        lsMetName := lUMLOperation.Name;
         case lUMLOperation.Visibility of
         vkPrivate : lVisibility := viPrivate;
         vkProtected : lVisibility := viProtected;
         vkPublic : lVisibility := viPublic;
         else lVisibility := viPublished;
         end;

        lMetodo := pInstantCodeClass.AddMethod(lVisibility);
        lMetodo.Name := lsMetName;

        for liCont2 := 0 to lMetCont - 1 do
        begin
          if liCont2 <> liCont then
          begin
            if pUMLClass.GetOperationAt(liCont2).Name = lsMetName then
            begin
              lMetodo.Prototype.Flags := [pfOverload];
              break;
            end;
          end;
        end;

        // Is abstract
        if lUMLOperation.IsAbstract then
           lMetodo.Prototype.Flags := [pfAbstract];

        // Is Polymorphic
        if sametext(lUMLOperation.GetTaggedValueAsString('DBMappings', 'DBOperationMap', 'IsPolymorphic'), 'True') then
           lMetodo.Prototype.Flags := [pfVirtual];

        // Override
        if sametext(lUMLOperation.GetTaggedValueAsString('DBMappings', 'DBOperationMap', 'Override'), 'True') then
           lMetodo.Prototype.Flags := [pfOverride];

        liParCount := lUMLOperation.GetParameterCount;
        for liParIndex := 0 to liParCount - 1 do
        begin
          lUMLParameter := lUMLOperation.GetParameterAt(liParIndex);
          if lUMLParameter.DirectionKind = pdkReturn then
            lMetodo.Prototype.ResultTypeName := lUMLParameter.TypeExpression
          else
          begin
            lParameter := lMetodo.Prototype.AddParameter;

            lParameter.TypeName := lUMLParameter.TypeExpression;
            lParameter.Name := lUMLParameter.Name;
            case lUMLParameter.DirectionKind of
            pdkIn: lParameter.Options := [poConst];
            pdkInout: lParameter.Options := [poVar];
            pdkOut: lParameter.Options := [poOut];
            else lParameter.Options := [poConst];
            end;

          end;
        end;
    end;

end;


procedure TUtil.ConvertXSDsToUseCaseXSD(piProgress: TFShowProgress);

  function XSDExiste(piXSDFile: utXSDFile; piXSD: string): string;
  var lEnum: acEnumerator;
      lXSD: utXSD;
  begin
    result :='';
    lEnum := piXSDFile.GetXSDEnumerator;
    try
      while not lenum.EOL do
      begin
        lXSD := utXSD(lEnum.current);
        if lXSD.Text = pixsd then
        begin
          result := lXSD.ID;
          break;
        end;
        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  end;

var
  lChildUseCaseCount: integer;
  lUMLChildUseCase: IUMLUseCase;
  lUMLStateMachine: IUMLStateMachine;
  lUMLTopState: IUMLCompositeState;
  lUMLState: IUMLStateVertex;
  lStateCount,lTransitionCount: integer;
  lUseCaseXSD: string;
  lUMLTransition: IUMLTransition;
  lXSDIn, lXSDOut, lTransitionName, lXSDName: string;
  lXSDFile: utXSDFile;
  lXSD: utXSD;
  lRootUseCase: IUMLUseCase;
begin
  lRootUseCase := gStarUMLApp.FindByPathname(MODELO + '::FrameworkModel::acuFrameworkPackage::UCU::ucUseCase') as IUMLUseCase;
  if assigned(piProgress) then piProgress.ChangeMessage('Lendo e convertendo XSD''s de todos os casos de usos...', 0, lRootUseCase.GetSpecializationCount);
  //Varre todos os usecases filho de ucUseCase
  for lChildUseCaseCount := 0 to lRootUseCase.GetSpecializationCount - 1 do
  begin
    lUMLChildUseCase := lRootUseCase.GetSpecializationAt(lChildUseCaseCount).Child as IUMLUseCase;
    if assigned(piProgress) then
    begin
      piProgress.ChangeMessage('Lendo e convertendo XSD''s do casos de uso "' + lUMLChildUseCase.name + '"');
      piProgress.Inc;
    end;

    lUseCaseXSD := lUMLChildUseCase.GetTaggedValueAsString('DBMappings', 'UseCaseMap', 'XSDs');
    if lUseCaseXSD = '' then
    begin
      if not lUMLChildUseCase.IsAbstract then
      begin
        //Retorna a primeira StateMachine
        lUMLStateMachine := lUMLChildUseCase.GetBehaviorAt(0);
        if assigned(lUMLStateMachine) then
        begin
          lUMLTopState := lUMLStateMachine.Top as IUMLCompositeState;

          lXSDFile := utXSDFile.create('');
          try
            for lStateCount := 0 to lUMLTopState.GetSubvertexCount - 1 do
            begin
              lUMLState := lUMLTopState.GetSubvertexAt(lStateCount);
              if lUMLState.GetMetaClass.IsKindOf('UMLState') then
              begin
                for lTransitionCount := 0 to lUMLState.GetOutgoingCount - 1 do
                begin
                  lUMLTransition := lUMLState.GetOutgoingAt(lTransitionCount);
                  lTransitionName := lUMLTransition.GetTriggerAt(0).Name;

                  lXSDIn := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD In');
                  lXSDOut := lUMLTransition.GetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD Out');

                  if lXSDIn <> '' then
                  begin
                    lXSDName := XSDExiste(lXSDFile, lXSDIn);
                    if lXSDName = '' then
                    begin
                      lXSDName := lTransitionName + '_XSDIn';
                      if lXSDFile.XSDExists(lXSDName) then lXSDName := lUMLState.name + lTransitionName + '_XSDIn';
                      lXSD := lXSDFile.NewXSD(lXSDName);
                      lXSD.Text := lXSDIn;
                    end;
                    lUMLTransition.SetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD In',lXSDName)
                  end;

                  if lXSDOut <> '' then
                  begin
                    lXSDName := XSDExiste(lXSDFile, lXSDOut);
                    if lXSDName = '' then
                    begin
                      lXSDName := lTransitionName + '_XSDOut';
                      if lXSDFile.XSDExists(lXSDName) then lXSDName := lUMLState.name + lTransitionName + '_XSDOut';
                      lXSD := lXSDFile.NewXSD(lXSDName);
                      lXSD.Text := lXSDOut;
                    end;
                    lUMLTransition.SetTaggedValueAsString ( 'DBMappings', 'TransitionMap', 'XSD Out',lXSDName)
                  end;
                end;
              end;
            end;
            if lXSDFile.Count > 0 then
              lUMLChildUseCase.SetTaggedValueAsString('DBMappings', 'UseCaseMap', 'XSDs', lXSDFile.XML);
          finally
            lXSDFile.free;
          end;
        end;
      end;
    end;
  end;
end;

function TUtil.GerarSQLPreview(piModelElement: IModel; piDBVendor: TDataBaseVendor = dbvSQLServer): string;
var
     lClass: IUMLClass;
     lAssociation: IUMLAssociation;
     lsNomeClasse, lsNomeTabela, lRelationName: string;
     lsResult: string;

     lClassTicket, lClassOriginTicket, lClassDestTicket: acClassTicket;

     lClassToDBMapTicket: acClassToDBMapTicket;

     lMetaModelPersistenceMapSQL: acMetaModelPersistenceMapSQL;

     lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;

     lRelationTicket: acRelationTicket;

//    liOriginMinCardinalidade,
    liOriginMaxCardinalidade,
//    liDestinationMinCardinalidade,
    liDestinationMaxCardinalidade, lPos: integer;
    lsMin, lsMax: string;
begin

  lMetaModelPersistenceMapSQL := fMetaModelPersistenceMap as acMetaModelPersistenceMapSQL;

  if (piModelElement.GetClassName = 'UMLClass') then
  begin
    lClass := piModelElement as IUMLClass;

    lsNomeClasse := lClass.Name;

    lsNomeTabela := Uppercase(Copy(lsNomeClasse, 0, 2)) + 'U' + Copy(lsNomeClasse, 3, Length(lsNomeClasse)-2);

    lClassTicket := MetaModel.ClassRegisterTicketByName[lsNomeClasse];
    lClassToDBMapTicket := lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassTicket);

    lsResult := concat(lsResult, SQLScriptCreateDirectTable(lClassToDBMapTicket, piDBVendor));

    lsResult := Concat(lsResult, #13#10#13#10);

    lsResult := Concat(lsResult, SQLScriptDirectTableForeignKeys(lClassToDBMapTicket, piDBVendor));
  end
  else
    if (piModelElement.GetClassName = 'UMLAssociation') then
    begin
      lAssociation := piModelElement as IUMLAssociation;


      (lAssociation.GetConnectionAt(1).Get_Participant as IUMLClass).Name;

      lClassOriginTicket := MetaModel.ClassRegisterTicketByName[((lAssociation.GetConnectionAt(0).Get_Participant as IUMLClass).Name)];
      lClassDestTicket := MetaModel.ClassRegisterTicketByName[((lAssociation.GetConnectionAt(1).Get_Participant as IUMLClass).Name)];


      if (lAssociation.GetConnectionAt(1).Get_Multiplicity = '1') then
      begin
//        liOriginMinCardinalidade := 1;
        liOriginMaxCardinalidade := 1;
      end
      else
        if (lAssociation.GetConnectionAt(1).Get_Multiplicity = '*') then
        begin
//          liOriginMinCardinalidade := 0;
          liOriginMaxCardinalidade := N;
        end
        else
        begin
          lPos := Pos('..', lAssociation.GetConnectionAt(1).Get_Multiplicity);
          lsMin := copy(lAssociation.GetConnectionAt(1).Get_Multiplicity, 1, lPos-1);
          lsMax := copy(lAssociation.GetConnectionAt(1).Get_Multiplicity, lPos + 2, length(lAssociation.GetConnectionAt(1).Get_Multiplicity) - (lPos + 1));
//          liOriginMinCardinalidade := strtoint(lsMin);
          if (uppercase(lsMax) = 'N') or (lsMax = '*') then
            liOriginMaxCardinalidade := N
          else
            liOriginMaxCardinalidade := strtoint(lsMax);
        end;

      if (lAssociation.GetConnectionAt(0).Get_Multiplicity = '1') then
      begin
//        liDestinationMinCardinalidade := 1;
        liDestinationMaxCardinalidade := 1;
      end
      else
        if (lAssociation.GetConnectionAt(0).Get_Multiplicity = '*') then
        begin
//          liDestinationMinCardinalidade := 0;
          liDestinationMaxCardinalidade := N;
        end
        else
        begin
          lPos := Pos('..', lAssociation.GetConnectionAt(0).Get_Multiplicity);
          lsMin := copy(lAssociation.GetConnectionAt(0).Get_Multiplicity, 1, lPos-1);
          lsMax := copy(lAssociation.GetConnectionAt(0).Get_Multiplicity, lPos + 2, length(lAssociation.GetConnectionAt(0).Get_Multiplicity) - (lPos + 1));
//          liDestinationMinCardinalidade := strtoint(lsMin);
          if (uppercase(lsMax) = 'N') or (lsMax = '*') then
            liDestinationMaxCardinalidade := N
          else
            liDestinationMaxCardinalidade := strtoint(lsMax);
        end;


      if ((liOriginMaxCardinalidade = 1) and (liDestinationMaxCardinalidade = N)) then
        lRelationName := lClassDestTicket.PersistentObjectClassName + ' ' + lAssociation.Name + ' ' + lClassOriginTicket.PersistentObjectClassName
      else
        lRelationName := lClassOriginTicket.PersistentObjectClassName + ' ' + lAssociation.Name + ' ' + lClassDestTicket.PersistentObjectClassName;

      lRelationTicket :=  MetaModel.RelationTickets.ValueOf(lRelationName) as acRelationTicket;

      lRelationSQLPersistenceMapTicket := lMetaModelPersistenceMapSQL.GetRelationsSQLPersistenceMapTicket(lRelationTicket);

      if not (lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket) then
        Raise Exception.Create('The relation must be an indirect relation to preview.')
      else
      begin
        lsResult := concat(lsResult, SQLScriptCreateDirectTable(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassOriginTicket), piDBVendor));
        lsResult := Concat(lsResult, #13#10#13#10);
        lsResult := concat(lsResult, SQLScriptCreateDirectTable(lMetaModelPersistenceMapSQL.GetClassToDBMapTicket(lClassDestTicket), piDBVendor));
        lsResult := Concat(lsResult, #13#10#13#10);
        lsResult := concat(lsResult, SQLScriptCreateIndirectTable(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
        lsResult := Concat(lsResult, #13#10#13#10);
        lsResult := concat(lsResult, SQLScriptIndirectTableForeignKeys(lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket, piDBVendor));
      end;
    end;

  result := lsResult;
end;


procedure TUtil.Reversa(psNomePacote, psPrjPath, psSTARUMLprj: string);
var lEnum: acEnumerator;
    lStarUMLApp: IStarUMLApplication;
    lClassTicket, lPatriarca: acClassTicket;
    lPrjManager: IProjectManager;
    lPrj: IUMLProject;
    lFactory: IUMLFactory;
    lModel, lModelBase: IUMLModel;
    lElement: IElement;
    lPackage, lCommonPack: IUMLPackage;
    lClass, lClassePersistentObject: IUMLClass;
    lRelationHash: acObjectHash;
    lIMetaModel: IMetaModel;
    lExtensionManager: IExtensionManager;
    lbCriouNovaClasse: boolean;
    lPackageUnit: IUMLUnitDocument;
    Tela : TFShowProgress;
    lMetaModel: acMetaModel;
begin
   try
      Tela := TFShowProgressForm.create('Carregando o StarUML...', 1, 100);
      // Criao de aplicao STARUML
//      lStarUMLApp := StarUML_TLB.CoStarUMLApplication.Create;
      // Obtm Gerenciador de Projeto do STARUML
      lPrjManager := lStarUMLApp.Get_ProjectManager;
      // Obtm gerenciador de mecanismos de estenso
      lExtensionManager := lStarUMLApp.ExtensionManager;
      lPrjManager.OpenProject(psSTARUMLprj);
      // Obtm projeto do STARUML onde sero inseridos os elementos UML
      lPrj := lPrjManager.Get_Project;

      // Fbrica responsvel por criar novos elementos UML
      lFactory := lStarUMLApp.UMLFactory;
      Tela.Inc(5);
      lElement := lStarUMLApp.FindByPathname(MODELO);
      lModelBase := lElement as IUMLModel;
      if (lModelBase = nil) then
      begin
        lModelBase := lFactory.CreateModel(lPrj);
        lModelBase.Name := MODELO_NAME;
      end;

        lElement := lStarUMLApp.FindByPathname(MODELO+'::Common');
        lCommonPack := lElement as IUMLPackage;
        if (lCommonPack = nil) then
        begin
          lCommonPack := lFactory.CreatePackage(lModelBase);
          lCommonPack.Name := 'Common';
          lPackageUnit := lPrjManager.SeparateUnit(lCommonPack, psPrjPath+ 'Commonx.unt');
        end;

      if (psNomePacote = 'siscon') then
      begin
          lElement := lStarUMLApp.FindByPathname(MODELO_SISCON);
          lModel := lElement as IUMLModel;
          if (lModel = nil) then
          begin
            lModel := lFactory.CreateModel(lModelBase);
            lModel.Name := MODELO_SISCON_NAME;
            lPackageUnit := lPrjManager.SeparateUnit(lModel, psPrjPath + psNomePacote+'.unt');
          end;
          lPackage := lModel as IUMLPackage;
      end
      else begin
          lElement := lStarUMLApp.FindByPathname(MODELO_SGIES);
          lModel := lElement as IUMLModel;
          if (lModel = nil) then
          begin
            lModel := lFactory.CreateModel(lModelBase);
            lModel.Name := MODELO_SGIES_NAME;
          end;
          lElement := lStarUMLApp.FindByPathname(MODELO_SGIES+'::'+psNomePacote);
          lPackage := lElement as IUMLPackage;
          if (lPackage = nil) then
          begin
            lPackage := lFactory.CreatePackage(lModel);
            lPackage.Name := psNomePacote;
            lPackageUnit := lPrjManager.SeparateUnit(lPackage, psPrjPath + psNomePacote+'.unt');
          end;
      end;

      // Meta Modelo do Star UML
      lIMetaModel := lStarUMLApp.MetaModel;


      lElement := lStarUMLApp.FindByPathname(MODELO + '::FrameworkModel::acuFrameworkPackage::' + cBASE_PERSISTENT_OBJECT_CLASS);
      lClassePersistentObject := lElement as IUMLClass;

      Tela.Inc(5);
      Tela.ChangeMessage('Gerando Classes...');

      // Obtm todos os ClassTickets da UNIT
      lEnum := MetaModel.ClassTickets.GetEnumerator;
      try
      // Visita todos os ClassTickets da UNIT
        while not lEnum.EOL do
        begin
          lClassTicket := acClassTicket(lEnum.Current);
          lPatriarca := lClassTicket.PatriarcClassTicket;

          // Verifica se  classe patriarca
          if (lPatriarca.PersistentObjectClassName = lClassTicket.PersistentObjectClassName) then
            begin
              // Criao de elemento UML Classe
              lbCriouNovaClasse := CriarUMLClass(lStarUMLApp, lClassTicket, lPackage, lClass);

              if (lbCriouNovaClasse) then
              begin
                  // Criao de UML Generalization
                  lFactory.CreateGeneralization(lModel, lClassePersistentObject, lClass);

              end;
              // A rvore de cada classe patriarca  criada
              CriarArvore(lStarUMLApp, lClass, lPackage, lClassTicket);
            end;

          lEnum.MoveNext;
        end;
      finally
        lEnum.Free;
      end;
      Tela.Inc(50);
      // Obtm Associaes
      lRelationHash := MetaModel.RelationTickets;

      // A partir da lista de tickets de associao, UML Associations so criadas
      Tela.ChangeMessage('Gerando Associaes...');
      CriarUMLAssociations(lStarUMLApp, lRelationHash, lModel, lPackage);
      Tela.Inc(35);
      lPrjManager.SaveProject;
      lPrjManager.SaveAllUnits;
      lPrjManager.CloseProject;
      Tela.Inc(5);
      Tela.Free;
   except
   end;
end;

function TUtil.BuscaClasseModelo(poPackage: IUMLPackage; piClassName: string; var pbAchou: boolean) : IUMLClass;
var lModelElement: IUMLModelElement;
    lClass: IUMLClass;
    lPackage: IUMLPackage;
    lindex, lnumElem: integer;
    s:String;
begin
      lnumElem := poPackage.GetOwnedElementCount;
      lindex := 0;
      while (lindex < lnumElem) and (not pbAchou) do
      begin
        lModelElement := poPackage.GetOwnedElementAt(lindex);
        s := poPackage.Name;
        s := lModelElement.Name;
        s := lModelElement.GetClassName;

        if (lModelElement.GetClassName = 'UMLPackage') or (lModelElement.GetClassName = 'UMLModel') then
        begin
           lPackage := lModelElement as IUMLPackage;

           lClass := BuscaClasseModelo(lPackage, piClassName, pbAchou);
        end
        else begin
          if (lModelElement.GetClassName = 'UMLClass') then
          begin
            lClass := lModelElement as IUMLClass;

            if (lClass.Name = piClassName) then
              pbAchou := true;
          end;
        end;
        lindex := lindex + 1;
      end;

      if pbAchou then
        result := lClass
      else
        result := nil;
end;

function TUtil.CriarUMLClass(pIStarUMLApp: IStarUMLApplication; pClassTicket: acClassTicket; pUMLPackage: IUMLPackage; var piUMLClass: IUMLClass): boolean;
var lIElement: IElement;
    lModel: IUMLPackage;
    lClassToDBMapTicket: acClassToDBMapTicket;
//    Stream: TFileStream;
    lbAchou: boolean;
    lInstantCodeModule: TInstantCodeModule;
begin
      lIElement := pIStarUMLApp.FindByPathname(MODELO);
      lModel := lIElement as IUMLPackage;
      lbAchou := false;
      piUMLClass := BuscaClasseModelo(lModel, pClassTicket.PersistentObjectClassName, lbAchou);
//     lIElement := pIStarUMLApp.FindByPathname('::'+MODELO+'::'+pUMLPackage.Name+'::'+pClassTicket.PersitentObjectClassName);

     if (piUMLClass = nil) then
     begin
       // Criao de elemento UML Classe

       piUMLClass := pIStarUMLApp.UMLFactory.CreateClass(pUMLPackage);
//       piUMLClass.Name := pClassTicket.ObjectClass.ClassName;
       piUMLClass.Name := pClassTicket.PersistentObjectClassName;
       lClassToDBMapTicket := fMetaModelPersistenceMap.GetClassToDBMapTicket(pClassTicket);

       // Nome da tabela - valor atribudo
       piUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table', lClassToDBMapTicket.TableName);

       // Coluna IDO na tabela - valor atribudo
       piUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO', lClassToDBMapTicket.IdoDBMapTicket.GetIDOColumns);

       // IDO CODE da classe - valor atribudo
       piUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod', pClassTicket.PersistentObjectClassCode);

       // Type Column Name da classe - valor atribudo
       piUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Type', lClassToDBMapTicket.TypeColumnName);

       // Preenche UML Class com seus atributos
//       CriarUMLAttributes(pClassTicket, piUMLClass, pIStarUMLApp.UMLFactory);

       result := true;
     end
     else
     begin
        lInstantCodeModule := TInstantCodeModule.Create(nil);
        lInstantCodeModule.Name := 'arqRepetidos';
        lInstantCodeModule.InterfaceSection.AddUses.Name := piUMLClass.Name;
        lInstantCodeModule.SaveToFile('C:\bruno\Rept'+piUMLClass.Name+'.txt');

//        lIElement := pIStarUMLApp.FindByPathname(MODELO+'::Common');
//        lCommonPack := lIElement as IUMLPackage;
//        piUMLClass.RelocateTo(lCommonPack);

        result := false;
     end;

end;
{
procedure TUtil.CriarUMLAttributes(piClassTicket: acClassTicket; piUMLClass: IUMLClass; piFactory: IUMLFactory);
var lindex, lNullable, llength, lprec, lscale: Integer;
    lbVariable: boolean;
    lAttribute: IUMLAttribute;
    lsAttribute, lsTipoAttribute, lsDBTableName, lsDBTypeAttribute: String;
    lClassToDBMapTicket: acClassToDBMapTicket;
    lAttributeTicket: acAttributeTicket;
    lAttributeVisibility: acAttributeVisibility;
    qryUtil: TQuery;
begin

//        ISQLMetaData.
        qryUtil := TQuery.Create(nil);
        qryUtil.DatabaseName := 'dbSGIES';

        // Obtm classe responsvel por mapeamento OO-DB
        lClassToDBMapTicket := (MetaModel.DefaultMetaModelPersistenceMap as acMetaModelPersistenceMapSQL).GetClassToDBMapTicket(piClassTicket);

        lsDBTableName := lClassToDBMapTicket.TableName;

        qryUtil.SQL.Text := 'select sysobjects.name as tablename,' +#13#10+
                            ' syscolumns.name as columnname,' +#13#10+
                            ' syscolumns.length,' +#13#10+
                            ' syscolumns.xprec,' +#13#10+
                            ' syscolumns.xscale,' +#13#10+
                            ' syscolumns.isnullable,' +#13#10+
                            ' systypes.name as typename,' +#13#10+
                            ' systypes.variable as variable' +#13#10+
                            'from sysobjects, syscolumns, systypes' +#13#10+
                            'where sysobjects.id = syscolumns.id' +#13#10+
                            'and syscolumns.xtype = systypes.xtype' +#13#10+
                            'and sysobjects.type = ''U''' +#13#10+
                            'and sysobjects.name = '''+lsDBTableName+'''' +#13#10+
                            'and syscolumns.name = :column_name';

        //Preenche a Classe UML criada com seus atributos
        for lindex := 0 to (piClassTicket.Attributes.Count - 1) do
        begin
             lsAttribute := piClassTicket.Attributes.Strings[lindex];
             lAttributeTicket := piClassTicket.Attributes.Objects[lindex] as acAttributeTicket;
             lAttribute := piFactory.CreateAttribute(piUMLClass);
             lAttribute.Name := lsAttribute;
             // Obtm a string do tipo do atributo situado em ObjectClass de ClassTicket
             lsTipoAttribute := piClassTicket.ObjectClass.GetPropType(lsAttribute).ClassName;
//***             lsTipoAttribute := lPropertyRegisterTicket.Tipo;
             lAttributeVisibility := lAttributeTicket.Visibility;
             // Atribui a string do tipo do atributo ao UML Atributo
             lAttribute.SetType2(lsTipoAttribute);
             case lAttributeVisibility of
             pvPublic : lAttribute.Visibility := vkPublic;
             pvProtected : lAttribute.Visibility := vkProtected;
             pvPrivate : lAttribute.Visibility := vkPrivate;
             else lAttribute.Visibility := vkPrivate;
             end;
             // Seta nome da coluna do BD como valor atribudo
             lAttribute.SetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name', lClassToDBMapTicket.ColumnTicket[lindex].ColumnName);

             qryUtil.ParamByName('column_name').AsString := lClassToDBMapTicket.ColumnTicket[lindex].ColumnName;
             qryUtil.Open;
             if not qryUtil.IsEmpty then
             begin
               lNullable := qryUtil.FieldByName('isnullable').AsInteger;
               if lNullable = 1 then
                   lAttribute.SetTaggedValueAsBoolean('DBMappings', 'DBAttributeMap', 'Mand', true)
               else lAttribute.SetTaggedValueAsBoolean('DBMappings', 'DBAttributeMap', 'Mand', false);
               llength := qryUtil.FieldByName('length').AsInteger;
               lprec := qryUtil.FieldByName('xprec').AsInteger;
               lscale := qryUtil.FieldByName('xscale').AsInteger;
               lbVariable := qryUtil.FieldByName('variable').AsBoolean;
               if lprec <> 0 then
               begin
                   lAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'FSize', lprec);
                   lAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'VSize', lscale)
               end else
               begin
                   if lbVariable then
                       lAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'VSize', llength)
                   else lAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'FSize', llength);
               end;
               lsDBTypeAttribute := qryUtil.FieldByName('typename').AsString;
               lAttribute.SetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Type', lsDBTypeAttribute);
             end;
             qryUtil.Close;
        end;
end;
}
// Procedure responsvel por criar a estrutura de rvore de todo modelo (cria generalizaes e UML classes envolvidas)
procedure TUtil.CriarArvore(piIStarUMLApp: IStarUMLApplication; piUMLClass: IUMLClass; piUMLPackage: IUMLPackage; piClassTicket: acClassTicket);
var lDescendetesList: acObjectList;
    lDescendente: acClassTicket;
    index: Integer;
    lUMLDescendente: IUMLClass;
    lUMLGeneralizacao: IUMLGeneralization;
    lbCriouNovaClasse: boolean;
begin
    // Ponto de parada da recurso
    // S classes com descendentes podem originar rvores
    if piClassTicket.HasDescendants then
    begin
        // Busca ClassTickets descendentes
        lDescendetesList := piClassTicket.DirectDescendants;
        for index := 0 to lDescendetesList.Count - 1 do
        begin
            lDescendente :=  acClassTicket(lDescendetesList.Items[index]);
            // Criaao de UML Class descendente
            lbCriouNovaClasse := CriarUMLClass(piIStarUMLApp, lDescendente, piUMLPackage, lUMLDescendente);

            if (lbCriouNovaClasse) then
            begin
              // Criao de UML Generalization
              lUMLGeneralizacao := piIStarUMLApp.UMLFactory.CreateGeneralization(piUMLPackage, piUMLClass, lUMLDescendente);
            end;

            // Recursso
            CriarArvore(piIStarUMLApp, lUMLDescendente, piUMLPackage, lDescendente);
        end;
    end;
end;

function TUtil.ExisteAssociacao(piRelationTicket: acRelationTicket; piUMLClassOrigem, piUMLClassDestino: IUMLClass): boolean;
var lNumAssoc, index: integer;
    lbAchou: boolean;
    lUMLAssociation: IUMLAssociation;
    lAssociationEndOr, lAssociationEndDest: IUMLAssociationEnd;
    lsNomePropOr, lsNomePropDest, lsParticipantOr, lsParticipantDest: string;
begin

  lNumAssoc := piUMLClassOrigem.GetAssociationCount;
  index := 0;
  lbAchou := false;

  while (index < lNumAssoc) and (not lbAchou) do
  begin
      lUMLAssociation := piUMLClassOrigem.GetAssociationAt(index).Association;

      lAssociationEndOr := lUMLAssociation.GetConnectionAt(0);
      lAssociationEndDest := lUMLAssociation.GetConnectionAt(1);
      lsNomePropOr := lAssociationEndOr.Name;
      lsNomePropDest := lAssociationEndDest.Name;
      lsParticipantOr := lAssociationEndOr.Participant.Name;
      lsParticipantDest := lAssociationEndDest.Participant.Name;

      if (lsParticipantOr = piUMLClassOrigem.Name) and (lsParticipantDest = piUMLClassDestino.Name) and (piRelationTicket.OriginPropertyName = lsNomePropOr) and (piRelationTicket.DestinationPropertyName = lsNomePropDest) then
        lbAchou := true;
      inc(index);
  end;

  result := lbAchou;
end;


procedure TUtil.CriarUMLAssociations(piIStarUMLApp: IStarUMLApplication; piRelationHash: acObjectHash; piModel: IUMLModel; piPackage: IUMLPackage);
var lEnumRelation: acEnumerator;
    lRelationTicket: acRelationTicket;
    lClassOrigem, lClassDestino: acClassTicket;
    lIElement: IElement;
    lMultiplicity, lsNomeTabelaAssociativa, lsNomeFKA, lsNomeFKB: String;
    lAssociation: IUMLAssociation;
    lAssociationEndOr, lAssociationEndDest: IUMLAssociationEnd;
    lUMLClassOrigem, lUMLClassDestino: IUMLClass;
    lRelationSQLPersistenceMapTicket: acRelationSQLPersistenceMapTicket;
    lModel: IUMLModel;
    lbAchou: boolean;
begin
    lEnumRelation := piRelationHash.GetEnumerator;
    try
      while not lEnumRelation.EOL do
      begin
         lRelationTicket := acRelationTicket(lEnumRelation.Current);
         // Obtm classes origem e destino. No est sendo considerada associaao ternria.
         lClassOrigem := lRelationTicket.OriginClassTicket;
         lClassDestino := lRelationTicket.DestinationClassTicket;

         lIElement := piIStarUMLApp.FindByPathname(MODELO);
         lModel := lIElement as IUMLModel;
         lbAchou := false;
         lUMLClassOrigem := BuscaClasseModelo(lModel, lClassOrigem.PersistentObjectClassName, lbAchou);
//           lsNomeClass := lUMLClassOrigem.Name;
         lbAchou := false;
         lUMLClassDestino := BuscaClasseModelo(lModel, lClassDestino.PersistentObjectClassName, lbAchou);

         if not(ExisteAssociacao(lRelationTicket, lUMLClassOrigem, lUMLClassDestino)) then
         begin
             // Bloco de cdigo responsvel por criar a associaao e seus atributos
             lAssociation := piIStarUMLApp.UMLFactory.CreateAssociation(piPackage, lUMLClassOrigem, lUMLClassDestino);
             lAssociation.Name := lRelationTicket.Name;
             lAssociationEndOr := lAssociation.GetConnectionAt(0);
             lAssociationEndDest := lAssociation.GetConnectionAt(1);
             // Os atributos de navegabilidade so preenchidos
//               lAssociationEndOr.Set_Name(lRelationTicket.OriginPropertyName);
//               lAssociationEndDest.Set_Name(lRelationTicket.DestinationPropertyName);
             lAssociationEndOr.Set_Name(lRelationTicket.DestinationPropertyName);
             lAssociationEndDest.Set_Name(lRelationTicket.OriginPropertyName);

             // As cardinalidades sao preenchidas
             if (lRelationTicket.OriginMinMultiplicity = 1) and (lRelationTicket.OriginMaxMultiplicity = 1) then
                lMultiplicity := '1'
                else if (lRelationTicket.OriginMinMultiplicity = 0) and (lRelationTicket.OriginMaxMultiplicity = N) then
                        lMultiplicity := '*'
                        else if (lRelationTicket.OriginMaxMultiplicity = N) then
                                 lMultiplicity := IntToStr(lRelationTicket.OriginMinMultiplicity) + '..*'
                                 else lMultiplicity := IntToStr(lRelationTicket.OriginMinMultiplicity) + '..' + IntToStr(lRelationTicket.OriginMaxMultiplicity);
//               lAssociationEndOr.Set_Multiplicity(lMultiplicity);
             lAssociationEndDest.Set_Multiplicity(lMultiplicity);

             if (lRelationTicket.DestinationMinMultiplicity = 1) and (lRelationTicket.DestinationMaxMultiplicity = 1) then
                lMultiplicity := '1'
                else if (lRelationTicket.DestinationMinMultiplicity = 0) and (lRelationTicket.DestinationMaxMultiplicity = N) then
                        lMultiplicity := '*'
                        else if (lRelationTicket.DestinationMaxMultiplicity = N) then
                                 lMultiplicity := IntToStr(lRelationTicket.DestinationMinMultiplicity) + '..*'
                                 else lMultiplicity := IntToStr(lRelationTicket.DestinationMinMultiplicity) + '..' + IntToStr(lRelationTicket.DestinationMaxMultiplicity);
//               lAssociationEndDest.Set_Multiplicity(lMultiplicity);
             lAssociationEndOr.Set_Multiplicity(lMultiplicity);

             // As navegabilidades so efetivamente preenchidas
             { TODO : VERIFICAR OS 2 IFS ABAIXO }
             if lRelationTicket.OriginPropertyName <> '' then
                lAssociationEndOr.Set_IsNavigable(false);
             if lRelationTicket.DestinationPropertyName <> '' then
                lAssociationEndDest.Set_IsNavigable(false);

            case lRelationTicket.OriginAggregation of
              acPropertyAggregation.pvAggregate: lAssociationEndOr.Aggregation := akAggregate;
              acPropertyAggregation.pvComposite: lAssociationEndOr.Aggregation := akComposite;
              else lAssociationEndOr.Aggregation := akNone;
            end;
            case lRelationTicket.DestinationAggregation of
              acPropertyAggregation.pvAggregate: lAssociationEndDest.Aggregation := akAggregate;
              acPropertyAggregation.pvComposite: lAssociationEndDest.Aggregation := akComposite;
              else lAssociationEndDest.Aggregation := akNone;
            end;

             // ATRIBUTOS ESTENDIDOS
             // Obtm classe responsvel por mapeamento OO-DB para Relacionamento
             lRelationSQLPersistenceMapTicket := fMetaModelPersistenceMap.GetRelationsSQLPersistenceMapTicket(lRelationTicket);

             if (lRelationSQLPersistenceMapTicket is acIndirectDBRelationMapTicket) then
             begin
                 lsNomeTabelaAssociativa := (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).TableName;
                 lsNomeFKA := (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKOrigemName;
                 lsNomeFKB := (lRelationSQLPersistenceMapTicket as acIndirectDBRelationMapTicket).FKDestinoName;

                 // Indicador de Relacao Indireta - valor atribudo
                 lAssociation.SetTaggedValueAsBoolean('DBMappings', 'DBAssociationMap', 'Ind', true);
                 // Nome da tabela - valor atribudo
                 lAssociation.SetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'ATbName', lsNomeTabelaAssociativa);
                 // Nome da FKA - valor atribudo
                 lAssociation.SetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'FKA', lsNomeFKA);
                 // Nome da FKB - valor atribudo
                 lAssociation.SetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'FKB', lsNomeFKB);
             end
             else
               begin
                   lsNomeFKA := (lRelationSQLPersistenceMapTicket as acDirectDBRelationMapTicket).FKColumnName;
                   // Nome da FK - valor atribudo
                   lAssociation.SetTaggedValueAsString('DBMappings', 'DBAssociationMap', 'FKA', lsNomeFKA);
               end;

         end; //end if
         lEnumRelation.MoveNext;
      end;
    finally
      lEnumRelation.Free;
    end;
end;

function TUtil.ValidateAttribute(const piAttribute: IUMLAttribute; piCheckLength: boolean): string;
var lsColumnName, lsColumnDBType: String;
    lFixSize, lVarSize: integer;
//    lbMandatory: boolean;
begin
  result := '';

  if trim(piAttribute.Name) = '' then
    result := 'Attribute name was not provided'
  else
    if VarIsEmpty(piAttribute.Type_) then
      result := 'Attribute type was not provided';

  if Result = '' then
  begin
    lsColumnName := piAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name');
    lsColumnDBType := piAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Type');
    lFixSize := strtointdef(piAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'FSize'),0);
    lVarSize := strtointdef(piAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'VSize'),0);
//    lbMandatory := sametext(piAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Mand'), 'True');
    result := ValidateDBAttribute(lsColumnName, lsColumnDBType, lFixSize, lVarSize, piCheckLength);
  end;
end;

function TUtil.ValidateClass(piUMLClass: IUMLClass; poErrors: TStringList): integer;
var I: integer;
    lAttributeNames, lAttributeNamesTag: TStringList;
    lUMLAtt: IUMLAttribute;
    lAttNameTagValue: string;
begin
  result := 0;
  lAttributeNames := TStringList.Create;
  lAttributeNamesTag := TStringList.Create;
  try
    for I := 0 to piUMLClass.GetAttributeCount - 1 do
    begin
      lUMLAtt := piUMLClass.GetAttributeAt(I);
      if lAttributeNames.IndexOf(lUMLAtt.Name) >= 0 then
      begin
        poErrors.Add(format('- Attribute name "%s" already exists in class "%s".', [lUMLAtt.Name, piUMLClass.Name]));
        inc(Result);
      end
      else lAttributeNames.Add(lUMLAtt.Name);

      lAttNameTagValue := lUMLAtt.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name');
      if lAttributeNamesTag.IndexOf(lAttNameTagValue) >= 0 then
      begin
        poErrors.Add(format('- The "Name" tagged value for attribute "%s" is already in use in class "%s".', [lUMLAtt.Name, piUMLClass.Name]));
        inc(Result);
      end
      else lAttributeNamesTag.Add(lAttNameTagValue);
    end;
  finally
    lAttributeNames.free;
    lAttributeNamesTag.Free;
  end;
end;

function TUtil.ValidateDBAttribute(piAttributeDBName: string; piType: string; piFSize, piVSize: integer; piCheckLength: boolean): string;
begin
  result := '';
  if trim(piAttributeDBName) = '' then
    result := 'Tagged value name was not provided.'
  else
    if piCheckLength then
      if Length(piAttributeDBName) > 30 then
        result := 'Attribute name length is too long (Max: 30 characters).';

  if result = '' then
    result := ValidateDBAttributeType(piType, piFSize, piVSize);
end;

function TUtil.ValidateDBAttributeType(piType: string; piFSize, piVSize: integer): string;
begin
  result := '';
  if SameText(piType,'varchar') then
  begin
    if piVSize <= 0 then result := 'Invalid "VSize" value for "VARCHAR" type.';
  end
  else if SameText(piType, 'char') then
  begin
    if piFSize <= 0 then result := 'Invalid "FSize" value for "CHAR" type.';
  end
  else if SameText(piType, 'numeric') or SameText(piType, 'decimal') then
  begin
    if piFSize <= 0 then result := 'Invalid "FSize" value for "NUMERIC" or "DECIMAL" type.';
  end
  else if SameText(piType, 'int') or SameText(piType, 'integer') or
          SameText(piType, 'datetime') or SameText(piType, 'text') or SameText(piType, 'image')then
          //
  else
    result := 'Invalid "TYPE" ' + piType;
end;

function TUtil.CarregaMetodo(pStarUMLApp: IStarUMLApplication): string;
var //lPrjManager: IProjectManager;
    lModel: IModel;
    lClass: IUMLClass;
    lPackage: IUMLPackage;
    lElement: IElement;
    lsPrjFileName, lsPrjPathName, lsNomePacote, lsPasPath, lsNomeUnit, lsNomeClasse, lsMetName: string;
    lPos, lMetCont, liCont, liParCount, liParIndex, lopCont: integer;
    lInstantCodeProjectAux: TInstantCodeProject;
    lModuleAux: TInstantCodeModule;
    lOptions: TInstantCodeParameterOptions;
    lFactory: IUMLFactory;
    lOperation: IUMLOperation;
    lParameter: IUMLParameter;
begin
   try
      lModel := pStarUMLApp.SelectionManager.GetSelectedModelAt(0);
      lFactory := pStarUMLApp.UMLFactory;

      if (lModel.GetClassName = 'UMLClass') then
      begin
          lClass := lModel as IUMLClass;

          lsNomeClasse := lClass.Name;
          lsNomeUnit := Uppercase(Copy(lsNomeClasse, 0, 2)) + 'U' + Copy(lsNomeClasse, 3, Length(lsNomeClasse)-2);

          lsPrjFileName := pStarUMLApp.ProjectManager.FileName;
          lPos := Pos('\mdl\', lsPrjFileName);
          lsPrjPathName := copy(lsPrjFileName, 1, lPos-1);

          lPos := Pos(lsNomeClasse, lClass.Pathname);
          lsNomePacote := copy(lClass.Pathname, 1, lPos-3);

          lElement := pStarUMLApp.FindByPathname(lsNomePacote);
          if (lElement <> nil) and (lElement.GetClassName = 'UMLPackage') then
          begin
            lPackage := lElement as IUMLPackage;
            lsNomePacote := lPackage.Name;
            lsPasPath := lsPrjPathName + '\' + lowercase(lsNomePacote) + '\src\ngu\' + lsNomeUnit + '.pas';

            (*CARREGAR METODOS*)
            lopCont := lClass.GetOperationCount;
           for liCont := lopCont - 1 downto 0 do
           begin
              if lClass.GetOperationAt(liCont) <> nil then
                pStarUMLApp.DeleteModel(lClass.GetOperationAt(liCont));
           end;

           // Modulo a ser lido para buscar metodos
           lInstantCodeProjectAux := TInstantCodeProject.Create();
           lModuleAux := TInstantCodeModule.Create(lInstantCodeProjectAux);
           lModuleAux.LoadFromFile(lsPasPath, scInterface);

           lMetCont := lModuleAux.Classes[0].MethodCount;

           for liCont := 0 to lMetCont - 1 do
           begin
               lsMetName := lModuleAux.Classes[0].Methods[liCont].Name;
               lOperation := lFactory.CreateOperation(lClass);
               lOperation.Name := lsMetName;

               case lModuleAux.Classes[0].Methods[liCont].Visibility of
               viPrivate : lOperation.Visibility := vkPrivate;
               viProtected : lOperation.Visibility := vkProtected;
               viPublic : lOperation.Visibility := vkPublic;
               viPublished : lOperation.Visibility := vkPublic;
               else lOperation.Visibility := vkPackage;
               end;

               if lModuleAux.Classes[0].Methods[liCont].Prototype.ResultTypeName <> '' then
               begin
                 lParameter := lFactory.CreateParameter(lOperation);
                 lParameter.DirectionKind := pdkReturn;
                 lParameter.TypeExpression := lModuleAux.Classes[0].Methods[liCont].Prototype.ResultTypeName;
                 lParameter.Name := '';
               end;
               // Is Abstract
               if pfAbstract in lModuleAux.Classes[0].Methods[liCont].Prototype.Flags then
                  lOperation.IsAbstract := true;

               // Is Polymorphic
               if pfVirtual in lModuleAux.Classes[0].Methods[liCont].Prototype.Flags then
                  lOperation.SetTaggedValueAsBoolean('DBMappings', 'DBOperationMap', 'IsPolymorphic', true);

               //Override
               if pfOverride in lModuleAux.Classes[0].Methods[liCont].Prototype.Flags then
                  lOperation.SetTaggedValueAsBoolean('DBMappings', 'DBOperationMap', 'Override', true);

               liParCount := lModuleAux.Classes[0].Methods[liCont].Prototype.Parameters.count;
               for liParIndex := 0 to liParCount - 1 do
               begin
                 lParameter := lFactory.CreateParameter(lOperation);
                 lParameter.TypeExpression := lModuleAux.Classes[0].Methods[liCont].Prototype.Parameters.Items[liParIndex].TypeName;
                 lParameter.Name := lModuleAux.Classes[0].Methods[liCont].Prototype.Parameters.Items[liParIndex].Name;
                 lOptions := lModuleAux.Classes[0].Methods[liCont].Prototype.Parameters.Items[liParIndex].Options;
                 if poConst in lOptions then
                   lParameter.DirectionKind := pdkIn
                   else if poVar in lOptions then
                      lParameter.DirectionKind := pdkInout
                        else if poOut in lOptions then
                            lParameter.DirectionKind := pdkOut
                              else lParameter.DirectionKind := pdkIn;
               end;
           end;    // end for

            (**)

//            lPrjManager.SaveProject;
//            lPrjManager.SaveAllUnits;
          end
          else result := 'A classe deve estar dentro de um pacote.';
      end
      else result := 'This option is avaliable only for classes.';
   finally
   end;
   result := 'Mtodos da classe ' + lsNomeClasse + ' Carregados.';
end;

procedure TUtil.PutMessage(piMessage: string; piElement: IElement; piMessageType: integer);
begin
  gStarUMLApp.AddMessageItem(piMessageType, piMessage, piElement);
end;

function TUtil.EncodeMultiplicity(piMultiplicity: Integer): string;
begin
  if (piMultiplicity = N)
  then Result := '*'
  else Result := IntToStr(piMultiplicity);
end;

constructor TUtil.Create;
begin
  fStarUMLApp := gStarUMLApp;
  fMetaModel := acMetaModel.Create(PersistenceManager.ModelImplementation);
  fMetaModelPersistenceMap := acMetaModelPersistenceMapSQL.Create(fMetaModel);
  fMetaModelPersistenceMap.Initialize;
  PersistenceManager.RegisterModelMapping(fMetaModelPersistenceMap);
end;

function TUtil.DescendsFrom(piElement: IUMLGeneralizableElement; piName: string): boolean;
var I: integer;
begin
  result := false;
  for I := 0 to piElement.GetGeneralizationCount - 1 do
    if SameText(piElement.GetGeneralizationAt(i).Parent.Name, piName) then
      result := true
    else
      result := DescendsFrom(piElement.GetGeneralizationAt(i).Parent, piName);
end;

destructor TUtil.Destroy;
begin
  fMetaModelPersistenceMap.Free;
  fMetaModel.Free;
  fStarUMLApp := nil;
  inherited;
end;

initialization

finalization

end.
