library CurioAddIn;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

uses
  {$IFDEF UNIX}
  cwstring,
  {$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  SysUtils,
  LCLType,
  Classes,
  Interfaces,
  {$IFDEF DARWIN}
  CocoaInt,
  {$ENDIF}
  Forms,
  acuObject,
  utuMessage,
  acuRepositorySQL,
  acuSQLDialectManager,
  acuSQLDialectSQLServer,
  acuSQLDialectOracle,
  acuSQLDialectDB2,
  utuLinksManager,
  utuLinkSock,
  acuFramework,
  acuQuerySQLODBC,
  ituExplorerV2,
  IntegracaoDelphiSUML in 'IntegracaoDelphiSUML.pas',
  Mostra_Processamento in 'Mostra_Processamento.pas' {FMostra_Processamento},
  InstantClasses in 'InstantCode\InstantClasses.pas',
  InstantCode in 'InstantCode\InstantCode.pas',
  InstantTextFiler in 'InstantCode\InstantTextFiler.pas',
  Utility in 'Utility.pas',
  utuOQL in 'utuOQL.pas',
  utuXSD in 'utuXSD.pas',
  DelphiAddInObj in 'DelphiAddInObj.pas';

exports
  InitializeAddIn,
  FinalizeAddIn,
  DoMenuAction;

begin
  {$if declared(UseHeapTrace)}
  if UseHeaptrace then
  begin
    GlobalSkipIfNoLeaks := True;
    DeleteFile('CURIOAddIn.trc');
    SetHeapTraceOutput('CURIOAddIn.trc');
  end;
  {$ifend}
  ChangeLocaleFormatSetting;
  gDefaultDatabaseDriver := typeOf(acDatabaseSQLODBC);
  PersistenceManager.DefaultRepositoryClass := typeOf(acRepositorySQL);
  PersistenceManager.RegisterClass(typeOf(acPersistentObject), acPersistentObjectClassFactory.Create);
  gSQLDialectManager.RegisterSQLDialect('MS SQL Server', typeOf(acSQLDialectSQLServer), acSQLDialectSQLServerClassFactory.Create);
  gSQLDialectManager.RegisterSQLDialect('Oracle', typeOf(acSQLDialectOracle), acSQLDialectOracleClassFactory.Create);
  gSQLDialectManager.RegisterSQLDialect('DB2', typeOf(acSQLDialectDB2), acSQLDialectDB2ClassFactory.Create);
  gLinksManager.RegisterLink('tcp/ip', typeOf(utLinkSock), utLinkSockClassFactory.Create);

  {$IFDEF DARWIN}
  MainPool := Nil;
  {$ENDIF}

  Application.Initialize;

//  Application.CaptureExceptions := True;

//  ExtensionManager.LoadProfiles;
//  StarUMLApplication.OpenProject('D:\Users\sandrosantana\Documents\git\GED\mdl\GED.uml');
//  Application.CreateForm(TExplorerV2, ExplorerV2);
//  Application.Run;
end.
