unit fCodeGen;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, acuframework, IntegracaoDelphiSUML,
  JvExControls, JvEditorCommon, JvEditor, JvHLEditor, Buttons, utuStateMachine, acuCollection,
  acuContainers, JvComponentBase, JvRichEditToHtml;


const cServer = 0; cClient = 1;
      cDelphi = 0; cJava = 1; cCCharp = 2;

type
  TCodeGen = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel3: TPanel;
    Panel2: TPanel;
    Panel4: TPanel;
    lvUseCases: TListView;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    PageControl2: TPageControl;
    TabSheet2: TTabSheet;
    Panel5: TPanel;
    Panel6: TPanel;
    memCode: TJvHLEditor;
    TabSheet3: TTabSheet;
    lvXSD: TListView;
    PageControl3: TPageControl;
    TabSheet4: TTabSheet;
    TabSheet5: TTabSheet;
    memXSDIn: TJvHLEditor;
    memXSDOut: TJvHLEditor;
    TabSheet6: TTabSheet;
    General: TPageControl;
    TabSheet7: TTabSheet;
    Options: TTabSheet;
    Panel1: TPanel;
    SpeedButton6: TSpeedButton;
    rdgType: TRadioGroup;
    rdgLanguage: TRadioGroup;
    GroupBox1: TGroupBox;
    SpeedButton5: TSpeedButton;
    edtDirectory: TEdit;
    Panel9: TPanel;
    PageControl4: TPageControl;
    TabSheet8: TTabSheet;
    Panel10: TPanel;
    ckbExportsXSD: TCheckBox;
    ckbExportJPG: TCheckBox;
    Label1: TLabel;
    edtJavaPackageName: TEdit;
    PageControl5: TPageControl;
    TabSheet9: TTabSheet;
    TabSheet10: TTabSheet;
    Panel7: TPanel;
    Panel8: TPanel;
    SpeedButton4: TSpeedButton;
    memSQLServer: TJvHLEditor;
    Panel11: TPanel;
    Panel12: TPanel;
    SpeedButton7: TSpeedButton;
    memSQLOracle: TJvHLEditor;
    Panel13: TPanel;
    Label2: TLabel;
    TabSheet11: TTabSheet;
    Panel14: TPanel;
    Panel15: TPanel;
    SpeedButton8: TSpeedButton;
    memSQLDB2: TJvHLEditor;
    procedure FormShow(Sender: TObject);
    procedure lvUseCasesChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure rdgTypeClick(Sender: TObject);
    procedure rdgLanguageClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure lvXSDChange(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure SpeedButton4Click(Sender: TObject);
    procedure edtJavaPackageNameChange(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
  private
    { Private declarations }
    fUtil: TUtil;
    fFileExtension: string;
    procedure ListUseCases;
    function GetGenerateCodeProcedure: TProcCodeGen;
    procedure ShowCodePreview(piUseCase: acUseCaseTicket);
    procedure GetTransitionsWithXsd(const piStateMachine: utStateMachine; const poTransitions: acObjectList);
    function SuggestFileName(piValue: string; piExtension: boolean = false): string;
    Function GenCode(piUseCaseCode: String): string;
  public
    { Public declarations }
    property Util: TUtil read fUtil write fUtil;
    property GenerateCodeProcedure: TProcCodeGen read GetGenerateCodeProcedure;
    property FileExtension: string read fFileExtension write fFileExtension;
  end;

var
  CodeGen: TCodeGen;

implementation

uses acuObject, FileCtrl, strutils;


{$R *.dfm}

{ TCodeGen }

procedure TCodeGen.edtJavaPackageNameChange(Sender: TObject);
begin
  if Assigned(lvUseCases.Selected) then
     ShowCodePreview(acUseCaseTicket(lvUseCases.Selected.Data));
end;

procedure TCodeGen.FormShow(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    ListUseCases;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TCodeGen.ShowCodePreview(piUseCase: acUseCaseTicket);
var lTransitions: acObjectList;
    lItem: TListItem;
    lTransition: utTransition;
    lEnum: acEnumerator;
    lTriggerEnum: acEnumerator;
    lTrigger: utTrigger;
    lTriggersName: string;
begin
  memCode.Lines.Text := GenCode(piUseCase.Code);
  if memCode.Lines.Text = '' then memCode.Lines.Text := 'Language not yet supported';

  lTransitions := acObjectList.Create();
  try
    GetTransitionsWithXsd(piUseCase.StateMachine, lTransitions);
    lvXSD.Clear;
    lEnum := lTransitions.GetEnumerator;
    while not lEnum.EOL do
    begin
      lTransition := utTransition(lEnum.Current);

      lTriggersName := '';
      lTriggerEnum := lTransition.GetTriggersEnumerator;
      try
        while not lTriggerEnum.EOL do
        begin
          lTrigger := utTrigger(lTriggerEnum.Current);
          lTriggersName := lTriggersName + lTrigger.Name + '; ';
          lTriggerEnum.MoveNext;
        end;
      finally
        lTriggerEnum.free;
      end;
      if lTriggersName <> '' then lTriggersName := LeftStr(lTriggersName, Length(lTriggersName) - 2);

      lItem := lvXSD.Items.Add;
      lItem.Caption := lTransition.Owner.Owner.Name;
      lItem.SubItems.Add(lTransition.Name);
      lItem.SubItems.Add(lTriggersName);
      lItem.SubItems.Add(lTransition.SourceState.Name);
      lItem.SubItems.Add(lTransition.TargetState.Name);
      lItem.Data := lTransition;
      lEnum.MoveNext;
    end;
  finally
    lTransitions.Free;
  end;


end;

procedure TCodeGen.SpeedButton1Click(Sender: TObject);
var I: integer;
begin
  for I := 0 to lvUseCases.Items.Count - 1 do
    lvUseCases.Items[i].Checked := true;
end;

procedure TCodeGen.SpeedButton2Click(Sender: TObject);
var I: integer;
begin
  for I := 0 to lvUseCases.Items.Count - 1 do
    if lvUseCases.Items[i].Selected then
      lvUseCases.Items[i].Checked := true;
end;

procedure TCodeGen.SpeedButton3Click(Sender: TObject);
var I: integer;
begin
  for I := 0 to lvUseCases.Items.Count - 1 do
    lvUseCases.Items[i].Checked := false;
end;

procedure TCodeGen.SpeedButton4Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    memSQLServer.Clear;
    memSQLServer.Lines.Text := Util.GerarFullSQLPreview(dbvSQLServer);
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TCodeGen.SpeedButton5Click(Sender: TObject);
var lDir: string;
begin
  lDir := '';
  SelectDirectory('Generate code to', '', lDir);
  edtDirectory.Text := ldir;
end;

procedure TCodeGen.SpeedButton6Click(Sender: TObject);
var I: integer;
    lCode: TStrings;

    lTransitions: acObjectList;
    lTransition: utTransition;
    lEnum: acEnumerator;

    lTargetDir, lDocTargetDir: string;
begin
  if (Trim(edtDirectory.Text) = '') then
    raise Exception.Create('Directory not specified.');

  lTargetDir := IncludeTrailingPathDelimiter(edtDirectory.Text);

  if not DirectoryExists(lTargetDir) then
    raise Exception.Create('Directory "' + lTargetDir + '" does not exists.');

  if not assigned(GenerateCodeProcedure) then
    raise Exception.Create('Language not yet supported.');

  Screen.Cursor := crHourGlass;
  try
    lCode := TStringList.Create;
    try
      for I := 0 to lvUseCases.Items.Count - 1 do
        if lvUseCases.Items[i].Checked then
        begin
          lDocTargetDir := IncludeTrailingPathDelimiter(lTargetDir + lvUseCases.Items[i].Caption);
          if not DirectoryExists(lDocTargetDir) then
            CreateDirectory(PAnsiChar(lDocTargetDir), nil);

          lCode.Clear;
          lCode.Text := GenCode(acUseCaseTicket(lvUseCases.Items[i].Data).Code);
          lCode.SaveToFile(lTargetDir + SuggestFileName(lvUseCases.Items[i].Caption,true));

//          if ckbExportJPG.Checked then
//            Util.SaveUseCaseDiagramJPG(lvUseCases.Items[i].Caption, lDocTargetDir);

          if ckbExportsXSD.Checked then
          begin
            //XSDs
            lTransitions := acObjectList.Create();
            try
              GetTransitionsWithXsd(acUseCaseTicket(lvUseCases.Items[i].Data).StateMachine, lTransitions);
              lvXSD.Clear;
              lEnum := lTransitions.GetEnumerator;
              while not lEnum.EOL do
              begin
                lTransition := utTransition(lEnum.Current);
                if lTransition.XsdIn.XML <> '' then
                begin
                  lCode.Clear;
                  lCode.Text := lTransition.XsdIn.XML;
                  lCode.SaveToFile(lDocTargetDir + lvUseCases.Items[i].Caption + '_' + lTransition.Name + '_XsdIn.xsd');
                end;
                if lTransition.XsdOut.XML <> '' then
                begin
                  lCode.Clear;
                  lCode.Text := lTransition.XsdOut.XML;
                  lCode.SaveToFile(lDocTargetDir + lvUseCases.Items[i].Caption + '_' + lTransition.Name + '_XsdOut.xsd');
                end;
                lEnum.MoveNext;
              end;
            finally
              lTransitions.Free;
            end;
          end;
        end;
    finally
      lCode.Free;
    end;
    if ckbExportJPG.Checked then
      Util.SaveAllDiagrams(lTargetDir);
  finally
    Screen.Cursor := crDefault;
  end;
  Application.MessageBox('Code generated successefully.','Conexo', MB_ICONINFORMATION);
end;

procedure TCodeGen.SpeedButton7Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    memSQLOracle.Clear;
    memSQLOracle.Lines.Text := Util.GerarFullSQLPreview(dbvOracle);
  finally
    Screen.Cursor := crDefault;
  end;

end;

procedure TCodeGen.SpeedButton8Click(Sender: TObject);
begin
  Screen.Cursor := crHourGlass;
  try
    memSQLDB2.Clear;
    memSQLDB2.Lines.Text := Util.GerarFullSQLPreview(dbvDB2);
  finally
    Screen.Cursor := crDefault;
  end;
end;

function TCodeGen.SuggestFileName(piValue: string; piExtension: boolean = false): string;
  var lFileName: string;
begin
  case rdgLanguage.ItemIndex of
    cDelphi:
      begin
        lFileName := copy(piValue,1,2) + 'u' + copy(piValue,3,length(piValue)-2);
      end;
    cJava:
      begin
        lFileName := copy(piValue,1,2) + copy(piValue,3,length(piValue)-2);
      end;
    cCCharp:
      begin
        lFileName := copy(piValue,1,2) + copy(piValue,3,length(piValue)-2);
      end;
  end;
  if piExtension then
    lFileName := lFileName + FileExtension;
  result := lFileName;
end;

function TCodeGen.GenCode(piUseCaseCode: String): string;
var lCodeGenParams: TCodeGenParams;
begin
  lCodeGenParams := nil;
  result := '';
  if assigned(@GenerateCodeProcedure) then
  begin
    try
      case rdgLanguage.ItemIndex of
        cDelphi:
          begin
            lCodeGenParams := TCodeGenParamsUseCase.Create;
          end;
        cJava:
          begin
            lCodeGenParams := TCodeGenParamsUseCaseJava.Create;
            TCodeGenParamsUseCaseJava(lCodeGenParams).JavaClientPackageName := edtJavaPackageName.Text;
          end;
        cCCharp:
          begin
            lCodeGenParams := TCodeGenParamsUseCase.Create;
          end;
      end;

      TCodeGenParamsUseCase(lCodeGenParams).UseCaseCode := piUseCaseCode;

      result := GenerateCodeProcedure(lCodeGenParams);
    finally
      if assigned(lCodeGenParams) then lCodeGenParams.Free;
    end;
  end;
end;

function TCodeGen.GetGenerateCodeProcedure: TProcCodeGen;
begin
  case rdgLanguage.ItemIndex of
    cDelphi:
      begin
        FileExtension := '.pas';
        memCode.Highlighter := hlPascal;
        case rdgType.ItemIndex of
          cServer: result := Util.GerarUseCaseServerPreview_Pascal;
          cClient: result := nil;
        end;
      end;

    cJava:
      begin
        FileExtension := '.java';
        memCode.Highlighter := hlJava;
        case rdgType.ItemIndex of
          cServer: result := nil;
          cClient: result := Util.GerarUseCaseClientPreview_Java;
        end;
      end;
    cCCharp:
    begin
      FileExtension := '.cs';
      memCode.Highlighter := hlCSharp;
      case rdgType.ItemIndex of
        cServer: result := nil;
        cClient: result := Util.GerarUseCaseClientPreview_DotNet;
      end;
    end;
  end;
end;

procedure TCodeGen.GetTransitionsWithXsd(const piStateMachine: utStateMachine; const poTransitions: acObjectList);
var lTransitionEnum, lStateEnum: acEnumerator;
    lState: utState;
    lTransition: utTransition;
begin
  lStateEnum := piStateMachine.GetStatesEnumerator;
  try
    while not lStateEnum.EOL do
    begin
      lState := utState(lStateEnum.Current);

      lTransitionEnum := lState.GetOutgoingTransitionsEnumerator;
      try
        while not lTransitionEnum.EOL do
        begin
          lTransition := utTransition(lTransitionEnum.Current);

          if (lTransition.XsdIn.XML <> '') or (lTransition.XsdOut.XML <> '') then
            poTransitions.Add(lTransition);

//          lTriggersEnum := lTransition.GetTriggersEnumerator;
//          try
//            while not lTriggersEnum.EOL do
//            begin
//              lTrigger := utTrigger(lTriggersEnum.Current);
//
//              lTriggersEnum.MoveNext;
//            end;
//          finally
//            lTriggersEnum.Free;
//          end;

          lTransitionEnum.MoveNext;
        end;
      finally
        lTransitionEnum.Free;
      end;

      if lState is utSubMachineState then
        GetTransitionsWithXsd(utSubMachineState(lState).StateMachine, poTransitions);

      lStateEnum.MoveNext;
    end;
  finally
    lStateEnum.Free;
  end;
end;

procedure TCodeGen.ListUseCases;
var lListItem: TListItem;
    lEnum: acEnumerator;
    lMetaModel: acMetaModel;
    lUseCaseTicket: acUseCaseTicket;
begin
  lMetaModel := Util.MetaModel;
  lEnum := lMetaModel.UseCaseTickets.GetEnumerator;
  try
    while not lEnum.EOL do
    begin
      lUseCaseTicket := acUseCaseTicket(lEnum.Current);
      lListItem := lvUseCases.Items.Add;
      lListItem.Caption := lUseCaseTicket.Name;
      lListItem.Data := lUseCaseTicket;
      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

procedure TCodeGen.lvUseCasesChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if Assigned(lvUseCases.Selected) then
     ShowCodePreview(acUseCaseTicket(lvUseCases.Selected.Data));
end;

procedure TCodeGen.lvXSDChange(Sender: TObject; Item: TListItem;
  Change: TItemChange);
begin
  if Assigned(lvXSD.Selected) then
  begin
    memXSDIn.Lines.Text := utTransition(lvXSD.Selected.Data).XsdIn.XML;
    memXSDOut.Lines.Text := utTransition(lvXSD.Selected.Data).XsdOut.XML;
  end;
end;

procedure TCodeGen.rdgLanguageClick(Sender: TObject);
begin
  if Assigned(lvUseCases.Selected) then
     ShowCodePreview(acUseCaseTicket(lvUseCases.Selected.Data));
end;

procedure TCodeGen.rdgTypeClick(Sender: TObject);
begin
  if Assigned(lvUseCases.Selected) then
     ShowCodePreview(acUseCaseTicket(lvUseCases.Selected.Data));
end;

end.
