unit acuObjectExplorer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, acuframework, ElXPThemedControl, ElTree;

type
  TObjectExplorer = class(TFrame)
    tvExplorer: TElTree;
    procedure tvExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetSession(piSession: acPersistenceSession);
    procedure SetList(piList: acPersistentObjectList; piDesc: string);
    procedure SetPersistenceManager(piPersistenceManager: acPersistenceManager);
  end;

implementation

{$R *.dfm}

uses TypInfo, acuobject;

procedure TObjectExplorer.SetList(piList: acPersistentObjectList; piDesc: string);
begin
  tvExplorer.Items.Clear;
  if assigned(piList) then tvExplorer.Items.AddChildObject(nil, piDesc, piList).Expand(False);
end;

procedure TObjectExplorer.SetPersistenceManager(piPersistenceManager: acPersistenceManager);
begin
  tvExplorer.Items.AddChildObject(nil, 'Objects Repository', piPersistenceManager).Expand(False);
end;

procedure TObjectExplorer.SetSession(piSession: acPersistenceSession);
begin
  tvExplorer.Items.Clear;
  if assigned(piSession) then tvExplorer.Items.AddChildObject(nil, piSession.Name, piSession).Expand(False);
end;

procedure TObjectExplorer.tvExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
var lSession: acPersistenceSession;
    lPatriarca: acPatriarca;
    lPersistentObject: acPersistentObject;
    lClassTicket: acClassTicket;
    lObject: acObject;
    lEnumerator: acEnumerator;
    li: integer;
    lAttribute: acAttribute;
    lAttributeTicket: acAttributeTicket;
    lPropertyName: String;
    lRelation: acRelationTicket;
begin
  if (Node.Tag <> 100) then
  begin
    Node.Owner.Items.BeginUpdate;
    try
      if (TObject(Node.Data) is acPersistenceManager) then
      begin
        lEnumerator := acPersistenceManager(Node.Data).GetSessionsEnumerator;
        li := 1;
        while not lEnumerator.EOL do
        begin
          lSession := acPersistenceSession(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, 'Session ' + inttostr(li) + ': ' + lSession.Name, lSession);
          lEnumerator.MoveNext;
          inc(li);
        end;
      end
      else if (TObject(Node.Data) is acPersistenceSession) then
      begin
        lSession := acPersistenceSession(Node.Data);
        lEnumerator := lSession.getPatriarcsEnumerator;
        while not lEnumerator.EOL do
        begin
          lPatriarca := acPatriarca(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, lPatriarca.ClassTicket.PersistentObjectClassName, lPatriarca);
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acPatriarca) then
      begin
        lPatriarca := acPatriarca(Node.Data);
        lEnumerator := lPatriarca.Objects.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject);
          lEnumerator.MoveNext;
        end;
        lEnumerator := lPatriarca.NewObjects.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject);
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acPersistentObject) or (TObject(Node.Data) is acRelationPartnerShip) then
      begin
        if (TObject(Node.Data) is acPersistentObject)
          then lPersistentObject := acPersistentObject(Node.Data)
          else lPersistentObject := acRelationPartnerShip(Node.Data).Partner;
        lClassTicket := lPersistentObject.ClassTicket;

        while lClassTicket <> nil do
        begin
          for li := 0 to pred(lClassTicket.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
            lAttribute := lPersistentObject.AttributeByName[lAttributeTicket.AttributeName];
            if assigned(lAttribute) then
            begin
              if lAttribute.IsNull
                then Node.Owner.Items.AddChildObject(Node, lAttributeTicket.AttributeName+ ': '+lAttributeTicket.AttributeType+' (null)', lAttribute).Tag := 100
                else Node.Owner.Items.AddChildObject(Node, lAttributeTicket.AttributeName+ ': '+lAttributeTicket.AttributeType+' ('+lAttribute.AsString + ')', lAttribute);
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        end;

        lClassTicket := lPersistentObject.ClassTicket;
        while lClassTicket <> nil do
        begin
          for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
          begin
            lRelation := (lClassTicket.RelationTicketsIn.Objects[li] as acRelationTicket);

            lPropertyName := lRelation.DestinationPropertyName;
            if (lPropertyName <> '') then
            begin
              if lRelation.DestinationMaxMultiplicity <= 1 then
              begin
                lObject := acObject(lPersistentObject.PartnerShipByName[lPropertyName]);
                if acRelationPartnerShip(lObject).Status = PSLoaded then
                  if assigned(acRelationPartnerShip(lObject).Partner)
                    then Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).Partner.IDO.AsString + ')', acRelationPartnerShip(lObject).Partner)
                    else Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginTicket.PersistentObjectClassName + ' (null)', lObject).Tag := 100
                else
                  if assigned(acRelationPartnerShip(lObject).PartnerOID)
                    then Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).PartnerOID.AsString + ')', lObject)
                    else Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginTicket.PersistentObjectClassName + ' (null)', lObject).Tag := 100;
              end
              else
              begin
                lObject := acObject(lPersistentObject.PartnerListByName[lPropertyName]);
                Node.Owner.Items.AddChildObject(Node, lPropertyName, lObject);
              end;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
          begin
            lRelation := (lClassTicket.RelationTicketsOut.Objects[li] as acRelationTicket);

            lPropertyName := lRelation.OriginPropertyName;
            if (lPropertyName <> '') then
            begin
              if lRelation.OriginMaxMultiplicity <= 1 then
              begin
                lObject := acObject(lPersistentObject.PartnerShipByName[lPropertyName]);
                if acRelationPartnerShip(lObject).Status = PSLoaded then
                  if assigned(acRelationPartnerShip(lObject).Partner)
                    then Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).Partner.IDO.AsString + ')', acRelationPartnerShip(lObject).Partner)
                    else Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationTicket.PersistentObjectClassName + ' (null)', lObject).Tag := 100
                else
                  if assigned(acRelationPartnerShip(lObject).PartnerOID)
                    then Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).PartnerOID.AsString + ')', lObject)
                    else Node.Owner.Items.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationTicket.PersistentObjectClassName + ' (null)', lObject).Tag := 100;
              end
              else
              begin
                lObject := acObject(lPersistentObject.PartnerListByName[lPropertyName]);
                Node.Owner.Items.AddChildObject(Node, lPropertyName, lObject);
              end;
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        end;
      end
      else if (TObject(Node.Data) is acPersistentObjectList) then
      begin
        lEnumerator := acPersistentObjectList(Node.Data).GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject);
          lEnumerator.MoveNext;
        end;
      end;
      Node.Tag := 100;
    finally
      Node.Owner.Items.EndUpdate;
    end;
  end;
  AllowExpansion := True;
end;

end.
