unit MetamodelManager;

interface

uses
  InstantCode, StarUML_TLB, acuObject, acuframework, acuRepositorySQL, SysUtils,
  Classes, DBTables, Mostra_Processamento, acuContainers, utuStateMachine, variants, OleServer;//, dbuDataModule;

const MODELO = '::AppModel';
const cBASE_PERSISTENT_OBJECT_CLASS = 'acPersistentObject';
const cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH = MODELO + '::FrameworkModel::acuFrameworkPackage::' + cBASE_PERSISTENT_OBJECT_CLASS;

type
  TMetamodelManager = class(TObject)
  private
    fMetaModel: acMetaModel;
    function IsGeneralization(piClass: IUMLClass; const Pathname: string): Boolean;
    procedure UpdateClassElement(piClass: IUMLClass);
    //procedure UpdateUseCaseElement(piUseCase: IUMLUseCase);
  public
    constructor Create;
    procedure InitializeMetamodel;
    procedure UpdateModel(piModel: IModel);
  end;

function GetInstance: TMetamodelManager;

implementation

var Manager: TMetamodelManager;

function GetInstance: TMetamodelManager;
begin
  if not Assigned(Manager) then
  begin
    Manager := TMetamodelManager.Create;
  end;
  Result := Manager;
end;

{ TMetamodelManager }

constructor TMetamodelManager.Create;
begin

end;

procedure TMetamodelManager.InitializeMetamodel;
begin
  fMetaModel := acMetaModel.Create;
  fMetaModel.DefaultMetaModelPersistenceMap := acMetaModelPersistenceMapSQL.Create(fMetaModel);
end;

function TMetamodelManager.IsGeneralization(piClass: IUMLClass; const Pathname: string): Boolean;
var
  I: integer;
  lClass: IUMLClass;
begin
  Result := False;
  for I := 0 to piClass.GetGeneralizationCount - 1 do
  begin
    lClass := piClass.GetGeneralizationAt(I).Parent as IUMLClass;
    Result := SameText(lClass.Pathname, Pathname) or IsGeneralization(lClass, Pathname);
    if Result
      then Break;
  end;
end;

procedure TMetamodelManager.UpdateClassElement(piClass: IUMLClass);
begin

end;

procedure TMetamodelManager.UpdateModel(piModel: IModel);
var
  lClass: IUMLClass;
  //lUseCase: IUMLUseCase;
begin
  if piModel.QueryInterface(IUMLClass, lClass) = S_OK then
  begin
    if IsGeneralization(lClass, cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH)
      then UpdateClassElement(lClass);
  end;
end;

{procedure TMetamodelManager.UpdateUseCaseElement(piUseCase: IUMLUseCase);
begin

end; }

initialization

finalization
  if Assigned(Manager) then Manager.Free;
  
end.




