unit ituCadastrarFormulario;

{$MODE Delphi}

interface

uses
  LCLIntf, LCLType, LMessages, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms, StdCtrls, Dialogs, ComCtrls, ExtCtrls, Buttons,
  MaskEdit, utuMessage, Grids, ValEdit, StarUMLintf,
  cxuCadastroDefinicaoClasse, IntegracaoDelphiSUML, acuModel;

type

  { TitCadastrarFormulario }

  TitCadastrarFormulario = class(TForm)
    btnExcluir: TButton;
    cbbForm: TComboBox;
    edtNome: TEdit;
    edtDisplayNome: TEdit;
    edtNomeForm: TEdit;
    lblCodigoForm: TLabel;
    lblCodigoForm2: TLabel;
    lblNomeForm: TLabel;
    lblNomeClasse: TLabel;
    lblForm: TLabel;
    lblClasseName: TLabel;
    lblOrdem: TLabel;
    lblObrigatorio: TLabel;
    lblNome: TLabel;
    lblDisplayNome: TLabel;
    lvCampos: TListView;
    lblExibirCampos: TLabel;
    btnUp: TSpeedButton;
    btnDown: TSpeedButton;
    cbbTipo: TComboBox;
    lblTipoAtributo: TLabel;
    lstAtributos: TValueListEditor;
    Panel1: TPanel;
    Panel2: TPanel;
    rbNao: TRadioButton;
    rbSim: TRadioButton;
    scrlbxTudo: TScrollBox;
    btnSalvar: TButton;
    btnCancelar: TButton;
    edtCampo: TEdit;
    lblNovoCampo: TLabel;
    btnAdd: TSpeedButton;
    procedure btnExcluirClick(Sender: TObject);
    procedure cbbFormSelect(Sender: TObject);
    procedure edtDisplayNomeChange(Sender: TObject);
    procedure edtNomeChange(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure lstAtributosFill(piType: string);
    procedure btnCancelarClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure lstAtributosValidateEntry(sender: TObject; aCol, aRow: Integer;
      const OldValue: string; var NewValue: String);
    procedure lvCamposSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvCamposClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure cbbTipoChange(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure edtCampoKeyPress(Sender: TObject; var Key: Char);
    procedure rbNaoChange(Sender: TObject);
    procedure rbSimChange(Sender: TObject);

  private
    fUtil: TUtil;
    fUMLClass: IUMLClass;
    fcxCadastroDefinicaoClasse: cxCadastroDefinicaoClasse;
    fClassPackage: IUMLPackage;
    fClassCode: string;

    fForms: utField;
    fFormFields: utField;
    fTypesField: utField;
    fIdCount: Integer;

    procedure Initialize;
    procedure SendToInterface(piField: utField);
    procedure FillListViewClassData(piClass: acClassTicket);
    function AdicionarCampo (piName : string) : TListItem;
  public
    Constructor Create(Sender: TComponent; piCadastroClasse: cxCadastroDefinicaoClasse; piUMLClass: IUMLClass); reintroduce;

    property FieldTypeList: utField read fFormFields write fFormFields;
    property UMLClass: IUMLClass read fUMLClass write fUMLClass;
    property ClassPackage: IUMLPackage read fClassPackage write fClassPackage;
  end;

implementation

uses
  acuObject, acuFramework;

const
  __STRING = 1;
  __NUMBER = 2;
  __BOOLEAN = 3;

  //indices dos subitens das listviews
  __DISPLAY_NAME = 0;
  __OBRIGATORIO = 1;
  __ID = 2;
  __TIPO = 3;

{$R *.lfm}

{ itCadastrarCliente }

constructor TitCadastrarFormulario.Create(Sender: TComponent; piCadastroClasse: cxCadastroDefinicaoClasse; piUMLClass: IUMLCLass);
var lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  inherited Create(sender);

  if assigned(piUMLClass) then
  begin
    fUMLClass := piUMLClass;
    lblNomeClasse.Caption := fUMLClass.Name;
    fClassCode := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod');
    //lblClassIDO.Caption := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO');
    //lblClasseName.Caption := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table');
  end;
  fcxCadastroDefinicaoClasse := piCadastroClasse;

  lMetaModelGenOpt.CheckDBAttributeNameLength := false;
  lMetaModelGenOpt.CheckDBTableNameLength := false;

  fUtil := TUtil.Create;
  fUtil.AlimentarMetamodel(lMetaModelGenOpt, nil);

  self.Initialize;
end;

procedure TitCadastrarFormulario.Initialize;
var lField, lResponseField, lClassField: utField;
begin
  fForms := utField.Create;
  fFormFields := utField.Create;
  lResponseField := utField.Create;

  lField := utField.Create;
  lClassField := lField.AddField('Class');
  lClassField.AddAttribute('name').AsString := fUMLClass.Name;
  lClassField.AddAttribute('code').AsString := fClassCode;

  fcxCadastroDefinicaoClasse.rmObtemContexto(lField, lResponseField);
  SendToInterface(lResponseField);
  lvCamposClick(nil);
end;

procedure TitCadastrarFormulario.SendToInterface(piField: utField);
var
  lFieldItem: utField;
  lEnum: acEnumerator;
  lRelationName: string;
  lClass: acClassTicket;
  i: Integer;
begin
  inherited;
  fTypesField := piField.FindField('FieldTypes');
  if assigned(fTypesField) then
  begin
    cbbTipo.Items.Clear;
    lEnum := fTypesField.ChildFields.GetEnumerator;
    try
      while not lEnum.EOL do  {preenche a comboBox com os tipos de field }
      begin
        lFieldItem := lEnum.Current as utField;
        cbbTipo.AddItem(lFieldItem.Name, Pointer(lFieldItem.AttributeByName('OID').AsInteger));
        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  end;

  {preenche a combo box de opes de formulrio da classe}
  if piField.HasField('Forms') then
  begin
    fForms.Assign(piField.FieldByName('Forms'));
    lEnum := fForms.ChildFields.GetEnumerator;
    try
      while not lEnum.EOL do  {preenche a comboBox com os tipos de field }
      begin
        lFieldItem := lEnum.Current as utField;
        lFieldItem.Name := lFieldItem.AttributeByName('OID').AsString;

        if lFieldItem.HasAttribute('name') then
          cbbForm.AddItem(lFieldItem.AttributeByName('name').AsString, Pointer(lFieldItem.AttributeByName('OID').AsInteger))
        else
          cbbForm.AddItem(lFieldItem.AttributeByName('code').AsString, Pointer(lFieldItem.AttributeByName('OID').AsInteger));
        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  end;
  cbbForm.AddItem('Novo', nil);
  cbbForm.ItemIndex := 0;
  cbbFormSelect(nil);

                         
  {preenche a listview com os atributos e relaes da classe}
  //lClass := fUtil.MetaModel.ClassTicketByCode[fClassCode] as acClassTicket;
  //FillListViewClassData(lClass);


end;

procedure TitCadastrarFormulario.FillListViewClassData(piClass: acClassTicket);
var
  lRelationName: string;
  i: Integer;
begin
  for i := 0 to piClass.Attributes.Count - 1 do
  begin
    AdicionarCampo(piClass.Attributes[i]);
  end;

  for i := 0 to piClass.RelationTicketsIn.Count - 1 do
  begin
    lRelationName := acRelationTicket(piClass.RelationTicketsIn.Objects[i]).DestinationPropertyName;
    if lRelationName <> '' then AdicionarCampo(lRelationName);
  end;

  for i := 0 to piClass.RelationTicketsOut.Count - 1 do
  begin
    lRelationName := acRelationTicket(piClass.RelationTicketsOut.Objects[i]).OriginPropertyName;
    if lRelationName <> '' then AdicionarCampo(lRelationName);
  end;
end;

procedure TitCadastrarFormulario.btnSalvarClick(Sender: TObject);
var
  lField, lResponseField, lFormField, lFields, lNewForm,
  lFieldField, lTypeField, lTypeSelectRelation, lForm: utField;
  lOrder, lFormOID: Integer;
  lItem: TListItem;
begin
  if edtNomeForm.Text = '' then
      raise Exception.Create('O Formulrio deve possuir um nome.');

  lField := utField.Create;
  lFormField := lField.AddField('Form');
  if cbbForm.Text <> 'Novo' then
     lFormField.AddAttribute('OID').AsInteger := Integer(cbbForm.Items.Objects[cbbForm.ItemIndex]);

  lFormField.AddAttribute('name').AsString := edtNomeForm.Text;
  lFields := lFormField.AddField('Fields');

  lOrder := 0;
  for lItem in lvCampos.Items do
  begin
    if lItem.Checked then
    begin
      if (lItem.Caption = '') or (lItem.SubItems[__DISPLAY_NAME] = '')then
        raise Exception.Create('Todos os campos devem possuir um nome e um display nome');
      if lItem.SubItems[__TIPO] = '' then
        raise Exception.Create('O campo ''' + lItem.Caption + ''' deve possuir um tipo');

      if lItem.SubItems[__TIPO] = 'ftSelectRelation' then
      begin
        lTypeSelectRelation := fFormFields.FieldByName(lItem.SubItems[__ID]).FieldByName('Type');

        if not lTypeSelectRelation.HasField('labelAttribute') then
        begin
          raise Exception.Create('O campo ''' + lItem.Caption + ''' deve preencher o valor da Key: ''labelAttribute''');
        end
      end;

      lFieldField := lFields.AddField('Field');
      lFieldField.AddAttribute('name').AsString := lItem.Caption;
      lFieldField.AddAttribute('displayName').AsString := lItem.SubItems[__DISPLAY_NAME];
      lFieldField.AddAttribute('order').AsInteger := lOrder;
      lFieldField.AddAttribute('required').AsBoolean := (lItem.SubItems[__OBRIGATORIO] = 'S');
      lFieldField.AddAttribute('id').AsInteger := StrToInt(lItem.SubItems[__ID]);

      lTypeField := lFieldField.AddField('Type');
      lTypeField.Assign(fFormFields.FieldByName(lItem.SubItems[__ID]).FieldByName('Type'));

      lOrder := lOrder + 1;
    end;
  end;

  if not lFields.HasField('Field') then
    raise Exception.Create('O formulrio deve possuir pelo menos um campo, use as CheckBoxes para escolhe-los.');

  lResponseField := utField.Create;
  fcxCadastroDefinicaoClasse.rmSalvaObjeto(lField, lResponseField);

  {caso tenha sido salvo com sucesso}
  if lResponseField.HasField('Form') then
  begin
    application.MessageBox('Formulrio salvo com sucesso.','StarUML', MB_ICONASTERISK + MB_OK);

    lForm := lResponseField.FieldByName('Form');
    lFormOID := lForm.AttributeByName('OID').AsInteger;

    if cbbForm.Text = 'Novo' then
    begin
      lblCodigoForm.Caption := IntToStr(lFormOID);
      cbbForm.Items.Objects[cbbForm.ItemIndex] := Pointer(lFormOID);
      cbbForm.AddItem('Novo', nil);

      lForm.Name := IntToStr(lFormOID);
      lNewForm := fForms.AddField(IntToStr(lFormOID));
      lNewForm.Assign(lForm);
    end
    else
    begin
      lForm.Name := IntToStr(lFormOID);
      fForms.FieldByName(IntToStr(lFormOID)).Assign(lForm);
    end;

    cbbForm.Items[cbbForm.ItemIndex] := lForm.AttributeByName('name').AsString;
    cbbForm.ItemIndex := cbbForm.Items.IndexOf(lForm.AttributeByName('name').AsString);
    edtNomeForm.Text := lForm.AttributeByName('name').AsString;
  end
  else raise Exception.Create('Erro ao salvar formulrio.');

end;

function TitCadastrarFormulario.AdicionarCampo (piName : string) : TListItem;
var
  lItem : TListItem;
begin
  lItem := lvCampos.FindCaption(0, piName, False, True, False);

  if lItem = nil then
  begin
    fIdCount := fIdCount + 1;
    fFormFields.AddField(IntToStr(fIdCount));

    lItem := lvCampos.Items.Add;
    lItem.Caption := piName;
    //lItem.Checked := True;

    with lItem.SubItems do
    begin
      Add(piName);             //nome do atributo
      Add('N');                //requerido
      Add(IntToStr(fIdCount)); //ID
      Add('');                 //tipo
    end;
  end
  else lvCampos.Selected := lItem;
  Result := lItem;
end;

procedure TitCadastrarFormulario.btnAddClick(Sender: TObject);
begin
  if edtCampo.Text <> '' then
  begin
    AdicionarCampo(edtCampo.Text);
    edtCampo.Clear;
  end;
end;

procedure TitCadastrarFormulario.edtCampoKeyPress(Sender: TObject; var Key: Char);
begin
  if Ord(Key) = VK_RETURN then
  begin
    btnAdd.Click;
  end;
end;

procedure TitCadastrarFormulario.btnCancelarClick(Sender: TObject);
begin
  Self.Close;
end;

procedure MoveListViewItem(ListView: TListView; IndexFrom, IndexTo: Integer);
var
  Source, Target: TListItem;
begin
  listview.Items.BeginUpdate;
  try
    Source := listview.Items[IndexFrom];
    Target := listview.Items.Insert(IndexTo);
    Target.Assign(Source);
    Target.Checked := Source.Checked;
    Source.Free;
  finally
    listview.Items.EndUpdate;
  end;
end;

procedure TitCadastrarFormulario.btnDownClick(Sender: TObject);
var
  lIndex : Integer;
begin
  lIndex := lvCampos.Selected.Index;
  if lIndex <> lvCampos.Items.Count - 1 then
  begin
    MoveListViewItem(lvCampos, lIndex, lIndex + 2);
    lvCampos.Selected := lvCampos.Items[lIndex + 1];
  end;
  lvCampos.SetFocus;
end;

procedure TitCadastrarFormulario.btnUpClick(Sender: TObject);
var
  lIndex : Integer;
begin
  lIndex := lvCampos.Selected.Index;
  if lIndex <> 0 then
  begin
    MoveListViewItem(lvCampos, lIndex, lIndex - 1);
    lvCampos.Selected := lvCampos.Items[lIndex - 1];
  end;
  lvCampos.SetFocus;
end;

procedure TitCadastrarFormulario.cbbFormSelect(Sender: TObject);
var
  lFieldItem : utField;
  lFieldName, lFormOID: string;
  lEnum : acEnumerator;
  lItem: TListItem;
  lId : Integer;
  lClass: acClassTicket;
begin
  lvCampos.Clear;
  lblCodigoForm2.Caption := '';
  edtNomeForm.Clear;
  fIdCount := 0;

  if cbbForm.Text = 'Novo' then
  begin
    if not fForms.HasField('Novo') then fForms.AddField('Novo');
    if fFormFields <> nil then fFormFields.Free;
    fFormFields := utField.Create;
  end
  else
  begin
    lFormOID := IntToStr(Integer(cbbForm.Items.Objects[cbbForm.ItemIndex]));
    lblCodigoForm2.Caption := lFormOID;
    fFormFields.Assign(fForms.FieldByName(lFormOID).FieldByName('Fields'));

    if fForms.FieldByName(lFormOID).HasAttribute('name') then
      edtNomeForm.Text := fForms.FieldByName(lFormOID).AttributeByName('name').AsString;

    lEnum := fFormFields.GetFieldsEnumerator;
    try
      while not lEnum.EOL do
      begin
        lFieldItem := lEnum.Current as utField;
        if lFieldItem.Name <> 'Field' then Break;

        lFieldName := lFieldItem.AttributeByName('name').AsString;
        lId := lFieldItem.AttributeByName('id').AsInteger;

        if lId > fIdCount then fIdCount := lId - 1;

        lItem := AdicionarCampo(lFieldName);
        lItem.Checked := True;
        lItem.SubItems[__DISPLAY_NAME] := lFieldItem.AttributeByName('displayName').AsString;
        lItem.SubItems[__OBRIGATORIO] := lFieldItem.AttributeByName('required').AsString;
        lItem.SubItems[__ID] := lFieldItem.AttributeByName('id').AsString;
        lItem.SubItems[__TIPO] := lFieldItem.FieldByName('Type').AttributeByName('name').AsString;

        lFieldItem.Name := IntToStr(lId);

        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  end;

  lClass := fUtil.MetaModel.GetClassTicketByCode(fClassCode) as acClassTicket;
  FillListViewClassData(lClass);
  lvCampos.Selected := nil;
  lvCamposClick(nil);
end;

procedure TitCadastrarFormulario.btnExcluirClick(Sender: TObject);
var
  lField, lResponseField, lFormField: utField;
  lClass: acClassTicket;
begin
  if cbbForm.Text = 'Novo' then
  begin
    lvCampos.Clear;
    cbbFormSelect(nil);
  end
  else
  begin
    lField := utField.Create;
    lResponseField := utField.Create;

    lFormField := lField.AddField('Form');
    lFormField.AddAttribute('OID').AsInteger := Integer(cbbForm.Items.Objects[cbbForm.ItemIndex]);

    fcxCadastroDefinicaoClasse.rmExcluiObjeto(lField, lResponseField);

    cbbForm.Items.Delete(cbbForm.ItemIndex);
    cbbForm.ItemIndex := 0;
    cbbFormSelect(nil);
  end;
end;

procedure TitCadastrarFormulario.cbbTipoChange(Sender: TObject);
var
  lField, lTypeField : utField;
begin
  lvCampos.Selected.SubItems[__TIPO] := cbbTipo.Text;

  lField := fFormFields.FieldByName(lvCampos.Selected.SubItems[__ID]);

  if lField.HasField('Type') then
    lField.RemoveField(lField.FieldByName('Type'));

  lTypeField := lField.AddField('Type');
  lTypeField.AddAttribute('name').AsString := cbbTipo.Text;
  lTypeField.AddAttribute('OID').AsInteger := Integer(cbbTipo.Items.Objects[cbbTipo.ItemIndex]);

  if cbbTipo.ItemIndex <> -1 then
  begin
     lstAtributosFill(cbbTipo.Text);
  end;
end;

procedure TitCadastrarFormulario.lstAtributosFill(piType: string);
var
  lEnum : acEnumerator;
  lFieldItem, lTypeField :utField;
  lValue, lAttribute : string;
  lIndex : Integer;
begin
  lstAtributos.Clear;
  lEnum := fTypesField.FieldByName(piType).FieldByName('Attributes').ChildFields.GetEnumerator;
  try
    while not lEnum.EOL do  {preenche a ValueList com os atributos do tipo de field }
    begin
      lFieldItem := lEnum.Current as utField;

      lAttribute := lFieldItem.Name;

      lValue := '';
      if fFormFields.FieldByName(lvCampos.Selected.SubItems[__ID]).HasField('Type') then
      begin
        lTypeField := fFormFields.FieldByName(lvCampos.Selected.SubItems[__ID]).FieldByName('Type');
        if lTypeField.HasField(lAttribute) then
          lValue := lTypeField.FieldByName(lAttribute).AttributeByName('value').AsString;
      end;

      lIndex := lstAtributos.InsertRow(lAttribute, lValue, True);
      lstAtributos.Strings.Objects[lIndex] := Pointer(lFieldItem.AttributeByName('OID').AsInteger);

      if lFieldItem.AttributeByName('type').AsInteger = __BOOLEAN then
      begin
        lstAtributos.ItemProps[lAttribute].EditStyle := esPickList;
        lstAtributos.ItemProps[lAttribute].PickList.Add('True');
        lstAtributos.ItemProps[lAttribute].PickList.Add('False');
      end;

      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

procedure TitCadastrarFormulario.edtNomeChange(Sender: TObject);
begin
  if lvCampos.SelCount <> 0 then
    lvCampos.Selected.Caption := edtNome.Text;
end;

procedure TitCadastrarFormulario.edtDisplayNomeChange(Sender: TObject);
begin
  if lvCampos.SelCount <> 0 then
    lvCampos.Selected.SubItems[__DISPLAY_NAME] := edtDisplayNome.Text;
end;

procedure TitCadastrarFormulario.lstAtributosValidateEntry(sender: TObject;
  aCol, aRow: Integer; const OldValue: string; var NewValue: String);
var
  lField, lAttributeField, lTypeField : utField;
  lOID, lAttributeType, lIntValue : Integer;
  lBoolValue: Boolean;
  lKeyName : string;
 begin
  if NewValue <> OldValue then
  begin
    lKeyName := lstAtributos.Keys[aRow];
    lTypeField := fTypesField.FieldByName(lvCampos.Selected.SubItems[__TIPO]);
    lAttributeType := lTypeField.FieldByName('Attributes').FieldByName(lKeyName).AttributeByName('type').AsInteger;

    if NewValue = '' then
    begin
      lField := fFormFields.FieldByName(lvCampos.Selected.SubItems[__ID]).FieldByName('Type');
      if lField.HasField(lKeyName) then
        lField.RemoveField(lField.FieldByName(lKeyName));
      Exit;
    end;

    if (lAttributeType = __NUMBER) and (TryStrToInt(NewValue, lIntValue) = False) then
       raise Exception.Create('Atributo ' + lKeyName + ' deve ser do tipo INTEGER');

    if (lAttributeType = __BOOLEAN) and (TryStrToBool(NewValue, lBoolValue) = False) then
      raise Exception.Create('Atributo ''' + lKeyName + ''' deve ser do tipo BOOLEAN');

    //caso os dados estejam validos:
    lOID := Integer(lstAtributos.Strings.Objects[lstAtributos.Strings.IndexOfName(lKeyName)]);
    lField := fFormFields.FieldByName(lvCampos.Selected.SubItems[__ID]).FieldByName('Type');
    if lField.HasField(lKeyName) then
    begin
      lAttributeField := lField.FieldByName(lKeyName);
      lAttributeField.AttributeByName('OID').AsInteger := lOID;
      lAttributeField.AttributeByName('value').AsString := NewValue;
    end
    else
    begin
      lAttributeField := lField.AddField(lKeyName);
      lAttributeField.AddAttribute('OID').AsInteger := lOID;
      lAttributeField.AddAttribute('value').AsString := NewValue;
    end;
  end;
end;

procedure TitCadastrarFormulario.rbNaoChange(Sender: TObject);
begin
  if lvCampos.SelCount <> 0 then
    lvCampos.Selected.SubItems[__OBRIGATORIO] := 'N';
end;

procedure TitCadastrarFormulario.rbSimChange(Sender: TObject);
begin
  if lvCampos.SelCount <> 0 then
    lvCampos.Selected.SubItems[__OBRIGATORIO] := 'S';
end;

procedure TitCadastrarFormulario.lvCamposClick(Sender: TObject);
begin
  if lvCampos.SelCount = 0 then
  begin
    rbSim.Enabled := False;
    rbNao.Enabled := False;
    btnUp.Enabled := False;
    btnDown.Enabled := False;
    cbbTipo.Enabled := False;
    lblOrdem.Enabled := False;
    lblObrigatorio.Enabled := False;
    lblTipoAtributo.Enabled := False;
    lblNome.Enabled := False;
    lblDisplayNome.Enabled := False;
    edtNome.Clear;
    edtDisplayNome.Clear;
    edtNome.Enabled := False;
    edtDisplayNome.Enabled := False;
    lstAtributos.Enabled := False;
    lstAtributos.Clear;
  end
  else
  begin                         
    rbSim.Enabled := True;
    rbNao.Enabled := True;
    btnUp.Enabled := True;
    btnDown.Enabled := True;
    cbbTipo.Enabled := True;
    lblOrdem.Enabled := True;
    lblObrigatorio.Enabled := True;
    lblTipoAtributo.Enabled := True;
    lblNome.Enabled := True;
    lblDisplayNome.Enabled := True;
    edtNome.Enabled := True;
    edtDisplayNome.Enabled := True;
    lstAtributos.Enabled := True;
  end;
end;

procedure TitCadastrarFormulario.lvCamposSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  if Selected then
  begin
    edtNome.Text := Item.Caption;
    edtDisplayNome.Text := Item.SubItems[__DISPLAY_NAME];

    if Item.SubItems[__OBRIGATORIO] = 'N' then
      rbNao.Checked := True
    else
      rbSim.Checked := True;

    if Item.SubItems[__TIPO] = '' then
    begin
      cbbTipo.ItemIndex := -1;
      lstAtributos.Clear;
    end
    else
    begin
      cbbTipo.ItemIndex := cbbTipo.Items.IndexOf(Item.SubItems[__TIPO]);
      lstAtributosFill(Item.SubItems[__TIPO]);
    end;
  end;
end;

procedure TitCadastrarFormulario.FormDestroy(Sender: TObject);
begin
  if Assigned(fTypesField) then
    fTypesField.Free;
  if Assigned(fForms) then
    fForms.Free;
  if Assigned(fFormFields) then
    fFormFields.Free;
end;

end.
