unit cxuCadastroDefinicaoClasse;

interface

uses cxuUseCase, utuMessage;

type

  cxCadastroDefinicaoClasse = class(cxUseCase)
  protected
    function GetUseCaseCode: String; override;
  public
    procedure rmObtemContexto(piField: utField; const piResponseField: utField = nil);
    procedure rmIncluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmExcluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmEditaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmSalvaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmConsultaObjeto(piField: utField; const piResponseField: utField = nil);
  end;

implementation

{ cxCadastroDefinicaoClasse }

procedure cxCadastroDefinicaoClasse.rmObtemContexto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_OBTER_CONTEXTO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroDefinicaoClasse.rmSalvaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_SALVAR', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroDefinicaoClasse.rmExcluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EXCLUIR', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroDefinicaoClasse.rmIncluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_INCLUIR', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroDefinicaoClasse.rmConsultaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_CONSULTA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadastroDefinicaoClasse.rmEditaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EDITA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

function cxCadastroDefinicaoClasse.GetUseCaseCode: String;
begin
  result := '3565';
end;

end.
