unit DelphiAddInObj;

interface

uses
  LCLType, IntegracaoDelphiSUML, StarUMLintf, cxuSession, Classes;


type

  { TDelphiAddInObj }

  TDelphiAddInObj = class
  public
    EventPub: IEventPublisher;
    function GetSelectedModel: IModel;

    class procedure ActionMenu_LoadMethods;

    class procedure ActionMenu_GenerateRegisterModelMappings;
    class procedure ActionMenu_GeneratePreview;
    class procedure ActionMenu_CodeGenerator;
    class procedure ActionMenu_XSDEditor;

    class procedure ActionMenu_InsertUseCase;
    class procedure ActionMenu_InsertClass;
    class procedure ActionMenu_EditClass;
    class procedure ActionMenu_EditUseCase;

    class procedure ActionMenu_ElementDocumentation;
    class procedure ActionMenu_UseCaseXSDsEditor;

    class procedure ActionMenu_ExportDiagramClasses;
    class procedure ActionMenu_ExportPackageClasses;
    class procedure ActionMenu_ExportUseCases;

    class procedure ActionMenu_OQLV2;
    class procedure ActionMenu_CXOQLV2;

    class procedure ActionMenu_DynamoDefinition;

    procedure ListOwnedClasses( piPackage : IUMLPackage ; piObjectList : TInterfaceList ; piStringList : TStringList);
    procedure ListOwnedUseCases ( piPackage : IUMLPackage ; piObjectList : TInterfaceList ; piStringList : TStringList);

    class function GetServiceSession: cxSession;
    class function DoMenuAction(const ActionID: Integer): Integer;
//    function NotifyEvent(AEvent: EventKind): HResult; stdcall;
  end;


implementation

uses
  InstantCode, SysUtils, Mostra_Processamento, utuStateMachine, fCodeGen, Controls, Forms,
  fModelMappingsGenerationOptions, fXSDEditor, ituDataBaseLogin, formMemo,
  cxuCadastroClasse, cxuCadastroCasoDeUso, ituCadastrarDefinicao, ituCadastrarFormulario,
  utuMessage, uCadastroCasoDeUso, uCadastroClasse, ituServiceParameters, ituExplorerV2,
  Registry, uRTFEditor, ituXSDExplorer, ituExportUnits, ituOQLExplorerV2, cxuCadastroDefinicaoClasse;

//procedure TDelphiAddInObj.NotifyUpdate(piMsg: string);
//begin
//  MessageDlg(piMsg, mtInformation, [mbOk], 0);
//end;

procedure TDelphiAddInObj.ListOwnedClasses(piPackage: IUMLPackage; piObjectList: TInterfaceList; piStringList: TStringList);
var
  lEnum : Integer;
  lClass: IUMLClass;
  lPackage : IUMLPackage;
begin
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1 do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLPackage, lPackage) = S_OK then
      ListOwnedClasses(lPackage,piObjectList,piStringList);
  end;
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1  do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLClass, lClass) = S_OK then
    begin
      piObjectList.Add(lClass);
      piStringList.Add(lClass.Pathname );
    end;
  end;
end;

procedure TDelphiAddInObj.ListOwnedUseCases(piPackage: IUMLPackage; piObjectList: TInterfaceList; piStringList: TStringList);
var
  lEnum : Integer;
  lUseCase: IUMLUseCase;
  lPackage : IUMLPackage;
begin
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1 do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLPackage, lPackage) = S_OK then
      ListOwnedUseCases(lPackage,piObjectList,piStringList);
  end;
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1  do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLUseCase, lUseCase) = S_OK then
    begin
      piObjectList.Add(lUseCase);
      piStringList.Add(lUseCase.Pathname );
    end;
  end;
end;


function TDelphiAddInObj.GetSelectedModel: IModel;
begin
  result := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
end;

class function TDelphiAddInObj.GetServiceSession: cxSession;
var lServiceParamDialog: TitServiceParameters;
    lReg: TRegistry;
begin
  lServiceParamDialog := TitServiceParameters.Create(nil);
  try
    lReg := TRegistry.Create;
    try
      lReg.RootKey := HKEY_CURRENT_USER;
      lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(gStarUMLApp.ProjectManager.FileName) + '\Service', true);

      if lReg.ValueExists('SERVICE_SERVERNAME') then lServiceParamDialog.ServerName := lReg.ReadString('SERVICE_SERVERNAME');
      if lReg.ValueExists('SERVICE_PORTNUMBER') then lServiceParamDialog.PortNumber := lReg.ReadInteger('SERVICE_PORTNUMBER');
      if lReg.ValueExists('SERVICE_SYSTEMCODE') then lServiceParamDialog.SystemCode := lReg.ReadInteger('SERVICE_SYSTEMCODE');
      if lReg.ValueExists('SERVICE_USERNAME')   then lServiceParamDialog.UserName := lReg.ReadString('SERVICE_USERNAME');
      if lReg.ValueExists('SERVICE_PASSWORD')   then lServiceParamDialog.Password := lReg.ReadString('SERVICE_PASSWORD');

      if lServiceParamDialog.ShowModal = mrok then
      begin
        lReg.WriteString('SERVICE_SERVERNAME', lServiceParamDialog.ServerName);
        lReg.WriteInteger('SERVICE_PORTNUMBER', lServiceParamDialog.PortNumber);
        lReg.WriteInteger('SERVICE_SYSTEMCODE', lServiceParamDialog.SystemCode);
        lReg.WriteString('SERVICE_USERNAME', lServiceParamDialog.UserName);
        lReg.WriteString('SERVICE_PASSWORD', lServiceParamDialog.Password);

        gStarUMLApp.ProjectManager.Project.SetTaggedValueAsInteger('DBMappings', 'ProjectMap', 'SystemCode', lServiceParamDialog.SystemCode);
        gStarUMLApp.ProjectManager.Project.SetTaggedValueAsInteger('DBMappings', 'ProjectMap', 'PortNumber', lServiceParamDialog.PortNumber);

        result := lServiceParamDialog.Session;
      end
      else
        result := Nil;
    finally
      lReg.free;
    end;
  finally
    lServiceParamDialog.Free;
  end;

end;

class function TDelphiAddInObj.DoMenuAction(const ActionID: Integer): Integer;
begin
  try
    Result := S_OK;
    case ActionID of
      1: ActionMenu_GenerateRegisterModelMappings;
      2: ActionMenu_GeneratePreview;
      3: ActionMenu_LoadMethods;
      6: ActionMenu_CodeGenerator;
      7: ActionMenu_XSDEditor;
      8: ActionMenu_InsertUseCase;
      9: ActionMenu_InsertClass;
      10: ActionMenu_EditClass;
      11: ActionMenu_EditUseCase;
      12: ActionMenu_ElementDocumentation;
      13: ActionMenu_UseCaseXSDsEditor;
      15: ActionMenu_ExportDiagramClasses;
      16: ActionMenu_ExportPackageClasses;
      17: ActionMenu_ExportUseCases;
      18: ActionMenu_OQLV2;
      19: ActionMenu_CXOQLV2;
      20: ActionMenu_DynamoDefinition;
    end;
  except
    on E: Exception do
    begin
      Application.MessageBox(PAnsiChar(e.Message), 'Staruml', MB_ICONERROR);
    end;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_GenerateRegisterModelMappings;
var lUtilitario: TUtil;
    lProgress: TFShowProgress;
    lsModelMappingsFileName, lsModelMappingsPath: string;
    lModelMappingsOptionsForm: TModelMappingsGenerationOptions;
    lModelMappingsOptions: TModelMappingsOptions;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lsModelMappingsFileName := '';
  lsModelMappingsPath := '';
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  /////////////////////////////////////////////////////////////////////////
  lModelMappingsOptionsForm := TModelMappingsGenerationOptions.Create(nil);
  try
    if lModelMappingsOptionsForm.ShowModal = mrok then
    begin
      lsModelMappingsPath := lModelMappingsOptionsForm.dlbDirectory.Path;
      lsModelMappingsFileName := lModelMappingsOptionsForm.edtFileName.Text;
      lModelMappingsOptions.IgnoreXSDSchema := lModelMappingsOptionsForm.ckbIgnoreXSD.Checked;
      lModelMappingsOptions.FileName := IncludeTrailingBackslash(trim(lsModelMappingsPath)) +  lsModelMappingsFileName;
      if lModelMappingsOptionsForm.rdObjectPascal.Checked
        then lModelMappingsOptions.TargetLanguage := 'O'
        else if lModelMappingsOptionsForm.rdCSharp.Checked
          then lModelMappingsOptions.TargetLanguage := 'C'
          else lModelMappingsOptions.TargetLanguage := 'J';
    end
    else
      lModelMappingsOptions.FileName := '';
  finally
    lModelMappingsOptionsForm.Free;
  end;

  if lModelMappingsOptions.FileName <> '' then
  begin
    lProgress := TFShowProgressForm.create('Creating Meta Model...');
    try                     
      lUtilitario := TUtil.Create;
      try
        if lModelMappingsOptions.TargetLanguage = 'O' then
        begin
          lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings(lModelMappingsOptions, lProgress);
        end
        else if lModelMappingsOptions.TargetLanguage = 'C' then
        begin
          lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings_CSharp(lModelMappingsOptions, lProgress);
        end
        else
        begin
          lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings_Java(lModelMappingsOptions, lProgress);
        end;
      finally
        lUtilitario.Free;
      end;
             
      application.MessageBox(PAnsiChar('File ' + lModelMappingsOptions.FileName + ' was generated.'), 'Staruml', MB_OK + MB_ICONINFORMATION);
    finally
      lProgress.Free;
    end;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_LoadMethods;
var lsResult: string;
    lUtilitario: TUtil;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

//  lUtilitario := TUtil.Create(StarUMLApp);
//  try
////        lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp);
//    if (MessageDlg('This option will overwrite class methods. Continue?', mtConfirmation, [mbYes, mbNo], 0) = mryes) then
//    begin
//      lsResult := lUtilitario.CarregaMetodo(StarUMLApp);
//      Application.MessageBox(PAnsiChar(lsResult), 'Staruml');
//    end;
//  finally
//    lUtilitario.free;
//  end;

end;

class procedure TDelphiAddInObj.ActionMenu_InsertClass;
var lCadClasse: TCadastroClasse;
    lSession: cxSession;
    lCadastroClasseUC: cxCadastroClasse;
    lModel: IModel;
    lUMLPackageAux: IUMLPackage;
begin
  lCadClasse := nil;
  lSession := GetServiceSession;
  if Assigned(lSession) then
  begin
    lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);

    lCadastroClasseUC := cxCadastroClasse.Create(lSession);
    try
      lCadClasse := TCadastroClasse.Create(nil, lCadastroClasseUC, Nil);
      try
        if lModel.QueryInterface(IUMLPackage, lUMLPackageAux) = S_OK then
        begin
          lCadClasse.ClassPackage := lModel as IUMLPackage;
        end;
        if lCadClasse.ShowModal = mrok then
          gStarUMLApp.SelectInModelExplorer(lCadClasse.UMLClass);
      finally
        lCadClasse.Free;
      end;
    finally
      lCadastroClasseUC.Free;
    end;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_CodeGenerator;
var lUtilitario: TUtil;
    lCodeGen: TCodeGen;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;
  
  lCodeGen := TCodeGen.Create(nil);
  try
    lUtilitario := TUtil.Create;
    try
      lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, nil);
      lCodeGen.Util := lUtilitario;
      lCodeGen.ShowModal;
    finally
      lUtilitario.Free;
    end;
  finally
    lCodeGen.Free;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_EditClass;
var lCadClasse: TCadastroClasse;
    lSession: cxSession;
    lCadastroClasseUC: cxCadastroClasse;
    lModel: IModel;
    lUMLClassAux: IUMLClass;
begin
  lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.QueryInterface(IUMLClass, lUMLClassAux) = S_OK then
  begin
    lUMLClassAux := lModel as IUMLClass;

    lSession := GetServiceSession;
    if Assigned(lSession) then
    begin
      lCadastroClasseUC := cxCadastroClasse.Create(lSession);
      try
        lCadClasse := TCadastroClasse.Create(nil, lCadastroClasseUC, lUMLClassAux);
        try
          if lCadClasse.ShowModal = mrok then
            gStarUMLApp.SelectInModelExplorer(lCadClasse.UMLClass);
        finally
          lCadClasse.Free;
        end;
      finally
        lCadastroClasseUC.Free;
      end;
    end;
  end else raise Exception.Create('This option is avaliable only for classes.');
end;

class procedure TDelphiAddInObj.ActionMenu_EditUseCase;
var lCadCasoDeUso: TCadastroCasoDeUso;
    lSession: cxSession;
    lCadastroCasoUsoUC: cxCadatroCasoDeUso;
    lModel: IModel;
    lUMLUseCaseAux: IUMLUseCase;
begin
  lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.QueryInterface(IUMLUsecase, lUMLUseCaseAux) = S_OK then
  begin
    lUMLUseCaseAux := lModel as IUMLUsecase;

    lSession := GetServiceSession;
    if assigned(lSession) then
    begin
      lCadastroCasoUsoUC := cxCadatroCasoDeUso.Create(lSession);
      try
        lCadCasoDeUso := TCadastroCasoDeUso.Create(nil, lCadastroCasoUsoUC, lUMLUseCaseAux);
        try
          if lCadCasoDeUso.ShowModal = mrok then
            gStarUMLApp.SelectInModelExplorer(lCadCasoDeUso.UseCase);

        finally
          lCadCasoDeUso.Free;
        end;
      finally
        lCadastroCasoUsoUC.Free;
      end;
    end;
  end
  else raise exception.Create('This option is only avaliable for Usecases.');
end;

class procedure TDelphiAddInObj.ActionMenu_GeneratePreview;
var lPreview: TPreviewClassCode;
    lUtilitario: TUtil;
    lModel: IModel;
    lUMLClasAux: IUMLClass;
    lUMLAssociationAux: IUMLAssociation;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  lUtilitario := TUtil.Create;
  try
    lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
    if lModel.QueryInterface(IUMLClass, lUMLClasAux) = S_OK then
    begin
      lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, nil);
      lPreview := TPreviewClassCode.Create(nil);
      try
//        inserir preview para oracle
        lPreview.mem_ClassPascal.Lines.Text := lUtilitario.GerarClassPreview_Pascal(lModel as IUMLClass);
        lPreview.mem_ClassCSharp.Lines.Text := lUtilitario.GerarClassPreview_CSharp(lModel as IUMLClass);
        lPreview.mem_ClassJava.Lines.Text := lUtilitario.GerarClassPreview_Java(lModel as IUMLClass);
        lPreview.mem_ClassSQL.Lines.Text := lUtilitario.GerarSQLPreview(lModel);
        lPreview.mem_ClassOracle.Lines.Text := lUtilitario.GerarSQLPreview(lModel, dbvOracle);
        lPreview.ShowModal;
      finally
        FreeAndNil(lPreview);
      end;
    end
    else
      if lModel.QueryInterface(IUMLAssociation, lUMLAssociationAux) = S_OK then
      begin
        lUtilitario.AlimentarMetamodel(lMetaModelGenOpt, nil);
        lPreview := TPreviewClassCode.Create(nil);
        try
          lPreview.mem_ClassSQL.Lines.Text := lUtilitario.GerarSQLPreview(lModel);
          lPreview.mem_ClassOracle.Lines.Text := lUtilitario.GerarSQLPreview(lModel, dbvOracle);
          lPreview.ShowModal;
        finally
          FreeAndNil(lPreview);
        end;
      end
      else
        raise Exception.Create('This option is avaliable only for classes and associations between classes.');
  finally
    freeandnil(lUtilitario);
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_OQLV2;
var
  lOQL: TExplorerV2;
begin
  lOQL := TExplorerV2.Create(Application);
  try
    lOQL.ShowModal;
  finally
    lOQL.Free;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_CXOQLV2;
var
  lOQLExplorer: TOQLExplorerV2;
begin
  lOQLExplorer := TOQLExplorerV2.Create(nil);
  lOQLExplorer.ShowModal;
end;

class procedure TDelphiAddInObj.ActionMenu_DynamoDefinition;
var lDynamoDef: TitCadastrarFormulario;
    lSession: cxSession;
    lCadastroDefinicaoClasseUC: cxCadastroDefinicaoClasse;
    lModel: IModel;
    lUMLPackageAux: IUMLPackage;
    lUMLClassAux: IUMLClass;
begin
  lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.QueryInterface(IUMLClass, lUMLClassAux) = S_OK then
  begin
    lUMLClassAux := lModel as IUMLClass;

    lSession := GetServiceSession;
    if Assigned(lSession) then
    begin
      lCadastroDefinicaoClasseUC := cxCadastroDefinicaoClasse.Create(lSession);
      try
        lDynamoDef := TitCadastrarFormulario.Create(nil, lCadastroDefinicaoClasseUC, lUMLClassAux);
        try
          if lDynamoDef.ShowModal = mrok then
            gStarUMLApp.SelectInModelExplorer(lDynamoDef.UMLClass);
        finally
          lDynamoDef.Free;
        end;
      finally
        lCadastroDefinicaoClasseUC.Free;
      end;
    end;
  end else raise Exception.Create('This option is avaliable only for classes.');


  //lDynamoDef := nil;
  //lSession := GetServiceSession;
  //if Assigned(lSession) then
  //begin
  //  lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
  //
  //  lCadastroDefinicaoClasseUC := cxCadastroDefinicaoClasse.Create(lSession);
  //  try
  //    lDynamoDef := TitCadastrarFormulario.Create(nil, lCadastroDefinicaoClasseUC, Nil);
  //    try
  //      if lModel.QueryInterface(IUMLPackage, lUMLPackageAux) = S_OK then
  //      begin
  //        lDynamoDef.ClassPackage := lModel as IUMLPackage;
  //      end;
  //       lDynamoDef.ShowModal;
  //      //if lDynamoDef.ShowModal = mrok then
  //      //  gStarUMLApp.SelectInModelExplorer(lCadClasse.UMLClass);
  //    finally
  //      lDynamoDef.Free;
  //    end;
  //  finally
  //    lCadastroDefinicaoClasseUC.Free;
  //  end;
  //end;
end;


class procedure TDelphiAddInObj.ActionMenu_ExportDiagramClasses;
var
  lEnum : Integer;
  listaStrings : TStringList;
  listaObjetos : TInterfaceList;
//  lClass: IUMLClass;  
  lForm : TExportUnits;
begin
  //listaStrings := TStringList.Create;
  //listaObjetos := TInterfaceList.Create;
  //try
  //  for lEnum := 0 to StarUMLApp.SelectionManager.GetSelectedViewCount - 1  do
  //  begin
  //    if StarUMLApp.SelectionManager.GetSelectedViewAt(lenum).Model.QueryInterface(IUMLClass, lClass) = S_OK then
  //    begin
  //      listaObjetos.Add(lClass);
  //      listaStrings.Add(lClass.Pathname );
  //    end;
  //  end;
  //
  //  lForm := TExportUnits.Create(nil);
  //  lForm.Position := poScreenCenter;
  //  Screen.Cursor := crHourGlass;
  //  try
  //    for lEnum := 0 to listaStrings.Count - 1 do
  //    begin
  //      lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
  //    end;
  //    lForm.lstUsecases.SelectAll;
  //    lForm.ShowModal;  
  //  finally
  //    Screen.Cursor := crDefault;
  //    lForm.Free;
  //  end;
  //
  //  finally
  //  listaStrings.Free;
  //  listaObjetos.Free;
  //end;
end;

class procedure TDelphiAddInObj.ActionMenu_UseCaseXSDsEditor;
var lXSDExplorer: TXSDExplorer;
begin
//  lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
  //if lModel.GetMetaClass.IsKindOf('UMLUseCase') then
  //begin
  //  lXSDExplorer := TXSDExplorer.Create(nil, StarUMLApp, lModel as IUMLUseCase);
  //  try
  //    lXSDExplorer.ShowModal;
  //  finally
  //    lXSDExplorer.free;
  //  end;
  //end;
end;

class procedure TDelphiAddInObj.ActionMenu_ElementDocumentation;
//var lModel: IModel;
//    lRTFEditor: TRTFEditor;
begin
  //lRTFEditor := nil;
  //lModel := GetSelectedModel;
  //if assigned(lModel) then
  //begin
  //  try
  //    lRTFEditor := TRTFEditor.Create(nil);
  //    lRTFEditor.DocWithRTFInformation := lModel.Documentation;
  //    lRTFEditor.Caption := lModel.Pathname;
  //    if lRTFEditor.ShowModal = mrok then
  //      lModel.Documentation := lRTFEditor.DocWithRTFInformation;
  //  finally
  //    lRTFEditor.free;
  //  end;
  //end
  //else
  //  raise exception.Create('This option is only avaliable for Usecases.');
end;

class procedure TDelphiAddInObj.ActionMenu_ExportPackageClasses;
//var
//  listaStrings : TStringList;
//  listaObjetos : TInterfaceList;
//  lPackage : IUMLPackage;
//  lForm : TExportUnits;
//  lEnum : Integer;
begin
  //if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLPackage, lPackage) = S_OK then
  //begin
  //  listaStrings := TStringList.Create;
  //  listaObjetos := TInterfaceList.Create;
  //  try
  //    ListOwnedClasses(lPackage,listaObjetos,listaStrings);
  //
  //    lForm := TExportUnits.Create(nil);
  //    lForm.Position := poScreenCenter;
  //    Screen.Cursor := crHourGlass;
  //    try
  //      for lEnum := 0 to listaStrings.Count - 1 do
  //      begin
  //        lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
  //      end;
  //      lForm.lstUsecases.SelectAll;
  //      lForm.ShowModal;  
  //    finally
  //      Screen.Cursor := crDefault;
  //      lForm.Free;
  //    end;
  //
  //  finally
  //    listaStrings.Free;
  //    listaObjetos.Free;
  //  end;
  //end;
end;

class procedure TDelphiAddInObj.ActionMenu_ExportUseCases;
//var
//  listaStrings : TStringList;
//  listaObjetos : TInterfaceList;
//  lPackage : IUMLPackage;
//  lUseCase: IUMLUseCase;
//  lForm : TExportUnits;
//  lEnum : Integer;
begin
  //listaStrings := TStringList.Create;
  //listaObjetos := TInterfaceList.Create;
  //try
  //  if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLPackage, lPackage) = S_OK then
  //  begin
  //    ListOwnedUseCases(lPackage,listaObjetos,listaStrings);
  //  end
  //  else
  //  begin
  //    if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLUseCase, lUseCase) = S_OK then
  //    begin
  //      listaObjetos.Add(lUseCase);
  //      listaStrings.Add(lUseCase.Pathname );
  //    end;
  //  end;
  //
  //  lForm := TExportUnits.Create(nil);
  //  lForm.Position := poScreenCenter;
  //  Screen.Cursor := crHourGlass;
  //  try
  //    for lEnum := 0 to listaStrings.Count - 1 do
  //    begin
  //      lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
  //    end;
  //    lForm.lstUsecases.SelectAll;
  //    lForm.ShowModal;  
  //  finally
  //    Screen.Cursor := crDefault;
  //    lForm.Free;
  //  end;
  //
  //finally
  //  listaStrings.Free;
  //  listaObjetos.Free;
  //end;
end;

class procedure TDelphiAddInObj.ActionMenu_InsertUseCase;
var lCadCasoDeUso: TCadastroCasoDeUso;
    lSession: cxSession;
    lCadastroCasoUsoUC: cxCadatroCasoDeUso;
    lModel: IModel;
    lUMLPackageAux: IUMLPackage;
begin
  lCadCasoDeUso := nil;
  lSession := GetServiceSession;
  if assigned(lSession) then
  begin
    lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
    lCadastroCasoUsoUC := cxCadatroCasoDeUso.Create(lSession);
    try
      lCadCasoDeUso := TCadastroCasoDeUso.Create(nil, lCadastroCasoUsoUC, Nil);
      try
        if lModel.QueryInterface(IUMLPackage, lUMLPackageAux) = S_OK then
        begin
          lCadCasoDeUso.UseCasePackage := lModel as IUMLPackage;
        end;

        if lCadCasoDeUso.ShowModal = mrok then
          gStarUMLApp.SelectInModelExplorer(lCadCasoDeUso.UseCase);

      finally
        if assigned(lCadCasoDeUso) then lCadCasoDeUso.Free;
      end;
    finally
      lCadastroCasoUsoUC.Free;
    end;
  end;
end;

class procedure TDelphiAddInObj.ActionMenu_XSDEditor;
var
    lModel: IModel;
    lUMLTransitionAux: IUMLTransition;
    lXSDEditor: TXSDEdit;
begin
  lModel := gStarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.QueryInterface(IUMLTransition, lUMLTransitionAux) = S_OK then
  begin
    lXSDEditor := TXSDEdit.Create(nil);
    try
      lXSDEditor.Transition := lModel as IUMLTransition;
      lXSDEditor.ShowModal;
    except
      FreeAndNil(lXSDEditor);
    end;
  end
  else
    raise Exception.Create('This option is avaliable only for transitions.');

end;

// TDelphiAddInObj
////////////////////////////////////////////////////////////////////////////////

end.
