library CurioAddIn;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

uses
  {$IFDEF UNIX}
  cmem,
  cwstring,
  {$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  SysUtils,
  LCLType,
  Classes,
  Interfaces,
  {$IFDEF DARWIN}
  CocoaInt,
  {$ENDIF}
  Forms,
  acuObject,
  utuMessage,
  acuRepositorySQL,
  acuSQLDialectManager,
  acuSQLDialectSQLServer,
  acuSQLDialectOracle,
  acuSQLDialectDB2,
  utuLinksManager,
  utuLinkSock,
  acuFramework,
  acuSystemCurrentConfig,
  acuApplicationLog,
  acuPersistenceLog,
  acuQuerySQLODBC,
  ituExplorerV2,
  acuAudit,
  IntegracaoDelphiSUML in 'IntegracaoDelphiSUML.pas',
  Mostra_Processamento in 'Mostra_Processamento.pas' {FMostra_Processamento},
  InstantClasses in 'InstantCode\InstantClasses.pas',
  InstantCode in 'InstantCode\InstantCode.pas',
  InstantTextFiler in 'InstantCode\InstantTextFiler.pas',
  Utility in 'Utility.pas',
  utuOQL in 'utuOQL.pas',
  utuXSD in 'utuXSD.pas',
  DelphiAddInObj in 'DelphiAddInObj.pas';

exports
  InitializeAddIn,
  FinalizeAddIn,
  DoMenuAction;

{$R *.res}

begin
  {$if declared(UseHeapTrace)}
  if UseHeaptrace then
  begin
    GlobalSkipIfNoLeaks := True;
    DeleteFile('CURIOAddIn.trc');
    SetHeapTraceOutput('CURIOAddIn.trc');
  end;
  {$ifend}

  if not assigned(acApplicationLog.Instance) then acApplicationLog.Instance := acApplicationLog.Create;
  if not assigned(acPersistenceManager.Instance) then acPersistenceManager.Instance := acPersistenceManager.Create;
  if not assigned(acPersistenceManager.Audit) then acPersistenceManager.Audit := acAudit.Create;
  if not Assigned(acPersistenceLog.Instance) then acPersistenceLog.Instance := acPersistenceLog.Create;
  if not Assigned(acSystemCurrentConfig.Instance) then acSystemCurrentConfig.Instance := acSystemCurrentConfig.Create;
  mxMessage.ChangeLocaleFormatSetting;
  acRepositorySQL.DefaultDatabaseDriver := typeOf(acDatabaseSQLODBC);
  PersistenceManager.DefaultRepositoryClass := typeOf(acRepositorySQL);
  PersistenceManager.RegisterClass(typeOf(acPersistentObject), acPersistentObjectClassFactory.Create);
  if not Assigned(acSQLDialectManager.Instance) then acSQLDialectManager.Instance := acSQLDialectManager.Create;
  acSQLDialectManager.Instance.RegisterSQLDialect('MS SQL Server', typeOf(acSQLDialectSQLServer), acSQLDialectSQLServerClassFactory.Create);
  acSQLDialectManager.Instance.RegisterSQLDialect('Oracle', typeOf(acSQLDialectOracle), acSQLDialectOracleClassFactory.Create);
  acSQLDialectManager.Instance.RegisterSQLDialect('DB2', typeOf(acSQLDialectDB2), acSQLDialectDB2ClassFactory.Create);
  if not Assigned(utLinksManager.Instance) then utLinksManager.Instance := utLinksManager.Create;
  utLinksManager.Instance.RegisterLink('tcp/ip', typeOf(utLinkSock), utLinkSockClassFactory.Create);

  {$IFDEF DARWIN}
  MainPool := Nil;
  {$ENDIF}

  Application.Initialize;

//  Application.CaptureExceptions := True;

//  ExtensionManager.LoadProfiles;
//  StarUMLApplication.OpenProject('D:\Users\sandrosantana\Documents\git\GED\mdl\GED.uml');
//  Application.CreateForm(TExplorerV2, ExplorerV2);
//  Application.Run;
end.
