unit ituOQLExplorer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, utuOQL, Menus, ComCtrls, Buttons, ActnList, ituexplorer, StarUML_TLB, ImgList,
  JvExControls, JvEditorCommon, JvEditor, JvHLEditor;

type
  TOQLExplorer = class(TForm)
    Panel1: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    alMain: TActionList;
    actNewOQL: TAction;
    actDeleteOQL: TAction;
    actSave: TAction;
    actLoad: TAction;
    actSaveAs: TAction;
    SaveDialog1: TSaveDialog;
    OpenDialog1: TOpenDialog;
    actUndo: TAction;
    imgOQLState: TImageList;
    PageControl1: TPageControl;
    tsOQL: TTabSheet;
    tsUnit: TTabSheet;
    Panel2: TPanel;
    memErro: TMemo;
    ltvOqls: TListView;
    Splitter1: TSplitter;
    Panel3: TPanel;
    Panel5: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    SpeedButton5: TSpeedButton;
    edtName: TEdit;
    edtDescription: TEdit;
    pnlExplorer: TPanel;
    memUnit: TJvHLEditor;
    SpeedButton6: TSpeedButton;
    actGenUnit: TAction;
    SaveUnit: TSaveDialog;
    rdgType: TRadioGroup;
    procedure actLoadExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure actNewOQLExecute(Sender: TObject);
    procedure actSaveOQLExecute(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure actSaveAsExecute(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure actDeleteOQLExecute(Sender: TObject);
    procedure ltvOqlsCustomDrawItem(Sender: TCustomListView; Item: TListItem; State: TCustomDrawState;
      var DefaultDraw: Boolean);
    procedure ltvOqlsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure ltvOqlsChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
    procedure actUndoExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormResize(Sender: TObject);
    procedure actGenUnitExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rdgTypeClick(Sender: TObject);
  private
    { Private declarations }
    fFlagFormClosing : Boolean; // Impede que as OQLs sejam inutilmente verificados ao fechar o form    
    fExplorer: TExplorer;
    fOQLList: utOQLFile;
    FStarUMLApp: IStarUMLApplication;
    procedure UpdateOQLList;
    procedure SelectedOQLToInterface;
    procedure InterfaceToSelectedOQL;
    function ValidaQuery(piQuery: string; piOQLType: integer): string;
    procedure SetOQLType(piOQLType: integer);
  public
    { Public declarations }
    constructor Create(piOwner: TComponent; piStarUMLApp: IStarUMLApplication); reintroduce;
  end;

var
  OQLExplorer: TOQLExplorer;

implementation

uses acuObject, acuOQL;


{$R *.dfm}

procedure TOQLExplorer.actDeleteOQLExecute(Sender: TObject);
var li: integer;
    lOQL: utOQL;
begin
  if assigned(ltvOqls.Selected) then
  begin
    lOQL := utOQL(ltvOqls.Selected.Data);
    li := ltvOqls.Selected.Index;

    ltvOqls.Selected.Delete;
    lOQL.Delete;    
    if ltvOqls.Items.Count > 0 then
      if li - 1 >= 0 then
        ltvOqls.Selected := ltvOqls.Items[li-1]
      else
        ltvOqls.Selected := ltvOqls.Items[0];
      SelectedOQLToInterface;
  end;
end;

procedure TOQLExplorer.actGenUnitExecute(Sender: TObject);
var lFileName: string;
begin
  if fOQLList.FileName = '' then
    ShowMessage('Need to save file before generation.')
  else
  begin
    InterfaceToSelectedOQL;
    fOQLList.Save;
    Screen.Cursor := crHourGlass;
    try
      memUnit.Lines.Text := fExplorer.Util.GerarUnitOQL(fOQLList.FileName, fExplorer.Session);
    finally
      Screen.Cursor := crDefault;
    end;
    PageControl1.ActivePage := tsUnit;
    if SaveUnit.Execute then
    begin
      lFileName := SaveUnit.FileName;
      if pos('.pas', lFileName) = 0 then
        lFileName := lFileName + '.pas';
      memUnit.Lines.SaveToFile(lFileName);
    end
  end;
end;

procedure TOQLExplorer.actLoadExecute(Sender: TObject);
begin
  try
    try
      OpenDialog1.InitialDir := ExtractFilePath(FStarUMLApp.ProjectManager.FileName);
      if OpenDialog1.Execute then
      begin
        ltvOqls.ItemIndex := -1;
        if assigned(fOQLList) then freeandnil(fOQLList);
        fOQLList := utOQLFile.create(OpenDialog1.FileName);
      end;
    Except
      on e:exception do
      begin
        if assigned(fOQLList) then freeandnil(fOQLList);
        fOQLList := utOQLFile.create;
        raise;
      end;
    end;
  finally
    Caption := fOQLList.FileName;
    UpdateOQLList;
  end;
end;

procedure TOQLExplorer.actNewOQLExecute(Sender: TObject);
var lListItem: TListItem;
    lOQL: utOQL;
    lCont: integer;
begin
  InterfaceToSelectedOQL;
  lCont := 1;
  while fOQLList.OQLExists('_NEW_OQL_' + inttostr(lCont)) do
    Inc(lCont);

  lOQL := fOQLList.NewOQL('_NEW_OQL_' + inttostr(lCont));
  lListItem := ltvOqls.Items.Add;
  lListItem.Caption := lOQL.ID;
  lListItem.Data := lOQL;
  lListItem.ImageIndex := 2;
  lListItem.SubItems.Add('No OQL query');
  ltvOqls.Selected := lListItem;
  SelectedOQLToInterface;
  edtName.SetFocus;
  edtName.SelectAll;
end;

procedure TOQLExplorer.actSaveAsExecute(Sender: TObject);
var lFileName: string;
begin
  lFileName := fOQLList.FileName;
  if SaveDialog1.Execute then
  begin
    lFileName := SaveDialog1.FileName;
    if pos('.cxoql', lFileName) = 0 then
      lFileName := lFileName + '.cxoql';
  end
  else Application.MessageBox('File not saved.', '', MB_ICONEXCLAMATION);

  fOQLList.Save(lFileName);
  Caption := lFileName;
  Application.MessageBox('File saved.', '', MB_ICONINFORMATION);
end;

procedure TOQLExplorer.actSaveExecute(Sender: TObject);
var lFileName: string;
begin
  InterfaceToSelectedOQL;
  lFileName := fOQLList.FileName;
  if lFileName = '' then
    if SaveDialog1.Execute then
    begin
      lFileName := SaveDialog1.FileName;
      if pos('.cxoql', lFileName) = 0 then
        lFileName := lFileName + '.cxoql';
    end
    else Application.MessageBox('File not saved.', '', MB_ICONEXCLAMATION);

  ltvOqls.SortType := stText;
  ltvOqls.SortType := stNone;
  fOQLList.Save(lFileName);
  Caption := lFileName;
  Application.MessageBox('File saved.', '', MB_ICONINFORMATION);
end;

procedure TOQLExplorer.actSaveOQLExecute(Sender: TObject);
begin
 InterfaceToSelectedOQL;
end;

procedure TOQLExplorer.actUndoExecute(Sender: TObject);
var lOQL: utOQL;
begin
  if Assigned(ltvOqls.Selected) then
  begin
    lOQL := utOQL(ltvOqls.Selected.Data);
    edtName.Text := lOQL.ID;
    edtDescription.Text := lOQL.Description;
    fExplorer.memOQLQuery.Text := lOQL.Query;
  end;
end;

procedure TOQLExplorer.Close1Click(Sender: TObject);
begin
  Close;
end;

constructor TOQLExplorer.Create(piOwner: TComponent; piStarUMLApp: IStarUMLApplication);
begin
  inherited Create(piOwner);
  fFlagFormClosing := False;  
  FStarUMLApp := piStarUMLApp;
  fExplorer := TExplorer.Create(nil);
  fExplorer.Parent := pnlExplorer;
  fExplorer.StarUMLApp := piStarUMLApp;
  fExplorer.BorderIcons := [];
  fExplorer.BorderStyle := bsNone;
  fExplorer.Align := alClient;
  fExplorer.WindowState := wsMaximized;
  fExplorer.Position := poDefaultPosOnly;
  fExplorer.ckbXMLOQLQuery.Visible := false;
  fExplorer.Show;
end;

procedure TOQLExplorer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  fFlagFormClosing := True;
  fExplorer.Close;
  Action := caFree;
end;

procedure TOQLExplorer.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var lM: integer;
begin
  lM := application.MessageBox('Save before close?', 'Attention', MB_ICONQUESTION + MB_YESNO);
  case lM of
    IDYES: actSaveExecute(sender);
    IDCANCEL: CanClose := False;
  end;
end;

procedure TOQLExplorer.FormCreate(Sender: TObject);
var lFileName: string;
begin
  lFileName := '';
//  if ParamCount > 0 then
//    if FileExists(ParamStr(1)) then
//      lFileName := ParamStr(1);
  fOQLList := utOQLFile.create(lFileName);
  UpdateOQLList;
  Caption := fOQLList.FileName;
end;

procedure TOQLExplorer.FormResize(Sender: TObject);
begin
  fExplorer.Top := 0;
  fExplorer.Left := 0;
end;

procedure TOQLExplorer.FormShow(Sender: TObject);
begin
  if fOQLList.Count = 0 then
    actNewOQLExecute(sender);
end;

procedure TOQLExplorer.InterfaceToSelectedOQL;
var lOQL: utOQL;
    lErro: string;
begin
  if Assigned(ltvOqls.Selected) then
  begin
    lOQL := utOQL(ltvOqls.Selected.Data);
    lOQL.ID := edtName.Text;
    lOQL.Description := edtDescription.Text;
    lOQL.Query := fExplorer.memOQLQuery.Text;

    lErro := '';
    if not fFlagFormClosing then
    begin
      lOQL.OQLType := rdgType.ItemIndex;
      lErro := ValidaQuery(lOQL.Query, lOQL.OQLType);
    end;
    if lErro = '' then
    begin
      if lOQL.OQLType = 1
        then ltvOqls.Selected.ImageIndex := 1
        else ltvOqls.Selected.ImageIndex := 0;
    end
    else
      ltvOqls.Selected.ImageIndex := 2;
    ltvOqls.Selected.Caption := edtName.Text;
    ltvOqls.Selected.SubItems[0] := lErro;
  end;
end;

procedure TOQLExplorer.ltvOqlsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
begin
  SelectedOQLToInterface;
end;

procedure TOQLExplorer.ltvOqlsChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
begin
  InterfaceToSelectedOQL;
end;

procedure TOQLExplorer.ltvOqlsCustomDrawItem(Sender: TCustomListView; Item: TListItem; State: TCustomDrawState;
  var DefaultDraw: Boolean);
  //var lOql: utOQL;
begin
//  if item.Data <> nil then
//  begin
//    lOql := utOQL(item.Data);
//    if loql.OQLType = 1 then
//      ltvOqls.Canvas.Brush.Color := $00FFDAD5;
//  end;
end;

procedure TOQLExplorer.rdgTypeClick(Sender: TObject);
begin
  fExplorer.ckbXMLOQLQuery.Checked := rdgType.ItemIndex = 1;
end;

procedure TOQLExplorer.UpdateOQLList;
var lListItem: TListItem;
    lEnum: acEnumerator;
    lOQL: utOQL;
    lErro: string;
begin
  ltvOqls.Items.BeginUpdate;
  try
    ltvOqls.Clear;
    lEnum := fOQLList.GetOQLEnumerator;
    try
      while not lEnum.EOL do
      begin
        lOQL := utOQL(lEnum.Current);
        lListItem := ltvOqls.Items.Add;
        lListItem.Caption := lOQL.ID;
        lListItem.Data := lOQL;
        lErro := ValidaQuery(lOQL.Query, lOQL.OQLType);
        lListItem.SubItems.Add(lErro);
        if lErro = '' then
        begin
          if lOQL.OQLType = 1
            then lListItem.ImageIndex := 1
            else lListItem.ImageIndex := 0;
        end
        else
          lListItem.ImageIndex := 2;
        lEnum.MoveNext;
      end;
    finally
      lEnum.free;
    end;
  finally
    ltvOqls.Items.EndUpdate;
  end;
  if ltvOqls.Items.Count > 0 then
  begin
    ltvOqls.ItemIndex := 0;
    SelectedOQLToInterface;
  end;
end;

function TOQLExplorer.ValidaQuery(piQuery: string; piOQLType: integer): string;
var lQuery: acAbstractOQLQuery;
begin
  result := '';
  if not fFlagFormClosing then
  begin
    try
      if Assigned(fExplorer) then
      begin
        if Assigned(fExplorer.Session) then
        begin
          if piOQLType = 1 then
            lQuery := acDataSetOQLQuery.Create(fExplorer.Session, piQuery)
          else
            lQuery := acOQLQuery.Create(fExplorer.Session, piQuery);
          lQuery.Free;
        end;
      end;
    except
      on e:exception do
      begin
        Result := e.Message;
      end;
    end;
  end;
end;

procedure TOQLExplorer.SelectedOQLToInterface;
var lOQL: utOQL;
begin
  edtName.Text := '';
  edtDescription.Text := '';
  fExplorer.memOQLQuery.Text := '';
  if Assigned(ltvOqls.Selected) then
  begin
    lOQL := utOQL(ltvOqls.Selected.Data);
    edtName.Text := lOQL.ID;
    edtDescription.Text := lOQL.Description;
    fExplorer.memOQLQuery.Text := lOQL.Query;
    memErro.Text := ltvOqls.Selected.SubItems[0];
    SetOQLType(lOQL.OQLType);
  end;
  ltvOqls.Column[0].Caption := 'OQL Name (' + IntToStr(fOQLList.Count) + ')';
end;

procedure TOQLExplorer.SetOQLType(piOQLType: integer);
begin
  rdgType.itemindex := piOQLType;
  fExplorer.ckbXMLOQLQuery.Checked := piOQLType = 1;
end;

end.
