unit ituExplorer;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Clipbrd,
  Dialogs, acuObjectExplorer, ExtCtrls, StdCtrls, ComCtrls, ElXPThemedControl,
  ElTree, ActnCtrls, StdActns, ActnList, XPStyleActnCtrls, ActnMan, ToolWin,
  ActnMenus, ImgList, acuframework, DB, DBTables, ADODB, StarUML_TLB, IntegracaoDelphiSUML,
  Menus;

type
  TExplorer = class(TForm)
    ActionManager1: TActionManager;
    Execute: TAction;
    Cancel: TAction;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    FileOpen1: TFileOpen;
    FileSaveAs1: TFileSaveAs;
    SearchFind1: TSearchFind;
    SearchReplace1: TSearchReplace;
    save: TAction;
    ModelPanel: TAction;
    ResultsPanel: TAction;
    ImageList1: TImageList;
    ActionToolBar1: TActionToolBar;
    ADOConnection1: TADOConnection;
    Panel2: TPanel;
    tvModelExplorer: TElTree;
    Splitter1: TSplitter;
    pcRepository: TPageControl;
    tsOQL: TTabSheet;
    OQLStatusBar: TStatusBar;
    Panel1: TPanel;
    Splitter2: TSplitter;
    memOQLQuery: TMemo;
    pcResult: TPageControl;
    tsObjectResults: TTabSheet;
    tsTextResults: TTabSheet;
    TextResults: TMemo;
    TabSheet1: TTabSheet;
    ckbXMLOQLQuery: TCheckBox;
    pgcResultOQLType: TPageControl;
    tbsOQLQuery: TTabSheet;
    tbsXMLOQLQuery: TTabSheet;
    OQLObjects: TObjectExplorer;
    memSQL: TMemo;
    pgcXMLOqlQuery: TPageControl;
    TabSheet2: TTabSheet;
    TabSheet3: TTabSheet;
    ltvXMLOQLQueryResult: TListView;
    memXMLOqlQuery: TMemo;
    pmCopiar: TPopupMenu;
    Copia: TMenuItem;
    procedure ExportModelExecute(Sender: TObject);
    procedure ResultsPanelExecute(Sender: TObject);
    procedure ModelPanelExecute(Sender: TObject);
    procedure memOQLQueryDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure memOQLQueryDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure saveExecute(Sender: TObject);
    procedure FileSaveAs1Accept(Sender: TObject);
    procedure FileOpen1Accept(Sender: TObject);
    procedure tsOQLShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ExecuteQuery(Sender: TObject);
    procedure tvModelExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
    procedure FormShow(Sender: TObject);
    procedure pcResultChange(Sender: TObject);
    procedure OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure CopiaDadosObjeto(Sender: TObject);
    procedure OQLObjectstvExplorerKeyUp(Sender: TObject; var Key: Word;Shift: TShiftState);
  private
    { Private declarations }
    fSession: acPersistenceSession;
    fMetaModel: acMetaModel;
    fWorkFile: string;
    fConnectionString: string;
    FStarUMLApp: IStarUMLApplication;
    fUtil: TUtil;
    procedure SetWorkFile(const Value: string);
    procedure SetMetaModel(const Value: acMetaModel);
    function GetConnectionString: string;
    function Connect: boolean;
    procedure SetStarUMLApp(const Value: IStarUMLApplication);
    procedure ResizeColumns(piListView: TListView);
    function GetStringEntreParenteses(piString : string) : string;
    function GetNumeroDeStringOID (piString : string) : string;
    procedure CopiaTextoObjeto (piObjeto : TElTreeItem);
  public
    { Public declarations }
    property Session: acPersistenceSession read fSession;
    property ConnectionString: string read fConnectionString write fConnectionString;
    property WorkFile: string read fWorkFile write SetWorkFile;
    property MetaModel: acMetaModel read fMetaModel write SetMetaModel;
    property StarUMLApp: IStarUMLApplication read FStarUMLApp write SetStarUMLApp;
    property Util: TUtil read fUtil;
  end;

  var     fExplorer: Texplorer;

implementation

{$R *.dfm}

uses ituDataBaseLogin, DBLogDlg, DateUtils, acuRepositorySQL, acuObject, acuOQL,
     utuMessage, ituOQLParams;//, IntegracaoDelphiSUML;

function TExplorer.Connect: boolean;
begin
  result := false;
  try
    gDefaultConnetionString := GetConnectionString;
    fSession := PersistenceManager.OpenSession(fMetaModel, acRepositorySQL, gDefaultConnetionString);
    result := true;
  Except
    on e:Exception do
    begin
      ShowMessage(e.Message);
    end;
  end;
end;

procedure TExplorer.CopiaDadosObjeto(Sender: TObject);
begin
  if Assigned(OQLObjects.tvExplorer.Selected) then
    CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
end;

procedure TExplorer.CopiaTextoObjeto(piObjeto: TElTreeItem);
var
  lString : string;
begin
  lString := piObjeto.Text;
  lString := GetNumeroDeStringOID(GetStringEntreParenteses(lString));
  if lString <> '' then
    Clipbrd.Clipboard.AsText := lString;
end;

procedure TExplorer.ExecuteQuery(Sender: TObject);
var lList: acPersistentObjectList;
    lStart: TDateTime;
    lOQLQuery: acAbstractOQLQuery;
    lOQLParams: TOQLParams;
    lResultField: utField;
    lEnum: acEnumerator;
    lField: utField;
    lColumn: TListColumn;
    lListItem: TListItem;
    lEnumAtt: acEnumerator;
    lFirstItemFlag: boolean;
    lCount: integer;
begin
  lCount := 0;
  if Assigned(fSession)
   then fSession := PersistenceManager.OpenSession(fMetaModel, acRepositorySQL, gDefaultConnetionString);
  if memOQLQuery.Text <> '' then
  begin
    try
      memSQL.Text := '';
      OQLObjects.SetList(nil, '');
      ltvXMLOQLQueryResult.Clear;
      ltvXMLOQLQueryResult.Columns.Clear;
      pcResult.ActivePageIndex := 0;
      if not ResultsPanel.Checked then ResultsPanel.Execute;
      if not ckbXMLOQLQuery.Checked then
      begin
        pgcResultOQLType.ActivePageIndex := 0;

        lList := acPersistentObjectList.Create(acPersistentObject);
        try
          tsObjectResults.TabVisible := True;
          tsTextResults.TabVisible := False;
          OQLStatusBar.Panels[0].Text := 'Executing query...';
          OQLStatusBar.Panels[1].Text := '';

          if memOQLQuery.SelText = ''
            then lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.Text)
            else lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.SelText);
          try
            if lOQLQuery.Parameters.Count > 0 then
            begin
              lOQLParams := TOQLParams.Create(nil, lOQLQuery);
              try
                lOQLParams.ShowModal;
              finally
                lOQLParams.free;
              end;
            end;

            lStart := Now;

            (lOQLQuery as acOQLQuery).LoadList(lList);
            memSQL.Text := lOQLQuery.SQLText;
          finally
            lOQLQuery.Free;
          end;

          OQLStatusBar.Panels[2].Text := TimeToStr(TimeOf(Now - lStart));
          OQLStatusBar.Panels[0].Text := 'Query completed.';
          if lList.Count <= 1 then
            OQLStatusBar.Panels[1].Text := inttostr(lList.Count) + ' object'
          else
            OQLStatusBar.Panels[1].Text := inttostr(lList.Count) + ' objects';
          OQLObjects.SetList(lList, 'OQL Results');
        finally
          lList.Free;
        end;
      end
      else
      begin
        pgcResultOQLType.ActivePageIndex := 1;
        pgcXMLOqlQuery.ActivePageIndex := 0;
        tsObjectResults.TabVisible := True;
        tsTextResults.TabVisible := False;
        OQLStatusBar.Panels[0].Text := 'Executing query...';
        OQLStatusBar.Panels[1].Text := '';

        if memOQLQuery.SelText = ''
          then lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.Text)
          else lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.SelText);
        try
          if lOQLQuery.Parameters.Count > 0 then
          begin
            lOQLParams := TOQLParams.Create(nil, lOQLQuery);
            try
              lOQLParams.ShowModal;
            finally
              lOQLParams.free;
            end;
          end;

          lStart := Now;

          lResultField := utField.Create;
          try
            lResultField.Name := 'ROOT';
            (lOQLQuery as acDataSetOQLQuery).LoadDataSet(lResultField);
            memSQL.Text := lOQLQuery.SQLText;
            memXMLOqlQuery.Text := lResultField.GetXMLString([xoLegible]);

            ltvXMLOQLQueryResult.Items.BeginUpdate;
            try
              //Adiciona as colunas no listview
              if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('METADATA')) then
              begin
                lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('METADATA').FieldByName('FIELDS').GetFieldsEnumerator;
                try
                  while not lEnum.EOL do
                  begin
                    lField := utField(lEnum.Current);
                    lColumn := ltvXMLOQLQueryResult.Columns.Add;
                    lColumn.Caption := lField.AttributeByName('Name').AsString;
                    lEnum.MoveNext;
                  end;
                finally
                  lEnum.Free;
                end;
              end;

              if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('ROWDATA')) then
              begin
                lCount := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').AttributeByName('Count').AsInteger;
                lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').GetFieldsEnumerator;
                try
                  while not lEnum.EOL do
                  begin
                    lField := utField(lEnum.Current);
                    lListItem := ltvXMLOQLQueryResult.Items.Add;
                    lEnumAtt := lField.GetAttibutesEnumerator;
                    try
                      lFirstItemFlag := true;
                      while not lEnumAtt.EOL do
                      begin
                        if lFirstItemFlag then
                        begin
                          lListItem.Caption := utAttribute(lEnumAtt.Current).AsString;
                          lFirstItemFlag := false;
                        end
                        else
                          lListItem.SubItems.Add(utAttribute(lEnumAtt.Current).AsString);
                        lEnumAtt.MoveNext;
                      end;
                    finally
                      lEnumAtt.Free;
                    end;
                    lEnum.MoveNext;
                  end;
                finally
                  lEnum.Free;
                end;
              end;
            finally
              ltvXMLOQLQueryResult.Items.EndUpdate;
            end;

          finally
            lResultField.free;
          end;
          ResizeColumns(ltvXMLOQLQueryResult);
        finally
          lOQLQuery.Free;
        end;
        OQLStatusBar.Panels[2].Text := TimeToStr(TimeOf(Now - lStart));
        if lCount <= 1 then
          OQLStatusBar.Panels[1].Text := inttostr(lCount) + ' row'
        else
          OQLStatusBar.Panels[1].Text := inttostr(lCount) + ' rows';
        OQLStatusBar.Panels[0].Text := 'Query completed.';
      end;
    except
      on e: Exception do
        begin
          TextResults.Text := e.Message;
          OQLStatusBar.Panels[0].Text := 'Query completed with errors.';
          tsTextResults.TabVisible := True;
          tsObjectResults.TabVisible := False;
        end;
    end;
  end;
end;

procedure TExplorer.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if assigned(fSession) then fSession.Free;
  if assigned(futil) then fUtil.Free;
  FStarUMLApp := nil;
  Action := caFree;
  fExplorer := nil;
end;

procedure TExplorer.FormShow(Sender: TObject);
var
    lDataBaseLogin: TDataBaseLogin;
    lConnected: boolean;
    lModalResult: Integer;
begin
  lModalResult := mrok;

  lConnected := false;
  lDataBaseLogin := TDataBaseLogin.Create(nil);
  try
    lDataBaseLogin.ProjectFileName := ExtractFileName(StarUMLApp.ProjectManager.FileName);
    while (lModalResult = mrOk) and (not lConnected) do
    begin
      lModalResult := lDataBaseLogin.ShowModal;
      if lModalResult = mrok then
      begin
        fConnectionString := lDataBaseLogin.ConnectionString;
        lConnected := Connect;
      end;
    end;
  finally
    lDataBaseLogin.Free;
  end;

  OQLObjects.Align := alClient;
  pcResult.Visible := false;
  Splitter2.Align := alNone;
//  memOQLQuery.Align := alClient;
end;

function TExplorer.GetConnectionString: string;
begin
  Result := fConnectionString;
end;

function TExplorer.GetNumeroDeStringOID(piString: string): string;
var
  lString : string;
  lEnum : Integer;
begin
  lString := '';
  // Verifica se a string tem mais que 4 caracteres
  if  Length(piString) > 4  then
  begin
    // Extrai os 4 primeiros caracteres da string
    for lEnum := 1 to 4  do
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Se a string comear com OID: esses 4 primeiro caracteres sero excludos
    if lString = 'OID:' then
    begin
      lString := '';
      for lEnum := 5 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end
    // Caso contrrio copia-se a string toda
    else
    begin
      lString := '';
      for lEnum := 1 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end;
  end
  else
  begin
    lString := piString;
  end;
  Result := lString;  
end;

procedure TExplorer.tsOQLShow(Sender: TObject);
begin
  self.memOQLQuery.SetFocus;
end;

procedure TExplorer.FileOpen1Accept(Sender: TObject);
begin
  WorkFile := (Sender as TFileOpen).Dialog.FileName;
  memOQLQuery.Lines.LoadFromFile(WorkFile);
end;

procedure TExplorer.FileSaveAs1Accept(Sender: TObject);
begin
  memOQLQuery.Lines.SaveToFile((Sender as TFileSaveAs).Dialog.FileName);
  WorkFile := (Sender as TFileSaveAs).Dialog.FileName;
end;

function TExplorer.GetStringEntreParenteses(piString: string) : string;
var
  lString : string;
  lEnum : Integer;
  flagDadosDesejados : Boolean;
begin
  flagDadosDesejados := False;
  lString := '';
  for lEnum := 1 to Length(piString)  do
  begin
    // Fim dos dados entre parenteses
    if piString[lEnum] = ')' then
      flagDadosDesejados := False;
    if flagDadosDesejados then
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Inicio dos dados entre parenteses
    if piString[lEnum] = '(' then
      flagDadosDesejados := True;
  end;
  Result := lString;
end;

procedure TExplorer.saveExecute(Sender: TObject);
begin
  if WorkFile = ''
    then FileSaveAs1.Execute
    else memOQLQuery.Lines.SaveToFile(WorkFile);
end;

procedure TExplorer.SetWorkFile(const Value: string);
begin
  fWorkFile := Value;
  self.Caption := 'Explorer - ' + fWorkFile;
end;

procedure TExplorer.tvModelExplorerItemExpanding(Sender: TObject; Node: TElTreeItem; var AllowExpansion: Boolean);
var lClassTicket: acClassTicket;
    lAttributeTicket: acAttributeTicket;
    lRelationTicket: acRelationTicket;
    lCardinality: string;
    lEnumerator: acEnumerator;
    li: integer;
begin
  if (Node.Tag <> 100) then
  begin
    Node.Owner.Items.BeginUpdate;
    try
      if (TObject(Node.Data) is acMetaModel) then
      begin
        lEnumerator := acMetaModel(Node.Data).ClassTickets.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lClassTicket := acClassTicket(lEnumerator.Current);
          Node.Owner.Items.AddChildObject(Node, lClassTicket.PersistentObjectClassName, lClassTicket);
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acClassTicket) then
      begin
        lClassTicket := acClassTicket(Node.Data);
        repeat
          for li := 0 to pred(lClassTicket.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
            if lAttributeTicket.Stereotype = pvPersistent then
              Node.Owner.Items.AddChildObject(Node, lAttributeTicket.AttributeName + ': ' + lAttributeTicket.AttributeType, lAttributeTicket);
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsIn.Objects[li]);
            if lRelationTicket.DestinationMaxMultiplicity = N
              then lCardinality := '*'
              else lCardinality := inttostr(lRelationTicket.DestinationMaxMultiplicity);
            if lRelationTicket.DestinationPropertyName <> '' then
            begin
              Node.Owner.Items.AddChildObject(Node, lRelationTicket.DestinationPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.OriginTicket.PersistentObjectClassName, lRelationTicket.OriginTicket);
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsOut.Objects[li]);
            if lRelationTicket.OriginPropertyName <> '' then
            begin
              if lRelationTicket.OriginMaxMultiplicity = N
                then lCardinality := '*'
                else lCardinality := inttostr(lRelationTicket.OriginMaxMultiplicity);
              Node.Owner.Items.AddChildObject(Node, lRelationTicket.OriginPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.DestinationTicket.PersistentObjectClassName, lRelationTicket.DestinationTicket);
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        until lClassTicket = nil;
      end;
      Node.Tag := 100;
    finally
      Node.Owner.Items.EndUpdate;
    end;
  end;
end;

procedure TExplorer.memOQLQueryDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
var lNode: TElTreeItem;
begin
  Accept := (TBaseDragControlObject(Source).Control is TElTree);
  if Accept then
  begin
    lNode := (TBaseDragControlObject(Source).Control as TElTree).Selected;
    Accept := Accept and ((TObject(lNode.Data) is acClassTicket) or (TObject(lNode.Data) is acAttributeTicket));
    if State = dsDragEnter then TWinControl(Sender).SetFocus;
  end
end;

procedure TExplorer.memOQLQueryDragDrop(Sender, Source: TObject; X, Y: Integer);
   function FromClause(piNode: TElTreeItem; var poPath: string): string;
   begin
     if piNode.Level = 1
       then begin
              poPath := acClassTicket(piNode.Data).PersistentObjectClassName;
              result := poPath;
            end
       else begin
              result := FromClause(piNode.Parent, poPath);
              poPath := poPath + '.' + copy(piNode.Text, 1, pred(pos(':', piNode.Text)));
              result := result + ', ' + #13#10 + '     ' + poPath;
            end;
   end;
var lCaption: string;
    lNode: TElTreeItem;
    lPath: string;
    lFrom: string;
    lSelect: string;
begin
  lNode := (TBaseDragControlObject(Source).Control as TElTree).Selected;
  if (TObject(lNode.Data) is acClassTicket)
    then begin
      lCaption := acClassTicket(lNode.Data).PersistentObjectClassName;
      if GetKeyState(VK_CONTROL) < 0
         then memOQLQuery.SelText := #13#10 +
                                  'SELECT ' + lCaption + #13#10 +
                                  'FROM ' + lCaption
         else memOQLQuery.SelText := lCaption;
    end
    else if (TObject(lNode.Data) is acAttributeTicket) then
    begin
      if GetKeyState(VK_CONTROL) < 0
        then begin
          lCaption := (TObject(lNode.Parent.data) as acClassTicket).PersistentObjectClassName;
          lFrom := FromClause(lNode.Parent, lPath);
          lSelect := copy(lPath, 1, pred(pos('.', lPath)));
          if lSelect = '' then lSelect := lPath;
          memOQLQuery.SelText := #13#10 +
                              'SELECT ' + lSelect + #13#10 +
                              'FROM ' + lFrom + #13#10 +
                              'WHERE ' + lPath + '.' + acAttributeTicket(lNode.Data).AttributeName + ' = ';
        end else memOQLQuery.SelText := acAttributeTicket(lNode.Data).AttributeName;
    end;
end;

procedure TExplorer.ModelPanelExecute(Sender: TObject);
var lAction: TAction;
begin
  lAction := (Sender as TAction);
  lAction.Checked := not lAction.Checked;
  tvModelExplorer.Visible := lAction.Checked;
end;

procedure TExplorer.OQLObjectstvExplorerKeyUp(Sender: TObject;var Key: Word; Shift: TShiftState);
begin
  // Copia dados do objeto ao apertar Ctrl + C
  if (Key = 67) and (Shift = [ssCtrl]) then
  begin
    if Assigned(OQLObjects.tvExplorer.Selected) then
      CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
  end;
end;

procedure TExplorer.OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  lPoint : TPoint;
begin
  GetCursorPos(lPoint);
  if (Button = mbRight) then
  begin
    pmCopiar.Popup(lPoint.X ,lPoint.Y );
  end;
end;

procedure TExplorer.pcResultChange(Sender: TObject);
var
    lOQLQuery: acAbstractOQLQuery;
begin
  if pcResult.ActivePage.ImageIndex = 2 then
  begin
    try
    if memOQLQuery.Text <> '' then
      begin
        memSQL.Text := '';
        if not ckbXMLOQLQuery.Checked then
        begin
            if memOQLQuery.SelText = ''
              then lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.Text)
              else lOQLQuery := acOQLQuery.Create(fSession, memOQLQuery.SelText);
          try
            memSQL.Text := lOQLQuery.SQLText;
          finally
            lOQLQuery.Free;
          end;
        end
        else
        begin
            if memOQLQuery.SelText = ''
              then lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.Text)
              else lOQLQuery := acDataSetOQLQuery.Create(fSession, memOQLQuery.SelText);
          try
            memSQL.Text := lOQLQuery.SQLText;
          finally
            lOQLQuery.Free;
          end;
        end;
      end;
    except
      on e: Exception do
        begin
          TextResults.Text := e.Message;
          pcResult.ActivePageIndex := 1;
          OQLStatusBar.Panels[0].Text := 'Query completed with errors.';
          tsTextResults.TabVisible := True;
          tsObjectResults.TabVisible := False;
        end;
    end;
  end;
end;

procedure TExplorer.ResizeColumns(piListView: TListView);
var li: integer;
begin
  if piListView.Columns.Count > 0 then
  begin
    piListView.Items.BeginUpdate;
    try
      for li := pred(piListView.Columns.Count) downto 0 do
      begin
        piListView.Columns.Items[li].Width := -2;
      end;
    finally
      piListView.Columns[0].Width := piListView.Columns[0].Width + 20;
      piListView.Items.EndUpdate;
    end;
  end;
end;

procedure TExplorer.ResultsPanelExecute(Sender: TObject);
var lAction: TAction;
begin
  lAction := (Sender as TAction);
  if lAction.Checked then
  begin
    Splitter2.Align := alNone;
    pcResult.Visible := False;
//    memOQLQuery.Align := alClient;
  end
  else
  begin
//    memOQLQuery.Align := alTop;
//    memOQLQuery.Height := (tsOQL.Height div 2);
//    Splitter2.Align := alTop;
    pcResult.Visible := True;
    Splitter2.Align := alBottom;    
  end;
  lAction.Checked := not lAction.Checked;
end;

procedure TExplorer.ExportModelExecute(Sender: TObject);
//var Utilitario: TUtil;
//    lsPathPrjSTARUML, lsSTARUMLPrj: string;
begin
////  lsPathPrjSTARUML := 'C:\bruno\mdl\';
//  lsPathPrjSTARUML := 'C:\Documents and Settings\sandrosantana\Meus documentos\cvsroot\br1-11-0\prj\sgies\lib\mdl\';
//  lsSTARUMLPrj := lsPathPrjSTARUML + 'ConexoModel.uml';
//  Utilitario := TUtil.Create;
//  Utilitario.Reversa(Application.Title,lsPathPrjSTARUML, lsSTARUMLPrj);
//  Utilitario.Destroy;
end;

procedure TExplorer.SetMetaModel(const Value: acMetaModel);
begin
  fMetaModel := Value;
  tvModelExplorer.Items.AddChildObject(nil, 'Persistence Model', fMetaModel).Expand(False);
end;

procedure TExplorer.SetStarUMLApp(const Value: IStarUMLApplication);
var   lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  FStarUMLApp := Value;
  fUtil := TUtil.Create(FStarUMLApp);
  fUtil.AlimentarMetamodel(FStarUMLApp, lMetaModelGenOpt, nil);
  MetaModel := fUtil.MetaModel;
end;

end.
