unit UseCaseController;

interface

uses ituVCLUIController, utuMessage, mxuConnectionClient, ituInterfaceFactory;

const
  cGUIID_CadastroCasoDeUso = 2;
  cUSECASEID_CadastroCasoDeUso = 441;

type
  itMainInterface = class;

  TUseCaseController = class
  private
    fServerName: string;
    fPortNumber: integer;
    fSystemCode: integer;
    fUserName: string;
    fPassword: string;
    fConnectionClient: mxConnectionClient;
    fMainInterface: itMainInterface;
  public
    Constructor Create(piServerName: string; piPortNumber, piSystemCode: integer; piUserName, piPassword: String);
    Destructor Destroy; override;

    procedure ExecuteUseCase(piGUIID, piUseCaseID: integer); overload;
    procedure ExecuteUseCase(piGUIID, piUseCaseID, piObjectID: integer); overload;
  end;


  itMainInterface = class(itInterface)
  private
    fSessionID: integer;
  public
    procedure ProcessMessage(piMessage: mxMessage; poMessage: mxMessage; var poProcessed: boolean); override;
    procedure OpenSession(piSystemCode: integer; piLogin, piPassword: string; piAuditContext: string);
    procedure Initialize; override;
    procedure Finalize; override;

    procedure ExecuteUseCase(piGUIID, piUseCaseID: integer); overload;
    procedure ExecuteUseCase(piGUIID, piUseCaseID, piObjectID: integer); overload;
  end;

implementation

uses SysUtils;

{ itMainInterface }

procedure itMainInterface.Finalize;
begin
  inherited;

end;

procedure itMainInterface.Initialize;
begin
  inherited;

end;

procedure itMainInterface.OpenSession(piSystemCode: integer; piLogin, piPassword, piAuditContext: string);
var
  lRequest: mxRequestMessage;
begin
  lRequest := Self.NewRequest(RM_OPEN_SESSION);
  lRequest.Fields.AddField('SYSTEM_CODE').AsInteger := piSystemCode;
  lRequest.Fields.AddField('AUDIT_CONTEXT').AsString := piAuditContext;
  lRequest.Fields.AddField('LOGIN').AsString := piLogin;
  lRequest.Fields.AddField('PASSWORD').AsString := piPassword;
  Self.PostMessage(lRequest);
end;

procedure itMainInterface.ProcessMessage(piMessage, poMessage: mxMessage; var poProcessed: boolean);
var lInterface: itInterface;
begin
  case piMessage.Id of
    AM_USECASE_RUNNING:
    begin
      if not piMessage.Fields.HasField('OBJECTID') then
        lInterface := itInterface(self.Connection.CreateGUIController(piMessage.Fields['GUIID'].AsInteger,
                                         piMessage.Fields['UCID'].AsInteger))
      else
        lInterface := itInterface(self.Connection.CreateGUIController(piMessage.Fields['GUIID'].AsInteger,
                                         piMessage.Fields['UCID'].AsInteger,
                                         piMessage.Fields['OBJECTID'].AsString));
      lInterface.Initialize;
      lInterface.Run;
      poProcessed := True;
    end;
    AM_SESSION_OPENED:
    begin
      fSessionID := piMessage.Fields['UCID'].AsInteger;
      poProcessed := True;
    end;
  end;
  inherited;
end;

procedure itMainInterface.ExecuteUseCase(piGUIID, piUseCaseID: integer);
var lMessage: mxRequestMessage;
begin
  lMessage := self.NewRequest(RM_EXE_USECASE);
  lMessage.Fields.AddField('GUIID').AsInteger := piGUIID;
  lMessage.Fields.AddField('USECASEID').AsInteger := piUseCaseID;
  self.PostMessage(lMessage);
end;

procedure itMainInterface.ExecuteUseCase(piGUIID, piUseCaseID, piObjectID: integer);
var lMessage: mxRequestMessage;
begin
  lMessage := self.NewRequest(RM_EXE_USECASE_WITH_PARAM);
  lMessage.Fields.AddField('GUIID').AsInteger := piGUIID;
  lMessage.Fields.AddField('USECASEID').AsInteger := piUseCaseID;
  lMessage.Fields.AddField('OBJECTID').AsInteger := piObjectID;
  self.PostMessage(lMessage);
end;


{ TUseCaseController }

constructor TUseCaseController.Create(piServerName: string; piPortNumber, piSystemCode: integer;
                                      piUserName, piPassword: String);
var lConnString: string;
begin
  fServerName := piServerName;
  fPortNumber := piPortNumber;
  fSystemCode := piSystemCode;
  fUserName := piUserName;
  fPassword := piPassword;

  lConnString := 'ServerName=' + piServerName + ';' +
                 'PortNumber=' + inttostr(piPortNumber) + ';' +
                 'SystemCode=' + inttostr(piSystemCode) + ';' +
                 'UserName=' + piUserName + ';' +
                 'Password=' + piPassword + ';';

  fConnectionClient := mxConnectionClient.Create;
  fConnectionClient.Connect(lConnString);

  //  fConnectionClient.RunGUIController(0);
  fMainInterface := itMainInterface(gInterfaceFactory.Instantiate(999999));
  if not assigned(fMainInterface) then raise Exception.Create('Interface no implementada: 0');
  fMainInterface.Connection := fConnectionClient;
  fMainInterface.UseCaseAddress := 0;
  fMainInterface.Initialize;
  fMainInterface.Run;

  fMainInterface.OpenSession(fSystemCode, fUserName, fPassword, '');
end;

destructor TUseCaseController.Destroy;
begin
  fConnectionClient.Free;
  inherited;
end;

procedure TUseCaseController.ExecuteUseCase(piGUIID, piUseCaseID: integer);
begin
  fMainInterface.ExecuteUseCase(piGUIID, piUseCaseID);
end;

procedure TUseCaseController.ExecuteUseCase(piGUIID, piUseCaseID, piObjectID: integer);
begin
  fMainInterface.ExecuteUseCase(piGUIID, piUseCaseID, piObjectID);
end;

initialization
  gInterfaceFactory.RegisterClass(999999, itMainInterface);

end.
