unit uCadastroClasse;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  LCLIntf, LCLType, LMessages, StarUMLintf,
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, utuMessage, uCadastroCasoDeUsoIcones, acuObject, cxuCadastroClasse,
  Buttons, cxuSession;

type

  { TCadastroClasse }

  TCadastroClasse = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Panel1: TPanel;
    Panel3: TPanel;
    Panel2: TPanel;
    Label3: TLabel;
    btnSelecionarDestino: TSpeedButton;
    edtPackage: TEdit;
    Panel4: TPanel;
    edtNome: TEdit;
    lblNome: TLabel;
    lblValorCodigo: TLabel;
    lblCodigo: TLabel;
    Panel5: TPanel;
    Label4: TLabel;
    edtNomeStarUML: TEdit;
    Panel7: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    edtDBTableName: TEdit;
    edtDBIDO: TEdit;
    procedure SpeedButton1Click(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnSelecionarDestinoClick(Sender: TObject);
    procedure edtNomeChange(Sender: TObject);
  private
    { Private declarations }
    FOID: integer;
    fUMLClass: IUMLClass;
    fcxCadastroClasse: cxCadastroClasse;
    fClassPackage: IUMLPackage;
    procedure SaveFromInterface(piField: utField);
    procedure SendToInterface(piField: utField);
    procedure SalvaObjeto;

    procedure Initialize;
  public
    { Public declarations }
    Constructor Create(Sender: TComponent; piCadastroClasse: cxCadastroClasse; piUMLClass: IUMLCLass); reintroduce;

    property ClassPackage: IUMLPackage read fClassPackage write fClassPackage;
    property UMLClass: IUMLClass read fUMLClass write fUMLClass;
  end;

var
  CadastroClasse: TCadastroClasse;

implementation

uses IntegracaoDelphiSUML;

{$R *.dfm}

{ TCadastroClasse }

constructor TCadastroClasse.Create(Sender: TComponent; piCadastroClasse: cxCadastroClasse; piUMLClass: IUMLCLass);
begin
  inherited Create(sender);

  if assigned(piUMLClass) then
  begin
    fUMLClass := piUMLClass;
    edtDBIDO.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO');
    edtDBTableName.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table');
  end;
  fcxCadastroClasse := piCadastroClasse;
  self.Initialize;
end;

procedure TCadastroClasse.btnSalvarClick(Sender: TObject);
var lUMLFactory: IUMLFactory;
    lUMLPersistentObject: IUMLCLass;

begin
  if edtNomeStarUML.Text = '' then
  begin
    application.MessageBox('É necessário informar o nome da classe no StarUML.','StarUML', MB_ICONEXCLAMATION + MB_OK);
    exit;
  end else
  if edtPackage.Text = '' then
  begin
    application.MessageBox('É necessário informar o package onde será criado o caso de uso.','StarUML', MB_ICONEXCLAMATION + MB_OK);
    exit;
  end;

  try
    //Se em modo de edição (classe já criada)
    if assigned(fUMLClass) then
    begin
      SalvaObjeto;
      fUMLClass.Name := edtNomeStarUML.Text;
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table', edtDBTableName.Text);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO', edtDBIDO.Text);
    end
    else
    begin
      //Senão cria o objeto no StarUML e salva no caso de uso
      if assigned(fClassPackage.FindByName(edtNomeStarUML.Text)) then
      begin
        application.MessageBox('Classe já existente no pacote selecionado.','StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;

      lUMLPersistentObject := gStarUMLAPP.FindByPathname(cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH) as IUMLCLass;
      if not assigned(lUMLPersistentObject) then
      begin
        application.MessageBox('acPersistentObject not found in "' + cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH + '"', 'StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;
      SalvaObjeto;
      lUMLFactory := gStarUMLAPP.UMLFactory;
      //Cria classe
      fUMLClass := lUMLFactory.CreateClass(fClassPackage);
      fUMLClass.Name := edtNomeStarUML.Text;
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod', lblValorCodigo.Caption);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table', edtDBTableName.Text);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO', edtDBIDO.Text);

      //Cria o relacionamento entre acPersistentObject e a nova classe
      fUMLClass.AddGeneralization(lUMLFactory.CreateGeneralization(fUMLClass.Namespace, lUMLPersistentObject, fUMLClass));
    end;
    ModalResult := mrOk;
  except
    on e:Exception do
    begin
      ModalResult := mrnone;
      raise;
    end;
  end;
end;

procedure TCadastroClasse.btnSelecionarDestinoClick(Sender: TObject);
var lElementSelector: IElementSelector;
begin
  lElementSelector := gStarUMLApp.ElementSelector;
  lElementSelector.AllowNull := false;
  lElementSelector.Filter(fkPackages);
  lElementSelector.ClearSelectableModels();
  lElementSelector.AddSelectableModel('UMLPackage');
  lElementSelector.AddSelectableModel('UMLModel');
  if lElementSelector.Execute('Selecione o local para criar a classe') then
  begin
    ClassPackage :=  lElementSelector.GetSelectedModel as IUMLPackage;
    edtPackage.caption := ClassPackage.PathName;
  end;
end;

procedure TCadastroClasse.edtNomeChange(Sender: TObject);
begin
  edtNomeStarUML.text := 'ng' + edtNome.Text;
  if sametext(copy(edtNome.Text,1,2), 'ng') then
  begin
    edtDBTableName.Text := uppercase(copy(edtNome.Text,3,length(edtNome.Text)-2));
    edtDBIDO.Text := 'ID_' + uppercase(copy(edtNome.Text,3,length(edtNome.Text)-2));
  end
  else
  begin
    edtDBTableName.Text := uppercase(edtNome.Text);
    edtDBIDO.Text := 'ID_' + uppercase(edtNome.Text);
  end;
end;

procedure TCadastroClasse.Initialize;
var lField, lResponseField: utField;
    lClassCode: string;
begin
  FOID := -1;
  //Se for edição, seta o contexto no caso de uso (cadastro de classe )para a classe corrente
  // atraves do código
  if assigned(fUMLClass) then
  begin
    lField := utField.Create;
    lClassCode := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod');
    lField.AddField('CODIGO').AsString :=  lClassCode;

    lResponseField := utField.Create;
    try
      fcxCadastroClasse.rmEditaObjeto(lField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;
    btnSelecionarDestino.Enabled := false;
    edtPackage.Text := fUMLClass.Namespace.Pathname;
  end
  else
  begin
    lResponseField := utField.Create;
    try
      lField := utField.Create;
      fcxCadastroClasse.rmIncluiObjeto(lField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;
  end;
end;

procedure TCadastroClasse.SalvaObjeto;
var lField: utField;
begin
  lField := utField.Create;
  SaveFromInterface(lField);
  fcxCadastroClasse.rmSalvaObjeto(lField);
end;

procedure TCadastroClasse.SaveFromInterface(piField: utField);
var lFieldClasse: utField;
begin
  inherited;
    lFieldClasse := piField.AddField('Classe');
    lFieldClasse.AddAttribute('OID').AsInteger := FOID;
    lFieldClasse.AddAttribute('Nome').AsString := edtNome.Text;
    lFieldClasse.AddAttribute('Codigo').AsString := lblValorCodigo.Caption;
end;

procedure TCadastroClasse.SendToInterface(piField: utField);
var lFieldClasse: utField;
begin
  inherited;
  lFieldClasse := piField.FindField('Classe');
  if assigned(lFieldClasse) then
  begin
    if lFieldClasse.HasAttribute('OID') then FOID := lFieldClasse.AttributeByName('OID').AsInteger;
    if lFieldClasse.HasAttribute('Codigo') then
      lblValorCodigo.Caption := lFieldClasse.AttributeByName('Codigo').AsString;
    if lFieldClasse.HasAttribute('Nome') then
      edtNome.Text := lFieldClasse.AttributeByName('Nome').AsString;
  end;
end;

procedure TCadastroClasse.SpeedButton1Click(Sender: TObject);
begin
end;

end.
