unit ituServiceParameters;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TitServiceParameters = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    GroupBox3: TGroupBox;
    edtServerName: TEdit;
    Label2: TLabel;
    Label1: TLabel;
    edtPortNumber: TEdit;
    edtSystemCode: TEdit;
    Label3: TLabel;
    edtUserName: TEdit;
    edtPassword: TEdit;
    Label5: TLabel;
    Label4: TLabel;
    procedure BitBtn1Click(Sender: TObject);
  private
    function GetPassword: string;
    function GetPortNumber: integer;
    function GetServerName: string;
    function GetSystemCode: integer;
    function GetUserName: string;
    procedure SetPassword(const Value: string);
    procedure SetPortNumber(const Value: integer);
    procedure SetServerName(const Value: string);
    procedure SetSystemCode(const Value: integer);
    procedure SetUserName(const Value: string);
    { Private declarations }
  public
    { Public declarations }
    property ServerName: string read GetServerName write SetServerName;
    property PortNumber: integer read GetPortNumber write SetPortNumber;
    property SystemCode: integer read GetSystemCode write SetSystemCode;
    property UserName: string read GetUserName write SetUserName;
    property Password: string read GetPassword write SetPassword;
  end;


implementation

{$R *.dfm}

{ TServiceParameters }

procedure TitServiceParameters.BitBtn1Click(Sender: TObject);
begin
  if edtServerName.Text = '' then
  begin
    Application.MessageBox(' necessrio informar o nome do servidor.','Ateno', MB_ICONEXCLAMATION);
    edtServerName.SetFocus;
    modalresult := mrnone;
  end else if edtPortNumber.Text = '' then
  begin
    Application.MessageBox(' necessrio informar o nmero da porta.','Ateno', MB_ICONEXCLAMATION);
    edtPortNumber.SetFocus;
    modalresult := mrnone;
  end else if edtSystemCode.Text = '' then
  begin
    Application.MessageBox(' necessrio informar o cdigo do sistema.','Ateno', MB_ICONEXCLAMATION);
    edtSystemCode.SetFocus;
    modalresult := mrnone;
  end else if edtUserName.Text = '' then
  begin
    Application.MessageBox(' necessrio informar o nome do usurio.','Ateno', MB_ICONEXCLAMATION);
    edtUserName.SetFocus;
    modalresult := mrnone;
  end;

  try
    strtoint(edtPortNumber.Text);
  except
    Application.MessageBox('Porta informada invlida.','Ateno', MB_ICONEXCLAMATION);
    edtPortNumber.SetFocus;
    edtPortNumber.SelectAll;
    modalresult := mrnone;
  end;

  try
    strtoint(edtSystemCode.Text);
  except
    Application.MessageBox('Cdigo do sistema informado invlido.','Ateno', MB_ICONEXCLAMATION);
    edtSystemCode.SetFocus;
    edtSystemCode.SelectAll;
    modalresult := mrnone;
  end;
end;

function TitServiceParameters.GetPassword: string;
begin
  result := edtPassword.Text;
end;

function TitServiceParameters.GetPortNumber: integer;
begin
  Result := strtoint(edtPortNumber.Text);
end;

function TitServiceParameters.GetServerName: string;
begin
  Result := edtServerName.Text;
end;

function TitServiceParameters.GetSystemCode: integer;
begin
  Result := strtoint(edtSystemCode.Text);
end;

function TitServiceParameters.GetUserName: string;
begin
  Result := edtUserName.Text;
end;

procedure TitServiceParameters.SetPassword(const Value: string);
begin
  edtPassword.Text := value;
end;

procedure TitServiceParameters.SetPortNumber(const Value: integer);
begin
  edtPortNumber.Text := inttostr(Value);
end;

procedure TitServiceParameters.SetServerName(const Value: string);
begin
  edtServerName.Text := value;
end;

procedure TitServiceParameters.SetSystemCode(const Value: integer);
begin
  edtSystemCode.Text := inttostr(value);
end;

procedure TitServiceParameters.SetUserName(const Value: string);
begin
  edtUserName.Text := Value;
end;

end.
