unit uCadastroClasse;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, utuMessage, uCadastroCasoDeUsoIcones, acuObject, cxuCadastroClasse,
  StarUML_TLB, Buttons, cxuSession;

type
  TCadastroClasse = class(TForm)
    Panel1: TPanel;
    Panel3: TPanel;
    Panel2: TPanel;
    Label3: TLabel;
    btnSelecionarDestino: TSpeedButton;
    edtPackage: TEdit;
    Panel4: TPanel;
    edtNome: TEdit;
    lblNome: TLabel;
    lblValorCodigo: TLabel;
    lblCodigo: TLabel;
    Panel5: TPanel;
    Label4: TLabel;
    edtNomeStarUML: TEdit;
    Panel6: TPanel;
    SpeedButton1: TSpeedButton;
    btnSalvar: TSpeedButton;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    edtDBTableName: TEdit;
    edtDBIDO: TEdit;
    procedure SpeedButton1Click(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnSelecionarDestinoClick(Sender: TObject);
    procedure edtNomeChange(Sender: TObject);
  private
    { Private declarations }
    FOID: integer;
    fUMLClass: IUMLClass;
    fcxCadastroClasse: cxCadastroClasse;
    fClassPackage: IUMLPackage;
    procedure SaveFromInterface(piField: utField);
    procedure SendToInterface(piField: utField);
    procedure SalvaObjeto;
    procedure SetClassPackage(const Value: IUMLPackage);

    procedure Initialize;
  public
    { Public declarations }
    FStarUMLAPP: IStarUMLApplication;
    Constructor Create(Sender: TComponent; piConnectionString: string; piUMLClass: IUMLClass = nil); reintroduce; overload;
    Constructor Create(Sender: TComponent; piSession: cxSession; piUMLClass: IUMLClass = nil); reintroduce; overload;

    property ClassPackage: IUMLPackage read fClassPackage write SetClassPackage;
    property UMLClass: IUMLClass read fUMLClass write fUMLClass;
  end;

var
  CadastroClasse: TCadastroClasse;

implementation

uses IntegracaoDelphiSUML;

{$R *.dfm}

{ TCadastroClasse }

constructor TCadastroClasse.Create(Sender: TComponent; piConnectionString: string; piUMLClass: IUMLClass);
begin
  inherited Create(sender);
  fClassPackage := nil;
  fUMLClass := piUMLClass;

  if assigned(piUMLClass) then
  begin
    edtDBIDO.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO');
    edtDBTableName.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table');
  end;

  fcxCadastroClasse := cxCadastroClasse.Create(piConnectionString);
  self.Initialize;
end;

procedure TCadastroClasse.btnSalvarClick(Sender: TObject);
var lUMLFactory: IUMLFactory;
    lUMLPersistentObject: IUMLCLass;

begin
  if edtNomeStarUML.Text = '' then
  begin
    application.MessageBox(' necessrio informar o nome da classe no StarUML.','StarUML', MB_ICONEXCLAMATION + MB_OK);
    exit;
  end else
  if edtPackage.Text = '' then
  begin
    application.MessageBox(' necessrio informar o package onde ser criado o caso de uso.','StarUML', MB_ICONEXCLAMATION + MB_OK);
    exit;
  end;

  try
    //Se em modo de edio (classe j criada)
    if assigned(fUMLClass) then
    begin
//      if (assigned(fClassPackage.FindByName(edtNomeStarUML.Text))) and (fUMLClass.name <> edtNomeStarUML.Text) then
//      begin
//        application.MessageBox('Classe j existente no pacote selecionado.','StarUML', MB_ICONEXCLAMATION + MB_OK);
//        exit;
//      end;

      SalvaObjeto;
      fUMLClass.Name := edtNomeStarUML.Text;
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table', edtDBTableName.Text);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO', edtDBIDO.Text);
    end
    else
    begin
      //Seno cria o objeto no StarUML e salva no caso de uso
      if assigned(fClassPackage.FindByName(edtNomeStarUML.Text)) then
      begin
        application.MessageBox('Classe j existente no pacote selecionado.','StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;

      lUMLPersistentObject := FStarUMLAPP.FindByPathname(cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH) as IUMLCLass;
      if not assigned(lUMLPersistentObject) then
      begin
        application.MessageBox('acPersistentObject not found in "' + cBASE_PERSISTENT_OBJECT_CLASS_FULL_PATH + '"', 'StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;
      SalvaObjeto;
      lUMLFactory := FStarUMLAPP.UMLFactory;
      //Cria classe
      fUMLClass := lUMLFactory.CreateClass(fClassPackage);
      fUMLClass.Name := edtNomeStarUML.Text;
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod', lblValorCodigo.Caption);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table', edtDBTableName.Text);
      fUMLClass.SetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO', edtDBIDO.Text);

      //Cria o relacionamento entre acPersistentObject e a nova classe
      fUMLClass.AddGeneralization(lUMLFactory.CreateGeneralization(fUMLClass.Namespace, lUMLPersistentObject, fUMLClass));
    end;
    ModalResult := mrOk;
  except
    on e:Exception do
    begin
      ModalResult := mrnone;
      raise;
    end;
  end;
end;

procedure TCadastroClasse.btnSelecionarDestinoClick(Sender: TObject);
var lElementSelector: IElementSelector;
begin
  lElementSelector := fStarUMLApp.ElementSelector;
  lElementSelector.AllowNull := false;
  lElementSelector.Filter(fkPackages);
  lElementSelector.ClearSelectableModels();
  lElementSelector.AddSelectableModel('UMLPackage');
  lElementSelector.AddSelectableModel('UMLModel');  
  if lElementSelector.Execute('Selecione o local para criar o caso de uso') then
    ClassPackage :=  lElementSelector.GetSelectedModel as IUMLPackage;
end;

constructor TCadastroClasse.Create(Sender: TComponent; piSession: cxSession; piUMLClass: IUMLClass);
begin
  inherited Create(sender);
  fClassPackage := nil;
  if assigned(piUMLClass) then
  begin
    edtDBIDO.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'DBIDO');
    edtDBTableName.Text := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Table');
  end;
  fcxCadastroClasse := cxCadastroClasse.Create(piSession);
  self.Initialize;
end;

procedure TCadastroClasse.edtNomeChange(Sender: TObject);
begin
  edtNomeStarUML.text := 'ng' + edtNome.Text;
//  if sametext(copy(edtNome.Text,1,2), 'ng') then
//  begin
//    edtDBTableName.Text := uppercase(copy(edtNome.Text,3,length(edtNome.Text)-2));
//    edtDBIDO.Text := 'ID_' + uppercase(copy(edtNome.Text,3,length(edtNome.Text)-2));
//  end
//  else
//  begin
//    edtDBTableName.Text := uppercase(edtNome.Text);
//    edtDBIDO.Text := 'ID_' + uppercase(edtNome.Text);
//  end;
end;

procedure TCadastroClasse.Initialize;
var lField, lResponseField: utField;
    lClassCode: string;
begin
  FOID := -1;
  //Se for edio, seta o contexto no caso de uso (cadastro de classe )para a classe corrente
  // atraves do cdigo
  if assigned(fUMLClass) then
  begin
    lField := utField.Create;
    lClassCode := fUMLClass.GetTaggedValueAsString('DBMappings', 'DBClassMap', 'Cod');
    lField.AddField('CODIGO').AsString :=  lClassCode;

    lResponseField := utField.Create;
    try
      fcxCadastroClasse.rmEditaObjeto(lField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;
    btnSelecionarDestino.Enabled := false;
    edtPackage.Text := fUMLClass.Namespace.Pathname;
  end
  else
  begin
    lResponseField := utField.Create;
    try
      lField := utField.Create;
      fcxCadastroClasse.rmIncluiObjeto(lField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;
  end;
end;

procedure TCadastroClasse.SalvaObjeto;
var lField: utField;
begin
  lField := utField.Create;
  SaveFromInterface(lField);
  fcxCadastroClasse.rmSalvaObjeto(lField);
end;

procedure TCadastroClasse.SaveFromInterface(piField: utField);
var lFieldClasse: utField;
begin
  inherited;
    lFieldClasse := piField.AddField('Classe');
    lFieldClasse.AddAttribute('OID').AsInteger := FOID;
    lFieldClasse.AddAttribute('Nome').AsString := edtNome.Text;
    lFieldClasse.AddAttribute('Codigo').AsString := lblValorCodigo.Caption;
end;

procedure TCadastroClasse.SendToInterface(piField: utField);
var lFieldClasse: utField;
begin
  inherited;
  lFieldClasse := piField.FindField('Classe');
  if assigned(lFieldClasse) then
  begin
    if lFieldClasse.HasAttribute('OID') then FOID := lFieldClasse.AttributeByName('OID').AsInteger;
    if lFieldClasse.HasAttribute('Codigo') then
      lblValorCodigo.Caption := lFieldClasse.AttributeByName('Codigo').AsString;
    if lFieldClasse.HasAttribute('Nome') then
      edtNome.Text := lFieldClasse.AttributeByName('Nome').AsString;
  end;
end;

procedure TCadastroClasse.SetClassPackage(const Value: IUMLPackage);
begin
  fClassPackage := Value;
  edtPackage.Text := Value.Pathname;
end;

procedure TCadastroClasse.SpeedButton1Click(Sender: TObject);
begin
  ModalResult := mrcancel;
end;

end.
