unit uDBAttributeParameters;

interface

uses
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Buttons, ExtCtrls, Grids, ValEdit, StdCtrls, IntegracaoDelphiSUML, StarUMLintf;

type
  TfDBAttributeParameters = class(TForm)
    pnlError: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    lblError: TLabel;
    ckbCheckLength: TCheckBox;
    GroupBox1: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    GroupBox2: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    lblAttLength: TLabel;
    ckbMand: TCheckBox;
    edtName: TEdit;
    edtFSize: TEdit;
    edtVSize: TEdit;
    cbbType: TComboBox;
    ckbIsAuditable: TCheckBox;
    cbbStarUMLTypes: TComboBox;
    edtAttributeName: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure btnCancelClick(Sender: TObject);
    procedure edtNameChange(Sender: TObject);
    procedure cbbStarUMLTypesClick(Sender: TObject);
    procedure cbbTypeClick(Sender: TObject);
    procedure edtAttributeNameChange(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    FUMLAttribute: IUMLAttribute;
    FStarUML: IStarUMLApplication;
    function GetDBTypeByACType(piACType: string): string;
    procedure SetFSize(const Value: integer);
    procedure SetVSize(const Value: integer);
    procedure SetMand(const Value: boolean);
    procedure SetName_(const Value: String);
    procedure SetType1(const Value: String);
    function GetFSize: integer;
    function GetVSize: integer;
    function GetMand: boolean;
    function GetName_: String;
    function GetType1: String;
    function GetError: String;
    procedure SetError(const Value: String);
    function GetIsAuditable: boolean;
    procedure SetIsAuditable(const Value: boolean);
    function GetAttributeName: string;
    function GetAttributeType: string;
    procedure SetAttributeName(const Value: string);
    procedure SetAttributeType(const Value: string);
    { Private declarations }
  public
    { Public declarations }
    fError: string;
    Util: TUtil;
    constructor Create(AOwner: TComponent; piStarUML: IStarUMLApplication; var piUMLAttribute: IUMLAttribute); reintroduce;
    property AttributeName: string read GetAttributeName write SetAttributeName;
    property AttributeType: string read GetAttributeType write SetAttributeType;

    property Error: String read GetError write SetError;
    property Name_: String read GetName_ write SetName_;
    property Type1: String read GetType1 write SetType1;
    property FSize: integer read GetFSize write SetFSize;
    property VSize: integer read GetVSize write SetVSize;
    property Mand: boolean read GetMand write SetMand;
    property IsAuditable: boolean read GetIsAuditable write SetIsAuditable;
  end;

var
  fDBAttributeParameters: TfDBAttributeParameters;

implementation


{$R *.dfm}

procedure TfDBAttributeParameters.cbbStarUMLTypesClick(Sender: TObject);
begin
  if cbbStarUMLTypes.ItemIndex <> -1 then Self.Type1 := GetDBTypeByACType(cbbStarUMLTypes.Text);
  if Self.Name_ = '' then Self.Name_ := edtAttributeName.Text;
  cbbTypeClick(sender);
end;

procedure TfDBAttributeParameters.cbbTypeClick(Sender: TObject);
begin
  if sametext(cbbType.Text, 'CHAR') then
  begin
    edtVSize.Text := '0';
    edtFSize.Enabled := true;
    edtVSize.Enabled := false;
    if assigned(sender) then edtFSize.SetFocus;
  end else if sametext(cbbType.Text, 'VARCHAR') then
  begin
    edtFSize.Text := '0';
    edtFSize.Enabled := false;
    edtVSize.Enabled := true;
    if assigned(sender) then edtVSize.SetFocus;
  end else if sametext(cbbType.Text, 'DECIMAL') then
  begin
    edtFSize.Enabled := true;
    edtVSize.Enabled := true;
    if assigned(sender) then edtVSize.SetFocus;
  end else if sametext(cbbType.Text, 'NUMERIC') then
  begin
    edtFSize.Enabled := true;
    edtVSize.Enabled := true;
    if assigned(sender) then edtVSize.SetFocus;
  end
  else
  begin
    edtFSize.Text := '0';
    edtVSize.Text := '0';
    edtFSize.Enabled := false;
    edtVSize.Enabled := false;
  end;
end;

procedure TfDBAttributeParameters.BitBtn1Click(Sender: TObject);
begin
  FUMLAttribute.Name := AttributeName;
  FUMLAttribute.SetType2(AttributeType);
  FUMLAttribute.SetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name', Name_);
  FUMLAttribute.SetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Type', Type1);
  FUMLAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'FSize', FSize);
  FUMLAttribute.SetTaggedValueAsInteger('DBMappings', 'DBAttributeMap', 'VSize', VSize);
  FUMLAttribute.SetTaggedValueAsBoolean('DBMappings', 'DBAttributeMap', 'Mand', mand);
  FUMLAttribute.SetTaggedValueAsBoolean('DBMappings', 'DBAttributeMap', 'IsAuditable', IsAuditable);
  Error := Util.ValidateAttribute(FUMLAttribute, ckbCheckLength.Checked);

  if Error <> '' then
    ShowMessage(Error)
  else
    ModalResult := mrOk;
end;

procedure TfDBAttributeParameters.btnCancelClick(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

constructor TfDBAttributeParameters.Create(AOwner: TComponent; piStarUML: IStarUMLApplication; var piUMLAttribute: IUMLAttribute);
var lProfile: IProfile;
  I: Integer;
begin
  inherited create(AOwner);
  self.FUMLAttribute := piUMLAttribute;
  self.FStarUML := piStarUML;
  edtAttributeName.Text := piUMLAttribute.Name;

  lProfile := FStarUML.ExtensionManager.FindIncludedProfile('DBMappings');
  for I := 0 to lProfile.GetDataTypeCount - 1 do
    cbbStarUMLTypes.AddItem(lProfile.GetDataTypeAt(I).Name, nil);

  self.Caption := piUMLAttribute.Owner.Name + '.' + piUMLAttribute.Name;

  Name_ := piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Name');
  Type1 := piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Type');
  FSize := strtointdef(piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'FSize'),0);
  VSize := strtointdef(piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'VSize'),0);
  Mand := sametext(piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'Mand'), 'True');
  IsAuditable := sametext(piUMLAttribute.GetTaggedValueAsString('DBMappings', 'DBAttributeMap', 'IsAuditable'), 'True');

  AttributeName := piUMLAttribute.Name;
  if not VarIsEmpty(piUMLAttribute.Type_) then
  begin
    if assigned(piUMLAttribute.Type_) then
    begin
      AttributeType := piUMLAttribute.Type_.Name;
      if Type1 = '' then Type1 := GetDBTypeByACType(AttributeType);
      cbbTypeClick(nil);
    end;
  end;
end;

procedure TfDBAttributeParameters.edtAttributeNameChange(Sender: TObject);
begin
  self.Caption := FUMLAttribute.Owner.Name + '.' + edtAttributeName.Text;
  self.Name_ := edtAttributeName.Text;
end;

procedure TfDBAttributeParameters.edtNameChange(Sender: TObject);
begin
  lblAttLength.Caption := inttostr(Length(edtName.Text));
end;

procedure TfDBAttributeParameters.FormShow(Sender: TObject);
begin
  edtAttributeName.SetFocus;
  edtAttributeName.SelectAll;  
end;

function TfDBAttributeParameters.GetAttributeName: string;
begin
  result := edtAttributeName.Text;
end;

function TfDBAttributeParameters.GetAttributeType: string;
begin
  if cbbStarUMLTypes.ItemIndex <> -1 then
    result := cbbStarUMLTypes.Text;
end;

function TfDBAttributeParameters.GetDBTypeByACType(piACType: string): string;
begin
  if SameText(piACType, 'acBlob') then
    result := 'TEXT'
  else if SameText(piACType, 'acDateTime') then
    result := 'DATETIME'
  else if SameText(piACType, 'acString') then
    result := 'VARCHAR'
  else if SameText(piACType, 'acEnumeratedList') then
    result := ''
  else if SameText(piACType, 'acErrorList') then
    result := ''
  else if SameText(piACType, 'acGraphic') then
    result := 'IMAGE'
  else if SameText(piACType, 'acInt') then
    result := 'INT'
  else if SameText(piACType, 'acText') then
    result := 'TEXT'
  else if SameText(piACType, 'acFloat') then
    result := 'DECIMAL'
  else if SameText(piACType, 'acDouble') then
    result := 'DECIMAL'
  else if SameText(piACType, 'acBoolean') then
    result := 'CHAR'
  else if SameText(piACType, 'acReal') then
    result := 'DECIMAL'
  else if SameText(piACType, 'acCurrency') then
    result := 'DECIMAL'
  else if SameText(piACType, 'acXMLString') then
    result := 'TEXT'
  else if SameText(piACType, 'acXMLText') then
    result := 'TEXT'
  else result := '';  
end;

function TfDBAttributeParameters.GetError: String;
begin
  result := fError;
end;

function TfDBAttributeParameters.GetFSize: integer;
begin
  result := strtointdef(edtFSize.Text,0);
end;

function TfDBAttributeParameters.GetIsAuditable: boolean;
begin
  result := ckbIsAuditable.Checked;
end;

function TfDBAttributeParameters.GetMand: boolean;
begin
  result := ckbMand.Checked;
end;

function TfDBAttributeParameters.GetName_: String;
begin
  result := edtName.Text;
end;

function TfDBAttributeParameters.GetType1: String;
begin
  result := cbbType.Text;
end;

function TfDBAttributeParameters.GetVSize: integer;
begin
  Result := strtointdef(edtVSize.Text,0);
end;

procedure TfDBAttributeParameters.SetAttributeName(const Value: string);
begin
  edtAttributeName.Text := value;
end;

procedure TfDBAttributeParameters.SetAttributeType(const Value: string);
var i: integer;
begin
  cbbStarUMLTypes.ItemIndex := -1;
  for I := 0 to cbbStarUMLTypes.Items.Count - 1 do
    if SameText(cbbStarUMLTypes.Items[i], value) then
    begin
      cbbStarUMLTypes.ItemIndex := i;
      break;
    end;
end;

procedure TfDBAttributeParameters.SetError(const Value: String);
begin
  fError := value;
  lblError.Caption := value;
end;

procedure TfDBAttributeParameters.SetFSize(const Value: integer);
begin
  edtFSize.Text := inttostr(Value);
end;

procedure TfDBAttributeParameters.SetIsAuditable(const Value: boolean);
begin
  ckbIsAuditable.Checked := Value;
end;

procedure TfDBAttributeParameters.SetMand(const Value: boolean);
begin
  ckbMand.Checked := Value;
end;

procedure TfDBAttributeParameters.SetName_(const Value: String);
begin
  edtName.Text := Value;
  lblAttLength.Caption := inttostr(Length(Value));
end;

procedure TfDBAttributeParameters.SetType1(const Value: String);
var i: integer;
begin
  cbbType.ItemIndex := -1;
  for I := 0 to cbbType.Items.Count - 1 do
    if SameText(cbbType.Items[i], value) then
    begin
      cbbType.ItemIndex := i;
      break;
    end;
end;

procedure TfDBAttributeParameters.SetVSize(const Value: integer);
begin
  edtVSize.Text := inttostr(Value);
end;

end.
