unit uConnStringTemplates;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TConnStringsTemplates = class(TForm)
    rdgOptions: TRadioGroup;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    edtUserDefined: TEdit;
    procedure BitBtn1Click(Sender: TObject);
    procedure edtUserDefinedChange(Sender: TObject);
  private
    function GetConnectionString: string;
    { Private declarations }
  public
    { Public declarations }
    property ConnectionString: string read GetConnectionString;
  end;

var
  ConnStringsTemplates: TConnStringsTemplates;

implementation

{$R *.dfm}

{ TConnStringsTemplates }

procedure TConnStringsTemplates.BitBtn1Click(Sender: TObject);
begin
  if (rdgOptions.ItemIndex = 3) and (edtUserDefined.Text = '') then
  begin
    Application.MessageBox('Connection string not specified.', 'Attention', MB_ICONINFORMATION);
    edtUserDefined.SetFocus;
  end
  else
    ModalResult := mrok;
end;

procedure TConnStringsTemplates.edtUserDefinedChange(Sender: TObject);
begin
  rdgOptions.ItemIndex := 3;
end;

function TConnStringsTemplates.GetConnectionString: string;
begin
  case rdgOptions.ItemIndex of
    0: result := 'Provider=SQLNCLI.1;Data Source=;Initial Catalog=;Integrated Security=SSPI';
    1: result := 'Provider=SQLNCLI.1;Data Source=;Initial Catalog=;User ID=;Password=';
    2: result := 'Provider=OraOLEDB.Oracle.1;Data Source=;User ID=;Password=';
    3: result := edtUserDefined.Text;
  end;
end;

end.
