unit uCadastroCasoDeUso;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
  LCLIntf, LCLType, LMessages, StarUMLintf,
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, utuMessage, uCadastroCasoDeUsoIcones, acuObject, cxuCadastroCasoDeUso,
  Buttons, cxuSession;

type

  { TCadastroCasoDeUso }

  TCadastroCasoDeUso = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    edtUseCaseName: TEdit;
    Label4: TLabel;
    Panel3: TPanel;
    pnPrincipal: TPanel;
    lblNome: TLabel;
    lblCodigo: TLabel;
    lblDescricao: TLabel;
    lblEntidade: TLabel;
    lblCategoria: TLabel;
    lblValorCodigo: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    edtNome: TEdit;
    cbxEntidade: TComboBox;
    cbxCategoria: TComboBox;
    ltvSistema: TListView;
    ltvOperacao: TListView;
    edtDescricao: TEdit;
    GroupBox1: TGroupBox;
    imgIcone: TImage;
    Panel1: TPanel;
    edtPackage: TEdit;
    Label3: TLabel;
    btnSelecionarDestino: TSpeedButton;
    Label5: TLabel;
    procedure imgIconeClick(Sender: TObject);
    procedure btnSelecionarDestinoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    FOID: integer;
    FContextField: utField;
    fUMLUseCase: IUMLUseCase;
    fFormIcones: TCadastroCasoDeUsoIcones;
    fcxCadastroCasoDeUso: cxCadatroCasoDeUso;
    fUseCasePackage: IUMLPackage;
    procedure SaveFromInterface(piField: utField);
    procedure SendToInterface(piField: utField);
    procedure SalvaObjeto;

    procedure Initialize;
    { Private declarations }
  public
    { Public declarations }
    Constructor Create(Sender: TComponent; piCadatroCasoDeUso: cxCadatroCasoDeUso; piUseCase: IUMLUseCase); reintroduce;
    Destructor Destroy; override;

    property UseCasePackage: IUMLPackage read fUseCasePackage write fUseCasePackage;
    property UseCase: IUMLUseCase read fUMLUseCase;
  end;

var
  CadastroCasoDeUso: TCadastroCasoDeUso;

implementation

uses IntegracaoDelphiSUML;

{$R *.dfm}

type
  CP1252String = type AnsiString(1252);

constructor TCadastroCasoDeUso.Create(Sender: TComponent; piCadatroCasoDeUso: cxCadatroCasoDeUso; piUseCase: IUMLUseCase);
begin
  inherited Create(sender);
  fUMLUseCase := piUseCase;
  fFormIcones := TCadastroCasoDeUsoIcones.Create(self);
  fcxCadastroCasoDeUso := piCadatroCasoDeUso;
  self.Initialize;
end;

destructor TCadastroCasoDeUso.Destroy;
begin
  FreeAndNil(FContextField);
  inherited Destroy;
end;

procedure TCadastroCasoDeUso.imgIconeClick(Sender: TObject);
begin
  if fFormIcones.ShowModal = mrOk then
    if assigned(fFormIcones.ltvIcones.Selected) then
    begin
      fFormIcones.imgListaIcone.GetBitmap(fFormIcones.ltvIcones.Selected.ImageIndex, imgIcone.Picture.Bitmap);
      imgIcone.Refresh;
    end;
end;

procedure TCadastroCasoDeUso.Initialize;
var lUseCaseCode: string;
    lRequestField, lResponseField: utField;
begin
  //Retorna do caso de uso os atributos da classe
  FreeAndNil(FContextField);
  FContextField := utField.Create;

  lRequestField := utField.Create;
  fcxCadastroCasoDeUso.rmObtemContexto(lRequestField, FContextField);
  SendToInterface(FContextField);

  if assigned(fUMLUseCase) then
  begin
    lRequestField := utField.Create;
    lUseCaseCode := fUMLUseCase.GetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code');
    lRequestField.AddField('CODIGO').AsString :=  lUseCaseCode;
    lResponseField := utField.Create;
    try
      fcxCadastroCasoDeUso.rmEditaObjeto(lRequestField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;

    edtUseCaseName.Text := fUMLUseCase.Name;
    edtPackage.Text := fUMLUseCase.Namespace.Pathname;
    btnSelecionarDestino.Enabled := false;
  end
  else
  begin
    lResponseField := utField.Create;
    try
      lRequestField := utField.Create;
      fcxCadastroCasoDeUso.rmIncluiObjeto(lRequestField, lResponseField);
      SendToInterface(lResponseField);
    finally
      lResponseField.free;
    end;
  end;

end;

procedure TCadastroCasoDeUso.SalvaObjeto;
var lField: utField;
begin
  lField := utField.Create;
  SaveFromInterface(lField);
  fcxCadastroCasoDeUso.rmSalvaObjeto(lField);
end;

procedure TCadastroCasoDeUso.SaveFromInterface(piField: utField);
var lFieldCasoDeUso, lFieldSistemas, lFieldOperacoes: utField;
  I: Integer;
begin
  inherited;
  lFieldCasoDeUso := piField.AddField('CasoDeUso');
//  lFieldCasoDeUso.AddAttribute('OID').AsInteger := FOID;
  lFieldCasoDeUso.AddAttribute('nome').AsString := edtNome.Text;
  lFieldCasoDeUso.AddAttribute('descricao').AsString := edtDescricao.Text;
  if cbxEntidade.ItemIndex <> -1 then lFieldCasoDeUso.AddAttribute('idoentidade').AsInteger := utAttribute(cbxEntidade.Items.Objects[cbxEntidade.ItemIndex]).AsInteger;
  if cbxCategoria.ItemIndex <> -1 then lFieldCasoDeUso.AddAttribute('idocategoria').AsInteger := utAttribute(cbxCategoria.Items.Objects[cbxCategoria.ItemIndex]).AsInteger;
  if assigned(fFormIcones.ltvIcones.Selected) then lFieldCasoDeUso.AddAttribute('idoicone').AsInteger := utAttribute(fFormIcones.ltvIcones.Selected.Data).AsInteger;

  lFieldSistemas := lFieldCasoDeUso.AddField('sistemas');
  for I := 0 to ltvSistema.Items.Count - 1 do
    if ltvSistema.Items[i].Checked then
      lFieldSistemas.AddField('ido').AsInteger := utAttribute(ltvSistema.Items[i].Data).AsInteger;

  lFieldOperacoes := lFieldCasoDeUso.AddField('operacoes');
  for I := 0 to ltvOperacao.Items.Count - 1 do
    if ltvOperacao.Items[i].Checked then
      lFieldOperacoes.AddField('ido').AsInteger :=  utAttribute(ltvOperacao.Items[i].Data).AsInteger;
end;

procedure TCadastroCasoDeUso.SendToInterface(piField: utField);
var lFieldCategorias, lFieldCategoria,
    lFieldEntidades, lFieldEntidade,
    lFieldIcones, lFieldIcone,
    lFieldSistemas, lFieldSistema,
    lFieldOperacoes, lFieldOperacao,
    lFieldCasoDeUsoSistemas,
    lFieldCasoDeUsoOperacoes,
    lFieldCasoDeUso: utField;
    lEnum: acEnumerator;
    lBMP: TBitmap;
    lMemoryStream: TMemoryStream;
    lListItem: TListItem;
    lIDO: integer;
    I,T: integer;
    s: CP1252String;
begin
  inherited;
    //CATEGORIAS
//    ShowMessage(piField.GetXMLString([XMLOptions.xoLegible]));

    lFieldCategorias := piField.FindField('categorias');
    if Assigned(lFieldCategorias) then
    begin
      cbxCategoria.Clear;
      lEnum := lFieldCategorias.GetFieldsEnumerator;
      while not lEnum.EOL do
      begin
        lFieldCategoria := utField(lEnum.Current);
        cbxCategoria.AddItem(lFieldCategoria.AttributeByName('nome').AsString, lFieldCategoria.AttributeByName('ido'));
        lEnum.MoveNext;
      end;
    end;

    //ENTIDADES
    lFieldEntidades := piField.FindField('entidades');
    if Assigned(lFieldEntidades) then
    begin
      cbxEntidade.Clear;
      lEnum := lFieldEntidades.GetFieldsEnumerator;
      while not lEnum.EOL do
      begin
        lFieldEntidade := utField(lEnum.Current);
        s :=  lFieldEntidade.AttributeByName('nome').AsString;
        cbxEntidade.AddItem(lFieldEntidade.AttributeByName('nome').AsString, lFieldEntidade.AttributeByName('ido'));
        lEnum.MoveNext;
      end;
    end;

    //ICONES
    lFieldIcones := piField.FindField('icones');
    if Assigned(lFieldIcones) then
    begin
      fFormIcones.ltvIcones.Clear;
      fFormIcones.imgListaIcone.Clear;
      lEnum := lFieldIcones.GetFieldsEnumerator;
      while not lEnum.EOL do
      begin
        lFieldIcone := utField(lEnum.Current);
        lListItem := fFormIcones.ltvIcones.Items.Add;
        lListItem.Caption := lFieldIcone.AttributeByName('descricao').AsString;
        lListItem.Data := lFieldIcone.AttributeByName('ido');
        lMemoryStream := TMemoryStream.Create;
        try
          lFieldIcone.AttributeByName('imagem').WriteToStream(lMemoryStream);
          lMemoryStream.Position := 0;
          lBMP := TBitmap.Create;
          try
            lBMP.LoadFromStream(lMemoryStream);
            fFormIcones.imgListaIcone.Height := lBMP.Height;
            fFormIcones.imgListaIcone.Width := lBMP.Width;
            lListItem.ImageIndex := fFormIcones.imgListaIcone.Add(lBMP, nil);
          finally
            lBMP.free;
          end;
        finally
          lMemoryStream.free;
        end;
        lEnum.MoveNext;
      end;
    end;

    //SISTEMAS
    lFieldSistemas := piField.FindField('sistemas');
    if Assigned(lFieldSistemas) then
    begin
      ltvSistema.Clear;
      lEnum := lFieldSistemas.GetFieldsEnumerator;
      while not lEnum.EOL do
      begin
        lFieldSistema := utField(lEnum.Current);
        lListItem := ltvSistema.Items.Add;
        lListItem.Caption := lFieldSistema.AttributeByName('nome').AsString;
        lListItem.Data := lFieldSistema.AttributeByName('ido');
        lEnum.MoveNext;
      end;
    end;

    //OPERAES
    lFieldOperacoes :=piField.FindField('operacoes1');
    if Assigned(lFieldOperacoes) then
    begin
      ltvOperacao.Clear;
      lEnum := lFieldOperacoes.GetFieldsEnumerator;
      while not lEnum.EOL do
      begin
        lFieldOperacao := utField(lEnum.Current);
        lListItem := ltvOperacao.Items.Add;
        lListItem.Caption := lFieldOperacao.AttributeByName('descricao').AsString;
        lListItem.Data := lFieldOperacao.AttributeByName('ido');
        lEnum.MoveNext;
      end;
    end;

    //CASO DE USO
    lFieldCasoDeUso := piField.FindField('CasoDeUso');
    if assigned(lFieldCasoDeUso) then
    begin
      if lFieldCasoDeUso.HasAttribute('OID') then FOID := lFieldCasoDeUso.AttributeByName('OID').AsInteger;
      if lFieldCasoDeUso.HasAttribute('Codigo') then lblValorCodigo.Caption := lFieldCasoDeUso.AttributeByName('Codigo').AsString;
      if lFieldCasoDeUso.HasAttribute('Nome') then edtNome.Text := lFieldCasoDeUso.AttributeByName('Nome').AsString;
      if lFieldCasoDeUso.HasAttribute('Descricao') then edtDescricao.Text := lFieldCasoDeUso.AttributeByName('Descricao').AsString;

      if lFieldCasoDeUso.HasAttribute('Entidade') then
      begin
        lIDO := lFieldCasoDeUso.AttributeByName('Entidade').AsInteger;
        for I := 0 to cbxEntidade.Items.Count - 1 do
          if utAttribute(cbxEntidade.Items.Objects[i]).AsInteger = lIDO then
          begin
            cbxEntidade.ItemIndex := I;
            break;
          end;
      end;

      if lFieldCasoDeUso.HasAttribute('Categoria') then
      begin
        lIDO := lFieldCasoDeUso.AttributeByName('Categoria').AsInteger;
        for I := 0 to cbxCategoria.Items.Count - 1 do
          if utAttribute(cbxCategoria.Items.Objects[i]).AsInteger = lIDO then
          begin
            cbxCategoria.ItemIndex := I;
            break;
          end;
      end;

      if lFieldCasoDeUso.HasAttribute('Icone') then
      begin
        lIDO := lFieldCasoDeUso.AttributeByName('Icone').AsInteger;
        for I := 0 to fFormIcones.ltvIcones.Items.Count - 1 do
          if utAttribute(fFormIcones.ltvIcones.Items[i].Data).AsInteger = lIDO then
          begin
            fFormIcones.ltvIcones.Selected := fFormIcones.ltvIcones.Items[i];
            fFormIcones.imgListaIcone.GetBitmap(fFormIcones.ltvIcones.Items[i].ImageIndex, imgIcone.Picture.Bitmap);
            break;
          end;
      end;

      lFieldCasoDeUsoOperacoes := lFieldCasoDeUso.FindField('operacoes');
      if assigned(lFieldCasoDeUsoOperacoes) then
      begin
        lEnum := lFieldCasoDeUsoOperacoes.GetFieldsEnumerator;
        try
          while not lEnum.EOL do
          begin
            lIDO := utField(lEnum.Current).AsInteger;
            for I := 0 to ltvOperacao.Items.Count - 1 do
              if lido = utAttribute(ltvOperacao.Items[i].Data).AsInteger then
              begin
                ltvOperacao.Items[i].Checked := true;
                break;
              end;
            lEnum.MoveNext;
          end;
        finally
          lEnum.free;
        end;
      end;

      lFieldCasoDeUsoSistemas := lFieldCasoDeUso.FindField('sistemas');
      if assigned(lFieldCasoDeUsoSistemas) then
      begin
        lEnum := lFieldCasoDeUsoSistemas.GetFieldsEnumerator;
        try
          while not lEnum.EOL do
          begin
            lIDO := utField(lEnum.Current).AsInteger;
            for I := 0 to ltvSistema.Items.Count - 1 do
              if lido = utAttribute(ltvSistema.Items[i].Data).AsInteger then
              begin
                ltvSistema.Items[i].Checked := true;
                break;
              end;
            lEnum.MoveNext;
          end;
        finally
          lEnum.free;
        end;
      end;
    end;
end;


procedure TCadastroCasoDeUso.SpeedButton1Click(Sender: TObject);
begin
end;

procedure TCadastroCasoDeUso.btnSelecionarDestinoClick(Sender: TObject);
var lElementSelector: IElementSelector;
begin
  lElementSelector := gStarUMLApp.ElementSelector;
  lElementSelector.AllowNull := false;
  lElementSelector.Filter(fkPackages);
  lElementSelector.ClearSelectableModels();
  lElementSelector.AddSelectableModel('UMLPackage');
  if lElementSelector.Execute('Selecione o local para criar o caso de uso') then
  begin
    UseCasePackage :=  lElementSelector.GetSelectedModel as IUMLPackage;
    edtPackage.Text := UseCasePackage.PathName;
  end;
end;

procedure TCadastroCasoDeUso.btnSalvarClick(Sender: TObject);
var lUMLFactory: IUMLFactory;
    lUMLucUseCase: IUMLUseCase;
    lUMLClassDiagram: IUMLClassDiagram;

    lUMLStateMachine: IUMLStateMachine;
    lUMLStatechartDiagram: IUMLStatechartDiagram;
    lUMLPseudoState: IUMLPseudoState;
    lUMLCompositeState: IUMLCompositeState;
begin
  if edtUseCaseName.Text = '' then
  begin
    application.MessageBox(' necessrio informar o nome do caso de uso no StarUML.','StarUML', MB_ICONEXCLAMATION + MB_OK);
    exit;
  end;

  try
    if assigned(fUMLUseCase) then
    begin
      SalvaObjeto;
      fUMLUseCase.Name := edtUseCaseName.Text;
    end
    else
    begin
      if edtPackage.Text = '' then
      begin
        application.MessageBox(' necessrio informar o package onde ser criado o caso de uso.','StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end else if assigned(fUseCasePackage.FindByName(edtUseCaseName.Text)) then
      begin
        application.MessageBox('Caso de uso j existente no pacote selecionado.','StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;

      lUMLucUseCase := gStarUMLAPP.FindByPathname(cBASE_USECASE_CLASS_FULL_PATH) as IUMLUseCase;
      if not assigned(lUMLucUseCase) then
      begin
        application.MessageBox('ucUsecase not found in "' + cBASE_USECASE_CLASS_FULL_PATH + '"', 'StarUML', MB_ICONEXCLAMATION + MB_OK);
        exit;
      end;

      SalvaObjeto;
      lUMLFactory := gStarUMLAPP.UMLFactory;
      //Cria Caso de uso
      fUMLUseCase := lUMLFactory.CreateUseCase(fUseCasePackage);
      fUMLUseCase.Name := edtUseCaseName.Text;
      fUMLUseCase.SetTaggedValueAsString('DBMappings', 'DBUseCaseMap', 'Code', lblValorCodigo.Caption);

      //Cria diagrama de classe para o caso de uso
      lUMLClassDiagram := lUMLFactory.CreateClassDiagram(fUMLUseCase);
      lUMLClassDiagram.Name := 'ClassDiagram';

      //Cria o relacionamento entre ucUsecase e o novo caso de uso
      fUMLUseCase.AddGeneralization(lUMLFactory.CreateGeneralization(fUMLUseCase.Namespace, lUMLucUseCase, fUMLUseCase));

      //Cria StateMachine para o caso de uso com um estado inicial, final e uma transicao ligando os dois
      lUMLStateMachine := lUMLFactory.CreateStateMachine(fUMLUseCase);
      lUMLStateMachine.Name := 'sm' + edtUseCaseName.Text;

      //Cria StatechartDiagram para o StateMachine
      lUMLStatechartDiagram := lUMLFactory.CreateStatechartDiagram(lUMLStateMachine);
      lUMLStatechartDiagram.Name := 'sc' + edtUseCaseName.Text;

      //Cria 2 estados e insere no diagrama s para torn-lo vlido
      lUMLPseudoState := lUMLFactory.CreatePseudostate(lUMLStateMachine.Top as IUMLCompositeState);
      lUMLPseudoState.PseudostateKind := pkInitial;
      lUMLPseudoState.Name := 'Initial1';
      lUMLCompositeState := lUMLFactory.CreateCompositeState(lUMLStateMachine.Top as IUMLCompositeState);
      lUMLCompositeState.Name := 'Executando';
      lUMLFactory.CreateTransition(lUMLStateMachine, lUMLPseudoState, lUMLCompositeState);
      lUMLStatechartDiagram.DiagramView.CreateViewOf(lUMLPseudoState, 200, 100);
      lUMLStatechartDiagram.DiagramView.CreateViewOf(lUMLCompositeState, 165, 200);
    end;
    ModalResult := mrOk;
  except
    on e:Exception do
    begin
      ModalResult := mrnone;
      raise;
    end;
  end;
end;

end.
