unit odbc_dsn_win;

{$mode delphi}

interface

Uses Classes, SysUtils, Registry;


procedure GetODBCDriversList(aODBCDriversList: TStrings);
procedure GetUserDSNList(aDSNList: TStrings);
procedure GetSystemDSNList(aDSNList: TStrings);
function GetDSNLastUser(aDSNName: String): String;

implementation

procedure GetODBCDriversList(aODBCDriversList: TStrings);

var
  aStringlist   : TStringlist;
  aRegistry   : TRegistry;
begin
  aStringlist:= Tstringlist.Create;
  try
    aRegistry:= TRegistry.Create;
    try
      with aRegistry do
      begin
        rootkey:= HKEY_LOCAL_MACHINE;
        OpenKey('Software\ODBC\ODBCINST.INI\ODBC Drivers',False);
        GetValueNames(aStringlist);
      end;
    finally
      aRegistry.Free;
    end;
    aStringlist.Sort;
    aODBCDriversList.AddStrings(aStringlist);
  finally
    aStringlist.Free;
  end;
end;

procedure GetUserDSNList(aDSNList: TStrings);
var
  lStringList : TStringlist;
  lRegistry   : TRegistry;
Begin
  lStringlist := TStringlist.Create;
  try
    lRegistry := Tregistry.Create;
    try
      With lRegistry do
      begin
        RootKey:=HKEY_CURRENT_USER;
        if OpenKeyReadOnly('\SOFTWARE\ODBC\ODBC.INI\ODBC Data Sources')
          then GetValueNames(lStringlist);
      end;
    finally
      lRegistry.Free;
    end;
    lStringlist.Sort;
    aDSNList.AddStrings(lStringlist);
  finally
    lStringlist.Free;
  end;
end;

procedure GetSystemDSNList(aDSNList: TStrings);
var
  lStringList : TStringlist;
  lRegistry   : TRegistry;
Begin
  lStringlist := TStringlist.Create;
  try
    lRegistry := TRegistry.Create;
    try
      with lRegistry do
      begin
        RootKey := HKEY_LOCAL_MACHINE;
        if OpenKeyReadOnly('\SOFTWARE\ODBC\ODBC.INI\ODBC Data Sources')
          then GetValueNames(lStringlist);
      end;
    finally
      lRegistry.Free;
    end;
    lStringlist.Sort;
    aDSNList.AddStrings(lStringlist);
  finally
    lStringlist.Free;
  end;
end;

function GetDSNLastUser(aDSNName: String): String;
var
  lRegistry   : TRegistry;
Begin
  Result := '';
  lRegistry := TRegistry.Create;
  try
    with lRegistry do
    begin
      RootKey := HKEY_LOCAL_MACHINE;
      if OpenKeyReadOnly('\SOFTWARE\ODBC\ODBC.INI\' + aDSNName) then
      begin
        if ValueExists('LastUser') then Result := ReadString('LastUser');
      end;
    end;
  finally
    lRegistry.Free;
  end;

  lRegistry := Tregistry.Create;
  try
    With lRegistry do
    begin
      RootKey := HKEY_CURRENT_USER;
      if OpenKeyReadOnly('\SOFTWARE\ODBC\ODBC.INI\' + aDSNName) then
      begin
        if ValueExists('LastUser') then Result := ReadString('LastUser');
      end;
    end;
  finally
    lRegistry.Free;
  end;

end;

end.

