unit ituXSDExplorer;

interface

uses
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, SynEdit,
  Dialogs, ExtCtrls, StdCtrls, utuXSD, Menus, ComCtrls, Buttons, ActnList, ImgList;

type
  TXSDExplorer = class(TForm)
    Panel1: TPanel;
    PageControl1: TPageControl;
    tsXSD: TTabSheet;
    Panel2: TPanel;
    ltvXSDs: TListView;
    Splitter1: TSplitter;
    alMain: TActionList;
    actSaveAs: TAction;
    actSave: TAction;
    actLoad: TAction;
    actUndo: TAction;
    actGenUnit: TAction;
    btnDeleteXSD: TSpeedButton;
    btnNewXSD: TSpeedButton;
    imgOQLState: TImageList;
    Panel4: TPanel;
    btnSaveClose: TBitBtn;
    Panel3: TPanel;
    pgcXSD: TPageControl;
    TabSheet1: TTabSheet;
    tbsTriggers: TTabSheet;
    Panel5: TPanel;
    Panel6: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    edtName: TEdit;
    edtDescription: TEdit;
    pnlExplorer: TPanel;
    trvStates: TTreeView;
    memXsd: TSynEdit;
    ppmTriggers: TPopupMenu;
    miClear: TMenuItem;
    btnCancelClose: TBitBtn;
    btnSendExternalEditor: TSpeedButton;
    btnGetExternalEditor: TSpeedButton;
    btnCancel: TSpeedButton;
    btnSave: TSpeedButton;
    Panel7: TPanel;
    btnClearAllMappings: TSpeedButton;
    procedure actLoadExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure actNewXSDExecute(Sender: TObject);
    procedure actSaveXSDExecute(Sender: TObject);
    procedure actSaveExecute(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure actDeleteXSDExecute(Sender: TObject);
    procedure ltvXSDsCustomDrawItem(Sender: TCustomListView; Item: TListItem; State: TCustomDrawState;
      var DefaultDraw: Boolean);
    procedure ltvXSDsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure ltvXSDsChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
    procedure actUndoExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure btnSaveCloseClick(Sender: TObject);
    procedure trvStatesCustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
      State: TCustomDrawState; var DefaultDraw: Boolean);
    procedure trvStatesDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure trvStatesDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure miClearClick(Sender: TObject);
    procedure ppmTriggersPopup(Sender: TObject);
    procedure pgcXSDChange(Sender: TObject);
    procedure ltvXSDsDblClick(Sender: TObject);
    procedure btnSendExternalEditorClick(Sender: TObject);
    procedure btnGetExternalEditorClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnClearAllMappingsClick(Sender: TObject);
  private
    { Private declarations }
    fBeforeXSD, fAfterXSD: string;
    fEditing: boolean;

    fXSDList: utXSDFile;
//    FStarUMLApp: IStarUMLApplication;
//    FUMLUseCase: IUMLUseCase;
    fCurrentFileName: string;
    procedure UpdateXSDList;
    procedure UpdateTreeView;
    procedure UpdateTriggersXSDName(piOldName, piNewName: string);
    procedure UpdateUsedTriggerCount;
    procedure SelectedXSDToInterface;
    procedure InterfaceToSelectedXSD;
    function ValidaXSD(piXSD: string): string;
    function GetTagName(piNodeText: string): string;
    function GetCurrentFileName: string;
    function GetExternalXSDEditor: string;
    function GetTempPath: String;
    procedure SetCurrentFileName(const Value: string);
    procedure SetEditing(const Value: boolean);

    property TempPath: String read GetTempPath;
    property CurrentFileName: string read GetCurrentFileName write SetCurrentFileName;
    property ExternalXSDEditor: string read GetExternalXSDEditor;
    property Editing: boolean  read fEditing write SetEditing;

  public
    { Public declarations }
    constructor Create(piOwner: TComponent); reintroduce;
  end;

var
  XSDExplorer: TXSDExplorer;

implementation

uses acuObject, utuStateMachine, IntegracaoDelphiSUML, acuXSDDocument;


{$R *.dfm}

procedure TXSDExplorer.actDeleteXSDExecute(Sender: TObject);
var lXSD: utXSD;
    li: integer;
begin
  if assigned(ltvXSDs.Selected) then
  begin
    lXSD := utXSD(ltvXSDs.Selected.Data);
    li := ltvXSDs.Selected.Index;

    ltvXSDs.Selected.Delete;
    lXSD.Delete;
    if ltvXSDs.Items.Count > 0 then
      if li - 1 >= 0 then
        ltvXSDs.Selected := ltvXSDs.Items[li-1]
      else
        ltvXSDs.Selected := ltvXSDs.Items[0];
      SelectedXSDToInterface;
  end;
end;

procedure TXSDExplorer.actLoadExecute(Sender: TObject);
var lXSDs: string;
begin
  try
    try
//      lXSDs := FUMLUseCase.GetTaggedValueAsString('DBMappings', 'UseCaseMap', 'XSDs');
      ltvXSDs.ItemIndex := -1;
      if assigned(fXSDList) then freeandnil(fXSDList);
      fXSDList := utXSDFile.create(lXSDs);
    Except
      on e:exception do
      begin
        if assigned(fXSDList) then freeandnil(fXSDList);
        fXSDList := utXSDFile.create;
        raise;
      end;
    end;
  finally
    UpdateXSDList;
  end;
end;

procedure TXSDExplorer.actNewXSDExecute(Sender: TObject);
var lListItem: TListItem;
    lXSD: utXSD;
    lCont: integer;
begin
  pgcXSD.ActivePageIndex := 0;
  InterfaceToSelectedXSD;
  lCont := 1;
  while fXSDList.XSDExists('_NEW_XSD_' + inttostr(lCont)) do
    Inc(lCont);

  lXSD := fXSDList.NewXSD('_NEW_XSD_' + inttostr(lCont));
  lListItem := ltvXSDs.Items.Add;
  lListItem.Caption := lXSD.ID;
  lListItem.Data := lXSD;
  lListItem.ImageIndex := 1;
  lListItem.SubItems.Add('');
  lListItem.SubItems.Add('');
  ltvXSDs.Selected := lListItem;
  SelectedXSDToInterface;
  edtName.SetFocus;
  edtName.SelectAll;
end;

procedure TXSDExplorer.actSaveExecute(Sender: TObject);
begin
  InterfaceToSelectedXSD;
  ltvXSDs.SortType := stText;
  ltvXSDs.SortType := stNone;
//  FUMLUseCase.SetTaggedValueAsString('DBMappings', 'UseCaseMap', 'XSDs', fXSDList.XML);    
end;

procedure TXSDExplorer.actSaveXSDExecute(Sender: TObject);
begin
 InterfaceToSelectedXSD;
end;

procedure TXSDExplorer.actUndoExecute(Sender: TObject);
var lXSD: utXSD;
begin
  if Assigned(ltvXSDs.Selected) then
  begin
    lXSD := utXSD(ltvXSDs.Selected.Data);
    edtName.Text := lXSD.ID;
    edtDescription.Text := lXSD.Description;
    memXSD.Lines.Text := lXSD.Text;
  end;
end;

procedure TXSDExplorer.btnCancelClick(Sender: TObject);
begin
  self.Editing := false;
end;

procedure TXSDExplorer.btnGetExternalEditorClick(Sender: TObject);
var laux: TStringList;
begin
  lAux := TStringList.Create;
  try
    lAux.LoadFromFile(self.TempPath + Self.CurrentFileName);
    fAfterXSD := lAux.Text;
  finally
    lAux.free;
  end;

  if fBeforeXSD <> fAfterXSD then
  begin
    memXSD.Lines.Text := fAfterXSD;
//
//    if pgcPrincipal.ActivePage = tbsXSDIn then
//      Self.XSDIn := fAfterXSD
//    else if pgcPrincipal.ActivePage = tbsXSDOut then
//      Self.XSDOut := fAfterXSD;
  end;
  self.Editing := false;
end;

procedure TXSDExplorer.btnSaveCloseClick(Sender: TObject);
begin
  actSaveExecute(sender);
end;

procedure TXSDExplorer.btnSendExternalEditorClick(Sender: TObject);
var
//  SUInfo: TStartupInfo;
//  ProcInfo: TProcessInformation;
  lOk: boolean;
  lAux: TStringList;
begin
  if Self.ExternalXSDEditor = '' then
  begin
//    Application.MessageBox('Need to define an external XSD editor.','StarUML', MB_ICONINFORMATION);
    exit;
  end;

  Self.CurrentFileName := 'StarUmlXSDTmpFile.xsd';

  lAux := TStringList.Create;
  try
    if trim(memXSD.Lines.Text) = '' then
      lAux.Text := '<?xml version="1.0" encoding="utf-8" ?>' + #13#10 +
                    '<xs:schema elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema" />'
    else
      lAux.Text := memXSD.Lines.Text;

    fBeforeXSD := lAux.Text;

    try
      if FileExists(self.TempPath + Self.CurrentFileName) then DeleteFile(self.TempPath + Self.CurrentFileName);
      lAux.SaveToFile(self.TempPath + Self.CurrentFileName);
    except
      Randomize;
      Self.CurrentFileName := 'StarUmlXSDTmpFile' + inttostr(Random(999999)) + '.xsd';
      lAux.SaveToFile(self.TempPath + Self.CurrentFileName);
    end;
  finally
    lAux.free;
  end;

//  FillChar(SUInfo, SizeOf(SUInfo), #0);
//  SUInfo.cb      := SizeOf(SUInfo);
//  SUInfo.dwFlags := STARTF_USESHOWWINDOW;
//  SUInfo.wShowWindow := SW_SHOWNORMAL;

{  lOk := CreateProcess(nil,
                       PChar(ExternalXSDEditor + ' ' + self.TempPath + Self.CurrentFileName),
                       nil,
                       nil,
                       false,
                       CREATE_NEW_CONSOLE or
                       NORMAL_PRIORITY_CLASS,
                       nil,
                       nil,
                       SUInfo,
                       ProcInfo);
 }
  self.Editing := lOK;

  if (lOk) then
  begin
//    CloseHandle(ProcInfo.hProcess);
//    CloseHandle(ProcInfo.hThread);
  end;

end;

procedure TXSDExplorer.miClearClick(Sender: TObject);
begin
//  IUMLTransition(trvStates.Selected.Data).SetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(trvStates.Selected.text), '');
  trvStates.Selected.Text := GetTagName(trvStates.Selected.text);
  UpdateUsedTriggerCount;
  trvStates.Repaint;
end;

procedure TXSDExplorer.Close1Click(Sender: TObject);
begin
  Close;
end;

constructor TXSDExplorer.Create(piOwner: TComponent);
begin
  inherited Create(piOwner);
//  FStarUMLApp := piStarUMLApp;
//  FUMLUseCase := piUMLUseCase;
  actLoadExecute(nil);
  UpdateTreeView;
end;

procedure TXSDExplorer.FormCreate(Sender: TObject);
begin
//  fXSDList := utXSDFile.create('');
//  UpdateXSDList;
end;

procedure TXSDExplorer.FormShow(Sender: TObject);
begin
  if fXSDList.Count = 0 then
    actNewXSDExecute(sender);
end;

function TXSDExplorer.GetCurrentFileName: string;
begin
  result := fCurrentFileName;
end;

function TXSDExplorer.GetExternalXSDEditor: string;
begin
//  result := Self.FStarUMLAPP.GetOptionValue(cOPTIONSCHEMAID, 'EXTERNAL_XSD_EDITOR');
  if (result = '') or (not FileExists(result)) then
  begin
    result := '';
    if FileExists('C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe') then
      result := 'C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe'
    else
      if FileExists('C:\Program Files\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe') then
        result := 'C:\Arquivos de programas\Liquid Technologies\Liquid XML Studio 2008 (v6)\XMLStudio.exe';
  end;
end;

function TXSDExplorer.GetTagName(piNodeText: string): string;
begin
  result := trim(copy(piNodeText,1,7));
end;

function TXSDExplorer.GetTempPath: String;
begin
  Result := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP'));
end;

procedure TXSDExplorer.InterfaceToSelectedXSD;
var lXSD: utXSD;
    lErro: string;
begin
  if Assigned(ltvXSDs.Selected) then
  begin
    lerro := '';
    lXSD := utXSD(ltvXSDs.Selected.Data);
    UpdateTriggersXSDName(lXSD.ID, edtName.text);
    lXSD.ID := edtName.Text;
    lXSD.Description := edtDescription.Text;
    lXSD.Text := memXSD.Lines.Text;
    lErro := ValidaXSD(lXSD.Text);
    if lErro = '' then
      ltvXSDs.Selected.ImageIndex := 0
    else
      ltvXSDs.Selected.ImageIndex := 1;
    ltvXSDs.Selected.Caption := edtName.Text;
    ltvXSDs.Selected.SubItems[0] := lErro;
  end;
end;

procedure TXSDExplorer.ltvXSDsChange(Sender: TObject; Item: TListItem; Change: TItemChange);
begin
  SelectedXSDToInterface;
end;

procedure TXSDExplorer.ltvXSDsChanging(Sender: TObject; Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
begin
  InterfaceToSelectedXSD;
end;

procedure TXSDExplorer.ltvXSDsCustomDrawItem(Sender: TCustomListView; Item: TListItem; State: TCustomDrawState;
  var DefaultDraw: Boolean);
begin
  //item.SubItems[1] guarda a quantidade de trasicoes que usam a trigger
  if (item.SubItems[1] = '') or (strtoint(item.SubItems[1]) = 0) then
    ltvXSDs.Canvas.font.Color := clred;
end;

procedure TXSDExplorer.ltvXSDsDblClick(Sender: TObject);
begin
  if assigned(ltvXSDs.Selected) then
    if ltvXSDs.Selected.SubItems[0] <> '' then
      ShowMessage(ltvXSDs.Selected.SubItems[0]);
end;

procedure TXSDExplorer.pgcXSDChange(Sender: TObject);
begin
 InterfaceToSelectedXSD;
end;

procedure TXSDExplorer.ppmTriggersPopup(Sender: TObject);
begin
  miClear.Caption := 'Clear ';
  miClear.Enabled := false;
  if (assigned(trvStates.Selected)) and (trvStates.Selected.Level = 2) then
  begin
     miClear.Caption := miClear.Caption + trvStates.Selected.Parent.Text + ' (' + trvStates.Selected.Text + ')';
//    miClear.Caption := miClear.Caption + IUMLTransition(trvStates.Selected.Data).GetTriggerAt(0).Name + '(' + trvStates.Selected.Text + ')';
    miClear.Enabled := true;
  end;
end;

procedure TXSDExplorer.UpdateTreeView;
//var lUMLTopState: IUMLCompositeState;
//    lStateCount, lTransitionCount: integer;
//    lUMLState: IUMLStateVertex;
//    lNodeState, lNodeTransition: TTreeNode;
//    lUMLTransition: IUMLTransition;
//    lTransitionName: string;
begin
  //trvStates.Items.Clear;
  //lUMLTopState := FUMLUseCase.GetBehaviorAt(0).Top as IUMLCompositeState;
  //trvStates.Items.BeginUpdate;
  //try
  //  for lStateCount := 0 to lUMLTopState.GetSubvertexCount - 1 do
  //  begin
  //    lUMLState := lUMLTopState.GetSubvertexAt(lStateCount);
  //    lNodeState := trvStates.Items.AddChild(nil, lUMLState.Name);
  //
  //    for lTransitionCount := 0 to lUMLState.GetOutgoingCount - 1 do
  //    begin
  //      lUMLTransition := lUMLState.GetOutgoingAt(lTransitionCount);
  //      lTransitionName := '';
  //      if lUMLTransition.GetTriggerCount > 0 then
  //        lTransitionName := lUMLTransition.GetTriggerAt(0).Name;
  //      if lUMLTransition.GetEffectCount > 0 then
  //        lTransitionName := lTransitionName + ' / ' + lUMLTransition.GetEffectAt(0).Name;
  //
  //      lNodeTransition := trvStates.Items.AddChildObject(lNodeState, lTransitionName, Pointer(lUMLTransition));
  //
  //      if lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In') = '' then
  //        trvStates.Items.AddChildObject(lNodeTransition, 'XSD In', Pointer(lUMLTransition))
  //      else
  //        trvStates.Items.AddChildObject(lNodeTransition, 'XSD In      [' + lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In') + ']', Pointer(lUMLTransition));
  //
  //      if lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out') = '' then
  //        trvStates.Items.AddChildObject(lNodeTransition, 'XSD Out', Pointer(lUMLTransition))
  //      else
  //        trvStates.Items.AddChildObject(lNodeTransition, 'XSD Out     [' + lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out') + ']',Pointer(lUMLTransition));
  //    end;
  //    lNodeState.Expand(true);
  //  end;
  //finally
  //  trvStates.Items.EndUpdate;
  //end;
end;

procedure TXSDExplorer.UpdateTriggersXSDName(piOldName, piNewName: string);
//var lUMLTopState: IUMLCompositeState;
//    lStateCount, lTransitionCount: integer;
//    lUMLState: IUMLStateVertex;
//    lUMLTransition: IUMLTransition;
//    lFound: boolean;
begin
  //if piOldName <> piNewName then
  //begin
  //  lFound := false;
  //  lUMLTopState := FUMLUseCase.GetBehaviorAt(0).Top as IUMLCompositeState;
  //  for lStateCount := 0 to lUMLTopState.GetSubvertexCount - 1 do
  //  begin
  //    lUMLState := lUMLTopState.GetSubvertexAt(lStateCount);
  //    for lTransitionCount := 0 to lUMLState.GetOutgoingCount - 1 do
  //    begin
  //      lUMLTransition := lUMLState.GetOutgoingAt(lTransitionCount);
  //      if lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In') = piOldName then
  //      begin
  //        lUMLTransition.SetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In', piNewName);
  //        lFound := true;
  //      end;
  //
  //      if lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out') = piOldName then
  //      begin
  //        lUMLTransition.SetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out', piNewName);
  //        lFound := true;
  //      end;
  //    end;
  //  end;
  //  if lFound then UpdateTreeView;
  //end;
end;

procedure TXSDExplorer.UpdateUsedTriggerCount;
//var lUMLTopState: IUMLCompositeState;
//    lStateCount, lTransitionCount: integer;
//    lUMLState: IUMLStateVertex;
//    lUMLTransition: IUMLTransition;
//    lListItem: TListItem;
//    I: Integer;
begin
  //for I := 0 to ltvXSDs.Items.Count - 1 do ltvXSDs.Items[i].SubItems[1] := '0';
  //
  //lUMLTopState := FUMLUseCase.GetBehaviorAt(0).Top as IUMLCompositeState;
  //for lStateCount := 0 to lUMLTopState.GetSubvertexCount - 1 do
  //begin
  //  lUMLState := lUMLTopState.GetSubvertexAt(lStateCount);
  //
  //  for lTransitionCount := 0 to lUMLState.GetOutgoingCount - 1 do
  //  begin
  //    lUMLTransition := lUMLState.GetOutgoingAt(lTransitionCount);
  //
  //    lListItem := ltvXSDs.FindCaption(0,lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD In'),false,true,true);
  //    if assigned(lListItem) then
  //      lListItem.SubItems[1] := inttostr(strtoint(lListItem.SubItems[1]) + 1);
  //
  //    lListItem := ltvXSDs.FindCaption(0,lUMLTransition.GetTaggedValueAsString('DBMappings', 'TransitionMap', 'XSD Out'),false,true,true);
  //    if assigned(lListItem) then
  //      lListItem.SubItems[1] := inttostr(strtoint(lListItem.SubItems[1]) + 1);
  //  end;
  //end;
  //ltvXSDs.Repaint;
end;

procedure TXSDExplorer.UpdateXSDList;
var lListItem: TListItem;
    lEnum: acEnumerator;
    lXSD: utXSD;
    lErro: string;
begin
  ltvXSDs.Items.BeginUpdate;
  try
    ltvXSDs.Clear;
    lEnum := fXSDList.GetXSDEnumerator;
    try
      while not lEnum.EOL do
      begin
        lerro := '';
        lXSD := utXSD(lEnum.Current);
        lListItem := ltvXSDs.Items.Add;
        lListItem.Caption := lXSD.ID;
        lListItem.Data := lXSD;
        lErro := ValidaXSD(lXSD.Text);
        if lErro = '' then
          lListItem.ImageIndex := 0
        else
          lListItem.ImageIndex := 1;
        lListItem.SubItems.Add(lErro);
        lListItem.SubItems.Add('');
        lEnum.MoveNext;
      end;
    finally
      lEnum.free;
    end;
    UpdateUsedTriggerCount;
  finally
    ltvXSDs.Items.EndUpdate;
  end;
  if ltvXSDs.Items.Count > 0 then
  begin
    ltvXSDs.ItemIndex := 0;
    SelectedXSDToInterface;
  end;
  ltvXSDs.Repaint;
end;

function TXSDExplorer.ValidaXSD(piXSD: string): string;
var lXSDDoc: acXSDDocument;
begin
  result := '';
  lXSDDoc := acXSDDocument.Create;
  try
    try
      lXSDDoc.XML := piXSD;
    Except
      on e:exception do
      begin
        Result := e.Message;
      end;
    end;
  finally
    lXSDDoc.free;
  end;
end;

procedure TXSDExplorer.SelectedXSDToInterface;
var lXSD: utXSD;
begin
  trvStates.Repaint;
  edtName.Text := '';
  edtDescription.Text := '';
  memXSD.Lines.Text := '';
  if Assigned(ltvXSDs.Selected) then
  begin
    lXSD := utXSD(ltvXSDs.Selected.Data);
    edtName.Text := lXSD.ID;
    edtDescription.Text := lXSD.Description;
    memXSD.Lines.Text := lXSD.Text;
  end;
  ltvXSDs.Column[0].Caption := 'XSD Name (' + IntToStr(fXSDList.Count) + ')';
end;

procedure TXSDExplorer.SetCurrentFileName(const Value: string);
begin
  fCurrentFileName := value;
end;

procedure TXSDExplorer.SetEditing(const Value: boolean);
begin
  fEditing := Value;
  btnSendExternalEditor.Visible := not value;
  btnGetExternalEditor.Visible := value;
  btnCancel.Visible := value;
  tbsTriggers.Visible := not value;
  ltvXSDs.Enabled := not value;
  btnSaveClose.Enabled := not value;
  btnCancelClose.Enabled := not value;
  btnNewXSD.Enabled := not value;
  btnSave.Enabled := not value;
  btnDeleteXSD.Enabled := not value;
end;

procedure TXSDExplorer.btnClearAllMappingsClick(Sender: TObject);
var I: integer;
begin
  Screen.Cursor := crhourglass;
  try
    for I := 0 to trvStates.Items.Count - 1 do
      if (trvStates.Items[i].Level = 2) then
      begin
//        IUMLTransition(trvStates.Items[i].Data).SetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(trvStates.Items[i].text), '');
        trvStates.Items[i].Text := GetTagName(trvStates.Items[i].text);
      end;
    UpdateUsedTriggerCount;
    trvStates.Repaint;
  finally
    Screen.Cursor := crdefault;
  end;
end;

procedure TXSDExplorer.trvStatesCustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  Sender.Canvas.Font.Size := 10;
  Sender.Canvas.Font.Color:=clblack;
  Sender.Canvas.Font.Style := [];
  if node.Level = 0 then
  begin
    Sender.Canvas.Font.Style := [fsBold];
    Sender.Canvas.Font.Color:=clMaroon;
  end
    else if Node.Level = 2 then
    begin
      //if IUMLTransition(Node.Data).GetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(Node.text)) = '' then
      //begin
      //  Sender.Canvas.Font.Color:=clGray;
      //end
      //else
      //  if assigned(ltvXSDs.Selected) then
      //    if IUMLTransition(Node.Data).GetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(Node.text)) = ltvXSDs.Selected.Caption then
      //    begin
      //      Sender.Canvas.Font.Size := 12;
      //      Sender.Canvas.Font.Style := [fsBold];
      //      Sender.Canvas.Font.Color:=clBlue;
      //    end
      //    else
      //      if not assigned(ltvXSDs.FindCaption(0,IUMLTransition(Node.Data).GetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(Node.text)),false,true,true)) then
      //      begin
      //        Sender.Canvas.Font.Color:=clred;
      //      end;

    end;
end;

procedure TXSDExplorer.trvStatesDragDrop(Sender, Source: TObject; X,
  Y: Integer);
  var lNode: TTreeNode;
begin
  if source = ltvXSDs then
  begin
    lNode := (Sender as TTreeView).GetNodeAt(X,Y);
    if assigned(lNode) then
    begin
      if lNode.Level = 2 then
      begin
//        IUMLTransition(lNode.Data).SetTaggedValueAsString('DBMappings', 'TransitionMap', GetTagName(lNode.text), (source as TListView).Selected.Caption);
        if GetTagName(lNode.text) = 'XSD In' then
          lNode.Text := 'XSD In      [' + (source as TListView).Selected.Caption + ']'
        else
          lNode.Text := 'XSD Out     [' + (source as TListView).Selected.Caption + ']';
        (Sender as TTreeView).Repaint;
      end;
      UpdateUsedTriggerCount;
    end;
  end;
end;

procedure TXSDExplorer.trvStatesDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  if sender = ltvXSDs then
    accept := true;
end;

end.
