unit ituOQLParams;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFnDEF FPC}
  Mask, Windows,
{$ELSE}
  MaskEdit, LCLIntf, LCLType, LMessages,
{$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, acuOQL, ComCtrls, StdCtrls, acuContainers, Buttons;

const cCol1 = 5;
      cCol1Width = 120;

      cCol2 = cCol1 + cCol1Width + 10;
      cCol2Width = 210;

      cCol3 = cCol2 + cCol2Width + 10;
      cCol3Width = 40;

      cCol4 = cCol3 + cCol3Width + 10;
      cCol4Width = 120;

type

  TOQLParams = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    sbParams: TScrollBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    fParams: TList;
    fOQLQuery: acAbstractOQLQuery;
    procedure SetOQLQuery(const Value: acAbstractOQLQuery);
    { Private declarations }
  public
    { Public declarations }
    Procedure ParamsToInterface;
    procedure InterfaceToParams;
    Constructor Create(piOwner: TComponent; piQuery: acAbstractOQLQuery); reintroduce;
    property OQLQuery: acAbstractOQLQuery read fOQLQuery write SetOQLQuery;
  end;

implementation

uses acuObject;

type

  TInterfaceParam = class
  private
    fLabelParamName: TLabel;
    fComponent: TWinControl;
    fLabelDataType: TLabel;
    fCheckBoxNull: TCheckBox;

    fParam: acOQLParam;
    fScrollBox: TScrollBox;
  public
    procedure ApplyValueToParam;
    constructor create(piParam: acOQLParam; piParent: TScrollBox);
    destructor Destroy; override;
  end;


{$R *.dfm}

{ TForm2 }

procedure TOQLParams.BitBtn1Click(Sender: TObject);
var
  I: Integer;
begin
  try
    for I := 0 to fParams.Count - 1 do
      TInterfaceParam(fParams.Items[i]).ApplyValueToParam;
  except
    ModalResult := mrnone;
    raise;
  end;
end;

procedure TOQLParams.BitBtn3Click(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to fParams.Count - 1 do
    TInterfaceParam(fParams.Items[i]).fCheckBoxNull.checked := true;
end;

constructor TOQLParams.Create(piOwner: TComponent; piQuery: acAbstractOQLQuery);
begin
  inherited Create(piOwner);
  Self.Width := cCol4 + cCol4Width + 40;
  fParams := TList.Create;
  OQLQuery := piQuery;
  ParamsToInterface;
end;

procedure TOQLParams.FormClose(Sender: TObject; var Action: TCloseAction);
var
  I: Integer;
begin
  for I := fParams.Count - 1 downto 0 do TInterfaceParam(fParams.Items[i]).Free;
  fParams.free;
end;

procedure TOQLParams.InterfaceToParams;
begin

end;

procedure TOQLParams.ParamsToInterface;
var lEnum: acEnumerator;
    lParam: acOQLParam;
    lInterfaceParam: TInterfaceParam;
begin
  lEnum := OQLQuery.Parameters.GetEnumerator;
  try
    while not lEnum.EOL do
    begin
      lParam := acOQLParam(lEnum.Current);
      lInterfaceParam := TInterfaceParam.create(lParam, sbParams);
      fParams.Add(lInterfaceParam);
      lEnum.MoveNext;
    end;
    Self.Height := sbParams.Tag + 120;
  finally
    lEnum.Free;
  end;
end;

procedure TOQLParams.SetOQLQuery(const Value: acAbstractOQLQuery);
begin
  fOQLQuery := Value;
end;

{ TInterfaceParam }

procedure TInterfaceParam.ApplyValueToParam;
begin
  if fCheckBoxNull.Checked then
    fParam.SetNull
  else
  begin
    if fParam is acOQLParamString        then acOQLParamString(fParam).Value   := TEdit(fComponent).Text
    else if fParam is acOQLParamChar     then acOQLParamChar(fParam).Value     := TEdit(fComponent).Text
    else if fParam is acOQLParamDateTime then acOQLParamDateTime(fParam).Value := SysUtils.strtodatetime(TMaskEdit(fComponent).text)
    else if fParam is acOQLParamBoolean  then acOQLParamBoolean(fParam).Value  := TCheckBox(fComponent).Checked
    else if fParam is acOQLParamInt      then acOQLParamInt(fParam).Value      := strtoint(TEdit(fComponent).Text)
    else if fParam is acOQLParamDouble   then acOQLParamDouble(fParam).Value   := SysUtils.StrToFloat(TEdit(fComponent).Text)
    else if fParam is acOQLParamCurrency then acOQLParamCurrency(fParam).Value := SysUtils.StrToCurr(TEdit(fComponent).Text)
  end;
end;

constructor TInterfaceParam.create(piParam: acOQLParam; piParent: TScrollBox);
begin
  fParam := piParam;
  fScrollBox := piParent;

  fScrollBox.Tag := fScrollBox.Tag + 30;

  //NOME DO PARAMETRO
  fLabelParamName := TLabel.Create(nil);
  fLabelParamName.AutoSize := false;
  fLabelParamName.Alignment := taRightJustify;
  fLabelParamName.Parent := fScrollBox;
  fLabelParamName.Left := cCol1;
  fLabelParamName.Width := cCol1Width;
  fLabelParamName.Top := fScrollBox.Tag + 3;

  fLabelParamName.AutoSize := false;
  fLabelParamName.Caption := fParam.Name + ':';

  //VALOR DO PARAMETRO
    if fParam is acOQLParamString then
      fComponent := TEdit.Create(nil)
    else if fParam is acOQLParamChar then
      fComponent := TEdit.Create(nil)
    else if fParam is acOQLParamDateTime then
    begin
      fComponent := TMaskEdit.Create(nil);
      TMaskEdit(fComponent).EditMask := '99/99/9999 99:99';
    end
    else if fParam is acOQLParamBoolean then
      fComponent := TCheckBox.Create(nil)
    else if fParam is acOQLParamInt then
      fComponent := TEdit.Create(nil)
    else if fParam is acOQLParamDouble then
      fComponent := TEdit.Create(nil)
    else if fParam is acOQLParamCurrency then
      fComponent := TEdit.Create(nil)
    else
      raise Exception.Create('TInterfaceParam.create: Param "' + fParam.ClassName + '" not found.');

  fComponent.Parent := fScrollBox;
  fComponent.Left := cCol2;
  fComponent.Width := cCol2Width;
  fComponent.Top := fScrollBox.Tag;

  //CheckBox NULL
  fCheckBoxNull := TCheckBox.Create(nil);
  fCheckBoxNull.Parent := fScrollBox;
  fCheckBoxNull.Left := cCol3;
  fCheckBoxNull.Width := cCol3Width;
  fCheckBoxNull.top := fScrollBox.Tag + 2;
  fCheckBoxNull.Caption := 'Null';


  //TIPO DO PARAMETRO
  fLabelDataType := TLabel.Create(nil);
  fLabelDataType.AutoSize := false;
  fLabelDataType.Parent := fScrollBox;
  fLabelDataType.Left := cCol4;
  fLabelDataType.Width := cCol4Width;
  fLabelDataType.top := fScrollBox.Tag + 3;
  fLabelDataType.AutoSize := false;
  fLabelDataType.Caption := '(' + fParam.ClassName + ')';
end;

destructor TInterfaceParam.Destroy;
begin
  fLabelParamName.free;
  fLabelDataType.Free;
  fComponent.free;
  fCheckBoxNull.free;
  inherited;
end;

end.
