unit ituDataBaseLogin;

interface

uses
  SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, ValEdit, Registry, Buttons,
  IntegracaoDelphiSUML, acuSQLDialectManager;

const cPROJECT_SAVE_OPTIONS_PATH = 'Software\StarUML\Options\' + cOPTIONSCHEMAID + '\Projects\';

type

  { TDataBaseLogin }

  TDataBaseLogin = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    cbODBCD_DSN: TComboBox;
    cbDialect: TComboBox;
    cbODBCD_DRIVERS: TComboBox;
    edtServerName: TLabeledEdit;
    edtUsuario: TLabeledEdit;
    edtPassword: TLabeledEdit;
    edtDatabaseName: TLabeledEdit;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Panel2: TPanel;
    rbDSN: TRadioButton;
    rbPersonalizado: TRadioButton;
    procedure cbODBCD_DSNChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure rbDSNClick(Sender: TObject);
    procedure rbPersonalizadoClick(Sender: TObject);
  private
    FProjectFileName: string;
    procedure SetProjectFileName(const Value: string);
  public
    property ProjectFileName: string read FProjectFileName write SetProjectFileName;
  end;

implementation

uses acuQuerySQLODBC, strUtils, acuObject, utuFactory;

{$R *.dfm}

procedure TDataBaseLogin.Button2Click(Sender: TObject);
begin
  ModalResult := mrCancel;
end;

procedure TDataBaseLogin.Button1Click(Sender: TObject);
var lReg: TRegistry;
begin
  ModalResult := mrNone;
  if ((cbODBCD_DSN.ItemIndex <> -1) or (cbODBCD_DRIVERS.ItemIndex <> -1))and (cbDialect.ItemIndex <> -1) then
  begin
    lReg := TRegistry.Create;
    try
      lReg.RootKey := HKEY_CURRENT_USER;
      lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ProjectFileName + '\Explorer', true);
      if rbDSN.Checked
        then lReg.WriteString('DSN', 'Yes')
        else lReg.WriteString('DSN', 'No');
      lReg.WriteString('DEFAULT_DSN', cbODBCD_DSN.Text);
      lReg.WriteString('DEFAULT_DRIVER', cbODBCD_DRIVERS.Text);
      lReg.WriteString('DEFAULT_SERVER', edtServerName.Text);
      lReg.WriteString('DEFAULT_DATABASE', edtDatabaseName.Text);
      lReg.WriteString('DEFAULT_DSN_USER', edtUsuario.Text);
      lReg.WriteString('DEFAULT_SQL_DIALECT', cbDialect.Caption);
    finally
      lReg.free;
    end;
    ModalResult := mrOk;
  end;
end;

procedure TDataBaseLogin.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;
end;

procedure TDataBaseLogin.cbODBCD_DSNChange(Sender: TObject);
begin
  {$IFDEF MSWINDOWS}
//  edtUsuario.Text := GetDSNLastUser(cbODBCD_DSN.Text);
  {$ENDIF}
  edtPassword.Text := '';
end;


procedure TDataBaseLogin.FormShow(Sender: TObject);
var lReg: TRegistry;
    lDSNActive, lDSN, lDriver, lDialect: string;
    lObj: acObject;
begin
  GetSystemDSNList(cbODBCD_DSN.Items);
  GetUserDSNList(cbODBCD_DSN.Items);
  GetDriverList(cbODBCD_DRIVERS.Items);

  for lObj in gSQLDialectManager.InstancedObjects do
  begin
    cbDialect.AddItem(acFactoredObject(lObj).Ticket.Code, lObj);
  end;

  ModalResult := mrNone;
  lReg := TRegistry.Create;
  try
    lReg.RootKey := HKEY_CURRENT_USER;
    lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ProjectFileName + '\Explorer', true);

    lDSNActive := lReg.ReadString('DSN');
    lDSN := lReg.ReadString('DEFAULT_DSN');
    lDriver := lReg.ReadString('DEFAULT_DRIVER');
    if lDriver <> ''
      then cbODBCD_DRIVERS.ItemIndex := cbODBCD_DRIVERS.Items.IndexOf(lDriver);

    if lDSN <> ''
      then cbODBCD_DSN.ItemIndex := cbODBCD_DSN.Items.IndexOf(lDSN);

    edtServerName.Text := lReg.ReadString('DEFAULT_SERVER');
    edtDatabaseName.Text := lReg.ReadString('DEFAULT_DATABASE');
    if lDSNActive = 'Yes' then
    begin
      rbDSN.Checked := True;
      rbDSNClick(rbDSN);
    end
    else
    begin
      if lDSNActive = 'No' then
      begin
        rbPersonalizado.Checked := True;
        rbPersonalizadoClick(rbPersonalizado);
      end;
    end;

    edtUsuario.Text := lReg.ReadString('DEFAULT_DSN_USER');

    lDialect := lReg.ReadString('DEFAULT_SQL_DIALECT');
    if lDialect <> '' then cbDialect.ItemIndex := cbDialect.Items.IndexOf(lDialect);
  finally
    lReg.free;
  end;

  if (cbODBCD_DSN.Caption <> '') and (cbDialect.Caption <> '') and (edtUsuario.Text <> '')
    then edtPassword.SetFocus;
end;

procedure TDataBaseLogin.rbDSNClick(Sender: TObject);
begin
  cbODBCD_DSN.Enabled := True;
  cbODBCD_DRIVERS.Enabled := False;
  edtDatabaseName.Enabled := False;
  edtServerName.Enabled := False;
end;

procedure TDataBaseLogin.rbPersonalizadoClick(Sender: TObject);
begin
  cbODBCD_DSN.Enabled := False;
  cbODBCD_DRIVERS.Enabled := True;
  edtDatabaseName.Enabled := True;
  edtServerName.Enabled := True;
end;

procedure TDataBaseLogin.SetProjectFileName(const Value: string);
begin
  FProjectFileName := Value;
end;


end.
