unit fModelMappingsGenerationOptions;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFnDEF FPC}
  Windows,
{$ELSE}
  LCLIntf, LCLType, LMessages,
{$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, ShellCtrls, Registry, IntegracaoDelphiSUML, ComCtrls;

const cPROJECT_SAVE_OPTIONS_PATH = 'Software\StarUML\Options\' + cOPTIONSCHEMAID + '\Projects\';

type

  { TModelMappingsGenerationOptions }

  TModelMappingsGenerationOptions = class(TForm)
    ImageList1: TImageList;
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    GroupBox1: TGroupBox;
    edtFileName: TEdit;
    GroupBox2: TGroupBox;
    ckbIgnoreXSD: TCheckBox;
    lblFileExists: TLabel;
    BitBtn3: TBitBtn;
    dlbDirectory: TShellTreeView;
    SpeedButton1: TSpeedButton;
    OpenDialog1: TOpenDialog;
    ckbDefault: TCheckBox;
    GroupBox3: TGroupBox;
    rdObjectPascal: TRadioButton;
    rdCSharp: TRadioButton;
    rdJava: TRadioButton;
    procedure dlbDirectoryGetImageIndex(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure edtFileNameChange(Sender: TObject);
    procedure dlbDirectoryClick(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure rdLanguageClick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
//    FStarUMLApp: IStarUMLApplication;
//    procedure SetStarUMLApp(const Value: IStarUMLApplication);
    procedure CheckFile;
    procedure GetParameters;
    { Private declarations }
  public
    { Public declarations }
//    property StarUMLApp: IStarUMLApplication read FStarUMLApp write SetStarUMLApp;
  end;

var
  ModelMappingsGenerationOptions: TModelMappingsGenerationOptions;

implementation

{$R *.dfm}

{ TModelMappingsGenerationOptions }

procedure TModelMappingsGenerationOptions.BitBtn1Click(Sender: TObject);
var lReg: TRegistry;
begin
  ModalResult := mrnone;
  if edtFileName.Text = '' then
    Application.MessageBox('Model mappings file name must be specified.', 'Attention', MB_ICONINFORMATION)
  else
  begin
    if ckbDefault.Checked then
    begin
      lReg := TRegistry.Create;
      try
        lReg.RootKey := HKEY_CURRENT_USER;
        lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(gStarUMLApp.ProjectManager.FileName), true);
        lReg.WriteString('MODELMAPPINGS_IGNORE_XSD_SCHEMA', BoolToStr(ckbIgnoreXSD.Checked, true));
        lReg.WriteString('MODELMAPPINGS_OUTPUT_DIRECTORY', dlbDirectory.Path);
        lReg.WriteString('MODELMAPPINGS_FILENAME', edtFileName.Text);
        
        if rdObjectPascal.Checked then
        begin            
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'O');
        end
        else if rdCSharp.Checked then
        begin
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'C');
        end
        else
        begin
          lReg.WriteString('MODELMAPPINGS_TARGET_LANGUAGE', 'J');
        end;
      finally
        lReg.free;
      end;
    end;          
         
    ModalResult := mrOk;
  end;
end;

procedure TModelMappingsGenerationOptions.BitBtn3Click(Sender: TObject);
begin
  GetParameters;
end;

procedure TModelMappingsGenerationOptions.rdLanguageClick(Sender: TObject);
begin
  if Sender = rdCSharp
  then edtFileName.Text := ChangeFileExt(edtFileName.Text, '.cs')
  else if Sender = rdJava
       then edtFileName.Text := ChangeFileExt(edtFileName.Text, '.java')
       else edtFileName.Text := ChangeFileExt(edtFileName.Text, '.pas');
end;

procedure TModelMappingsGenerationOptions.CheckFile;
begin
  lblFileExists.Visible := FileExists(IncludeTrailingPathDelimiter(dlbDirectory.Path) + edtFileName.Text);
end;

procedure TModelMappingsGenerationOptions.dlbDirectoryClick(Sender: TObject);
begin
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.edtFileNameChange(Sender: TObject);
begin
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.FormDestroy(Sender: TObject);
begin
end;

procedure TModelMappingsGenerationOptions.FormShow(Sender: TObject);
begin
  GetParameters;
end;

procedure TModelMappingsGenerationOptions.dlbDirectoryGetImageIndex(Sender: TObject; Node: TTreeNode);
begin
  Node.ImageIndex := 0;
end;

procedure TModelMappingsGenerationOptions.GetParameters;
var lReg: TRegistry;
begin
  lReg := TRegistry.Create;
  try
    lReg.RootKey := HKEY_CURRENT_USER;
    lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(gStarUMLApp.ProjectManager.FileName), true);

    ckbIgnoreXSD.Checked := StrToBoolDef(lReg.ReadString('MODELMAPPINGS_IGNORE_XSD_SCHEMA'), false);

    if lReg.ReadString('MODELMAPPINGS_OUTPUT_DIRECTORY') <> '' then
      dlbDirectory.Path := lReg.ReadString('MODELMAPPINGS_OUTPUT_DIRECTORY')
    else
      dlbDirectory.Path := ExtractFilePath(gStarUMLApp.ProjectManager.FileName);

    if lReg.ReadString('MODELMAPPINGS_FILENAME') <> '' then
      edtFileName.Text := lReg.ReadString('MODELMAPPINGS_FILENAME')
    else
      edtFileName.Text := 'acuRegisterModelMappings.pas';

    if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') <> '' then
    begin
      if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') = 'O' then
        rdObjectPascal.Checked := True
      else if lReg.ReadString('MODELMAPPINGS_TARGET_LANGUAGE') = 'C' then
        rdCSharp.Checked := True
      else
        rdJava.Checked := True;
           
    end
    else
      rdObjectPascal.Checked := True;
  finally
    lReg.free;
  end;
  CheckFile;
end;

procedure TModelMappingsGenerationOptions.SpeedButton1Click(Sender: TObject);
begin
  OpenDialog1.InitialDir := dlbDirectory.Path;
  if OpenDialog1.Execute then
  begin
    dlbDirectory.Path := ExtractFilePath(OpenDialog1.FileName);
    edtFileName.Text := ExtractFileName(OpenDialog1.FileName);
    CheckFile;
  end;
end;


end.
