unit acuObjectExplorer;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFnDEF FPC}
  Windows,
{$ELSE}
  LCLIntf, LCLType, LMessages,
{$ENDIF}
  Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, acuModel, acuframework;

type

  { TObjectExplorer }

  TObjectExplorer = class(TFrame)
    tvExplorer: TTreeView;
    procedure tvExplorerGetSelectedIndex(Sender: TObject; Node: TTreeNode);
    procedure tvExplorerItemExpanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure SetSession(piSession: acPersistenceSession);
    procedure SetList(piList: acPersistentObjectList; piDesc: string);
    procedure SetPersistenceManager(piPersistenceManager: acPersistenceManager);
  end;

implementation

{$R *.lfm}

uses TypInfo, acuObject;

procedure TObjectExplorer.SetList(piList: acPersistentObjectList; piDesc: string);
var lNode: TTreeNode;
begin
  tvExplorer.Items.Clear;
  if assigned(piList) then
  begin
    lNode := tvExplorer.Items.AddChildObject(nil, piDesc, piList);
    lNode.HasChildren := True;
    lNode.Expand(False);
  end;
end;

procedure TObjectExplorer.SetPersistenceManager(piPersistenceManager: acPersistenceManager);
var lNode: TTreeNode;
begin
  if assigned(piPersistenceManager) then
  begin
    lNode := tvExplorer.Items.AddChildObject(nil, 'Objects Repository', piPersistenceManager);
    lNode.HasChildren := True;
    lNode.Expand(False);
  end;
end;

procedure TObjectExplorer.SetSession(piSession: acPersistenceSession);
var lNode: TTreeNode;
begin
  tvExplorer.Items.Clear;
  if assigned(piSession) then
  begin
    lNode := tvExplorer.Items.AddChildObject(nil, piSession.Name, piSession);
    lNode.HasChildren := True;
    lNode.Expand(False);
  end;
end;

procedure TObjectExplorer.tvExplorerItemExpanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean);
var lSession: acPersistenceSession;
    lPatriarca: acPatriarca;
    lPersistentObject: acPersistentObject;
    lClassTicket: acClassTicket;
    lObject: acObject;
    lEnumerator: acEnumerator;
    lImageIndex, li: integer;
    lAttribute: acAttribute;
    lAttributeTicket: acAttributeTicket;
    lPropertyName: String;
    lRelation: acRelationTicket;
    lNode: TTreeNode;
begin
  if Node.HasChildren and (Node.Count = 0)then
  begin
    Node.Owner.BeginUpdate;
    try
      if (TObject(Node.Data) is acPersistenceManager) then
      begin
        lEnumerator := acPersistenceManager(Node.Data).GetSessionsEnumerator;
        li := 1;
        while not lEnumerator.EOL do
        begin
          lSession := acPersistenceSession(lEnumerator.Current);
          Node.Owner.AddChildObject(Node, 'Session ' + inttostr(li) + ': ' + lSession.Name, lSession).HasChildren := True;
          lEnumerator.MoveNext;
          inc(li);
        end;
      end
      else if (TObject(Node.Data) is acPersistenceSession) then
      begin
        lSession := acPersistenceSession(Node.Data);
        lEnumerator := lSession.getPatriarcsEnumerator;
        while not lEnumerator.EOL do
        begin
          lPatriarca := acPatriarca(lEnumerator.Current);
          Node.Owner.AddChildObject(Node, lPatriarca.ClassTicket.PersistentObjectClassName, lPatriarca).HasChildren := True;
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acPatriarca) then
      begin
        lPatriarca := acPatriarca(Node.Data);
        lEnumerator := lPatriarca.Objects.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          Node.Owner.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject).HasChildren := True;
          lEnumerator.MoveNext;
        end;
        lEnumerator := lPatriarca.NewObjects.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          Node.Owner.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject).HasChildren := True;
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acPersistentObject) or (TObject(Node.Data) is acRelationPartnerShip) then
      begin
        if (TObject(Node.Data) is acPersistentObject)
          then lPersistentObject := acPersistentObject(Node.Data)
          else lPersistentObject := acRelationPartnerShip(Node.Data).Partner;
        lClassTicket := lPersistentObject.ClassTicket;

        while lClassTicket <> nil do
        begin
          for li := 0 to pred(lClassTicket.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
            if lAttributeTicket.Mandatory
              then lImageIndex := 5
              else lImageIndex := 0;
            lAttribute := lPersistentObject.AttributeByName(lAttributeTicket.AttributeName);
            if assigned(lAttribute) then
            begin
              if lAttribute.IsNull
                then Node.Owner.AddChildObject(Node, lAttributeTicket.AttributeName+ ': '+lAttributeTicket.AttributeType+' (null)', lAttribute).ImageIndex := lImageIndex
                else Node.Owner.AddChildObject(Node, lAttributeTicket.AttributeName+ ': '+lAttributeTicket.AttributeType+' ('+lAttribute.AsString + ')', lAttribute).ImageIndex := lImageIndex;
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        end;

        lClassTicket := lPersistentObject.ClassTicket;
        while lClassTicket <> nil do
        begin
          for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
          begin
            lRelation := (lClassTicket.RelationTicketsIn.Objects[li] as acRelationTicket);

            lPropertyName := lRelation.DestinationPropertyName;
            if (lPropertyName <> '') then
            begin
              if lRelation.DestinationMaxMultiplicity <= 1 then
              begin
                if lRelation.DestinationMinMultiplicity > 0 then lImageIndex := 3 else lImageIndex := 1;
                lObject := acObject(lPersistentObject.PartnerShipByName(lPropertyName));
                if acRelationPartnerShip(lObject).Status = acRelationPartnerStatus.PSLoaded then
                begin
                  if assigned(acRelationPartnerShip(lObject).Partner)
                    then begin
                           lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginClassTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).Partner.IDO.AsString + ')', acRelationPartnerShip(lObject).Partner);
                           lNode.HasChildren := True;
                    end
                    else lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginClassTicket.PersistentObjectClassName + ' (null)', lObject);
                end
                else
                begin
                  if assigned(acRelationPartnerShip(lObject).PartnerOID)
                    then begin
                           lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginClassTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).PartnerOID.AsString + ')', lObject);
                           lNode.HasChildren := True;
                    end
                    else lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.OriginClassTicket.PersistentObjectClassName + ' (null)', lObject)
                end;
              end
              else
              begin
                if lRelation.DestinationMinMultiplicity > 0 then lImageIndex := 4 else lImageIndex := 2;
                lObject := acObject(lPersistentObject.PartnerListByName(lPropertyName));
                lNode := Node.Owner.AddChildObject(Node, lPropertyName, lObject);
                lNode.HasChildren := True;
              end;
              lNode.ImageIndex := lImageIndex;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
          begin
            lRelation := (lClassTicket.RelationTicketsOut.Objects[li] as acRelationTicket);

            lPropertyName := lRelation.OriginPropertyName;
            if (lPropertyName <> '') then
            begin
              if lRelation.OriginMaxMultiplicity <= 1 then
              begin
                if lRelation.OriginMinMultiplicity > 0 then lImageIndex := 3 else lImageIndex := 1;
                lObject := acObject(lPersistentObject.PartnerShipByName(lPropertyName));
                if acRelationPartnerShip(lObject).Status = acRelationPartnerStatus.PSLoaded then
                  if assigned(acRelationPartnerShip(lObject).Partner)
                    then begin
                           lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationClassTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).Partner.IDO.AsString + ')', acRelationPartnerShip(lObject).Partner);
                           lNode.HasChildren := True;
                    end
                    else Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationClassTicket.PersistentObjectClassName + ' (null)', lObject)
                else
                  if assigned(acRelationPartnerShip(lObject).PartnerOID)
                    then begin
                           lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationClassTicket.PersistentObjectClassName + ' (OID:' + acRelationPartnerShip(lObject).PartnerOID.AsString + ')', lObject);
                           lNode.HasChildren := True;
                         end
                    else lNode := Node.Owner.AddChildObject(Node, lPropertyName+ ': ' + acRelationPartnerShip(lObject).RelationTicket.DestinationClassTicket.PersistentObjectClassName + ' (null)', lObject);
              end
              else
              begin
                if lRelation.OriginMinMultiplicity > 0 then lImageIndex := 4 else lImageIndex := 2;
                lObject := acObject(lPersistentObject.PartnerListByName(lPropertyName));
                lNode := Node.Owner.AddChildObject(Node, lPropertyName, lObject);
                lNode.HasChildren := True;
              end;
              lNode.ImageIndex := lImageIndex;
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        end;
      end
      else if (TObject(Node.Data) is acPersistentObjectList) then
      begin
        lEnumerator := acPersistentObjectList(Node.Data).GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lPersistentObject := acPersistentObject(lEnumerator.Current);
          lNode := Node.Owner.AddChildObject(Node, lPersistentObject.ClassTicket.PersistentObjectClassName + ' (OID:' + lPersistentObject.IDO.AsString + ')', lPersistentObject);
          lNode.HasChildren := True;
          lNode.ImageIndex := 8;
          lEnumerator.MoveNext;
        end;
      end;
    finally
      Node.Owner.EndUpdate;
    end;
  end;
end;

procedure TObjectExplorer.tvExplorerGetSelectedIndex(Sender: TObject; Node: TTreeNode);
begin
  Node.SelectedIndex := Node.ImageIndex;
end;

end.
