unit Mostra_Processamento;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFnDEF FPC}
  Windows,
{$ELSE}
  LCLIntf, LCLType, LMessages,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls;

type

  TFMostra_Processamento = class(TForm)
    pnlMensagem: TPanel;
    Panel2: TPanel;
    pgbBarraDeProgresso: TProgressBar;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TFShowProgress = class
  public
    constructor create(piMsg: string = ''; piPosition: integer = 0; piTotal: integer = 0); virtual; abstract;
    procedure ChangeMessage (piMsg: string); overload; virtual; abstract;
    procedure ChangeMessage (piMsg: string; piPosition: integer; piTotal: integer); overload;
    procedure ChangeCounters (piPosition: integer; piTotal: integer); virtual; abstract;
    procedure Inc (piSize: integer = 1); virtual; abstract;
  end;

  TFShowProgressForm = class(TFShowProgress)
  private
    fFormProgress: TFMostra_Processamento;
  public
    destructor Destroy; override;
    constructor create(piMsg: string = ''; piPosition: integer = 0; piTotal: integer = 0); override;
    procedure ChangeMessage (piMsg: string); override;
    procedure ChangeCounters (piPosition: integer; piTotal: integer); override;
    procedure Inc (piSize: integer = 1); override;
  end;


implementation

{$R *.dfm}

{ TFShowProgressForm }

procedure TFShowProgressForm.ChangeCounters(piPosition, piTotal: integer);
begin
  fFormProgress.pgbBarraDeProgresso.Max := piTotal;
  fFormProgress.pgbBarraDeProgresso.Position := piPosition;
  Application.ProcessMessages;
end;

procedure TFShowProgressForm.ChangeMessage(piMsg: string);
begin
  fFormProgress.pnlMensagem.Caption := piMsg;
  Application.ProcessMessages;
end;

constructor TFShowProgressForm.create(piMsg: string; piPosition, piTotal: integer);
begin
  fFormProgress := TFMostra_Processamento.Create(nil);
  fFormProgress.pgbBarraDeProgresso.Max := piTotal;
  fFormProgress.pgbBarraDeProgresso.Position := piPosition;
  fFormProgress.pnlMensagem.Caption := piMsg;
  fFormProgress.Show;
  Application.ProcessMessages;
end;

destructor TFShowProgressForm.destroy;
begin
  fFormProgress.Close;
  fFormProgress.Free;
  inherited;
end;

procedure TFShowProgressForm.Inc(piSize: integer);
begin
  fFormProgress.pgbBarraDeProgresso.Position := fFormProgress.pgbBarraDeProgresso.Position + piSize;
  Application.ProcessMessages;
end;

{ TFShowProgress }

procedure TFShowProgress.ChangeMessage(piMsg: string; piPosition, piTotal: integer);
begin
  Self.ChangeMessage(piMsg);
  Self.ChangeCounters(piPosition, piTotal);
end;

end.
