unit ituOQLExplorerV2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, utuOQL, Menus, ComCtrls, Buttons, ActnList, ituExplorerV2, StarUML_TLB, ImgList,
  JvExControls, JvEditorCommon, JvEditor, JvHLEditor, ituDataBaseLogin,
  JvExComCtrls, JvComCtrls, ToolWin, ActnMan, ActnCtrls, JvExExtCtrls,
  JvExtComponent, JvPanel, XPStyleActnCtrls, JvListView, JvExStdCtrls,
  JvMemo, JvSplitter, JvLabel, JvEdit, JvSpeedButton;

type
  TOQLExplorerV2 = class(TForm)
    amCXOQL: TActionManager;
    ilCXOQL: TImageList;
    pnlActionBar: TJvPanel;
    abExportPAS: TActionToolBar;
    abCXOQL: TActionToolBar;
    aNewOQL: TAction;
    aDeleteOQL: TAction;
    aSaveFile: TAction;
    aLoadFile: TAction;
    aExportPAS: TAction;
    pcCXOQL: TJvPageControl;
    tsCXOQL: TTabSheet;
    tsPASunit: TTabSheet;
    ilOQLState: TImageList;
    pnlCXOQL: TJvPanel;
    pnlOQLList: TJvPanel;
    lvOQLList: TJvListView;
    memError: TJvMemo;
    splVertical: TJvSplitter;
    pnlRight: TJvPanel;
    pnlOQLExplorer: TJvPanel;
    pnlTop: TJvPanel;
    labelName: TJvLabel;
    labelDescription: TJvLabel;
    edtName: TJvEdit;
    edtDescription: TJvEdit;
    pnlPASUnit: TJvPanel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SaveUnit: TSaveDialog;
    memUnit: TJvMemo;
    pnlOQLButtons: TPanel;
    pnlList: TPanel;
    acttbOQL: TActionToolBar;
    aNewFile: TAction;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aNewOQLExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure aDeleteOQLExecute(Sender: TObject);
    procedure aSaveFileExecute(Sender: TObject);
    procedure aLoadFileExecute(Sender: TObject);
    procedure aExportPASExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormResize(Sender: TObject);
    procedure lvOQLListChange(Sender: TObject; Item: TListItem;Change: TItemChange);
    procedure lvOQLListChanging(Sender: TObject; Item: TListItem;Change: TItemChange; var AllowChange: Boolean);
    procedure aNewFileExecute(Sender: TObject);
    procedure splVerticalCanResize(Sender: TObject; var NewSize: Integer;
      var Accept: Boolean);
  protected
    procedure CreateParams(var Params : TCreateParams); override;
  private
    { Private declarations }
    fFlagFormClosing : Boolean; // Impede que as OQLs sejam inutilmente verificados ao fechar o form
    fExplorer: TExplorerV2;
    fOQLList: utOQLFile;
    fStarUMLApp: IStarUMLApplication;
    procedure InterfaceToSelectedOQL;
    function GetQueryType ( piExplorer : TExplorerV2 ) : Integer;
    function ValidaQuery(piQuery: string; piOQLType: integer): string;
    procedure SetQueryType (piType: integer);
    procedure SelectedOQLToInterface;
    procedure UpdateOQLList;
  public
    { Public declarations }
    constructor Create(piOwner: TComponent; piStarUMLApp: IStarUMLApplication); reintroduce;
  const
    __OQLQuery = 0;
    __XMLQuery = 1;
  end;

var
  OQLExplorerV2: TOQLExplorerV2;

implementation
  uses acuObject, acuOQL;
{$R *.dfm}

procedure TOQLExplorerV2.aDeleteOQLExecute(Sender: TObject);
var li: integer;
    lOQL: utOQL;
begin
  if assigned(lvOQLList.Selected) then
  begin
    lOQL := utOQL(lvOQLList.Selected.Data);
    li := lvOQLList.Selected.Index;

    lvOQLList.Selected.Delete;
    lOQL.Delete;
    if lvOQLList.Items.Count > 0 then
      if li - 1 >= 0 then
        lvOQLList.Selected := lvOQLList.Items[li-1]
      else
        lvOQLList.Selected := lvOQLList.Items[0];
      SelectedOQLToInterface;
  end;
end;

procedure TOQLExplorerV2.aExportPASExecute(Sender: TObject);
var lFileName: string;
begin
  if fOQLList.FileName = '' then
    ShowMessage('Need to save file before generation.')
  else
  begin
    InterfaceToSelectedOQL;
    fOQLList.Save;
    Screen.Cursor := crHourGlass;
    try
      memUnit.Lines.Text := fExplorer.Util.GerarUnitOQL(fOQLList.FileName, fExplorer.Session);
    finally
      Screen.Cursor := crDefault;
    end;
    pcCXOQL.ActivePage := tsPASUnit;
    if SaveUnit.Execute then
    begin
      lFileName := SaveUnit.FileName;
      if pos('.pas', lFileName) = 0 then
        lFileName := lFileName + '.pas';
      memUnit.Lines.SaveToFile(lFileName);
    end
  end;
end;

procedure TOQLExplorerV2.aLoadFileExecute(Sender: TObject);
var
  lM: integer;
  lCancel: Boolean;
begin

  lCancel := False;

  lM := application.MessageBox('Save before open another file?', 'Attention', MB_ICONQUESTION + MB_YESNO);
  case lM of
    IDYES: aSaveFileExecute(Sender);
    IDCANCEL: lCancel := True;
  end;

  if not (lCancel) then
  begin
    try
      try
        OpenDialog1.InitialDir := ExtractFilePath(FStarUMLApp.ProjectManager.FileName);
        if OpenDialog1.Execute then
        begin
          lvOQLList.ItemIndex := -1;
          if assigned(fOQLList) then freeandnil(fOQLList);
          fOQLList := utOQLFile.create(OpenDialog1.FileName);
        end;
      Except
        on e:exception do
        begin
          if assigned(fOQLList) then freeandnil(fOQLList);
          fOQLList := utOQLFile.create;
          raise;
        end;
      end;
    finally
      Caption := fOQLList.FileName;
      UpdateOQLList;
    end;
  end;
end;

procedure TOQLExplorerV2.aNewFileExecute(Sender: TObject);
var
  lM: integer;
  lCancel: Boolean;
begin

  lCancel := False;

  lM := application.MessageBox('Save before create new file?', 'Attention', MB_ICONQUESTION + MB_YESNO);
  case lM of
    IDYES: aSaveFileExecute(Sender);
    IDCANCEL: lCancel := True;
  end;

  if not lCancel then
  begin
    try
      lvOQLList.ItemIndex := -1;
      if assigned(fOQLList) then freeandnil(fOQLList);
      fOQLList := utOQLFile.Create;
      UpdateOQLList;
      aNewOQLExecute(Sender);
    finally
      Caption := 'New...';
    end;
  end;
end;

procedure TOQLExplorerV2.aNewOQLExecute(Sender: TObject);
var lListItem: TListItem;
    lOQL: utOQL;
    lCont: integer;
begin
  InterfaceToSelectedOQL;
  lCont := 1;
  while fOQLList.OQLExists('_NEW_OQL_' + inttostr(lCont)) do
    Inc(lCont);

  lOQL := fOQLList.NewOQL('_NEW_OQL_' + inttostr(lCont));
  lListItem := lvOQLList.Items.Add;
  lListItem.Caption := lOQL.ID;
  lListItem.Data := lOQL;
  lListItem.ImageIndex := 2;
  lListItem.SubItems.Add('No OQL query');
  lvOQLList.Selected := lListItem;
  SelectedOQLToInterface;
  edtName.SetFocus;
  edtName.SelectAll;
end;

procedure TOQLExplorerV2.aSaveFileExecute(Sender: TObject);
var lFileName: string;
begin
  InterfaceToSelectedOQL;
  lFileName := fOQLList.FileName;
  try
    if lFileName = '' then
      if SaveDialog1.Execute then
      begin
        lFileName := SaveDialog1.FileName;
        if pos('.cxoql', lFileName) = 0 then
          lFileName := lFileName + '.cxoql';
      end
      else raise Exception.Create('File not saved.');

    lvOQLList.SortType := stText;
    lvOQLList.SortType := stNone;
    fOQLList.Save(lFileName);
    Caption := lFileName;
    Application.MessageBox('File saved.', '', MB_ICONINFORMATION);
  except
    on E: Exception do
    begin
      Application.MessageBox(PAnsiChar(E.Message), '', MB_ICONEXCLAMATION);
    end;
  end;
end;

constructor TOQLExplorerV2.Create(piOwner: TComponent;  piStarUMLApp: IStarUMLApplication);
begin
  inherited Create(piOwner);
  fFlagFormClosing := False;
  fStarUMLApp := piStarUMLApp;
  fExplorer := TExplorerV2.Create(nil);
  fExplorer.Parent := pnlOQLExplorer;
  fExplorer.StarUMLApp := piStarUMLApp;
  fExplorer.BorderIcons := [];
  fExplorer.BorderStyle := bsNone;
  fExplorer.Align := alClient;
  fExplorer.WindowState := wsMaximized;
  fExplorer.Position := poDefaultPosOnly;
  fExplorer.Show;
end;

procedure TOQLExplorerV2.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.ExStyle   := Params.ExStyle or WS_EX_APPWINDOW;
end;

procedure TOQLExplorerV2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  fFlagFormClosing := True;
  fExplorer.Close;
  Action := caFree;
end;

procedure TOQLExplorerV2.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var lM: integer;
begin
  lM := application.MessageBox('Save before close?', 'Attention', MB_ICONQUESTION + MB_YESNO);
  case lM of
    IDYES: aSaveFileExecute(sender);
    IDCANCEL: CanClose := false;
  end;
end;

procedure TOQLExplorerV2.FormCreate(Sender: TObject);
var lFileName: string;
begin
  lFileName := '';
  fOQLList := utOQLFile.create(lFileName);
  UpdateOQLList;
  Caption := 'New...';
end;

procedure TOQLExplorerV2.FormResize(Sender: TObject);
begin
  fExplorer.Top := 0;
  fExplorer.Left := 0;
end;

procedure TOQLExplorerV2.FormShow(Sender: TObject);
begin
  pcCXOQL.ActivePage := tsCXOQL;
  if fOQLList.Count = 0 then
    aNewOQL.Execute;
end;

function TOQLExplorerV2.GetQueryType(piExplorer: TExplorerV2): Integer;
begin
  if piExplorer.aOQLQuery.Checked = True then
    Result := __OQLQuery
  else
    Result := __XMLQuery;
end;

procedure TOQLExplorerV2.InterfaceToSelectedOQL;
var lOQL: utOQL;
    lErro: string;
begin
  if Assigned(lvOQLList.Selected) and Assigned(fExplorer.memOQLQuery) then
  begin
    lOQL := utOQL(lvOQLList.Selected.Data);
    lOQL.ID := edtName.Text;
    lOQL.Description := edtDescription.Text;
    lOQL.Query := fExplorer.memOQLQuery.Text;
    lErro := '';
    if not fFlagFormClosing then
    begin
      lOQL.OQLType := GetQueryType(fExplorer);
      lErro := ValidaQuery(lOQL.Query, lOQL.OQLType);
    end;
    if lErro = '' then
    begin
      if lOQL.OQLType = 1
        then lvOQLList.Selected.ImageIndex := 1
        else lvOQLList.Selected.ImageIndex := 0;
    end
    else
      lvOQLList.Selected.ImageIndex := 2;
    lvOQLList.Selected.Caption := edtName.Text;
    lvOQLList.Selected.SubItems[0] := lErro;
  end;
end;

procedure TOQLExplorerV2.lvOQLListChange(Sender: TObject; Item: TListItem; Change: TItemChange);
begin
  SelectedOQLToInterface;
end;

procedure TOQLExplorerV2.lvOQLListChanging(Sender: TObject;Item: TListItem; Change: TItemChange; var AllowChange: Boolean);
begin
  InterfaceToSelectedOQL;
end;

procedure TOQLExplorerV2.SelectedOQLToInterface;
var lOQL: utOQL;
begin
  edtName.Text := '';
  edtDescription.Text := '';
  if Assigned(lvOQLList.Selected) and Assigned( fExplorer.memOQLQuery) then
  begin
    fExplorer.memOQLQuery.Text := '';
    lOQL := utOQL(lvOQLList.Selected.Data);
    edtName.Text := lOQL.ID;
    edtDescription.Text := lOQL.Description;
    fExplorer.memOQLQuery.Text := lOQL.Query;
    memError.Text := lvOQLList.Selected.SubItems[0];
    SetQueryType(lOQL.OQLType);
  end;
  lvOQLList.Column[0].Caption := 'OQL Name (' + IntToStr(fOQLList.Count) + ')';
end;

procedure TOQLExplorerV2.SetQueryType(piType: integer);
begin
  if piType = __OQLQuery then
    fExplorer.aOQLQuery.Execute
  else
    fExplorer.XMLQuery.Execute;
end;

procedure TOQLExplorerV2.splVerticalCanResize(Sender: TObject; var NewSize: Integer; var Accept: Boolean);
begin
  Accept := (NewSize > 190);  
end;

procedure TOQLExplorerV2.UpdateOQLList;
var lListItem: TListItem;
    lEnum: acEnumerator;
    lOQL: utOQL;
    lErro: string;
begin
  lvOQLList.Items.BeginUpdate;
  try
    lvOQLList.Clear;
    lEnum := fOQLList.GetOQLEnumerator;
    try
      while not lEnum.EOL do
      begin
        lOQL := utOQL(lEnum.Current);
        lListItem := lvOQLList.Items.Add;
        lListItem.Caption := lOQL.ID;
        lListItem.Data := lOQL;
        lErro := ValidaQuery(lOQL.Query, lOQL.OQLType);
        lListItem.SubItems.Add(lErro);
        if lErro = '' then
        begin
          if lOQL.OQLType = 1
            then lListItem.ImageIndex := 1
            else lListItem.ImageIndex := 0;
        end
        else
          lListItem.ImageIndex := 2;
        lEnum.MoveNext;
      end;
    finally
      lEnum.free;
    end;
  finally
    lvOQLList.Items.EndUpdate;
  end;
  if lvOQLList.Items.Count > 0 then
  begin
    lvOQLList.ItemIndex := 0;
    SelectedOQLToInterface;
  end;
end;

function TOQLExplorerV2.ValidaQuery(piQuery: string; piOQLType: integer): string;
var lQuery: acAbstractOQLQuery;
begin  
  result := '';
  if not fFlagFormClosing then
  begin
    try
      if Assigned(fExplorer) then
      begin
        if Assigned(fExplorer.Session) then
        begin
          if piOQLType = 1 then
            lQuery := acDataSetOQLQuery.Create(fExplorer.Session, piQuery)
          else
            lQuery := acOQLQuery.Create(fExplorer.Session, piQuery);
          lQuery.Free;
        end;
      end;
    except
      on e:exception do
      begin
        Result := e.Message;
      end;

    end;
  end;
end;

end.
