unit DelphiAddInObj;

{******************************************************************************}
{                                                                              }
{                StarUML - The Open Source UML/MDA Platform.                   }
{                                                                              }
{              Copyright (C) 2002-2005 - Plastic Software, Inc.                }
{                                                                              }
{                                                                              }
{ This program is free software; you can redistribute it and/or modify it      }
{ under the terms of the GNU General Public License as published by the Free   }
{ Software Foundation; either version 2 of the License, or (at your option)    }
{ any later version.                                                           }
{                                                                              }
{ This program is distributed in the hope that it will be useful, but WITHOUT  }
{ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or        }
{ FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for     }
{ more details.                                                                }
{                                                                              }
{ You should have received a copy of the GNU General Public License along with }
{ this program; if not, write to the Free Software Foundation, Inc., 51        }
{ Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                          }
{                                                                              }
{ Linking StarUML statically or dynamically with other modules is making a     }
{ combined work based on StarUML. Thus, the terms and conditions of the GNU    }
{ General Public License cover the whole combination.                          }
{                                                                              }
{ In addition, as a special exception, Plastic Software give you permission to }
{ combine StarUML program with free software programs or libraries that are    }
{ released under the GNU LGPL/Mozilla/Apache/BSD and with code included in the }
{ standard release of ExpressBar, ExpressNavBar, ExpressInspector,             }
{ ExpressPageControl, ProGrammar, NextGrid under the commercial license (or    }
{ modified versions of such code, with unchanged license). You may copy and    }
{ distribute such a system following the terms of the GNU GPL for StarUML and  }
{ the licenses of the other code concerned, provided that you include the      }
{ source code of that other code when and as the GNU GPL requires distribution }
{ of source code. Plastic Software also give you permission to combine StarUML }
{ program with dynamically linking plug-in (or add-in) programs that are       }
{ released under the GPL-incompatible and proprietary license.                 }
{                                                                              }
{ Note that people who make modified versions of StarUML are not obligated to  }
{ grant this special exception for their modified versions; it is their choice }
{ whether to do so. The GNU General Public License gives permission to release }
{ a modified version without this exception; this exception also makes it      }
{ possible to release a modified version which carries forward this exception. }
{******************************************************************************}

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, ActiveX, Classes, ComObj, Dialogs,
  StarUML_TLB, IntegracaoDelphiSUML, acuframework, ituExplorer, ituExplorerV2,ituOQLExplorerV2;


type

  TDelphiAddInObj = class(TComObject, IStarUMLAddIn, IEventSubscriber)
  private
    StarUMLApp: IStarUMLApplication;

    EventPub: IEventPublisher;
//    MetaModel: acMetaModel;
    function GetSelectedModel: IModel;
    procedure ActionMenu_GenerateRegisterModelMappings;
    procedure ActionMenu_LoadMethods;
    procedure ActionMenu_GeneratePreview;
    procedure ActionMenu_OQL;
    procedure ActionMenu_CXOQL;
    procedure ActionMenu_CodeGenerator;
    procedure ActionMenu_XSDEditor;
    procedure ActionMenu_InsertUseCase;
    procedure ActionMenu_InsertClass;
    procedure ActionMenu_EditClass;
    procedure ActionMenu_EditUseCase;
    procedure ActionMenu_ElementDocumentation;
    procedure ActionMenu_UseCaseXSDsEditor;
    procedure ActionMenu_ConvertXSDsToUseCaseXSD;
    procedure ActionMenu_ExportDiagramClasses;
    procedure ActionMenu_ExportPackageClasses;
    procedure ActionMenu_ExportUseCases;
    procedure ActionMenu_OQLV2;
    procedure ActionMenu_CXOQLV2;

    procedure ListOwnedClasses( piPackage : IUMLPackage ; piObjectList : TInterfaceList ; piStringList : TStringList);
    procedure ListOwnedUseCases ( piPackage : IUMLPackage ; piObjectList : TInterfaceList ; piStringList : TStringList);

    function GetServiceConnectionString: string;

    //procedure NotifyUpdate(piMsg: string);

    //procedure ProccessUpdates;

  protected
    function InitializeAddIn: HResult; stdcall;
    function FinalizeAddIn: HResult; stdcall;
    function DoMenuAction(ActionID: Integer): HResult; stdcall;
    function NotifyEvent(AEvent: EventKind): HResult; stdcall;
  public
    procedure Initialize; override;
    destructor Destroy; override;
  end;

const
  Class_DelphiAddInObj: TGUID = '{14A7CA1E-CC4C-4847-B1F9-CE7AD8812275}';

implementation

uses
  ComServ, Forms, InstantCode, formMemo, SysUtils, Controls,
  Mostra_Processamento, utuStateMachine, fCodeGen,
  fModelMappingsGenerationOptions, fXSDEditor, ituOQLExplorer, ituDataBaseLogin, cxuSession,
  mxuConnectionClient, utuMessage, UseCaseController, uCadastroCasoDeUso, uCadastroClasse, ituServiceParameters,
  Registry, uRTFEditor, ituXSDExplorer, ituExportUnits;

////////////////////////////////////////////////////////////////////////////////
// TDelphiAddInObj

procedure TDelphiAddInObj.Initialize;
begin
  inherited;
  StarUMLApp := CreateOleObject('StarUML.StarUMLApplication') as IStarUMLApplication;
  Application.Handle := StarUMLApp.Handle;
  EventPub := StarUMLApp.EventPublisher;
end;

destructor TDelphiAddInObj.Destroy;
begin
  EventPub := nil;
  StarUMLApp := nil;
  inherited;
end;

function TDelphiAddInObj.InitializeAddIn: HResult;
begin
  //EventPub.Subscribe(Self, EVK_PROJECT_OPENED);
  //EventPub.Unsubscribe(Self, EVK_PROJECT_CLOSED);
  //EventPub.Subscribe(Self, EVK_ELEMENTS_ADDED);
  //EventPub.Subscribe(Self, EVK_MODELS_CHANGED);
  //EventPub.Subscribe(Self, EVK_ELEMENTS_DELETING);
  EventPub.Subscribe(Self, EVK_PROJECT_CLOSING);
  Result := S_OK;
end;

function TDelphiAddInObj.NotifyEvent(AEvent: EventKind): HResult;
var
{  I: integer;
  lModel: IModel;
  lClass: IUMLClass;
  lAttribute: IUMLAttribute;
  lAssoc: IUMLAssociation;
  lGen: IUMLGeneralization;  
  lLog: string;
  etaModelGenOpt: TMetaModelGenerationOptions;}
  I: integer;
  lForm: TForm;
begin
  //etaModelGenOpt.SilentMode := True;
  //etaModelGenOpt.CheckDBAttributeNameLength := False;
  //etaModelGenOpt.CheckDBTableNameLength := False;

  {if AEvent = EVK_PROJECT_OPENED then
  begin
    lUtils := GetUtils(StarUMLApp);
    NotifyUpdate('Open Project');
    lUtils.CleanMetamodel;
    lUtils.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, nil);
  end;}

  if AEvent = EVK_PROJECT_CLOSING then
  begin
    for I := Screen.FormCount - 1 downto 0 do
    begin
      lForm := Screen.Forms[I];
      if ((lForm is TExplorerV2) or (lForm is TOQLExplorerV2)) and (not Assigned(lForm.Parent)) then
      begin
        lForm.SetFocus;
        lForm.Close;
        Application.ProcessMessages;
      end;
    end;

    //NotifyUpdate('Closing Project');
    //GetUtils(StarUMLApp).Free;
  end;
  
  {f (AEvent in [EVK_ELEMENTS_ADDED, EVK_MODELS_CHANGED, EVK_ELEMENTS_DELETING])
    and (EventPub.GetEventArgModelCount > 0) then
  begin
    //ProccessUpdates;
  end;}

  Result :=  S_OK;

end;

{procedure TDelphiAddInObj.NotifyUpdate(piMsg: string);
begin
  MessageDlg(piMsg, mtInformation, [mbOk], 0);
end; }

{procedure TDelphiAddInObj.ProccessUpdates;
var
  I: integer;
  lModel: IModel;
  lClass: IUMLClass;
  lAttribute: IUMLAttribute;
  lAssoc: IUMLAssociation;
  lGen: IUMLGeneralization;  
  lLog: string;

  lElementsList: TInterfaceList;
begin

  lElementsList := TInterfaceList.Create;
  try
    for I := 0 to EventPub.GetEventArgModelCount - 1 do
    begin
      lModel := EventPub.GetEventArgModelAt(I);

      if lModel.QueryInterface(IUMLClass, lClass) =  S_OK then
      begin
        if lElementsList.IndexOf(lClass) < 0 then lElementsList.Add(lClass);
      end;

      if lModel.QueryInterface(IUMLAssociation, lAssoc) =  S_OK then
      begin
        if lAssoc.GetConnectionAt(0).Participant.QueryInterface(IUMLClass, lClass) = S_OK then
        begin
          if lElementsList.IndexOf(lClass) < 0 then lElementsList.Add(lClass);
        end;
          
        if lAssoc.GetConnectionAt(1).Participant.QueryInterface(IUMLClass, lClass) = S_OK then
        begin
          if lElementsList.IndexOf(lClass) < 0 then lElementsList.Add(lClass);
        end;
      end;

      if lModel.QueryInterface(IUMLAttribute, lAttribute) =  S_OK then
      begin
        if lAttribute.Owner.QueryInterface(IUMLClass, lClass) = S_OK then
        begin
          if lElementsList.IndexOf(lClass) < 0 then lElementsList.Add(lClass);
        end;
      end;

      if lModel.QueryInterface(IUMLGeneralization, lGen) =  S_OK then
      begin
        if lGen.Child.QueryInterface(IUMLClass, lClass) = S_OK then
        begin
          if lElementsList.IndexOf(lClass) < 0 then lElementsList.Add(lClass);
        end;
      end;
    
    end;    
  
    for I := 0 to lElementsList.Count - 1 do
    begin
       lLog := lLog + '(' + IUMLClass(lElementsList.Items[I]).GetClassName + ')' + ' ' + IUMLClass(lElementsList.Items[I]).Pathname + #13#10;    
    end;
    NotifyUpdate(lLog);
    
  finally
    lElementsList.Free;
  end;

end; }

procedure TDelphiAddInObj.ListOwnedClasses(piPackage: IUMLPackage; piObjectList: TInterfaceList; piStringList: TStringList);
var
  lEnum : Integer;
  lClass: IUMLClass;
  lPackage : IUMLPackage;
begin
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1 do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLPackage, lPackage) = S_OK then
      ListOwnedClasses(lPackage,piObjectList,piStringList);
  end;
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1  do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLClass, lClass) = S_OK then
    begin
      piObjectList.Add(lClass);
      piStringList.Add(lClass.Pathname );
    end;
  end;
end;

procedure TDelphiAddInObj.ListOwnedUseCases(piPackage: IUMLPackage; piObjectList: TInterfaceList; piStringList: TStringList);
var
  lEnum : Integer;
  lUseCase: IUMLUseCase;
  lPackage : IUMLPackage;
begin
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1 do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLPackage, lPackage) = S_OK then
      ListOwnedUseCases(lPackage,piObjectList,piStringList);
  end;
  for lEnum := 0 to piPackage.GetOwnedElementCount - 1  do
  begin
    if piPackage.GetOwnedElementAt(lEnum).QueryInterface(IUMLUseCase, lUseCase) = S_OK then
    begin
      piObjectList.Add(lUseCase);
      piStringList.Add(lUseCase.Pathname );
    end;
  end;
end;

function TDelphiAddInObj.FinalizeAddIn: HResult;
begin
  //EventPub.Unsubscribe(Self, EVK_PROJECT_OPENED);
  //EventPub.Unsubscribe(Self, EVK_PROJECT_CLOSED);  
  //EventPub.Unsubscribe(Self, EVK_ELEMENTS_ADDED);  
  //EventPub.Unsubscribe(Self, EVK_MODELS_CHANGED);
  //EventPub.Unsubscribe(Self, EVK_ELEMENTS_DELETING);
  EventPub.Unsubscribe(Self, EVK_PROJECT_CLOSING);  
  Result := S_OK;
end;

function TDelphiAddInObj.GetSelectedModel: IModel;
begin
  result := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
end;

function TDelphiAddInObj.GetServiceConnectionString: string;
var lServiceParamDialog: TitServiceParameters;
    lReg: TRegistry;
begin
  lServiceParamDialog := TitServiceParameters.Create(nil);
  try
    lReg := TRegistry.Create;
    try
      lReg.RootKey := HKEY_CURRENT_USER;
      lReg.OpenKey(cPROJECT_SAVE_OPTIONS_PATH + ExtractFileName(StarUMLApp.ProjectManager.FileName) + '\Service', true);

      if lReg.ValueExists('SERVICE_SERVERNAME') then lServiceParamDialog.ServerName := lReg.ReadString('SERVICE_SERVERNAME');
      if lReg.ValueExists('SERVICE_PORTNUMBER') then lServiceParamDialog.PortNumber := lReg.ReadInteger('SERVICE_PORTNUMBER');
      if lReg.ValueExists('SERVICE_SYSTEMCODE') then lServiceParamDialog.SystemCode := lReg.ReadInteger('SERVICE_SYSTEMCODE');
      if lReg.ValueExists('SERVICE_USERNAME')   then lServiceParamDialog.UserName := lReg.ReadString('SERVICE_USERNAME');
      if lReg.ValueExists('SERVICE_PASSWORD')   then lServiceParamDialog.Password := lReg.ReadString('SERVICE_PASSWORD');

      if lServiceParamDialog.ShowModal = mrok then
      begin
        lReg.WriteString('SERVICE_SERVERNAME', lServiceParamDialog.ServerName);
        lReg.WriteInteger('SERVICE_PORTNUMBER', lServiceParamDialog.PortNumber);
        lReg.WriteInteger('SERVICE_SYSTEMCODE', lServiceParamDialog.SystemCode);
        lReg.WriteString('SERVICE_USERNAME', lServiceParamDialog.UserName);
        lReg.WriteString('SERVICE_PASSWORD', lServiceParamDialog.Password);

        StarUMLApp.ProjectManager.Project.SetTaggedValueAsInteger('DBMappings', 'ProjectMap', 'SystemCode', lServiceParamDialog.SystemCode);
        StarUMLApp.ProjectManager.Project.SetTaggedValueAsInteger('DBMappings', 'ProjectMap', 'PortNumber', lServiceParamDialog.PortNumber);

        result := format('ServerName=%s;PortNumber=%d;SystemCode=%d;UserName=%s;Password=%s;',
                         [lServiceParamDialog.ServerName, lServiceParamDialog.PortNumber,
                          lServiceParamDialog.SystemCode, lServiceParamDialog.UserName,
                          lServiceParamDialog.Password]);
      end
      else
        result := '';
    finally
      lReg.free;
    end;
  finally
    lServiceParamDialog.Free;
  end;

end;

function TDelphiAddInObj.DoMenuAction(ActionID: Integer): HResult;
begin
  try
    Result := S_OK;
    case ActionID of
      1: ActionMenu_GenerateRegisterModelMappings;
      2: ActionMenu_GeneratePreview;
      3: ActionMenu_LoadMethods;
      4: ActionMenu_OQL;
      5: ActionMenu_CXOQL;
      6: ActionMenu_CodeGenerator;
      7: ActionMenu_XSDEditor;
      8: ActionMenu_InsertUseCase;
      9: ActionMenu_InsertClass;
      10: ActionMenu_EditClass;
      11: ActionMenu_EditUseCase;
      12: ActionMenu_ElementDocumentation;
      13: ActionMenu_UseCaseXSDsEditor;
      14: ActionMenu_ConvertXSDsToUseCaseXSD;
      15: ActionMenu_ExportDiagramClasses;
      16: ActionMenu_ExportPackageClasses;
      17: ActionMenu_ExportUseCases;
      18: ActionMenu_OQLV2;
      19: ActionMenu_CXOQLV2;
    end;
  except
    on E: Exception do
    begin
      Application.MessageBox(PAnsiChar(e.Message), 'Staruml', MB_ICONERROR);
      raise;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_GenerateRegisterModelMappings;
var lsResult: string;
    lUtilitario: TUtil;
    lProgress: TFShowProgress;
    lsModelMappingsFileName, lsModelMappingsPath: string;
    lModelMappingsOptionsForm: TModelMappingsGenerationOptions;
    lModelMappingsOptions: TModelMappingsOptions;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lsModelMappingsFileName := '';
  lsModelMappingsPath := '';
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  /////////////////////////////////////////////////////////////////////////
  lModelMappingsOptionsForm := TModelMappingsGenerationOptions.Create(nil);
  try
    lModelMappingsOptionsForm.StarUMLApp := StarUMLApp;
    if lModelMappingsOptionsForm.ShowModal = mrok then
    begin
      lsModelMappingsPath := lModelMappingsOptionsForm.dlbDirectory.Directory;
      lsModelMappingsFileName := lModelMappingsOptionsForm.edtFileName.Text;
      lModelMappingsOptions.IgnoreXSDSchema := lModelMappingsOptionsForm.ckbIgnoreXSD.Checked;
      lModelMappingsOptions.FileName := IncludeTrailingBackslash(trim(lsModelMappingsPath)) +  lsModelMappingsFileName;
      if lModelMappingsOptionsForm.rdObjectPascal.Checked
        then lModelMappingsOptions.TargetLanguage := 'O'
        else if lModelMappingsOptionsForm.rdCSharp.Checked
          then lModelMappingsOptions.TargetLanguage := 'C'
          else lModelMappingsOptions.TargetLanguage := 'J';
    end
    else
      lModelMappingsOptions.FileName := '';
  finally
    lModelMappingsOptionsForm.Free;
  end;

  if lModelMappingsOptions.FileName <> '' then
  begin
    lProgress := TFShowProgressForm.create('Creating Meta Model...');
    try                     
      lUtilitario := TUtil.Create(StarUMLApp);
      try
        if lModelMappingsOptions.TargetLanguage = 'O' then
        begin
          lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings(lModelMappingsOptions, lProgress);
        end
        else if lModelMappingsOptions.TargetLanguage = 'C' then
        begin
          lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings_CSharp(lModelMappingsOptions, lProgress);
        end
        else
        begin
          lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, lProgress);
          lUtilitario.GerarUnitRegisterModelMappings_Java(lModelMappingsOptions, lProgress);
        end;
      finally
        lUtilitario.Free;
      end;
             
      application.MessageBox(PAnsiChar('File ' + lModelMappingsOptions.FileName + ' was generated.'), 'Staruml', MB_OK + MB_ICONINFORMATION);
    finally
      lProgress.Free;
    end;
  end;

end;

procedure TDelphiAddInObj.ActionMenu_LoadMethods;
var lsResult: string;
    lUtilitario: TUtil;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  lUtilitario := TUtil.Create(StarUMLApp);
  try
//        lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp);
    if (MessageDlg('This option will overwrite class methods. Continue?', mtConfirmation, [mbYes, mbNo], 0) = mryes) then
    begin
      lsResult := lUtilitario.CarregaMetodo(StarUMLApp);
      Application.MessageBox(PAnsiChar(lsResult), 'Staruml');
    end;
  finally
    lUtilitario.free;
  end;

end;

procedure TDelphiAddInObj.ActionMenu_InsertClass;
var lCadClasse: TCadastroClasse;
    lConnString: string;
    lModel: IModel;
    lUMLPackageAux: IUMLPackage;
begin
  lCadClasse := nil;
  lConnString := GetServiceConnectionString;
  if lConnString <> '' then
  begin
    lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
    try
      if lModel.QueryInterface(IUMLPackage, lUMLPackageAux) = S_OK then
      begin
        lCadClasse := TCadastroClasse.Create(nil, lConnString);
        lCadClasse.FStarUMLAPP := StarUMLApp;
        lCadClasse.ClassPackage := lModel as IUMLPackage;
      end
      else
      begin
        lCadClasse := TCadastroClasse.Create(nil, lConnString);
        lCadClasse.FStarUMLAPP := StarUMLApp;
      end;
      if lCadClasse.ShowModal = mrok then
        StarUMLApp.SelectInModelExplorer(lCadClasse.UMLClass);
    finally
      if assigned(lCadClasse) then lCadClasse.Free;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_CodeGenerator;
var lUtilitario: TUtil;
    lCodeGen: TCodeGen;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;
  
  lCodeGen := TCodeGen.Create(nil);
  Screen.Cursor := crHourGlass;
  try
    lUtilitario := TUtil.Create(StarUMLApp);
    try
      lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, nil);
      lCodeGen.Util := lUtilitario;
      lCodeGen.ShowModal;
    finally
      lUtilitario.Free;
    end;
  finally
    Screen.Cursor := crDefault;
    lCodeGen.Free;
  end;
//          lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
//          IUMLStatechartDiagram(IUMLStateMachine(lModel).GetOwnedDiagramAt(0)).DiagramView.ExportDiagramAsJPEG('c:\teste.jpg');

end;


procedure TDelphiAddInObj.ActionMenu_ConvertXSDsToUseCaseXSD;
var lsResult: string;
    lUtilitario: TUtil;
    lProgress: TFShowProgress;
    lsModelMappingsFileName, lsModelMappingsPath: string;
    lModelMappingsOptions: TModelMappingsOptions;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
    lFileStream:  TFileStream;
    lStringStream: TStringStream;
    lOld, lNew: string;
begin
  lsModelMappingsFileName := '';
  lsModelMappingsPath := '';
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  /////////////////////////////////////////////////////////////////////////
  lUtilitario := TUtil.Create(StarUMLApp);
  try
    if FileExists(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsOld.txt') then
      if not DeleteFile(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsOld.txt') then
        Raise Exception.Create('Could not delete file ' + IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsOld.txt');

    lsModelMappingsPath := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP'));
    lsModelMappingsFileName :=  'ConexoTempModelMappingsOld.txt';
    lModelMappingsOptions.IgnoreXSDSchema := false;
    lModelMappingsOptions.FileName := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsOld.txt';

    if lModelMappingsOptions.FileName <> '' then
    begin
      lProgress := TFShowProgressForm.create('Creating Meta Model...');
      try
        lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt,lProgress);
        lUtilitario.GerarUnitRegisterModelMappings(lModelMappingsOptions, lProgress);
      finally
        lProgress.Free;
      end;
    end;
  finally
    lUtilitario.Free;
  end;

  lUtilitario := TUtil.Create(StarUMLApp);
  try
    lProgress := TFShowProgressForm.create('');
    try
      lUtilitario.ConvertXSDsToUseCaseXSD(lProgress);
    finally
      lProgress.Free;
    end;
  finally
    lUtilitario.Free;
  end;

  lUtilitario := TUtil.Create(StarUMLApp);
  try
    if FileExists(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsNew.txt') then
      if not DeleteFile(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsNew.txt') then
        Raise Exception.Create('Could not delete file ' + IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsNew.txt');

    lsModelMappingsPath := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP'));
    lsModelMappingsFileName := 'ConexoTempModelMappingsNew.txt';
    lModelMappingsOptions.IgnoreXSDSchema := false;
    lModelMappingsOptions.FileName := IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsNew.txt';

    if lModelMappingsOptions.FileName <> '' then
    begin
      lProgress := TFShowProgressForm.create('Creating Meta Model...');
      try
        lsResult := lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt,lProgress);
        lUtilitario.GerarUnitRegisterModelMappings(lModelMappingsOptions, lProgress);
      finally
        lProgress.Free;
      end;
    end;
  finally
    lUtilitario.Free;
  end;

  lFileStream := TFileStream.Create(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsOld.txt', fmOpenRead);
  try
    lStringStream := TStringStream.Create('');
    try
      lStringStream.CopyFrom(lFileStream, 0);
      lOld := lStringStream.DataString;
    finally
      lStringStream.free;
    end;
  finally
    lFileStream.free;
  end;

  lFileStream := TFileStream.Create(IncludeTrailingPathDelimiter(GetEnvironmentVariable('TEMP')) + 'ConexoTempModelMappingsNew.txt', fmOpenRead);
  try
    lStringStream := TStringStream.Create('');
    try
      lStringStream.CopyFrom(lFileStream, 0);
      lNew := lStringStream.DataString;
    finally
      lStringStream.free;
    end;
  finally
    lFileStream.free;
  end;

  if lNew = lOld then
  begin
    Showmessage('Converso realizada com sucesso.');
  end
  else
    Showmessage('Erro ao realizar a converso.');
end;

procedure TDelphiAddInObj.ActionMenu_CXOQL;
var lOQLExplorer: TOQLExplorer;
begin
  lOQLExplorer := TOQLExplorer.Create(Application, StarUMLApp);
  lOQLExplorer.Show;
end;

procedure TDelphiAddInObj.ActionMenu_CXOQLV2;
var
  lOQLExplorer: TOQLExplorerV2;
begin
  lOQLExplorer := TOQLExplorerV2.Create(Application, StarUMLApp);
  lOQLExplorer.Show;
end;

procedure TDelphiAddInObj.ActionMenu_EditClass;
var lCadClasse: TCadastroClasse;
    lConnString: string;

    lModel: IModel;

    lUMLClassAux: IUMLClass;
begin
   lCadClasse := nil;
  lConnString := GetServiceConnectionString;
  if lConnString <> '' then
  begin
    lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);

      if lModel.QueryInterface(IUMLClass, lUMLClassAux) = S_OK then
      begin
        lUMLClassAux := lModel as IUMLClass;
        try
          lCadClasse := TCadastroClasse.Create(nil, lConnString, lUMLClassAux);
          lCadClasse.FStarUMLAPP := StarUMLApp;
          if lCadClasse.ShowModal = mrok then
            StarUMLApp.SelectInModelExplorer(lCadClasse.UMLClass);
        finally
          if assigned(lCadClasse) then lCadClasse.Free;
        end;
      end
      else
        raise Exception.Create('This option is avaliable only for classes.');
  end;
end;

procedure TDelphiAddInObj.ActionMenu_EditUseCase;
var lCadCasoDeUso: TCadastroCasoDeUso;
    lConnString: string;

    lModel: IModel;

    lUMLUseCaseAux: IUMLUseCase;
begin
  lCadCasoDeUso := nil;
  lConnString := GetServiceConnectionString;
  if lConnString <> '' then
  begin
    lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
    try
      if lModel.QueryInterface(IUMLUsecase, lUMLUseCaseAux) = S_OK then
      begin
        lUMLUseCaseAux := lModel as IUMLUsecase;
        lCadCasoDeUso := TCadastroCasoDeUso.Create(nil, lConnString, lUMLUseCaseAux);
        lCadCasoDeUso.FStarUMLAPP := StarUMLApp;
      end
      else
        raise exception.Create('This option is only avaliable for Usecases.');

      if lCadCasoDeUso.ShowModal = mrok then
        StarUMLApp.SelectInModelExplorer(lCadCasoDeUso.GetUseCase);
    finally
      if assigned(lCadCasoDeUso) then lCadCasoDeUso.Free;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_GeneratePreview;
var lPreview: TPreviewClassCode;
    lUtilitario: TUtil;
    lModel: IModel;
    lUMLClasAux: IUMLClass;
    lUMLAssociationAux: IUMLAssociation;
    lMetaModelGenOpt: TMetaModelGenerationOptions;
begin
  lMetaModelGenOpt.SilentMode := false;
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  lUtilitario := TUtil.Create(StarUMLApp);
  try
    lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
    if lModel.QueryInterface(IUMLClass, lUMLClasAux) = S_OK then
    begin
      lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, nil);
      lPreview := TPreviewClassCode.Create(nil);
      try
//        inserir preview para oracle
        lPreview.mem_ClassPascal.Lines.Text := lUtilitario.GerarClassPreview_Pascal(lModel as IUMLClass);
        lPreview.mem_ClassCSharp.Lines.Text := lUtilitario.GerarClassPreview_CSharp(lModel as IUMLClass);
        lPreview.mem_ClassJava.Lines.Text := lUtilitario.GerarClassPreview_Java(lModel as IUMLClass);
        lPreview.mem_ClassSQL.Lines.Text := lUtilitario.GerarSQLPreview(lModel);
        lPreview.mem_ClassOracle.Lines.Text := lUtilitario.GerarSQLPreview(lModel, dbvOracle);
        lPreview.ShowModal;
      finally
        FreeAndNil(lPreview);
      end;
    end
    else
      if lModel.QueryInterface(IUMLAssociation, lUMLAssociationAux) = S_OK then
      begin
        lUtilitario.AlimentarMetamodel(StarUMLApp, lMetaModelGenOpt, nil);
        lPreview := TPreviewClassCode.Create(nil);
        try
          lPreview.mem_ClassSQL.Lines.Text := lUtilitario.GerarSQLPreview(lModel);
          lPreview.mem_ClassOracle.Lines.Text := lUtilitario.GerarSQLPreview(lModel, dbvOracle);
          lPreview.ShowModal;
        finally
          FreeAndNil(lPreview);
        end;
      end
      else
        raise Exception.Create('This option is avaliable only for classes and associations between classes.');
    {  if lModel.QueryInterface(IUMLUseCase, lUMLUseCaseAux) = S_OK then
      begin
        if (lModel as IUMLUseCase).IsAbstract then
          raise Exception.Create(format('The usecase "%s" is abstract. Preview is not supported yet.', [(lModel as IUMLUseCase).name]));

        lUtilitario.AlimentarMetamodel(StarUMLApp, nil);
        lPreview := TPreviewClassCode.Create(nil);
        try
//                lPreview.mem_UsecaseClientJava.Lines.Text := lUtilitario.GerarUseCaseClientPreview_Java(lModel as IUMLUseCase);
//                lPreview.mem_UsecaseServerPascal.Lines.Text := lUtilitario.GerarUseCaseServerPreview_Pascal(lModel as IUMLUseCase);
          lPreview.ShowModal;
        finally
          FreeAndNil(lPreview);
        end;
      end;}

  finally
    freeandnil(lUtilitario);
  end;
end;

procedure TDelphiAddInObj.ActionMenu_OQL;
begin
  if not assigned(fExplorer) then
  begin
    fExplorer := TExplorer.Create(nil);
    fExplorer.StarUMLApp := StarUMLApp;
  end;
  fExplorer.Show;
end;

procedure TDelphiAddInObj.ActionMenu_OQLV2;
begin
  if not assigned(ExplorerV2) then
  begin
    ExplorerV2 := TExplorerV2.Create(nil);
    ExplorerV2.StarUMLApp := StarUMLApp;
  end;
  ExplorerV2.Show;
end;

procedure TDelphiAddInObj.ActionMenu_ExportDiagramClasses;
var
  lEnum : Integer;
  listaStrings : TStringList;
  listaObjetos : TInterfaceList;
  lClass: IUMLClass;  
  lForm : TExportUnits;
begin
  listaStrings := TStringList.Create;
  listaObjetos := TInterfaceList.Create;
  try
    for lEnum := 0 to StarUMLApp.SelectionManager.GetSelectedViewCount - 1  do
    begin
      if StarUMLApp.SelectionManager.GetSelectedViewAt(lenum).Model.QueryInterface(IUMLClass, lClass) = S_OK then
      begin
        listaObjetos.Add(lClass);
        listaStrings.Add(lClass.Pathname );
      end;
    end;

    lForm := TExportUnits.Create(nil);
    lForm.Position := poScreenCenter;
    Screen.Cursor := crHourGlass;
    try
      for lEnum := 0 to listaStrings.Count - 1 do
      begin
        lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
      end;
      lForm.lstUsecases.SelectAll;
      lForm.ShowModal;  
    finally
      Screen.Cursor := crDefault;
      lForm.Free;
    end;

    finally
    listaStrings.Free;
    listaObjetos.Free;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_UseCaseXSDsEditor;
var lModel: IModel;
    lXSDExplorer: TXSDExplorer;
begin
  lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.GetMetaClass.IsKindOf('UMLUseCase') then
  begin
    lXSDExplorer := TXSDExplorer.Create(nil, StarUMLApp, lModel as IUMLUseCase);
    try
      lXSDExplorer.ShowModal;
    finally
      lXSDExplorer.free;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_ElementDocumentation;
var lModel: IModel;
    lRTFEditor: TRTFEditor;
begin
  lRTFEditor := nil;
  lModel := GetSelectedModel;
  if assigned(lModel) then
  begin
    try
      lRTFEditor := TRTFEditor.Create(nil);
      lRTFEditor.DocWithRTFInformation := lModel.Documentation;
      lRTFEditor.Caption := lModel.Pathname;
      if lRTFEditor.ShowModal = mrok then
        lModel.Documentation := lRTFEditor.DocWithRTFInformation;
    finally
      lRTFEditor.free;
    end;
  end
  else
    raise exception.Create('This option is only avaliable for Usecases.');
end;

procedure TDelphiAddInObj.ActionMenu_ExportPackageClasses;
var
  listaStrings : TStringList;
  listaObjetos : TInterfaceList;
  lPackage : IUMLPackage;
  lForm : TExportUnits;
  lEnum : Integer;
begin
  if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLPackage, lPackage) = S_OK then
  begin
    listaStrings := TStringList.Create;
    listaObjetos := TInterfaceList.Create;
    try
      ListOwnedClasses(lPackage,listaObjetos,listaStrings);

      lForm := TExportUnits.Create(nil);
      lForm.Position := poScreenCenter;
      Screen.Cursor := crHourGlass;
      try
        for lEnum := 0 to listaStrings.Count - 1 do
        begin
          lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
        end;
        lForm.lstUsecases.SelectAll;
        lForm.ShowModal;  
      finally
        Screen.Cursor := crDefault;
        lForm.Free;
      end;

    finally
      listaStrings.Free;
      listaObjetos.Free;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_ExportUseCases;
var
  listaStrings : TStringList;
  listaObjetos : TInterfaceList;
  lPackage : IUMLPackage;
  lUseCase: IUMLUseCase;
  lForm : TExportUnits;
  lEnum : Integer;
begin
  listaStrings := TStringList.Create;
  listaObjetos := TInterfaceList.Create;
  try
    if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLPackage, lPackage) = S_OK then
    begin
      ListOwnedUseCases(lPackage,listaObjetos,listaStrings);
    end
    else
    begin
      if StarUMLApp.SelectionManager.GetSelectedModelAt(0).QueryInterface(IUMLUseCase, lUseCase) = S_OK then
      begin
        listaObjetos.Add(lUseCase);
        listaStrings.Add(lUseCase.Pathname );
      end;
    end;

    lForm := TExportUnits.Create(nil);
    lForm.Position := poScreenCenter;
    Screen.Cursor := crHourGlass;
    try
      for lEnum := 0 to listaStrings.Count - 1 do
      begin
        lForm.lstUsecases.AddItem(listaStrings.Strings[lEnum],nil );
      end;
      lForm.lstUsecases.SelectAll;
      lForm.ShowModal;  
    finally
      Screen.Cursor := crDefault;
      lForm.Free;
    end;

  finally
    listaStrings.Free;
    listaObjetos.Free;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_InsertUseCase;
//var lUseCaseCon: TUseCaseController;
var lCadCasoDeUso: TCadastroCasoDeUso;
    lConnString: string;

    lModel: IModel;

    lUMLPackageAux: IUMLPackage;
begin
  lCadCasoDeUso := nil;
  lConnString := GetServiceConnectionString;
  if lConnString <> '' then
  begin
    lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
    try
      if lModel.QueryInterface(IUMLPackage, lUMLPackageAux) = S_OK then
      begin
        lCadCasoDeUso := TCadastroCasoDeUso.Create(nil, lConnString);
        lCadCasoDeUso.FStarUMLAPP := StarUMLApp;
        lCadCasoDeUso.UseCasePackage := lModel as IUMLPackage;
      end
      else
      begin
        lCadCasoDeUso := TCadastroCasoDeUso.Create(nil, lConnString);
        lCadCasoDeUso.FStarUMLAPP := StarUMLApp;
      end;

      if lCadCasoDeUso.ShowModal = mrok then
        StarUMLApp.SelectInModelExplorer(lCadCasoDeUso.GetUseCase);
    finally
      if assigned(lCadCasoDeUso) then lCadCasoDeUso.Free;
    end;
  end;
end;

procedure TDelphiAddInObj.ActionMenu_XSDEditor;
var
    lModel: IModel;
    lUMLTransitionAux: IUMLTransition;
    lXSDEditor: TXSDEdit;
begin
  lModel := StarUMLApp.SelectionManager.GetSelectedModelAt(0);
  if lModel.QueryInterface(IUMLTransition, lUMLTransitionAux) = S_OK then
  begin
    lXSDEditor := TXSDEdit.Create(nil);
    try
      lXSDEditor.StarUMLAPP := self.StarUMLApp;
      lXSDEditor.Transition := lModel as IUMLTransition;
      lXSDEditor.ShowModal;
    except
      FreeAndNil(lXSDEditor);
    end;
  end
  else
    raise Exception.Create('This option is avaliable only for transitions.');

end;

// TDelphiAddInObj
////////////////////////////////////////////////////////////////////////////////

initialization
  TComObjectFactory.Create(ComServer, TDelphiAddInObj, Class_DelphiAddInObj,
    'DelphiAddInObj', '', ciMultiInstance, tmApartment);
end.
