unit uRTFEditor;

{$IFDEF FPC}
  {$MODE Delphi}
{$ENDIF}

interface

uses
{$IFnDEF FPC}
  Windows,
{$ELSE}
  LCLIntf, LCLType, LMessages,
{$ENDIF}
  SysUtils, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ComCtrls, ClipBrd,
  ToolWin, ActnList, ImgList, SynEdit;

type
  TRTFEditor = class(TForm)
    MainMenu: TMainMenu;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    FilePrintItem: TMenuItem;
    FileExitItem: TMenuItem;
    EditUndoItem: TMenuItem;
    EditCutItem: TMenuItem;
    EditCopyItem: TMenuItem;
    EditPasteItem: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    FontDialog1: TFontDialog;
    N5: TMenuItem;
    miEditFont: TMenuItem;
    Editor: TSynEdit;
    StatusBar: TStatusBar;
    StandardToolBar: TToolBar;
    OpenButton: TToolButton;
    SaveButton: TToolButton;
    PrintButton: TToolButton;
    ToolButton5: TToolButton;
    UndoButton: TToolButton;
    CutButton: TToolButton;
    CopyButton: TToolButton;
    PasteButton: TToolButton;
    ToolButton10: TToolButton;
    FontName: TComboBox;
    FontSize: TEdit;
    ToolButton11: TToolButton;
    UpDown1: TUpDown;
    BoldButton: TToolButton;
    ItalicButton: TToolButton;
    UnderlineButton: TToolButton;
    ToolButton16: TToolButton;
    LeftAlign: TToolButton;
    CenterAlign: TToolButton;
    RightAlign: TToolButton;
    ToolButton20: TToolButton;
    BulletsButton: TToolButton;
    ToolbarImages: TImageList;
    ActionList1: TActionList;
    FileNewCmd: TAction;
    FileOpenCmd: TAction;
    FileSaveCmd: TAction;
    FilePrintCmd: TAction;
    FileExitCmd: TAction;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    EditCutCmd: TAction;
    EditCopyCmd: TAction;
    EditPasteCmd: TAction;
    EditUndoCmd: TAction;
    EditFontCmd: TAction;
    FileSaveAsCmd: TAction;
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton2: TSpeedButton;
    SpeedButton1: TSpeedButton;

    procedure SelectionChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FileNew(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure FileSave(Sender: TObject);
    procedure FileSaveAs(Sender: TObject);
    procedure FilePrint(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure EditUndo(Sender: TObject);
    procedure EditCut(Sender: TObject);
    procedure EditCopy(Sender: TObject);
    procedure EditPaste(Sender: TObject);
    procedure SelectFont(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure BoldButtonClick(Sender: TObject);
    procedure ItalicButtonClick(Sender: TObject);
    procedure FontSizeChange(Sender: TObject);
    procedure AlignButtonClick(Sender: TObject);
    procedure FontNameChange(Sender: TObject);
    procedure UnderlineButtonClick(Sender: TObject);
    procedure BulletsButtonClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure RulerItemMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RulerItemMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure RightIndMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormShow(Sender: TObject);
    procedure RichEditChange(Sender: TObject);
    procedure ActionList2Update(Action: TBasicAction;
      var Handled: Boolean);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
  private
    FFileName: string;
    FUpdating: Boolean;
    FDragOfs: Integer;
    FDragging: Boolean;
    procedure GetFontNames;
    procedure SetFileName(const FileName: String);
    procedure CheckFileSave;
    procedure SetupRuler;
    procedure SetEditRect;
    procedure UpdateCursorPos;
//    procedure WMDropFiles(var Msg: TWMDropFiles); message WM_DROPFILES;
    procedure PerformFileOpen(const AFileName: string);
    procedure SetModified(Value: Boolean);
    function GetDocWithRTFInformation: string;
    procedure SetDocWithRTFInformation(const Value: string);

  public
    property DocWithRTFInformation: string read GetDocWithRTFInformation write SetDocWithRTFInformation;
  end;

implementation

//uses
{$IFnDEF FPC}
  ShellAPI,
{$ELSE}
{$ENDIF}
//  RichEdit;

resourcestring
  sSaveChanges = 'Save changes to %s?';
  sOverWrite = 'OK to overwrite %s';
  sUntitled = 'Untitled';
  sModified = 'Modified';
  sColRowInfo = 'Line: %3d   Col: %3d';

const
  RulerAdj = 4/3;
  GutterWid = 6;

{$R *.dfm}

procedure TRTFEditor.SelectionChange(Sender: TObject);
begin
  //with Editor.Paragraph do
  //try
  //  FUpdating := True;
  //  BoldButton.Down := fsBold in Editor.SelAttributes.Style;
  //  ItalicButton.Down := fsItalic in Editor.SelAttributes.Style;
  //  UnderlineButton.Down := fsUnderline in Editor.SelAttributes.Style;
  //  BulletsButton.Down := Boolean(Numbering);
  //  FontSize.Text := IntToStr(Editor.SelAttributes.Size);
  //  FontName.Text := Editor.SelAttributes.Name;
  //  case Ord(Alignment) of
  //    0: LeftAlign.Down := True;
  //    1: RightAlign.Down := True;
  //    2: CenterAlign.Down := True;
  //  end;
  //  UpdateCursorPos;
  //finally
  //  FUpdating := False;
  //end;
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

function TRTFEditor.GetDocWithRTFInformation: string;
var lRTF: TStringStream;
begin
  lRTF := TStringStream.Create('');
  try
    Editor.Lines.SaveToStream(lRTF);
    result := lRTF.DataString;
  finally
    lRTF.Free;
  end;
end;

procedure TRTFEditor.GetFontNames;
var
  DC: HDC;
begin
  DC := GetDC(0);
//  EnumFonts(DC, nil, @EnumFontsProc, Pointer(FontName.Items));
  ReleaseDC(0, DC);
  FontName.Sorted := True;
end;

procedure TRTFEditor.SetFileName(const FileName: String);
begin
  FFileName := FileName;
  Caption := Caption + ' - ' + Format('%s', [ExtractFileName(FileName)]);
end;

procedure TRTFEditor.CheckFileSave;
var
  SaveResp: Integer;
begin
  if not Editor.Modified then Exit;
  SaveResp := MessageDlg(Format(sSaveChanges, [FFileName]),
    mtConfirmation, mbYesNoCancel, 0);
  case SaveResp of
    idYes: FileSave(Self);
    idNo: {Nothing};
    idCancel: Abort;
  end;
end;

procedure TRTFEditor.SetupRuler;
var
  I: Integer;
  S: String;
begin
  SetLength(S, 201);
  I := 1;
  while I < 200 do
  begin
    S[I] := #9;
    S[I+1] := '|';
    Inc(I, 2);
  end;
end;

procedure TRTFEditor.SetDocWithRTFInformation(const Value: string);
begin
  editor.text := value;
end;

procedure TRTFEditor.SetEditRect;
var
  R: TRect;
begin
  with Editor do
  begin
    R := Rect(GutterWid, 0, ClientWidth-GutterWid, ClientHeight);
//    SendMessage(Handle, EM_SETRECT, 0, Longint(@R));
  end;
end;

{ Event Handlers }

procedure TRTFEditor.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  OpenDialog.InitialDir := ExtractFilePath(ParamStr(0));
  SaveDialog.InitialDir := OpenDialog.InitialDir;
  SetFileName(sUntitled);
  GetFontNames;
  SetupRuler;
  SelectionChange(Self);

//  CurrText.Name := DefFontData.Name;
//  CurrText.Size := -MulDiv(DefFontData.Height, 72, Screen.PixelsPerInch);
end;

procedure TRTFEditor.ShowHint(Sender: TObject);
begin
  if Length(Application.Hint) > 0 then
  begin
    StatusBar.SimplePanel := True;
    StatusBar.SimpleText := Application.Hint;
  end
  else StatusBar.SimplePanel := False;
end;

procedure TRTFEditor.SpeedButton1Click(Sender: TObject);
begin
  ModalResult := mrcancel;
end;

procedure TRTFEditor.SpeedButton2Click(Sender: TObject);
begin
  ModalResult := mrok;
end;

procedure TRTFEditor.FileNew(Sender: TObject);
begin
  SetFileName(sUntitled);
  Editor.Lines.Clear;
  Editor.Modified := False;
  SetModified(False);
end;

procedure TRTFEditor.PerformFileOpen(const AFileName: string);
begin
  Editor.Lines.LoadFromFile(AFileName);
  SetFileName(AFileName);
  Editor.SetFocus;
  Editor.Modified := False;
  SetModified(False);
end;

procedure TRTFEditor.FileOpen(Sender: TObject);
begin
  CheckFileSave;
  if OpenDialog.Execute then
  begin
    PerformFileOpen(OpenDialog.FileName);
    Editor.ReadOnly := ofReadOnly in OpenDialog.Options;
  end;
end;

procedure TRTFEditor.FileSave(Sender: TObject);
begin
  if FFileName = sUntitled then
    FileSaveAs(Sender)
  else
  begin
    Editor.Lines.SaveToFile(FFileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TRTFEditor.FileSaveAs(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    if FileExists(SaveDialog.FileName) then
      if MessageDlg(Format(sOverWrite, [SaveDialog.FileName]),
        mtConfirmation, mbYesNoCancel, 0) <> idYes then Exit;

    Editor.Lines.SaveToFile(SaveDialog.FileName);
    SetFileName(SaveDialog.FileName);
    Editor.Modified := False;
    SetModified(False);
  end;
end;

procedure TRTFEditor.FilePrint(Sender: TObject);
begin
//  if PrintDialog.Execute then
//    Editor.Print(FFileName);
end;

procedure TRTFEditor.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TRTFEditor.EditUndo(Sender: TObject);
begin
  with Editor do
//    if HandleAllocated then SendMessage(Handle, EM_UNDO, 0, 0);
end;

procedure TRTFEditor.EditCut(Sender: TObject);
begin
  Editor.CutToClipboard;
end;

procedure TRTFEditor.EditCopy(Sender: TObject);
begin
  Editor.CopyToClipboard;
end;

procedure TRTFEditor.EditPaste(Sender: TObject);
begin
  Editor.PasteFromClipboard;
end;

procedure TRTFEditor.SelectFont(Sender: TObject);
begin
//  FontDialog1.Font.Assign(Editor.SelAttributes);
//  if FontDialog1.Execute then
//    CurrText.Assign(FontDialog1.Font);
  SelectionChange(Self);
  Editor.SetFocus;
end;

procedure TRTFEditor.FormResize(Sender: TObject);
begin
  SetEditRect;
  SelectionChange(Sender);
end;

procedure TRTFEditor.FormPaint(Sender: TObject);
begin
  SetEditRect;
end;

procedure TRTFEditor.BoldButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if BoldButton.Down then
//    CurrText.Style := CurrText.Style + [fsBold]
  else
//    CurrText.Style := CurrText.Style - [fsBold];
end;

procedure TRTFEditor.ItalicButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if ItalicButton.Down then
//    CurrText.Style := CurrText.Style + [fsItalic]
  else
//    CurrText.Style := CurrText.Style - [fsItalic];
end;

procedure TRTFEditor.FontSizeChange(Sender: TObject);
begin
  if FUpdating then Exit;
  if FontSize.Text = '' then exit;
  
//  CurrText.Size := StrToInt(FontSize.Text);
end;

procedure TRTFEditor.AlignButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
//  Editor.Paragraph.Alignment := TAlignment(TControl(Sender).Tag);
end;

procedure TRTFEditor.FontNameChange(Sender: TObject);
begin
  if FUpdating then Exit;
//  CurrText.Name := FontName.Items[FontName.ItemIndex];
end;

procedure TRTFEditor.UnderlineButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
  if UnderlineButton.Down then
//    CurrText.Style := CurrText.Style + [fsUnderline]
  else
//    CurrText.Style := CurrText.Style - [fsUnderline];
end;

procedure TRTFEditor.BulletsButtonClick(Sender: TObject);
begin
  if FUpdating then Exit;
//  Editor.Paragraph.Numbering := TNumberingStyle(BulletsButton.Down);
end;

procedure TRTFEditor.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
//  try
//    CheckFileSave;
//  except
//    CanClose := False;
//  end;
end;

{ Ruler Indent Dragging }

procedure TRTFEditor.RulerItemMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragOfs := (TLabel(Sender).Width div 2);
  TLabel(Sender).Left := TLabel(Sender).Left+X-FDragOfs;
  FDragging := True;
end;

procedure TRTFEditor.RulerItemMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if FDragging then
    TLabel(Sender).Left :=  TLabel(Sender).Left+X-FDragOfs
end;

procedure TRTFEditor.FirstIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  LeftIndMouseUp(Sender, Button, Shift, X, Y);
end;

procedure TRTFEditor.LeftIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  SelectionChange(Sender);
end;

procedure TRTFEditor.RightIndMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FDragging := False;
  SelectionChange(Sender);
end;

procedure TRTFEditor.UpdateCursorPos;
var
  CharPos: TPoint;
begin
//  CharPos.Y := SendMessage(Editor.Handle, EM_EXLINEFROMCHAR, 0,
//    Editor.SelStart);
//  CharPos.X := (Editor.SelStart -
//    SendMessage(Editor.Handle, EM_LINEINDEX, CharPos.Y, 0));
  Inc(CharPos.Y);
  Inc(CharPos.X);
  StatusBar.Panels[0].Text := Format(sColRowInfo, [CharPos.Y, CharPos.X]);
end;

procedure TRTFEditor.FormShow(Sender: TObject);
begin
  UpdateCursorPos;
//  DragAcceptFiles(Handle, True);
  RichEditChange(nil);
  Editor.SetFocus;
  { Check if we should load a file from the command line }
  if (ParamCount > 0) and FileExists(ParamStr(1)) then
    PerformFileOpen(ParamStr(1));
end;

{procedure TRTFEditor.WMDropFiles(var Msg: TWMDropFiles);
var
  CFileName: array[0..MAX_PATH] of Char;
begin
  try
//    if DragQueryFile(Msg.Drop, 0, CFileName, MAX_PATH) > 0 then
    begin
      CheckFileSave;
//      PerformFileOpen(CFileName);
      Msg.Result := 0;
    end;
  finally
//    DragFinish(Msg.Drop);
  end;
end;
}
procedure TRTFEditor.RichEditChange(Sender: TObject);
begin
  SetModified(Editor.Modified);
end;

procedure TRTFEditor.SetModified(Value: Boolean);
begin
  if Value then StatusBar.Panels[1].Text := sModified
  else StatusBar.Panels[1].Text := '';
end;

procedure TRTFEditor.ActionList2Update(Action: TBasicAction;
  var Handled: Boolean);
begin
 { Update the status of the edit commands }
//  EditCutCmd.Enabled := Editor.SelLength > 0;
  EditCopyCmd.Enabled := EditCutCmd.Enabled;
  if Editor.HandleAllocated then
  begin
//    EditUndoCmd.Enabled := Editor.Perform(EM_CANUNDO, 0, 0) <> 0;
//    EditPasteCmd.Enabled := Editor.Perform(EM_CANPASTE, 0, 0) <> 0;
  end;
end;

end.
