unit ituExplorerV2;

interface

uses
  LCLIntf, SysUtils, Variants, Classes, Graphics, Controls, Forms, Clipbrd,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, ActnList, LCLType,
  acuSQLDialectManager, ImgList, acuframework, utuMessage, IntegracaoDelphiSUML,
  acuObjectExplorer, Menus, Buttons, SynEdit, SynHighlighterSQL, SynCompletion,
  acuModel, acuRepositorySQL, SynEditKeyCmds, SynHighlighterPython,SynFacilHighlighter,SynFacilCompletion,SynFacilBasic, Types;

const
    __WHERE  = 'WHERE';
    __SELECT = 'SELECT';
    __FROM   = 'FROM';
type

  TDLLDialog = class(TForm)
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    procedure BtnShowMessageClick(Sender: TObject);
    constructor Create(aOwner: TComponent); override;
  public
    ParentFormHandle: HWND;
  end;

  { TExplorerV2 }

  TExplorerV2 = class(TForm)
    actExecute: TAction;
    actCancel: TAction;
    edtClasse: TEdit;
    gbAgrupamento: TGroupBox;
    ilModel: TImageList;
    Label2: TLabel;
    lvXMLListResult: TListView;
    memXMLTextResult: TMemo;
    OQLObjects: TObjectExplorer;
    pnFiltroClasse: TPanel;
    pcXMLResults: TPageControl;
    rbHieraquia: TRadioButton;
    rbSequencial: TRadioButton;
    ReconnectDB: TAction;
    sbStatusBar: TStatusBar;
    spResultXML: TSplitter;
    spResultObject: TSplitter;
    SynEditOQL: TSynEdit;
    SynEditSQL: TSynEdit;
    SynSQLSyn1: TSynSQLSyn;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton10: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    tsList: TTabSheet;
    tsXML: TTabSheet;
    XMLQuery: TAction;
    OQLQuery: TAction;
    actResultsPanel: TAction;
    actModelPanel: TAction;
    ActionList1: TActionList;
    pnlEditor: TPanel;
    pnlModel: TPanel;
    splVertical: TSplitter;
    pnlResult: TPanel;
    tvModelExplorer: TTreeView;
//    con1: TADOConnection;
    il1: TImageList;
    pmCopiar: TPopupMenu;
    Copia: TMenuItem;
    pcEditor: TPageControl;
    tsOQL: TTabSheet;
    tsSQL: TTabSheet;
    pcResults: TPageControl;
    tsQueryResult: TTabSheet;
    tsError: TTabSheet;
    memErrorText: TMemo;
    pnlActionBar: TPanel;
    procedure opEveLoadItems(opEve: TFaOpenEvent; curEnv: TFaCursorEnviron; out Cancel: boolean);

    procedure actModelPanelExecute(Sender: TObject);
    procedure edtClasseChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure actResultsPanelExecute(Sender: TObject);
    procedure rbSequencialClick(Sender: TObject);
		procedure SynEditOQLKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure SynEditOQLUTF8KeyPress(Sender: TObject; var UTF8Key: TUTF8Char);
    procedure tvModelExplorerGetSelectedIndex(Sender: TObject; Node: TTreeNode);
    procedure tvModelExplorerItemExpanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean);
    procedure XMLQueryExecute(Sender: TObject);
    procedure actExecuteExecute(Sender: TObject);
    procedure memOQLQuery2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure memOQLQuery2DragOver(Sender, Source: TObject; X, Y: Integer;  State: TDragState; var Accept: Boolean);
    procedure CopiaDadosObjeto(Sender: TObject);
    procedure OQLObjectstvExplorerKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ReconnectDBExecute(Sender: TObject);
    procedure pcEditorChange(Sender: TObject);
    procedure OQLQueryExecute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    fAlias,
    fKeywords : TStrings;
    fExecuting: Boolean;
    fMetaModel: acMetaModel;
    fMetaModelPersistenceMap: acMetaModelPersistenceMapSQL;
    fSession: acPersistenceSession;
    fConnectionString: string;
    fSQLDialect: acAbstractSQLDialect;
    fSchema: String;
    fUtil: TUtil;
    fLastExecErrorFlag: Boolean;
    fopEvenSearchSelect,
    fopEvenSearchFrom,
    fopEvenSearchWhere,
    fopEvenSelectAposPonto,
    fopEvenFromAposPonto,
    fopEvenWhereAposPonto,
    fopEvenselectCompleto,
    fopEvenFromCompleto,
    fopEvenWhereCompleto :  TFaOpenEvent;
    fhlt1 : TSynFacilComplet;

    procedure MontarModelExploreSequencial(Sender: TObject; Node: TTreeNode);
    procedure MontarModelExploreHieraquia(Sender: TObject; Node: TTreeNode);
    procedure SetMetaModel(const Value: acMetaModel);
    procedure ResizeColumns(piListView: TListView);
    function GetStringEntreParenteses(piString : string) : string;
    function GetNumeroDeStringOID (piString : string) : string;
    function GetClassTicket(piBloco,piPropertyName : string):acClassTicket;
    procedure CopiaTextoObjeto (piObjeto : TTreeNode);
    function BuscaParcial(piSubstring,piTexto :string): boolean;
    function BuscaParcialClasse(piCLasse: string; piFiltrar: boolean): boolean;
    function BuscarParcialChildClass(piClassTicket : acClassTicket; piFiltrar: boolean): boolean;
    function FindParcialNodeClass(piClassTicketPai : acClassTicket; piFiltrar: boolean):acClassTicket;
    //procedure ExecutarSybCompletion(piSynCompletion : TSynCompletion);
    procedure LoadListCompletion(piLinha:string;piAceitaAtributo : boolean;piLista : TStrings);
    procedure LoadAliasCompletion(piLinha:string);
//    procedure PreparaSynCompletion;
    function RetirarPalavraChaveOLQ(piSynEdit :TSynEdit):string;
    function IsKeyword(piItem : string): boolean;

   protected
    procedure CreateParams(var Params : TCreateParams); override;
    function Connect : acPersistenceSession;

  public
    { Public declarations }
    property MetaModel: acMetaModel read fMetaModel write SetMetaModel;
    property Util: TUtil read fUtil;
    property SQLDialect: acAbstractSQLDialect read fSQLDialect;
    property Schema: String read fSchema;
  end;

var
  ExplorerV2: TExplorerV2;

implementation

uses ituDataBaseLogin, DateUtils, acuObject, acuOQL, acuOQLtoSQLTranslator,
      ituOQLParams;

{$R *.dfm}

function TiraAcentos(const s : string): string;
const
  Acentos = '';
   Letras = 'AIOUEAIOUEAIOUEAOAIOUEaioueaioueaioueaoaioue';
var
  i: Integer;
begin
  Result := S;
  for i := 1 to Length(Acentos) do
    while Pos(acentos[i],Result)>0 do
      Result[Pos(acentos[i],Result)]:=Letras[i];
end;
procedure TExplorerV2.actExecuteExecute(Sender: TObject);
var lSession: acPersistenceSession;
    lList: acPersistentObjectList;
    lStart: TDateTime;
    lOQLQuery: acAbstractOQLQuery;
    lOQLParams: TOQLParams;
    lResultField: utField;
    lEnum: acEnumerator;
    lField: utField;
    lColumn: TListColumn;
    lListItem: TListItem;
    lEnumAtt: acEnumerator;
    lFirstItemFlag: Boolean;
    lCount: integer;
begin
  lCount := 0;
  if (SynEditOQL.Text <> '') and (not fExecuting) then
  begin
    fExecuting := True;
    try
      lSession := Connect;
      if Assigned(lSession) then
      begin
        SynEditSQL.Text := '';
        OQLObjects.SetList(nil, '');
        lvXMLListResult.Clear;
        lvXMLListResult.Columns.Clear;
        pcResults.ActivePageIndex := 0;

        if assigned(fSession) then FreeAndNil(fSession);
        fSession := lSession;

        if OQLQuery.Checked then
        begin
          lList := acPersistentObjectList.Create;
          try
            sbStatusBar.Panels[0].Text := 'Executing query...';
            sbStatusBar.Panels[1].Text := '';
            sbStatusBar.Panels[2].Text := '';
            Application.ProcessMessages;
            if SynEditOQL.SelText = ''
              then lOQLQuery := acOQLQuery.Create(fSession, SynEditOQL.Text)
              else lOQLQuery := acOQLQuery.Create(fSession, SynEditOQL.SelText);
            try
              if lOQLQuery.Parameters.Count > 0 then
              begin
                lOQLParams := TOQLParams.Create(nil, lOQLQuery);
                try
                  lOQLParams.ShowModal;
                finally
                  lOQLParams.free;
                end;
              end;

              lStart := Now;

              (lOQLQuery as acOQLQuery).LoadList(lList);
              SynEditSQL.Text := lOQLQuery.GetSQLText;
            finally
              lOQLQuery.Free;
            end;

            sbStatusBar.Panels[2].Text := SysUtils.TimeToStr(TimeOf(Now - lStart));
            sbStatusBar.Panels[0].Text := 'Query completed.';
            if lList.Count <= 1 then
              sbStatusBar.Panels[1].Text := inttostr(lList.Count) + ' object'
            else
              sbStatusBar.Panels[1].Text := inttostr(lList.Count) + ' objects';
            OQLObjects.SetList(lList, 'OQL Results');

            fLastExecErrorFlag := False;
            if not actResultsPanel.Checked then actResultsPanel.Execute;
          finally
            lList.Free;
          end;
        end
        else
        begin
          pcXMLResults.ActivePageIndex := 0;
          sbStatusBar.Panels[0].Text := 'Executing query...';
          sbStatusBar.Panels[1].Text := '';
          sbStatusBar.Panels[2].Text := '';
          Application.ProcessMessages;

          if SynEditOQL.SelText = ''
            then lOQLQuery := acDataSetOQLQuery.Create(fSession, SynEditOQL.Text)
            else lOQLQuery := acDataSetOQLQuery.Create(fSession, SynEditOQL.SelText);
          try
            if lOQLQuery.Parameters.Count > 0 then
            begin
              lOQLParams := TOQLParams.Create(nil, lOQLQuery);
              try
                lOQLParams.ShowModal;
              finally
                lOQLParams.free;
              end;
            end;

            lStart := Now;

            lResultField := utField.Create;
            try
              lResultField.Name := 'ROOT';
              (lOQLQuery as acDataSetOQLQuery).LoadDataSet(lResultField);
              SynEditSQL.Text := lOQLQuery.GetSQLText;
              memXMLTextResult.Text := lResultField.GetXMLString([XMLOptions.xoLegible]);

              lvXMLListResult.Items.BeginUpdate;
              try
                //Adiciona as colunas no listview
                if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('METADATA')) then
                begin
                  lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('METADATA').FieldByName('FIELDS').GetFieldsEnumerator;
                  try
                    while not lEnum.EOL do
                    begin
                      lField := utField(lEnum.Current);
                      lColumn := lvXMLListResult.Columns.Add;
                      lColumn.Caption := lField.AttributeByName('Name').AsString;
                      lColumn.AutoSize := True;
                      lEnum.MoveNext;
                    end;
                  finally
                    lEnum.Free;
                  end;
                end;

                if (lResultField.HasField('DATAPACKET')) and (lResultField.FieldByName('DATAPACKET').HasField('ROWDATA')) then
                begin
                  lCount := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').AttributeByName('Count').AsInteger;
                  lEnum := lResultField.FieldByName('DATAPACKET').FieldByName('ROWDATA').GetFieldsEnumerator;
                  try
                    while not lEnum.EOL do
                    begin
                      lField := utField(lEnum.Current);
                      lListItem := lvXMLListResult.Items.Add;
                      lEnumAtt := lField.GetAttibutesEnumerator;
                      try
                        lFirstItemFlag := true;
                        while not lEnumAtt.EOL do
                        begin
                          if lFirstItemFlag then
                          begin
                            lListItem.Caption := utAttribute(lEnumAtt.Current).AsString;
                            lFirstItemFlag := false;
                          end
                          else
                            lListItem.SubItems.Add(utAttribute(lEnumAtt.Current).AsString);
                          lEnumAtt.MoveNext;
                        end;
                      finally
                        lEnumAtt.Free;
                      end;
                      lEnum.MoveNext;
                    end;
                  finally
                    lEnum.Free;
                  end;
                end;
              finally
                lvXMLListResult.Items.EndUpdate;
              end;

            finally
              lResultField.free;
            end;
//            ResizeColumns(lvXMLListResult);
          finally
            lOQLQuery.Free;
          end;
          sbStatusBar.Panels[2].Text := SysUtils.TimeToStr(TimeOf(Now - lStart));
          if lCount <= 1 then
            sbStatusBar.Panels[1].Text := inttostr(lCount) + ' row'
          else
            sbStatusBar.Panels[1].Text := inttostr(lCount) + ' rows';
          sbStatusBar.Panels[0].Text := 'Query completed.';

          fLastExecErrorFlag := False;
          if not actResultsPanel.Checked then actResultsPanel.Execute;
        end;
      end;
    except
      on e: Exception do
        begin
          fLastExecErrorFlag := True;
          memErrorText.Text := e.Message;
          pcResults.ActivePageIndex := 1;
          sbStatusBar.Panels[0].Text := 'Query completed with errors.';
          if not actResultsPanel.Checked then actResultsPanel.Execute;
        end;
    end;
  end;
  fExecuting := False;
end;

procedure TExplorerV2.actModelPanelExecute(Sender: TObject);
var
  lAction : TAction;
begin
  lAction := (Sender as TAction);
  lAction.Checked := not lAction.Checked;
  if lAction.Checked then
  begin
    pnlModel.Visible := True;
    if pnlModel.Width <= 10 then
      pnlModel.Width := 20;
  end
  else
  begin
    pnlModel.Visible := False;
  end;
end;

procedure TExplorerV2.edtClasseChange(Sender: TObject);
begin
  tvModelExplorer.Items.Clear;
  MetaModel := fUtil.MetaModel;
end;

procedure TExplorerV2.actResultsPanelExecute(Sender: TObject);
var
  lAction : TAction;
begin
  lAction := (Sender as TAction);
  lAction.Checked := not lAction.Checked;
  if lAction.Checked then
  begin
    if fLastExecErrorFlag then
    begin
      pcResults.ActivePageIndex := 1;
      pnlResult.Visible := True;
      spResultXML.Visible := True;
      spResultXML.Align := alBottom;
      if pnlResult.Height <= 10 then
        pnlResult.Height := 20;
    end
    else
    begin
      if OQLQuery.Checked then
      begin
        OQLObjects.Visible := True;
        spResultObject.Visible := True;
        spResultObject.Align := alRight;
        spResultXML.Visible := False;
      end
      else
      begin
        pcResults.ActivePageIndex := 0;
        spResultObject.Visible := False;
        pnlResult.Visible := True;
        spResultXML.Visible := True;
        spResultXML.Align := alBottom;
      end;
    end;
  end
  else
  begin
    spResultXML.Align := alNone;
    spResultObject.Align := alNone;
    spResultXML.Visible := False;
    spResultObject.Visible := False;
    pnlResult.Visible := False;
    OQLObjects.Visible := False;
  end;
end;

procedure TExplorerV2.rbSequencialClick(Sender: TObject);
begin

end;
 procedure TExplorerV2.SynEditOQLKeyUp(Sender: TObject; var Key: Word;
	 Shift: TShiftState);
var lmostrar : boolean;
begin
   lmostrar := true;

   // Ctrl + Espao
   if ( (Shift = [ssCtrl]) and (Key = 86) )
   then
   begin
     lmostrar := false;
	 end;
   //Espao
   if key = 32 then
   begin
     lmostrar := false;
	 end;
   //backspace
   if key = 8 then
   begin
     lmostrar := false;
	 end;

	 if lmostrar then
   begin
     fhlt1.KeyUp(Sender, Key, Shift);
	 end;
end;



procedure TExplorerV2.SynEditOQLUTF8KeyPress(Sender: TObject;
  var UTF8Key: TUTF8Char);
begin
  fhlt1.UTF8KeyPress(Sender, UTF8Key);
end;



procedure TExplorerV2.tvModelExplorerGetSelectedIndex(Sender: TObject; Node: TTreeNode);
begin
  Node.SelectedIndex := Node.ImageIndex;
end;

procedure TExplorerV2.OQLQueryExecute(Sender: TObject);
begin
  OQLQuery.Checked := True;
  XMLQuery.Checked := False;
end;

function TExplorerV2.Connect: acPersistenceSession;
var
    lDataBaseLogin: TDataBaseLogin;
    lModalResult: Integer;
begin
  lModalResult := mrOk;
  Result := Nil;
  lDataBaseLogin := TDataBaseLogin.Create(Self);
  try
    lDataBaseLogin.ProjectFileName := ExtractFileName(fUtil.StarUMLApp.ProjectManager.FileName);
    while (lModalResult = mrOk) and (not Assigned(Result)) do
    begin
      if fConnectionString = '' then
      begin
        lModalResult := lDataBaseLogin.ShowModal;
        if lModalResult = mrok then
        begin
          if lDataBaseLogin.rbDSN.Checked then
          begin
             fConnectionString := format('DSN=%s;UID=%s;PWD=%s',[lDataBaseLogin.cbODBCD_DSN.Text, lDataBaseLogin.edtUsuario.Text, lDataBaseLogin.edtPassword.Text]);
             fSQLDialect := lDataBaseLogin.cbDialect.Items.Objects[lDataBaseLogin.cbDialect.ItemIndex] as acAbstractSQLDialect;
             sbStatusBar.Panels[3].Text := Format('%s.%s(%s)', [lDataBaseLogin.cbDialect.Text, lDataBaseLogin.cbODBCD_DSN.Text, lDataBaseLogin.edtUsuario.Text]);
          end
          else
          begin
            if lDataBaseLogin.edtDatabaseName.Text <> ''
              then fConnectionString := format('DRIVER=%s;Server=%s;Database=%s;UID=%s;PWD=%s',[lDataBaseLogin.cbODBCD_DRIVERS.Text, lDataBaseLogin.edtServerName.Text, lDataBaseLogin.edtDatabaseName.Text, lDataBaseLogin.edtUsuario.Text, lDataBaseLogin.edtPassword.Text])
              else fConnectionString := format('DRIVER=%s;Server=%s;UID=%s;PWD=%s',[lDataBaseLogin.cbODBCD_DRIVERS.Text, lDataBaseLogin.edtServerName.Text, lDataBaseLogin.edtUsuario.Text, lDataBaseLogin.edtPassword.Text]);
            fSQLDialect := lDataBaseLogin.cbDialect.Items.Objects[lDataBaseLogin.cbDialect.ItemIndex] as acAbstractSQLDialect;
            if lDataBaseLogin.edtDatabaseName.Text <> ''
              then sbStatusBar.Panels[3].Text := Format('%s.%s.%s(%s)', [lDataBaseLogin.cbDialect.Text, lDataBaseLogin.edtServerName.Text, lDataBaseLogin.edtDatabaseName.Text, lDataBaseLogin.edtUsuario.Text])
              else sbStatusBar.Panels[3].Text := Format('%s.%s.Default(%s)', [lDataBaseLogin.cbDialect.Text, lDataBaseLogin.edtServerName.Text, lDataBaseLogin.edtUsuario.Text]);
          end;
        end
        else exit;
      end;

      if fConnectionString <> '' then
      begin
        try
          Result := PersistenceManager.OpenSession(fMetaModelPersistenceMap, fConnectionString);
          (Result.Repository as acRepositorySQL).SQLDialect := fSQLDialect;

          if actResultsPanel.Checked then actResultsPanel.Execute;
          sbStatusBar.Panels[0].Text := '';
          sbStatusBar.Panels[1].Text := '';
          sbStatusBar.Panels[2].Text := '';
          OQLObjects.SetList(nil, '');
          lvXMLListResult.Clear;
          lvXMLListResult.Columns.Clear;
          memXMLTextResult.Clear;
          pcResults.ActivePageIndex := 0;

        Except
          on e:Exception do
          begin
            fConnectionString := '';
            ShowMessage(e.Message);
          end;
        end;
      end;
    end;
  finally
    lDataBaseLogin.Free;
  end;
end;

procedure TExplorerV2.CopiaDadosObjeto(Sender: TObject);
begin
  if Assigned(OQLObjects.tvExplorer.Selected) then
    CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
end;

procedure TExplorerV2.CopiaTextoObjeto(piObjeto: TTreeNode);
var
  lString : string;
begin
  lString := piObjeto.Text;
  lString := GetNumeroDeStringOID(GetStringEntreParenteses(lString));
  if lString <> '' then
    Clipbrd.Clipboard.AsText := lString;
end;

function TExplorerV2.BuscaParcial(piSubstring, piTexto: string): boolean;
var lSubstring,
    lTexto : string;
begin
  if trim(piSubstring) <> '' then
  begin
	   lSubstring     :=  TiraAcentos(trim(UpperCase(piSubstring)));
	   lTexto         :=  TiraAcentos(trim(UpperCase(piTexto)));
	   result         :=  Pos(lSubstring,lTexto) > 0;
  end
  else
  begin
    result := true;
	end;

end;

function TExplorerV2.BuscaParcialClasse(piCLasse: string;  piFiltrar: boolean): boolean;
var lClasseTree,
    lClasseP : string;
begin
   if piFiltrar then
   begin
     lClasseP     :=  TiraAcentos(trim(UpperCase(edtClasse.Text)));
     lClasseTree  :=  TiraAcentos(trim(UpperCase(piCLasse)));
     result :=  Pos(lClasseP,lClasseTree) > 0;
   end
   else
   begin
     result := true;
   end;

end;

function TExplorerV2.BuscarParcialChildClass( piClassTicket : acClassTicket;
   piFiltrar: boolean): boolean;
var lEnumeratorChild : acEnumerator;
    lClassTicketChild : acClassTicket;
begin
  result := BuscaParcialClasse(piClassTicket.PersistentObjectClassName,piFiltrar);
  if not result then
  begin
    lEnumeratorChild := piClassTicket.DirectDescendants.GetEnumerator;
    try
      while not lEnumeratorChild.EOL do
      begin
        lClassTicketChild := acClassTicket(lEnumeratorChild.Current);
        if BuscaParcialClasse(lClassTicketChild.PersistentObjectClassName,piFiltrar) then
        begin
           result  := true;
           break;
        end
        else  if BuscarParcialChildClass(lClassTicketChild,piFiltrar) then
        begin
           result  := true;
           break;
        end;

        lEnumeratorChild.MoveNext;
      end;
    finally
      lEnumeratorChild.Free;
    end;
  end;

end;

function TExplorerV2.FindParcialNodeClass(piClassTicketPai: acClassTicket;
  piFiltrar: boolean): acClassTicket;
var lEnumeratorChild : acEnumerator;
    lClassTicketChild : acClassTicket;
begin
  result := nil;
  if BuscaParcialClasse(piClassTicketPai.PersistentObjectClassName,piFiltrar) then
  begin
    result := piClassTicketPai;
  end
  else
  begin
    lEnumeratorChild := piClassTicketPai.DirectDescendants.GetEnumerator;
    try
      while not lEnumeratorChild.EOL do
      begin
        lClassTicketChild := acClassTicket(lEnumeratorChild.Current);
        if BuscaParcialClasse(lClassTicketChild.PersistentObjectClassName,piFiltrar) then
        begin
           result  := lClassTicketChild;
        end
        else
        begin
           result  :=FindParcialNodeClass(lClassTicketChild,piFiltrar);
        end;
        if Assigned(result) then
        begin
          break;
        end;
        lEnumeratorChild.MoveNext;
      end;
    finally
      lEnumeratorChild.Free;
    end;
  end;

end;
{
procedure TExplorerV2.ExecutarSybCompletion(piSynCompletion: TSynCompletion);
var  apoint,temppoint:tpoint;
begin
    //will compare the schema_tablename to a list of available schema names for the current database.
   temppoint   := SynEditOQL.CaretXY;
   temppoint.y := temppoint.y+1;
   apoint      := SynEditOQL.ClientToScreen(SynEditOQL.RowColumnToPixels(temppoint));
   piSynCompletion.Execute('',apoint);

end; }

procedure TExplorerV2.LoadListCompletion(piLinha: string; piAceitaAtributo: boolean; piLista: TStrings);
var lClassTicketCurrent,

    lClassTicketAux: acClassTicket;
    lEnumerator : acEnumerator;
    li,
    li_Pos : integer;
    ls_ant_objeto,
    ls_aux,
    ls_Objeto : string;
    lRelationTicket : acRelationTicket;
    lbAchei : boolean;
    lAttributeTicket : acAttributeTicket;
begin
  piLista.Clear;
  li_Pos := Pos ('..',piLinha);
  if li_Pos > 0 then
  begin
    exit;
	end;
  li_Pos := Pos ('.',piLinha);
	if li_Pos <= 0 then
  begin
    lEnumerator := self.MetaModel.ClassTickets.GetEnumerator;
    try
      while not lEnumerator.EOL do
      begin
        lClassTicketCurrent := acClassTicket(lEnumerator.Current);
        if BuscaParcial(piLinha,lClassTicketCurrent.PersistentObjectClassName) then
        begin
          piLista.Add(lClassTicketCurrent.PersistentObjectClassName);
	      end;
	      lEnumerator.MoveNext;
      end;
    finally
      lEnumerator.Free;
    end;
  end
  else
  begin
     ls_aux := trim(piLinha);
     lClassTicketAux := nil;
     ls_Objeto := trim(Copy(ls_aux,0,li_Pos -1));
     lClassTicketCurrent := self.MetaModel.GetClassTicketByName(ls_Objeto);
     while li_Pos > 0 do
     begin

       ls_aux := trim(Copy(ls_aux,li_Pos +1,Length(ls_aux)));
       ls_ant_objeto := ls_aux;
       li_Pos := Pos ('.',ls_aux);
       ls_Objeto := trim(Copy(ls_aux,0,li_Pos -1));
       if Assigned(lClassTicketCurrent) and (ls_Objeto <> '') then
       begin

          lbAchei := false;
          for li := 0 to pred(lClassTicketCurrent.RelationTicketsIn.Count) do
			    begin
			      lRelationTicket := acRelationTicket(lClassTicketCurrent.RelationTicketsIn.Objects[li]);
			      if SameText(lRelationTicket.DestinationPropertyName, ls_Objeto) then
            begin
              lClassTicketAux := lRelationTicket.OriginClassTicket;
              ls_ant_objeto       := '';
              lbAchei := true;
              break;
            end;
			    end;
          if not lbAchei  then
          begin
				     for li := 0 to pred(lClassTicketCurrent.RelationTicketsOut.Count) do
				     begin
               lRelationTicket := acRelationTicket(lClassTicketCurrent.RelationTicketsOut.Objects[li]);
               if SameText(lRelationTicket.OriginPropertyName, ls_Objeto) then
               begin
                 lClassTicketAux := lRelationTicket.DestinationClassTicket;
                 ls_ant_objeto   := '';
                 break;
               end;
				     end;
					end;
          lClassTicketCurrent := lClassTicketAux;
			 end;

		 end;

     if Assigned(lClassTicketCurrent) then
     begin
        //ShowMessage(ls_ant_objeto);
        if piAceitaAtributo then
        begin
          for li := 0 to pred(lClassTicketCurrent.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicketCurrent.Attributes.Objects[li]);
            if lAttributeTicket.Stereotype = acAttributeStereotype.pvPersistent then
            begin

              if BuscaParcial(ls_ant_objeto,lAttributeTicket.AttributeName) then
                 piLista.Add(lAttributeTicket.AttributeName);
            end;
          end;
				end;
        for li := 0 to pred(lClassTicketCurrent.RelationTicketsIn.Count) do
        begin
          lRelationTicket := acRelationTicket(lClassTicketCurrent.RelationTicketsIn.Objects[li]);
          if trim(lRelationTicket.DestinationPropertyName) <> '' then
          begin
            if BuscaParcial(ls_ant_objeto,lRelationTicket.DestinationPropertyName) then
               piLista.Add(lRelationTicket.DestinationPropertyName);
          end;
        end;

        for li := 0 to pred(lClassTicketCurrent.RelationTicketsOut.Count) do
        begin
          lRelationTicket := acRelationTicket(lClassTicketCurrent.RelationTicketsOut.Objects[li]);
          if trim(lRelationTicket.OriginPropertyName) <> '' then
          begin
            if BuscaParcial(ls_ant_objeto,lRelationTicket.OriginPropertyName) then
             piLista.Add(lRelationTicket.OriginPropertyName);
          end;
        end;
		 end;
	end;

end;

procedure TExplorerV2.LoadAliasCompletion(piLinhas: string);
var  ls_texto,
     ls_espaco : string;
     li_Pos : integer;
     ls_Alias : string;
     ls_classe : string;
begin
  ls_espaco    := ' ';
  li_Pos       := Pos(__FROM,uppercase(piLinhas));
  if li_Pos > 0 then
  begin
    ls_texto :=trim(Copy(result,li_Pos + Length(__FROM),Length(piLinhas)));
	end;
  li_Pos     := Pos(ls_espaco,trim(ls_texto));
  if li_Pos > 0 then
  begin
		 ls_classe  := trim(Copy(ls_texto,0,li_Pos  -1);
		 ls_texto   := trim(Copy(ls_texto,li_Pos + 1,Length(ls_texto)));
		 li_Pos     := Pos(ls_espaco,trim(ls_texto));
     if li_Pos > 0 then
     begin
			  ls_Alias   := trim(Copy(ls_texto,0,li_Pos  -1);
			  if UpperCase(ls_Alias) = 'AS' then
			  begin
			    ls_Alias   := trim(Copy(ls_texto,li_Pos + 1 +li_Pos  -1);
			  end
        else
        begin

				end;
				li_Pos     := Pos(ls_espaco,ls_texto);
		 end;
	end;

end;

      {
procedure TExplorerV2.PreparaSynCompletion;
var  lAceitaAtributo : boolean;
     ls_espaco,
     ls_Aux : string;
     li_Pos : integer;
     p1,zeroPoint : TPoint;

begin
  scpListCompletion.ItemList.Clear;
  p1           := SynEditOQL.CaretXY ;
  zeroPoint.X  := 0;
  zeroPoint.y  := SynEditOQL.CaretY;
  ls_aux       := trim(SynEditOQL.TextBetweenPoints[zeroPoint,p1]);
  ls_espaco    := ' ';
  lAceitaAtributo := true;

  li_Pos       := Pos(__FROM,uppercase(ls_aux));
  if li_Pos > 0 then
  begin
     ls_aux:=trim(Copy(ls_aux,li_Pos + Length(__FROM),Length(ls_aux)));
    lAceitaAtributo:= false;
	end;

  li_Pos       := Pos(__SELECT,uppercase(ls_aux));
  if li_Pos > 0 then
  begin
    ls_aux:=trim(Copy(ls_aux,li_Pos + Length(__SELECT),Length(ls_aux)));
    lAceitaAtributo:= false;;
	end;

  li_Pos       := Pos(__WHERE,uppercase(ls_aux));
  if li_Pos > 0 then
  begin
    ls_aux:=trim(Copy(ls_aux,li_Pos + Length(__WHERE),Length(ls_aux)));
    lAceitaAtributo:= true;;
	end;

  li_Pos        := Pos(ls_espaco,trim(ls_aux));
  while li_Pos > 0 do
  begin
    ls_aux:=trim(Copy(ls_aux,li_Pos + 1,Length(ls_aux)));
    li_Pos       := Pos(ls_espaco,ls_aux);
	end;
  LoadListCompletion(ls_aux,lAceitaAtributo,scpListCompletion.ItemList);

end; }

function TExplorerV2.RetirarPalavraChaveOLQ(piSynEdit: TSynEdit): string;
var  ls_espaco : string;
     li_Pos : integer;
     p1,zeroPoint : TPoint;
begin
    p1           := piSynEdit.CaretXY ;
    zeroPoint.X  := 0;
    zeroPoint.y  := piSynEdit.CaretY;
    result       := trim(piSynEdit.TextBetweenPoints[zeroPoint,p1]);
    ls_espaco    := ' ';

    li_Pos       := Pos(__FROM,uppercase(result));
    if li_Pos > 0 then
    begin
       result:=trim(Copy(result,li_Pos + Length(__FROM),Length(result)));
  	end;

    li_Pos       := Pos(__SELECT,uppercase(result));
    if li_Pos > 0 then
    begin
      result:=trim(Copy(result,li_Pos + Length(__SELECT),Length(result)));
  	end;

    li_Pos       := Pos(__WHERE,uppercase(result));
    if li_Pos > 0 then
    begin
      result:=trim(Copy(result,li_Pos + Length(__WHERE),Length(result)));
  	end;

    li_Pos        := Pos(ls_espaco,trim(result));
    while li_Pos > 0 do
    begin
      result   :=trim(Copy(result,li_Pos + 1,Length(result)));
      li_Pos   := Pos(ls_espaco,result);
  	end;


end;

function TExplorerV2.IsKeyword(piItem: string): boolean;
var li_index : integer;
begin
  result := false;
  li_index := fKeywords.IndexOf(piItem);
  if li_index >= 0 then
  begin
    result := true;
	end;
end;

procedure TExplorerV2.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  {$IFDEF LCLWin32}
//  Params.WndParent := 0;
  {$ENDIF}
end;

procedure TExplorerV2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TExplorerV2.FormCreate(Sender: TObject);
var  lMetaModelGenOpt: TMetaModelGenerationOptions;
     lSelectBlock,
     lSelectSec,
     lFromSec,
     lWhereSec: TFaSynBlock;
     li : integer;
begin
  lMetaModelGenOpt.CheckDBAttributeNameLength := true;
  lMetaModelGenOpt.CheckDBTableNameLength := true;

  fUtil := TUtil.Create;
  fUtil.AlimentarMetamodel(lMetaModelGenOpt, nil);
  FMetaModelPersistenceMap := fUtil.MetaModelPersistenceMap;
  MetaModel := fUtil.MetaModel;

  fKeywords := TStringList.Create;
  fKeywords.Add(__SELECT);
  fKeywords.Add(__FROM);
  fKeywords.Add(__WHERE);
  fKeywords.Add('ORDER');
  fKeywords.Add('BY');
  fKeywords.Add('JOIN');

  fAlias := TStringList.Create;

  fhlt1 := TSynFacilComplet.Create(self);  //my highlighter
  //Here the syntax is defined
  // ...
  fhlt1.SelectEditor(SynEditOQL);
  fhlt1.Rebuild;
  fhlt1.CompletionOn:=true;
  fhlt1.OpenOnKeyUp:=true;
  fhlt1.SelectOnEnter:= true;
  fhlt1.DefTokIdentif('[$A-Za-z_]', '[A-Za-z0-9_]*');
  fhlt1.KeywordAttribute.Foreground:=clBlue;

  for li := 0 to fKeywords.Count - 1 do
  begin
	   fhlt1.AddKeyword(fKeywords.Strings[li]);
	end;

  lSelectSec   := fhlt1.AddSection(__SELECT);
  lFromSec     := fhlt1.AddSection(__FROM);
  lWhereSec    := fhlt1.AddSection(__WHERE);


  fopEvenSearchSelect              := fhlt1.AddOpenEvent('identifier','',fil_LastIdentPart);
  fopEvenSearchSelect.block        := lSelectSec;

  fopEvenSearchFrom               := fhlt1.AddOpenEvent('identifier','',fil_LastIdentPart);
  fopEvenSearchFrom.block         := lFromSec;

  fopEvenSearchWhere              := fhlt1.AddOpenEvent('identifier','',fil_LastIdentPart);
  fopEvenSearchWhere.block        := lWhereSec;

  fopEvenSelectAposPonto          := fhlt1.AddOpenEvent('identifier,''.''','',fil_None);
  fopEvenSelectAposPonto.Action   := pac_Insert;
  fopEvenSelectAposPonto.block    := lSelectSec;

  fopEvenFromAposPonto            := fhlt1.AddOpenEvent('identifier,''.''','',fil_None);
  fopEvenFromAposPonto.Action     := pac_Insert;
  fopEvenFromAposPonto.block      := lFromSec;

  fopEvenWhereAposPonto           := fhlt1.AddOpenEvent('identifier,''.''','',fil_None);
  fopEvenWhereAposPonto.Action    := pac_Insert;
  fopEvenWhereAposPonto.block     := lWhereSec;

  fopEvenSelectCompleto           := fhlt1.AddOpenEvent('','',fil_None);
  fopEvenselectCompleto.Action    := pac_Insert;
  fopEvenSelectCompleto.block     := lSelectSec;

  fopEvenFromCompleto             := fhlt1.AddOpenEvent('','',fil_None);
  fopEvenFromCompleto.Action      := pac_Insert;
  fopEvenFromCompleto.block       := lFromSec;

  fopEvenWhereCompleto            := fhlt1.AddOpenEvent('','',fil_None);
  fopEvenWhereCompleto.Action     := pac_Insert  ;
  fopEvenWhereCompleto.block      := lWhereSec;

  fopEvenFromAposPonto.OnLoadItems     :=opEveLoadItems;
  fopEvenSelectAposPonto.OnLoadItems   :=opEveLoadItems;
  fopEvenWhereAposPonto.OnLoadItems    :=opEveLoadItems;
  fopEvenselectCompleto.OnLoadItems    :=opEveLoadItems;
  fopEvenFromCompleto.OnLoadItems      :=opEveLoadItems;
  fopEvenWhereCompleto.OnLoadItems     :=opEveLoadItems;
  fopEvenSearchSelect.OnLoadItems      :=opEveLoadItems;
  fopEvenSearchFrom.OnLoadItems        :=opEveLoadItems;
  fopEvenSearchWhere.OnLoadItems       :=opEveLoadItems;



end;

procedure TExplorerV2.FormDestroy(Sender: TObject);
begin
  fUtil.Free;
  fhlt1.UnSelectEditor;
  fhlt1.Free;
  fKeywords.Free;
  fAlias.Free;
end;

procedure TExplorerV2.opEveLoadItems(opEve: TFaOpenEvent;
	 curEnv: TFaCursorEnviron; out Cancel: boolean);
var lLista : TStrings;
    ls_Texto,
    lLinha : string;
    lAceitaAtributo : boolean;
    li : integer;
begin
    opEve.ClearAvails;
    lAceitaAtributo := false;
    ls_Texto := SynEditOQL.GetWordAtRowCol(SynEditOQL.CaretXY);
    if not IsKeyword(ls_Texto) then
    begin
	     if  opEve = fopEvenWhereAposPonto then
	     begin
	        lAceitaAtributo := true;
	  	 end
	     else if opEve = fopEvenSelectAposPonto then
	     begin
	       if  XMLQuery.Checked then
	       begin
	         lAceitaAtributo := true;
	       end;
			 end;

	     lLista := TStringList.Create;
	     try
	       lLinha := RetirarPalavraChaveOLQ(SynEditOQL);
	       LoadListCompletion(lLinha,lAceitaAtributo,lLista);
	       for li := 0 to lLista.Count - 1 do
	       begin
	         opEve.AddAvail(lLista.Strings[li]);
	       end
	     finally
	       lLista.Free;
			 end;
		end;
		Cancel := true;


end;

procedure TExplorerV2.MontarModelExploreSequencial(Sender: TObject; Node: TTreeNode);
var lClassTicket: acClassTicket;
    lAttributeTicket: acAttributeTicket;
    lRelationTicket: acRelationTicket;
    lCardinality: string;
    lEnumerator: acEnumerator;
    li: integer;
    targetNode :  TTreeNode;
    lFiltro : boolean;
begin
  lFiltro  := trim(edtClasse.Text) <> '';
  if Node.HasChildren and (Node.Count = 0)then
  begin
    Node.Owner.BeginUpdate;
    try
      if (TObject(Node.Data) is acMetaModel) then
      begin
        lEnumerator := acMetaModel(Node.Data).ClassTickets.GetEnumerator;
        while not lEnumerator.EOL do
        begin
          lClassTicket := acClassTicket(lEnumerator.Current);
          if BuscaParcialClasse(lClassTicket.PersistentObjectClassName,lFiltro) then
          begin
            targetNode := Node.Owner.AddChildObject(Node, lClassTicket.PersistentObjectClassName, lClassTicket);
            targetNode.ImageIndex := 6;
            targetNode.HasChildren := True;
          end;
          lEnumerator.MoveNext;
        end;
      end
      else if (TObject(Node.Data) is acClassTicket) then
      begin
        lClassTicket := acClassTicket(Node.Data);
        repeat
          for li := 0 to pred(lClassTicket.Attributes.Count) do
          begin
            lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
            if lAttributeTicket.Stereotype = acAttributeStereotype.pvPersistent then
            begin
              targetNode := Node.Owner.AddChildObject(Node, lAttributeTicket.AttributeName + ': ' + lAttributeTicket.AttributeType, lAttributeTicket);
              if lAttributeTicket.Mandatory then
                targetNode.ImageIndex := 5
              else
                targetNode.ImageIndex := 0;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsIn.Objects[li]);
            if lRelationTicket.DestinationMaxMultiplicity = N
              then lCardinality := '*'
              else lCardinality := inttostr(lRelationTicket.DestinationMaxMultiplicity);
            if lRelationTicket.DestinationPropertyName <> '' then
            begin
              targetNode := Node.Owner.AddChildObject(Node, lRelationTicket.DestinationPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.OriginClassTicket.PersistentObjectClassName, lRelationTicket.OriginClassTicket);
              targetNode.HasChildren := True;

              if lRelationTicket.DestinationMaxMultiplicity = N then
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 4
                else
                  targetNode.ImageIndex := 2;
              end
              else
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 3
                else
                  targetNode.ImageIndex := 1;
              end;
            end;
          end;
          for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
          begin
            lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsOut.Objects[li]);
            if lRelationTicket.OriginPropertyName <> '' then
            begin
              if lRelationTicket.OriginMaxMultiplicity = N
                then lCardinality := '*'
                else lCardinality := inttostr(lRelationTicket.OriginMaxMultiplicity);
              targetNode := Node.Owner.AddChildObject(Node, lRelationTicket.OriginPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.DestinationClassTicket.PersistentObjectClassName, lRelationTicket.DestinationClassTicket);
              targetNode.HasChildren := True;
              if lRelationTicket.OriginMaxMultiplicity = N then
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 4
                else
                  targetNode.ImageIndex := 2;
              end
              else
              begin
                if lRelationTicket.DestinationMinMultiplicity = 1 then
                  targetNode.ImageIndex := 3
                else
                  targetNode.ImageIndex := 1;
              end;
            end;
          end;
          lClassTicket := lClassTicket.ParentClassTicket;
        until lClassTicket = nil;
      end;
    finally
      Node.Owner.EndUpdate;
    end;
  end;

end;

procedure TExplorerV2.MontarModelExploreHieraquia(Sender: TObject; Node: TTreeNode);
var lClassTicketChild,
    lClassTicketPatriarc,
    lClassTicket: acClassTicket;
    lAttributeTicket: acAttributeTicket;
    lRelationTicket: acRelationTicket;
    lCardinality: string;
    lEnumeratorChild,
    lEnumerator: acEnumerator;
    li: integer;
    lNodePatriarc,
    targetNode :  TTreeNode;
    lFiltroIgualFilho,
    lbIncluir,
    lFiltroIgualPai,
    lAchei,
    lFiltro : boolean;
begin
  lFiltro  := trim(edtClasse.Text) <> '';
  if Node.HasChildren and (Node.Count = 0) then
  begin
    Node.Owner.BeginUpdate;
    try
      if (TObject(Node.Data) is acMetaModel) then
      begin
        //Carregas o pai
        lEnumerator := acMetaModel(Node.Data).ClassTickets.GetEnumerator;
        try
          while not lEnumerator.EOL do
          begin
            lClassTicket := acClassTicket(lEnumerator.Current);
            lAchei := false;
            lFiltroIgualFilho := false;
            if not Assigned(lClassTicket.ParentClassTicket) then
            begin
              lClassTicketChild := FindParcialNodeClass(lClassTicket,lFiltro);
              if Assigned(lClassTicketChild) then
              begin
                if lClassTicket <>  lClassTicketChild then
                begin
                  if not Assigned(Node.Owner.FindNodeWithData(lClassTicket)) then
                  begin
                    lAchei := true;
                    lFiltroIgualFilho := true;
                  end;
                end
                else
                begin
                  lAchei := true;
                end;
                if lAchei then
                begin
                  targetNode := Node.Owner.AddChildObject(Node, lClassTicket.PersistentObjectClassName, lClassTicket);
                  targetNode.ImageIndex := 6;
                  targetNode.HasChildren := True;
                  if  lFiltroIgualFilho then
                  begin
                    targetNode.Expanded := true;
                  end;
                end;
              end;
            end;
            lEnumerator.MoveNext;
          end;
        finally
          lEnumerator.Free;
        end;

      end
      else if (TObject(Node.Data) is acClassTicket) then
      begin
        lClassTicket := acClassTicket(Node.Data);
        for li := 0 to pred(lClassTicket.Attributes.Count) do
        begin
          lAttributeTicket := acAttributeTicket(lClassTicket.Attributes.Objects[li]);
          if lAttributeTicket.Stereotype = acAttributeStereotype.pvPersistent then
          begin
            targetNode := Node.Owner.AddChildObject(Node, lAttributeTicket.AttributeName + ': ' + lAttributeTicket.AttributeType, lAttributeTicket);
            if lAttributeTicket.Mandatory then
              targetNode.ImageIndex := 5
            else
              targetNode.ImageIndex := 0;
          end;
        end;
        for li := 0 to pred(lClassTicket.RelationTicketsIn.Count) do
        begin
          lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsIn.Objects[li]);
          if lRelationTicket.DestinationMaxMultiplicity = N
            then lCardinality := '*'
            else lCardinality := inttostr(lRelationTicket.DestinationMaxMultiplicity);
          if lRelationTicket.DestinationPropertyName <> '' then
          begin
            targetNode := Node.Owner.AddChildObject(Node, lRelationTicket.DestinationPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.OriginClassTicket.PersistentObjectClassName, lRelationTicket.OriginClassTicket);
            targetNode.HasChildren := True;

            if lRelationTicket.DestinationMaxMultiplicity = N then
            begin
              if lRelationTicket.DestinationMinMultiplicity = 1 then
                targetNode.ImageIndex := 4
              else
                targetNode.ImageIndex := 2;
            end
            else
            begin
              if lRelationTicket.DestinationMinMultiplicity = 1 then
                targetNode.ImageIndex := 3
              else
                targetNode.ImageIndex := 1;
            end;
          end;
        end;
        for li := 0 to pred(lClassTicket.RelationTicketsOut.Count) do
        begin
          lRelationTicket := acRelationTicket(lClassTicket.RelationTicketsOut.Objects[li]);
          if lRelationTicket.OriginPropertyName <> '' then
          begin
            if lRelationTicket.OriginMaxMultiplicity = N
              then lCardinality := '*'
              else lCardinality := inttostr(lRelationTicket.OriginMaxMultiplicity);
            targetNode := Node.Owner.AddChildObject(Node, lRelationTicket.OriginPropertyName + ': (' + lCardinality + ') ' + lRelationTicket.DestinationClassTicket.PersistentObjectClassName, lRelationTicket.DestinationClassTicket);
            targetNode.HasChildren := True;
            if lRelationTicket.OriginMaxMultiplicity = N then
            begin
              if lRelationTicket.DestinationMinMultiplicity = 1 then
                targetNode.ImageIndex := 4
              else
                targetNode.ImageIndex := 2;
            end
            else
            begin
              if lRelationTicket.DestinationMinMultiplicity = 1 then
                targetNode.ImageIndex := 3
              else
                targetNode.ImageIndex := 1;
            end;
          end;
        end;
        if lClassTicket.HasDescendants then
        begin
          //Carrega os filhos
          if Assigned(lClassTicket.PatriarcClassTicket) then
          begin
            lFiltroIgualPai := BuscaParcialClasse(lClassTicket.PatriarcClassTicket.PersistentObjectClassName,lFiltro);
          end
          else
          begin
             lFiltroIgualPai := BuscaParcialClasse(lClassTicket.PersistentObjectClassName,lFiltro);
          end;

          lEnumerator := lClassTicket.DirectDescendants.GetEnumerator;
          try
            while not lEnumerator.EOL do
            begin
              lClassTicketChild := acClassTicket(lEnumerator.Current);
              lFiltroIgualFilho := BuscarParcialChildClass(lClassTicketChild,lFiltro);
              lbIncluir := lFiltroIgualPai or lFiltroIgualFilho;
              if lbIncluir then
              begin
                targetNode := Node.Owner.AddChildObject(Node, lClassTicketChild.PersistentObjectClassName, lClassTicketChild);
                targetNode.ImageIndex := 6;
                targetNode.HasChildren := True;
                if  lFiltroIgualFilho then
                begin
                  targetNode.Expanded := true;
                end;
              end;
              lEnumerator.MoveNext;
            end;
          finally
            lEnumerator.Free;
          end;
        end;
      end;
    finally
      Node.Owner.EndUpdate;
    end;
  end;

end;

procedure TExplorerV2.FormShow(Sender: TObject);
begin
  OQLQuery.Execute;

  spResultObject.Visible := False;
  spResultObject.Align := alNone;
  spResultXML.Visible := False;
  spResultXML.Align := alNone;

  pnlResult.Visible := False;
  pcEditor.ActivePageIndex := 0;
  pcResults.ActivePageIndex := 1;
end;

function TExplorerV2.GetNumeroDeStringOID(piString: string): string;
var
  lString : string;
  lEnum : Integer;
begin
  lString := '';
  // Verifica se a string tem mais que 4 caracteres
  if  Length(piString) > 4  then
  begin
    // Extrai os 4 primeiros caracteres da string
    for lEnum := 1 to 4  do
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Se a string comear com OID: esses 4 primeiro caracteres sero excludos
    if lString = 'OID:' then
    begin
      lString := '';
      for lEnum := 5 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end
    // Caso contrrio copia-se a string toda
    else
    begin
      lString := '';
      for lEnum := 1 to Length(piString)  do
      begin
        lString := Concat(lString,piString[lEnum])
      end;
    end;
  end
  else
  begin
    lString := piString;
  end;
  Result := lString;  
end;

function TExplorerV2.GetClassTicket(piBloco, piPropertyName: string
	 ): acClassTicket;
var lEnumerator: acEnumerator;
    lRelationTicket : acRelationTicket;
begin
  lEnumerator := MetaModel.RelationTickets.GetEnumerator;
  try
    while not lEnumerator.EOL do
    begin
      lRelationTicket := acRelationTicket(lEnumerator.Current);
      //if lRelationTicket.;
      lEnumerator.MoveNext;
    end;
  finally
    lEnumerator.Free;
  end;
end;

function TExplorerV2.GetStringEntreParenteses(piString: string): string;
var
  lString : string;
  lEnum : Integer;
  flagDadosDesejados : Boolean;
begin
  flagDadosDesejados := False;
  lString := '';
  for lEnum := 1 to Length(piString)  do
  begin
    // Fim dos dados entre parenteses
    if piString[lEnum] = ')' then
      flagDadosDesejados := False;
    if flagDadosDesejados then
    begin
      lString := Concat(lString,piString[lEnum])
    end;
    // Inicio dos dados entre parenteses
    if piString[lEnum] = '(' then
      flagDadosDesejados := True;
  end;
  Result := lString;
end;

procedure TExplorerV2.memOQLQuery2DragDrop(Sender, Source: TObject; X,Y: Integer);
    function FromClause(piNode: TTreeNode; var poPath: string): string;
    begin
      if piNode.Level = 1
      then begin
        poPath := acClassTicket(piNode.Data).PersistentObjectClassName;
        result := poPath;
      end
      else begin
        result := FromClause(piNode.Parent, poPath);
        poPath := poPath + '.' + copy(piNode.Text, 1, pred(pos(':', piNode.Text)));
        result := result + ', ' + #13#10 + '     ' + poPath;
      end;
    end;
var lCaption: string;
    lNode: TTreeNode;
    lPath: string;
    lFrom: string;
    lSelect: string;
begin
  if Source is TTreeView then
  begin
    lNode := TTreeView(Source).Selected;
    if (TObject(lNode.Data) is acClassTicket)
      then begin
        lCaption := acClassTicket(lNode.Data).PersistentObjectClassName;
        if GetKeyState(VK_CONTROL) < 0
           then SynEditOQL.SelText := #13#10 +
                                    'SELECT ' + lCaption + #13#10 +
                                    'FROM ' + lCaption
           else SynEditOQL.SelText := lCaption;
      end
      else if (TObject(lNode.Data) is acAttributeTicket) then
      begin
        if GetKeyState(VK_CONTROL) < 0
          then begin
            lCaption := (TObject(lNode.Parent.data) as acClassTicket).PersistentObjectClassName;
            lFrom := FromClause(lNode.Parent, lPath);
            lSelect := copy(lPath, 1, pred(pos('.', lPath)));
            if lSelect = '' then lSelect := lPath;
            SynEditOQL.SelText := #13#10 +
                                'SELECT ' + lSelect + #13#10 +
                                'FROM ' + lFrom + #13#10 +
                                'WHERE ' + lPath + '.' + acAttributeTicket(lNode.Data).AttributeName + ' = ';
          end else SynEditOQL.SelText := acAttributeTicket(lNode.Data).AttributeName;
      end;
  end;
end;

procedure TExplorerV2.memOQLQuery2DragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
var
  lNode: TTreeNode;
begin
  if Source is TTreeView then
  begin
    if Accept then
    begin
      lNode := TTreeView(Source).Selected;
      Accept := ((TObject(lNode.Data) is acClassTicket) or (TObject(lNode.Data) is acAttributeTicket));
      if (State = dsDragEnter) and (Sender is TWinControl) then TWinControl(Sender).SetFocus;
    end
  end;
end;

procedure TExplorerV2.OQLObjectstvExplorerKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Copia dados do objeto ao apertar Ctrl + C
  if (Key = 67) and (Shift = [ssCtrl]) then
  begin
    if Assigned(OQLObjects.tvExplorer.Selected) then
      CopiaTextoObjeto(OQLObjects.tvExplorer.Selected);
  end;
end;

procedure TExplorerV2.OQLObjectstvExplorerMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  lPoint : TPoint;
begin
  GetCursorPos(lPoint);
  if (Button = mbRight) then
  begin
    pmCopiar.Popup(lPoint.X ,lPoint.Y );
  end;
end;

procedure TExplorerV2.pcEditorChange(Sender: TObject);
var
  lOQLtoSQLTranslator: acOQLtoSQLTranslator;
  lOQL: String;
begin
  if pcEditor.ActivePageIndex = 1 then
  begin
    try
      SynEditSQL.Text := '';
      if Trim(SynEditOQL.Text) <> '' then
        begin
          if OQLQuery.Checked then
          begin
            if SynEditOQL.SelText = ''
              then lOQL := SynEditOQL.Text
              else lOQL := SynEditOQL.SelText;

            lOQLtoSQLTranslator := acOQLtoSQLTranslator.Create(fMetaModelPersistenceMap);
            try
              SynEditSQL.Text := lOQLtoSQLTranslator.TranslateOQLtoSQL(Trim(lOQL), fSQLDialect, fSchema, acQueryResultKind.qrkObject);
              SynEditSQL.SetFocus;
            finally
              lOQLtoSQLTranslator.Free;
            end;
          end
          else
          begin
            if SynEditOQL.SelText = ''
              then lOQL := SynEditOQL.Text
              else lOQL := SynEditOQL.SelText;
            lOQLtoSQLTranslator := acOQLtoSQLTranslator.Create(fMetaModelPersistenceMap);
            try
              SynEditSQL.Text := lOQLtoSQLTranslator.TranslateOQLtoSQL(lOQL, fSQLDialect, fSchema, acQueryResultKind.qrkDataSet);
              SynEditSQL.SetFocus;
            finally
              lOQLtoSQLTranslator.Free;
            end;
          end;
        end;
      except
        on e: Exception do
          begin
            if not actResultsPanel.Checked then actResultsPanel.Execute;
            memErrorText.Text := e.Message;
            pcResults.ActivePageIndex := 1;
            pcEditor.ActivePageIndex := 0;
            sbStatusBar.Panels[0].Text := 'OQL translation to SQL failed.';
            sbStatusBar.Panels[1].Text := '';
            sbStatusBar.Panels[2].Text := '';
          end;
    end;
  end
  else SynEditOQL.SetFocus;
end;

procedure TExplorerV2.ReconnectDBExecute(Sender: TObject);
var lConnectionString: string;
    lSession: acPersistenceSession;
begin
  lConnectionString := fConnectionString;
  try
    fConnectionString := '';
    lSession := Connect;
    if Assigned(lSession)
      then lSession.Free
      else fConnectionString := lConnectionString;
  except
    fConnectionString := lConnectionString;
    raise;
  end;
end;

procedure TExplorerV2.ResizeColumns(piListView: TListView);
var li: integer;
begin
  if piListView.Columns.Count > 0 then
  begin
    piListView.Items.BeginUpdate;
    try
      for li := pred(piListView.Columns.Count) downto 0 do
      begin
        piListView.Columns.Items[li].Width := 0;
      end;
    finally
      piListView.Columns[0].Width := piListView.Columns[0].Width + 20;
      piListView.Items.EndUpdate;
    end;
  end;
end;

procedure TExplorerV2.SetMetaModel(const Value: acMetaModel);
var
  lNode :  TTreeNode;
begin
  fMetaModel := Value;
  lNode := tvModelExplorer.Items.AddChildObject(nil, 'Persistence Model', fMetaModel);
  lNode.HasChildren := True;
  lNode.Expand(False);
end;

procedure TExplorerV2.tvModelExplorerItemExpanding(Sender: TObject; Node: TTreeNode; var AllowExpansion: Boolean);
begin
  if rbSequencial.Checked then
  begin
    MontarModelExploreSequencial(Sender,Node);
  end
  else if rbHieraquia.Checked then
  begin
     MontarModelExploreHieraquia(Sender,Node);
  end;
end;

procedure TExplorerV2.XMLQueryExecute(Sender: TObject);
begin
  OQLQuery.Checked := False;
  XMLQuery.Checked := True;
end;

{ TDLLDialog }

constructor TDLLDialog.Create(aOwner: TComponent);
var
  BtnShowMessage: TButton;
  edt: TEdit;
begin
  inherited CreateNew(aOwner);

  Caption := 'This form is in a DLL !!!';
  Position := poWorkAreaCenter;
  Width := 200;
  Height := 100;

  BtnShowMessage := TButton.Create(Self);
  BtnShowMessage.Parent := Self;
  BtnShowMessage.Caption := 'Show message';
  BtnShowMessage.AutoSize := True;
  BtnShowMessage.OnClick := BtnShowMessageClick;
  edt := TEdit.Create(Self);
  edt.Parent := Self;

end;

procedure TDLLDialog.BtnShowMessageClick(Sender: TObject);
begin
  ShowMessage('Hello from DLL!');
end;

procedure TDLLDialog.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);

  {$IFDEF LCLWin32}
  Params.WndParent := ParentFormHandle;
  {$ENDIF}
end;

end.11
