﻿unit ituCadastrarDefinicao;

{$MODE Delphi}

interface

uses
  LCLIntf, LCLType, LMessages, Messages, SysUtils, Variants, Classes,
  Graphics, Controls, Forms, utuMessage,  StdCtrls, ComCtrls,
  ExtCtrls, Buttons;

type

  { TitCadastrarDefinicao }

  TitCadastrarDefinicao = class(TForm)
    btnCancel: TButton;
    btnSave: TButton;
    FlowPanel1: TFlowPanel;
    jvGradientSuperior: TPanel;
    lblClasses: TLabel;
    lblUC: TLabel;
    ListView1: TListView;
    lvClass: TListView;
    pnDivisor: TPanel;
    pnMenuSuperior: TPanel;
    pnPrincipal: TPanel;
    sbEditar: TSpeedButton;
    sbExcluir: TSpeedButton;
    sbNovo: TSpeedButton;
    sbSair: TSpeedButton;
    sbSalvar: TSpeedButton;
    procedure FormShow(Sender: TObject);
    
   

  private
  public
  end;


implementation

uses
  acuObject, Dialogs, MaskUtils, DateUtils;


{$R *.lfm}

procedure TitCadastrarDefinicao.FormShow(Sender: TObject);
begin
  inherited;
//  itCadastrarDefinicao(self.Controller).NewRequest('RM_OBTER_CLASSES', itCadastrarDefinicao(Self.Controller).SendToInterface).Post;
//  Self.Enabled := False;



end;







 {


//Loads context dat to GUI
procedure itCadastrarDefinicao.SendToInterface(piRequest: acRequest);
var
  lClassField, lFieldItem: utField;
  lItem: TListItem;
  lEnum : acEnumerator;
begin
  inherited;
  try
    lClassField := piRequest.Response.RootField.FieldByName('Classes');
    lEnum := lClassField.ChildFields.GetEnumerator;

    with TitCadastrarDefinicao(Self.InterfaceForm) do
    begin
      lvClass.Items.Clear;

      try
        while not lEnum.EOL do
        begin
          lFieldItem := lEnum.Current as utField;

          lItem := lvClass.Items.Add;
          lItem.Caption := lFieldItem.AttributeByName('name').AsString;
          lItem.Data := Pointer(lFieldItem.AttributeByName('code').AsInteger);

          lEnum.MoveNext;
        end;
      finally
        lEnum.Free;
      end;

      btnConectar.Enabled := False;
    end;
  finally
    TitCadastrarDefinicao(Self.InterfaceForm).Enabled := True;
  end;
end;



//Loads Context object data to GUI
procedure itCadastrarDefinicao.GetTargetObjectsData(piRequest: acRequest);
var
  lFieldDefinition: utField;
  i: Integer;

  lItemName: TListItem;
//  lEnum : acEnumerator;

begin
  inherited;
  if piRequest.Response.RootField.HasField('Definition') then
  begin
    with Self.InterfaceForm as TitCadastrarDefinicao do
    begin
      //GUI Component  <--- piRequest Fields

      //Inicializar Componentes
      edtUC.Text := '';


      //Carregar
      lFieldDefinition := piRequest.Response.RootField.FieldByName('Definition');
      if lFieldDefinition.HasAttribute('OID')
        then fOID := lFieldDefinition.AttributeByName('OID').AsString;

      if lFieldDefinition.HasAttribute('UC')
        then edtUC.Text := lFieldDefinition.AttributeByName('UC').AsString;

      if lFieldDefinition.HasAttribute('code') then
      begin
        for i := 0 to lvClass.Items.Count - 1 do
        begin
          if (lvClass.Items[i] as TListItem).Data = Pointer(lFieldDefinition.AttributeByName('code').AsInteger)
            then
            begin
              lvClass.Items[i].Checked := True;
              lvClass.Items[i].Selected := True;
              lvClass.Items[i].MakeVisible(False);
              lvClass.Items[i].Focused := True;
              lvClass.Selected.MakeVisible(True);

              lvClass.ItemFocused := lvClass.Items[i];
              lvClass.SetFocus;
              Break;
            end;
        end;
//        lvClass.Selected.MakeVisible(True);

        lItemName := lvClass.FindCaption(0, lFieldDefinition.AttributeByName('name').AsString, False, True, False);
        if lItemName = nil then
        begin
          edtAddClass.Text := lFieldDefinition.AttributeByName('name').AsString;
          edtCodigoDaClasse.Text := lFieldDefinition.AttributeByName('code').AsString;
        end;






      end;
    end;
  end;
  Screen.Cursor := crDefault;

end;



//Saves GUI state to Object
procedure itCadastrarDefinicao.SaveFromInterface(piRequest: acRequest);
 var
//   lRequest : acRequest;
   lDefinitionField : utField;
   lItemName: TListItem;
begin
  inherited;
  with Self.InterfaceForm as TitCadastrarDefinicao do
  begin
    //GUI Component ---> piRequest Fields
    if (Assigned(lvClass.Selected)) and (chkManual.Checked = False) then
      begin
        lDefinitionField := piRequest.Message.RootField.AddField('Definition');
        lDefinitionField.AddField('Class').AddAttribute('code').AsInteger := Integer(lvClass.Selected.Data);
        lDefinitionField.FieldByName('Class').AddAttribute('name').AsString := lvClass.Selected.Caption;

        if edtUC.Text <> '' then
          lDefinitionField.AddField('UC').AddAttribute('code').AsString := edtUC.Text;
      end
    else if (chkManual.Checked = True) and (edtAddClass.Text <> '') and (edtCodigoDaClasse.Text <> '') then
      begin
        lDefinitionField := piRequest.Message.RootField.AddField('Definition');
        lDefinitionField.AddField('Class').AddAttribute('code').AsInteger := StrToInt(edtCodigoDaClasse.Text);
        lDefinitionField.FieldByName('Class').AddAttribute('name').AsString := edtAddClass.Text;

        if edtUC.Text <> '' then
          lDefinitionField.AddField('UC').AddAttribute('code').AsString := edtUC.Text;

        lItemName := lvClass.FindCaption(0, edtAddClass.Text, False, True, False);
        if lItemName <> nil then
          raise Exception.Create('Já existe uma classe no sistema com este nome. Selecione através da lista ou altere o nome digitado.');
      end
    else
      raise Exception.Create('Preencha todos os campos.');






  end;
  Screen.Cursor := crDefault;
end;
}

end.
