unit cxuCadastroCasoDeUso;

interface

uses cxuUseCase, utuMessage;

type

  cxCadatroCasoDeUso = class(cxUseCase)
  private
  protected
    function GetUseCaseCode: String; override;
  public
    procedure rmObtemContexto(piField: utField; const piResponseField: utField = nil);
    procedure rmIncluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmExcluiObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmEditaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmSalvaObjeto(piField: utField; const piResponseField: utField = nil);
    procedure rmConsultaObjeto(piField: utField; const piResponseField: utField = nil);
  end;

implementation

{ cxCadatroCasoDeUso }

procedure cxCadatroCasoDeUso.rmObtemContexto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_OBTEM_CONTEXTO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadatroCasoDeUso.rmSalvaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_SALVA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadatroCasoDeUso.rmExcluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EXCLUI_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadatroCasoDeUso.rmIncluiObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_INCLUI_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadatroCasoDeUso.rmConsultaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_CONSULTA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

procedure cxCadatroCasoDeUso.rmEditaObjeto(piField: utField; const piResponseField: utField);
var lRequestMessage: mxRequestMessage;
    lResponseMessage: mxAnswerMessage;
begin
  lRequestMessage := self.NewRequest('RM_EDITA_OBJETO', piField);
  try
    lResponseMessage := self.Session.SendRequest(lRequestMessage);
    try
      if assigned(piResponseField) then piResponseField.Assign(lResponseMessage.RootField);
    finally
      lResponseMessage.free;
    end;
  finally
    lRequestMessage.Free;
  end;
end;

function cxCadatroCasoDeUso.GetUseCaseCode: String;
begin
  result := '441';
end;

end.
