unit ituCadastrarFormulario;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  ituVCLUIController, ituUIController, StdCtrls, Dialogs, JvExControls,
  JvSpeedButton, ComCtrls, JvExComCtrls, JvListView, ExtCtrls, Mask, JvExMask,
  JvToolEdit, JvBaseEdits, JvExStdCtrls, JvCheckBox, JvEdit, JvCombobox, utuMessage,
  Grids, ValEdit;

type
  TitCadastrarFormulario = class(itInterfaceForm)
    lblCodigo: TLabel;
    lblOrdem: TLabel;
    lvCampos: TJvListView;
    lblExibirCampos: TLabel;
    btnUp: TJvSpeedButton;
    btnDown: TJvSpeedButton;
    chkRequerido: TJvCheckBox;
    edtCodigo: TJvEdit;
    cbbTipo: TComboBox;
    lblTipoAtributo: TLabel;
    lstAtributos: TValueListEditor;
    scrlbxTudo: TScrollBox;
    btnSalvar: TButton;
    btnCancelar: TButton;
    edtCampo: TJvEdit;
    lblNovoCampo: TLabel;
    btnAdd: TJvSpeedButton;
    procedure lstAtributosClear;
    procedure lstAtributosFill(piType: string);
    procedure btnCancelarClick(Sender: TObject);
    procedure btnUpClick(Sender: TObject);
    procedure btnDownClick(Sender: TObject);
    procedure lvCamposSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure chkRequeridoClick(Sender: TObject);
    procedure lvCamposClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure cbbTipoChange(Sender: TObject);
    procedure lstAtributosValidate(Sender: TObject; ACol, ARow: Integer;
      const KeyName, KeyValue: string);
    procedure btnAddClick(Sender: TObject);
    procedure edtCampoKeyPress(Sender: TObject; var Key: Char);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

  itCadastrarFormulario = class(itInterface)
  private
    fTypesField : utField;
    fFieldTypeList : utField;
    fIdCount : Integer;

    procedure ObterAtributosSuccess (piRequest : acRequest);
    procedure EditarSuccess (piRequest : acRequest);
    procedure IncluirSuccess (piRequest : acRequest);
    procedure SalvarSuccess (piRequest : acRequest);
    { Private declarations }
  public
    procedure Initialize; override;
    procedure Finalize; override;
  end;

implementation

uses
  ituInterfaceFactory, acuObject;

const
  __STRING = 1;
  __NUMBER = 2;
  __BOOLEAN = 3;

{$R *.dfm}

{ itCadastrarCliente }

procedure itCadastrarFormulario.Initialize;
var
  lRequest : acRequest;
begin
  inherited;
  fIdCount := 0;
  Screen.Cursor := crHourGlass;
  self.InterfaceForm := TitCadastrarFormulario.Create(Application);

  if Self.ContextObject.OperationCode = '5' then  {Novo}
  begin
    lRequest := Self.NewRequest('RM_OBTER_CONTEXTO', ObterAtributosSuccess);
    lRequest.Message.RootField.AddField('Definition').AddAttribute('OID').AsString := Self.ContextObject.ObjectID;
    lRequest.Post;
  end
  else if Self.ContextObject.OperationCode = '3' then  {Editar}
  begin
    lRequest := Self.NewRequest('RM_OBTER_CONTEXTO', ObterAtributosSuccess);
    lRequest.Message.RootField.AddField('Form').AddAttribute('OID').AsString := Self.ContextObject.ObjectID;
    lRequest.Post;
  end
  else
    raise Exception.Create('Operao invlida.');

  Self.InterfaceForm.Show;

  TitCadastrarFormulario(Self.InterfaceForm).lvCamposClick(nil);
  fFieldTypeList := utField.Create;
end;

procedure itCadastrarFormulario.ObterAtributosSuccess(piRequest: acRequest);
var
  lClassAttField, lFieldItem: utField;
  lItem: TListItem;
  lEnum : acEnumerator;
  lClassAttribute : string;
begin
  inherited;
  with TitCadastrarFormulario(Self.InterfaceForm) do
  begin
    fTypesField := piRequest.Response.RootField.ExtractField(piRequest.Response.RootField.FieldByName('Types'));


    if piRequest.Response.RootField.HasField('ClassAttributes') then
    begin
      lClassAttField := piRequest.Response.RootField.FieldByName('ClassAttributes');

      lvCampos.Items.Clear;
      lEnum := lClassAttField.ChildFields.GetEnumerator;
      try
        while not lEnum.EOL do  {preenche a listView com os atributos da classe }
        begin
          lFieldItem := lEnum.Current as utField;
          lClassAttribute := lFieldItem.AttributeByName('name').AsString;
          fIdCount := lFieldItem.AttributeByName('id').AsInteger;

          fFieldTypeList.AddField(lClassAttribute);         //fieald para armazenar os attributos de cada campo

          lItem := lvCampos.Items.Add;
          lItem.Caption := lClassAttribute;

          with lItem.SubItems do
          begin
            Add('N');                //requerido
            Add(IntToStr(fIdCount)); //ID
            Add('');                 //tipo
            Add('');                 //tipo index
          end;

          lEnum.MoveNext;
        end;
      finally
        lEnum.Free;
      end;
    end;

    cbbTipo.Items.Clear;
    lEnum := fTypesField.ChildFields.GetEnumerator;
    try
      while not lEnum.EOL do  {preenche a comboBox com os tipos de field }
      begin
        lFieldItem := lEnum.Current as utField;

        cbbTipo.AddItem(lFieldItem.Name, Pointer(lFieldItem.AttributeByName('OID').AsInteger));

        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  end;

  if Self.ContextObject.OperationCode = '5' then  {Novo}
    Self.NewRequest('RM_INCLUIR', IncluirSuccess).Post
  else if Self.ContextObject.OperationCode = '3' then  {Editar}
    Self.NewRequest('RM_EDITAR', EditarSuccess).Post;

end;

procedure itCadastrarFormulario.IncluirSuccess(piRequest: acRequest);
var
  lCode : string;
begin
  try
    lCode := piRequest.Response.RootField.FieldByName('Form').AttributeByName('OID').AsString;
    TitCadastrarFormulario(Self.InterfaceForm).edtCodigo.Text := lCode;
  finally
    TitCadastrarFormulario(Self.InterfaceForm).Enabled := True;
    Screen.Cursor := crDefault;
  end;
end;

procedure itCadastrarFormulario.EditarSuccess(piRequest: acRequest);
var
  lFieldItem : utField;
  lCode, lFieldName : string;
  lEnum : acEnumerator;
  lItem: TListItem;
  lPosition, lIndex, lId : Integer;
begin
  try
    lCode := piRequest.Response.RootField.FieldByName('Form').AttributeByName('code').AsString;
    TitCadastrarFormulario(Self.InterfaceForm).edtCodigo.Text := lCode;
    
    lEnum := piRequest.Response.RootField.FieldByName('Form').FieldByName('Fields').ChildFields.GetEnumerator;
    try
      while not lEnum.EOL do  {preenche a comboBox com os tipos de field }
      begin
        lFieldItem := lEnum.Current as utField;
        lFieldName := lFieldItem.AttributeByName('name').AsString;
        lId := lFieldItem.AttributeByName('id').AsInteger;

        if lId > fIdCount then fIdCount := lId;

        with TitCadastrarFormulario(Self.InterfaceForm) do
        begin
          lItem := lvCampos.FindCaption(0, lFieldName, False, True, False);
          if lItem = nil then
          begin
            lItem := lvCampos.Items.Add;
            lItem.Caption := lFieldName;
            lItem.SubItems.Add('');
            lItem.SubItems.Add('');
            lItem.SubItems.Add('');
          end;                          

          lItem.Checked := True;
          lItem.SubItems[0] := lFieldItem.AttributeByName('required').AsString;
          lItem.SubItems[1] := lFieldItem.AttributeByName('id').AsString;
          lItem.SubItems[2] := lFieldItem.FieldByName('Type').AttributeByName('name').AsString;

          lPosition := lFieldItem.AttributeByName('order').AsInteger;
          lIndex := lItem.Index;

          while lIndex > lPosition do
          begin
            lvCampos.MoveUp(lIndex, False);
            lIndex := lIndex - 1;
          end;

          while lIndex < lPosition do
          begin
            lvCampos.MoveDown(lIndex, False);
            lIndex := lIndex + 1;
          end;

        end;

        lFieldItem.Name := lFieldName;
        if not fFieldTypeList.HasField(lFieldName) then fFieldTypeList.AddField(lFieldName);
        fFieldTypeList.FieldByName(lFieldName).Assign(lFieldItem);

        lEnum.MoveNext;
      end;
    finally
      lEnum.Free;
    end;
  finally
    TitCadastrarFormulario(Self.InterfaceForm).Enabled := True;
    Screen.Cursor := crDefault;
  end;
end;


procedure TitCadastrarFormulario.btnSalvarClick(Sender: TObject);
var
  lRequest : acRequest;
  lFormField, lFieldField, lTypeField : utField;
  i, lOrder : Integer;
begin
  try
    with itCadastrarFormulario(Self.Controller) do
    begin
      lRequest := NewRequest('RM_SALVAR', SalvarSuccess);
      lFormField := lRequest.Message.RootField.AddField('Form');
      lFormField.AddAttribute('code').AsString := edtCodigo.Text;
      lFormField := lFormField.AddField('Fields');

      lOrder := 0;
      for i := 0 to lvCampos.Items.Count - 1 do
      begin
        if lvCampos.Items[i].Checked then
        begin
          if lvCampos.Items[i].SubItems[2] = '' then
            raise Exception.Create('O campo ''' + lvCampos.Items[i].Caption + ''' deve possuir um tipo');

          lFieldField := lFormField.AddField('Field');
          lFieldField.AddAttribute('name').AsString := lvCampos.Items[i].Caption;
          lFieldField.AddAttribute('order').AsInteger := lOrder;
          lFieldField.AddAttribute('required').AsBoolean := (lvCampos.Items[i].SubItems[0] = 'S');
          lFieldField.AddAttribute('id').AsInteger := StrToInt(lvCampos.Items[i].SubItems[1]);

          lTypeField := lFieldField.AddField('Type');
          lTypeField.Assign(fFieldTypeList.FieldByName(lvCampos.Items[i].Caption).FieldByName('Type'));

          lOrder := lOrder + 1;
        end;
      end;

      if not lFormField.HasField('Field') then
        raise Exception.Create('O formulrio deve possuir pelo menos um campo, use as CheckBoxes para escolhe-los.');

      lRequest.Post;
    end;
  except
    raise;
  end;
end;


procedure itCadastrarFormulario.SalvarSuccess(piRequest: acRequest);
begin
  ShowMessage('Formulrio cadastrado com sucesso.');
  TitCadastrarFormulario(Self.InterfaceForm).Close;
end;


procedure TitCadastrarFormulario.btnAddClick(Sender: TObject);
var
  lItem : TListItem;
begin
  if edtCampo.Text <> '' then
  begin
    with itCadastrarFormulario(Self.Controller) do
    begin
      fIdCount := fIdCount + 1;
      fFieldTypeList.AddField(edtCampo.Text);
    end;

    lItem := lvCampos.Items.Add;
    lItem.Caption := edtCampo.Text;
    lItem.Checked := True;

    with lItem.SubItems do
    begin
      Add('N');                                                       //requerido
      Add(IntToStr(itCadastrarFormulario(Self.Controller).fIdCount)); //ID
      Add('');                                                        //tipo
      Add('');                                                        //tipo index
    end;

    edtCampo.Clear;
  end;  
end;

procedure TitCadastrarFormulario.edtCampoKeyPress(Sender: TObject; var Key: Char);
begin
  if Ord(Key) = VK_RETURN then
  begin
    btnAdd.Click;
  end;
end;


procedure TitCadastrarFormulario.btnCancelarClick(Sender: TObject);
begin
  Self.Close;
end;


procedure TitCadastrarFormulario.btnDownClick(Sender: TObject);
var
  lIndex : Integer;
begin
  lIndex := lvCampos.Selected.Index;
  lvCampos.MoveDown(lIndex);
end;

procedure TitCadastrarFormulario.btnUpClick(Sender: TObject);
var
  lIndex : Integer;
begin
  lIndex := lvCampos.Selected.Index;
  lvCampos.MoveUp(lIndex);
end;


procedure TitCadastrarFormulario.cbbTipoChange(Sender: TObject);
var
  lField, lTypeField : utField;
begin
  lvCampos.Selected.SubItems[2] := cbbTipo.Text;
  //lvCampos.Selected.SubItems[3] := IntToStr(cbbTipo.ItemIndex);

  with itCadastrarFormulario(Self.Controller) do
  begin
    lField := fFieldTypeList.FieldByName(lvCampos.Selected.Caption);

    if lField.HasField('Type') then
      lField.RemoveField(lField.FieldByName('Type'));

    lTypeField := lField.AddField('Type');
    lTypeField.AddAttribute('name').AsString := cbbTipo.Text;
    lTypeField.AddAttribute('OID').AsInteger := Integer(cbbTipo.Items.Objects[cbbTipo.ItemIndex]);
  end;

  if cbbTipo.ItemIndex <> -1 then
  begin
     lstAtributosFill(cbbTipo.Text);
  end;
end;

procedure TitCadastrarFormulario.lstAtributosFill(piType: string);
var
  lEnum : acEnumerator;
  lFieldItem, lTypeField :utField;
  lValue, lAttribute : string;
  lIndex : Integer;
begin
  lstAtributosClear;
  lEnum := itCadastrarFormulario(Self.Controller).fTypesField.FieldByName(piType).FieldByName('Attributes').ChildFields.GetEnumerator;
  try
    while not lEnum.EOL do  {preenche a ValueList com os atributos do tipo de field }
    begin
      lFieldItem := lEnum.Current as utField;

      lAttribute := lFieldItem.Name;

      lValue := '';
      if itCadastrarFormulario(Controller).fFieldTypeList.FieldByName(lvCampos.Selected.Caption).HasField('Type') then
      begin
        lTypeField := itCadastrarFormulario(Controller).fFieldTypeList.FieldByName(lvCampos.Selected.Caption).FieldByName('Type');
        if lTypeField.HasField(lAttribute) then
          lValue := lTypeField.FieldByName(lAttribute).AttributeByName('value').AsString;
      end;

      lIndex := lstAtributos.InsertRow(lAttribute, lValue, True);
      lstAtributos.Strings.Objects[lIndex - 1] := Pointer(lFieldItem.AttributeByName('OID').AsInteger);

      if lFieldItem.AttributeByName('type').AsInteger = __BOOLEAN then
      begin
        lstAtributos.ItemProps[lAttribute].EditStyle := esPickList;
        lstAtributos.ItemProps[lAttribute].PickList.Add('True');
        lstAtributos.ItemProps[lAttribute].PickList.Add('False');        
      end;

      lEnum.MoveNext;
    end;
  finally
    lEnum.Free;
  end;
end;

procedure TitCadastrarFormulario.lstAtributosClear;
var
  i : Integer;
begin
  if lstAtributos.RowCount > 2 then
    for i := lstAtributos.RowCount-1 downto 1 do
      lstAtributos.DeleteRow(i)
  else
    lstAtributos.Values[lstAtributos.Keys[1]] := '';
end;


procedure TitCadastrarFormulario.lstAtributosValidate(Sender: TObject; ACol,
  ARow: Integer; const KeyName, KeyValue: string);
var
  lField, lAttributeField, lTypeField : utField;
  lOID, lAttributeType, lIntValue : Integer;
  lOK, lBoolValue: Boolean;
  lMessage : string;
begin
  if (lvCampos.SelCount > 0) and (lvCampos.Selected.SubItems[2] <> '') then
  begin
    with itCadastrarFormulario(Self.Controller) do
    begin
      lTypeField := fTypesField.FieldByName(lvCampos.Selected.SubItems[2]);
      lAttributeType := lTypeField.FieldByName('Attributes').FieldByName(KeyName).AttributeByName('type').AsInteger;

      lOK := True;
      if lAttributeType = __NUMBER then
      begin
        lOK := TryStrToInt(KeyValue, lIntValue);
        lMessage := 'Atributo ' + KeyName + ' deve ser do tipo INTEGER';
      end
      else if lAttributeType = __BOOLEAN then
      begin
        lOK := TryStrToBool(KeyValue, lBoolValue);
        lMessage := 'Atributo ''' + KeyName + ''' deve ser do tipo BOOLEAN';
      end;

      if KeyValue <> '' then
      begin
        if lOK then
        begin
          lOID := Integer(lstAtributos.Strings.Objects[lstAtributos.Strings.IndexOfName(KeyName)]);
          lField := fFieldTypeList.FieldByName(lvCampos.Selected.Caption).FieldByName('Type');
          if lField.HasField(KeyName) then
          begin
            lAttributeField := lField.FieldByName(KeyName);
            lAttributeField.AttributeByName('OID').AsInteger := lOID;
            lAttributeField.AttributeByName('value').AsString := KeyValue;
          end
          else
          begin
            lAttributeField := lField.AddField(KeyName);
            lAttributeField.AddAttribute('OID').AsInteger := lOID;
            lAttributeField.AddAttribute('value').AsString := KeyValue;
          end;
        end
        else
        begin
//          lstAtributos.Col := ACol;
//          lstAtributos.Row := ARow;
          lstAtributos.Values[KeyName] := '';
          MessageDlg(lMessage, mtError, [mbOK], 0);
//          raise Exception.Create(lMessage);
        end;
      end
      else
      begin
        lField := fFieldTypeList.FieldByName(lvCampos.Selected.Caption).FieldByName('Type');
        if lField.HasField(KeyName) then
          lField.RemoveField(lField.FieldByName(KeyName));
      end;
    end;
  end;
end;

procedure TitCadastrarFormulario.chkRequeridoClick(Sender: TObject);
begin
  if chkRequerido.Checked = True
    then lvCampos.Selected.SubItems[0] := 'S'
    else lvCampos.Selected.SubItems[0] := 'N';
end;

procedure TitCadastrarFormulario.lvCamposClick(Sender: TObject);
begin
  if lvCampos.SelCount = 0 then
  begin
    chkRequerido.Enabled := False;
    btnUp.Enabled := False;
    btnDown.Enabled := False;
    cbbTipo.Enabled := False;
    lblOrdem.Enabled := False;
    lblTipoAtributo.Enabled := False;
    lstAtributos.Enabled := False;
    lstAtributosClear;
  end
  else
  begin
    chkRequerido.Enabled := True;
    btnUp.Enabled := True;
    btnDown.Enabled := True;
    cbbTipo.Enabled := True;
    lblOrdem.Enabled := True;
    lblTipoAtributo.Enabled := True;
    lstAtributos.Enabled := True;
  end;
end;

procedure TitCadastrarFormulario.lvCamposSelectItem(Sender: TObject; Item: TListItem; Selected: Boolean);
begin
  if Selected then
  begin
    if Item.SubItems[0] = 'N' then
      chkRequerido.Checked := False
    else
      chkRequerido.Checked := True;

    if Item.SubItems[2] = '' then
    begin
      cbbTipo.ItemIndex := -1;
      lstAtributosClear;
    end
    else
    begin
      cbbTipo.ItemIndex := cbbTipo.Items.IndexOf(Item.SubItems[2]);
      lstAtributosFill(Item.SubItems[2]);
    end;
  end;
end;

procedure itCadastrarFormulario.Finalize;
begin
  inherited;
  if Assigned(fTypesField) then
    fTypesField.Free;
end;

initialization
  gInterfaceFactory.RegisterClass(1371, itCadastrarFormulario);

finalization
  gInterfaceFactory.UnRegisterClass(1371);
end.
