import * as React from 'react'
import * as cn from 'classnames'
import { storiesOf, StoryDecorator } from '@storybook/react'
import { action } from '@storybook/addon-actions'
import { linkTo } from '@storybook/addon-links'

import { MultipleSelectField, MultipleSelectFieldWeakProps, MultipleSelectFieldItem } from '../src/MultipleSelectField'

const items = [
  { label: 'item 1', id: '1' },
  { label: 'item 2', id: '2' },
  { label: 'item 3', id: '3' },
  { label: 'item 4', id: '4' },
  { label: 'item 5', id: '5' },
  { label: 'item 6', id: '6' }
]

const CenterDecorator: StoryDecorator = (storyFn) => <div className='md-grid'>{storyFn()}</div>
const DefaultMultipleSelectField = (props: MultipleSelectFieldWeakProps) => <MultipleSelectField
  {...props as any}
  menuItems={items}
  onToggleCheck={action('checkbox toggled')}
  className={cn('md-cell', props.className)}
/>

storiesOf('MultipleSelectField', module)
  .addDecorator(CenterDecorator)
  .add('default', () => <DefaultMultipleSelectField/>)
  .add('default visible', () => <DefaultMultipleSelectField menuDefaultVisible/>)
  .add('default input', () => <DefaultMultipleSelectField inputDefaultValue='item 1'/>)
  .add('menu positioned', () => <DefaultMultipleSelectField
    className='md-cell--2'
    menuDefaultVisible
    menuAnchor={{
      x: MultipleSelectField.HorizontalAnchors.INNER_LEFT,
      y: MultipleSelectField.VerticalAnchors.BOTTOM
    }}
    menuPosition={MultipleSelectField.Positions.BELOW}
  />)
  .add('with filter', () => <DefaultMultipleSelectField
    className='md-cell--2'
    menuDefaultVisible
    inputDefaultValue='item 2'
    filter={(items, text) => text ? items.filter(item => item.label.includes(text.toString())) : items}
    menuAnchor={{
      x: MultipleSelectField.HorizontalAnchors.INNER_LEFT,
      y: MultipleSelectField.VerticalAnchors.BOTTOM
    }}
    menuPosition={MultipleSelectField.Positions.BELOW}
  />)
