import * as React from 'react'
import { UP, DOWN, ESC, TAB, ZERO, NINE, KEYPAD_ZERO, KEYPAD_NINE } from '../constants/keyCodes'
import { CheckboxListItem } from '../CheckboxListItem'
/** React-md dependencies */
import DropdownMenu, { DropdownMenuProps } from 'react-md/lib/Menus/DropdownMenu'
import TextField, { TextFieldProps, TextFieldLineDirections, TextFieldTypes } from 'react-md/lib/TextFields/TextField'
import { HorizontalAnchors, VerticalAnchors, LayoverPositions, LayoverAnchor } from 'react-md/lib/Helpers/Layover'
import { CheckboxListMenuItem } from './CheckboxListMenuItem'

export interface MultipleSelectFieldItem {
  id: string
  label: string
  checked?: boolean
}

export interface MultipleSelectFieldState {
  checked: {[props: string]: boolean}
  inputValue: number | string
}

export interface MultipleSelectFieldWeakProps {
  // TextField props
  inputId?: string
  inputValue?: number | string
  inputDefaultValue?: number | string
  inputStyle?: React.CSSProperties
  inputClassName?: string
  inputBlock?: boolean
  inputPaddedBlock?: boolean
  inputDisabled?: boolean
  inputLabel?: React.ReactNode
  inputPlaceholder?: string
  inputType?: TextFieldTypes
  inputActive?: boolean
  inputError?: boolean
  inputFloating?: boolean
  inputRequired?: boolean
  inputLineDirection?: TextFieldLineDirections
  inputLeftIcon?: React.ReactElement<any>
  inputLeftIconStateful?: boolean
  inputRightIcon?: React.ReactElement<any>
  inputRightIconStateful?: boolean
  // inputPasswordIcon?: React.ReactElement<any>
  // inputPasswordInitiallyVisible?: boolean
  inputFullWidth?: boolean
  // inputRows?: number
  // inputMaxRows?: number
  inputCustomSize?: string
  inputErrorText?: React.ReactNode
  inputHelpText?: React.ReactNode
  inputHelpOnFocus?: boolean
  inputMaxLength?: number
  inputInlineIndicator?: React.ReactElement<any>
  inputMin?: number
  inputMax?: number
  inputStep?: number
  inputPattern?: string
  inputResize?: { min: number, max: number, disableShrink?: boolean }
  inputTabIndex?: number
  // ----------------
  // DropDownMenu props
  menuId?: string
  menuDefaultVisible?: boolean
  menuVisible?: boolean
  menuCascading?: boolean
  menuCascadingAnchor?: { x: HorizontalAnchors, y: VerticalAnchors }
  menuCascadingZDepth?: number
  menuPosition?: LayoverPositions
  menuSimplifiedMenu?: boolean
  menuListId?: string
  menuListProps?: {}
  menuListStyle?: React.CSSProperties
  menuListClassName?: string
  menuListInline?: boolean
  menuListZDepth?: number
  menuListHeightRestricted?: boolean
  menuStyle?: React.CSSProperties
  menuClassName?: string
  menuFixedTo?: {} | { x?: {}, y?: {} }
  menuBlock?: boolean
  menuCentered?: boolean
  menuFullWidth?: boolean
  menuSameWidth?: boolean
  menuXThreshold?: number
  menuYThreshold?: number
  menuTransitionName?: string
  menuTransitionEnterTimeout?: number
  menuTransitionLeaveTimeout?: number
  menuCloseOnOutsideClick?: boolean
  menuAnchor?: LayoverAnchor
  menuBelowAnchor?: LayoverAnchor
  menuRepositionOnScroll?: boolean
  menuRepositionOnResize?: boolean
  menuMinLeft?: number | string
  menuMinRight?: number | string
  menuMinBottom?: number | string
  menuFillViewportHeight?: boolean
  menuFillViewportWidth?: boolean
  // ------------------
  menuItems?: MultipleSelectFieldItem[]
  id?: string
  block?: boolean
  fullWidth?: boolean
  className?: string
  style?: React.CSSProperties
  filter?: null | ((data: MultipleSelectFieldItem[], filterText: string | number) => MultipleSelectFieldItem[])
  // TextField methods
  onInputChange? (value: number | string, event: Event): void
  onInputDoubleClick? (event: React.MouseEvent<HTMLElement>): void
  onInputPaste? (event: React.ClipboardEvent<HTMLElement>): void
  // ----------------
  // DropwDownMenu methods
  onMenuVisibilityChange? (visible: boolean, e: React.MouseEvent<HTMLElement>): void
  // ---------------------
  onToggleCheck? (checked: boolean, id: string): void
}

export interface MultipleSelectFieldProps extends MultipleSelectFieldWeakProps {
  menuItems: MultipleSelectFieldItem[]
}

function getInputProps (props: MultipleSelectFieldWeakProps): TextFieldProps {
  return {
    id: props.inputId,
    value: props.inputValue,
    defaultValue: props.inputDefaultValue,
    style: props.inputStyle,
    inputClassName: props.inputClassName,
    block: props.inputBlock,
    paddedBlock: props.inputPaddedBlock,
    disabled: props.inputDisabled,
    label: props.inputLabel,
    placeholder: props.inputPlaceholder,
    type: props.inputType,
    active: props.inputActive,
    error: props.inputError,
    floating: props.inputFloating,
    required: props.inputRequired,
    lineDirection: props.inputLineDirection,
    leftIcon: props.inputLeftIcon,
    leftIconStateful: props.inputLeftIconStateful,
    rightIcon: props.inputRightIcon,
    rightIconStateful: props.inputRightIconStateful,
    // PasswordIcon: props.inputPasswordIcon,
    // PasswordInitiallyVisible: props.inputPasswordInitiallyVisible,
    fullWidth: props.inputFullWidth,
    // Rows: props.inputRows,
    // MaxRows: props.inputMaxRows,
    customSize: props.inputCustomSize,
    errorText: props.inputErrorText,
    helpText: props.inputHelpText,
    helpOnFocus: props.inputHelpOnFocus,
    maxLength: props.inputMaxLength,
    inlineIndicator: props.inputInlineIndicator,
    min: props.inputMin,
    max: props.inputMax,
    step: props.inputStep,
    pattern: props.inputPattern,
    resize: props.inputResize,
    tabIndex: props.inputTabIndex,
    onChange: props.onInputChange,
    onDoubleClick: props.onInputDoubleClick,
    onPaste: props.onInputPaste
  }
}

function getMenuProps (props: MultipleSelectFieldWeakProps): DropdownMenuProps {
  return {
    id: props.menuId,
    defaultVisible: props.menuDefaultVisible,
    visible: props.menuVisible,
    cascading: props.menuCascading,
    cascadingAnchor: props.menuCascadingAnchor,
    cascadingZDepth: props.menuCascadingZDepth,
    position: props.menuPosition,
    simplifiedMenu: props.menuSimplifiedMenu,
    listId: props.menuListId,
    listProps: props.menuListProps,
    listStyle: props.menuListStyle,
    listClassName: props.menuListClassName,
    listInline: props.menuListInline,
    listZDepth: props.menuListZDepth,
    listHeightRestricted: props.menuListHeightRestricted,
    style: props.menuStyle,
    className: props.menuClassName,
    fixedTo: props.menuFixedTo,
    block: props.menuBlock,
    centered: props.menuCentered,
    fullWidth: props.menuFullWidth,
    sameWidth: props.menuSameWidth,
    xThreshold: props.menuXThreshold,
    yThreshold: props.menuYThreshold,
    transitionName: props.menuTransitionName,
    transitionEnterTimeout: props.menuTransitionEnterTimeout,
    transitionLeaveTimeout: props.menuTransitionLeaveTimeout,
    closeOnOutsideClick: props.menuCloseOnOutsideClick,
    anchor: props.menuAnchor,
    belowAnchor: props.menuBelowAnchor,
    repositionOnScroll: props.menuRepositionOnScroll,
    repositionOnResize: props.menuRepositionOnResize,
    minLeft: props.menuMinLeft,
    minRight: props.menuMinRight,
    minBottom: props.menuMinBottom,
    fillViewportHeight: props.menuFillViewportHeight,
    fillViewportWidth: props.menuFillViewportWidth,
    onVisibilityChange: props.onMenuVisibilityChange
  }
}

let counter = 1
export class MultipleSelectField extends React.PureComponent<MultipleSelectFieldProps, MultipleSelectFieldState> {
  static Positions = DropdownMenu.Positions
  static VerticalAnchors = DropdownMenu.VerticalAnchors
  static HorizontalAnchors = DropdownMenu.HorizontalAnchors
  public state: MultipleSelectFieldState = { checked: {}, inputValue: this.props.inputValue || this.props.inputDefaultValue }
  private _count: number
  constructor (props: MultipleSelectFieldProps) {
    super(props)
    this._handleToggleCheck = this._handleToggleCheck.bind(this)
    this._handleInputChange = this._handleInputChange.bind(this)
    this._count = counter++
  }
  render () {
    const menuProps = getMenuProps(this.props)
    const inputProps = getInputProps(this.props)
    const {
      menuItems,
      id,
      block,
      fullWidth,
      className,
      style,
      filter
    } = this.props
    const { checked, inputValue } = this.state
    const items = this._filter(menuItems, inputValue).map((item, index) => <CheckboxListMenuItem
      item={item}
      key={item.id}
      checked={item.checked || checked[item.id]}
      onToggleCheck={this._handleToggleCheck}
    />)
    return <DropdownMenu
      {...menuProps}
      id={this._menuId}
      menuItems={items}
      className={className}
      style={style}
    >
      <TextField
        {...inputProps}
        onChange={this._handleInputChange}
        id={this._inputId}
      />
    </DropdownMenu>
  }
  private get _menuId () {
    return this.props.menuId || this.props.id ? `${this.props.id}-menu` : `multiple-select-field-menu-${this._count}`
  }
  private get _inputId () {
    return this.props.inputId || this.props.id ? `${this.props.id}-input` : `multiple-select-field-input-${this._count}`
  }
  private _filter (data: MultipleSelectFieldItem[], filterText: string | number) {
    if (this.props.filter) return this.props.filter(data, filterText)
    return data
  }
  private _handleInputChange (inputValue: string, e: Event) {
    this.setState({ inputValue })
    if (this.props.onInputChange) this.props.onInputChange(inputValue, e)
  }
  private _handleToggleCheck (checked: boolean, item: MultipleSelectFieldItem) {
    if (item.checked === undefined) {
      this.setState(state => ({
        checked: { ...state.checked, [item.id]: checked }
      }))
    }
    this.props.onToggleCheck(checked, item.id)
  }
}
